/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.i18n.FileSelector;
import org.netbeans.modules.i18n.FilteredNode;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.Util;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.UserCancelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorUtils {
    public static final FilteredNode.NodeFilter BUNDLES_FILTER = new FilteredNode.NodeFilter(){

        public boolean acceptNode(Node node) {
            DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
            if (dataObject == null) {
                return false;
            }
            return dataObject instanceof DataFolder && SelectorUtils.isVisible(dataObject) || dataObject instanceof PropertiesDataObject;
        }
    };
    public static final FilteredNode.NodeFilter ALL_FILTER = new FilteredNode.NodeFilter(){

        public boolean acceptNode(Node node) {
            return true;
        }
    };

    private static boolean isVisible(DataObject dataObject) {
        return dataObject.getPrimaryFile() == null || VisibilityQuery.getDefault().isVisible(dataObject.getPrimaryFile());
    }

    public static DataObject selectBundle(Project project, FileObject fileObject) {
        try {
            Node node = SelectorUtils.bundlesNode(project, fileObject, true);
            Node[] nodeArray = NodeOperation.getDefault().select(Util.getString("CTL_SelectPropDO_Dialog_Title"), Util.getString("CTL_SelectPropDO_Dialog_RootTitle"), node, new NodeAcceptor(){

                public boolean acceptNodes(Node[] nodeArray) {
                    if (nodeArray == null || nodeArray.length != 1) {
                        return false;
                    }
                    DataObject dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class);
                    if (dataObject == null) {
                        return false;
                    }
                    return dataObject.getClass().equals(PropertiesDataObject.class);
                }
            });
            return (DataObject)nodeArray[0].getCookie(DataObject.class);
        }
        catch (UserCancelException userCancelException) {
            return null;
        }
    }

    public static Node bundlesNode(Project project, FileObject fileObject, boolean bl) {
        ClassPath classPath;
        LinkedList<Node> linkedList = new LinkedList<Node>();
        if (project == null) {
            project = FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        if ((classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute")) != null) {
            linkedList.addAll(SelectorUtils.getRootNodes(project, SelectorUtils.getRoots(classPath), BUNDLES_FILTER, bl));
        }
        return SelectorUtils.createRootFor(linkedList, project);
    }

    private static List<FileObject> getRoots(ClassPath classPath) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(classPath.entries().size());
        for (ClassPath.Entry entry : classPath.entries()) {
            URL uRL = entry.getURL();
            SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots((URL)uRL);
            FileObject[] fileObjectArray = result.getRoots();
            if (fileObjectArray.length > 0) {
                for (FileObject fileObject : fileObjectArray) {
                    arrayList.add(fileObject);
                }
                continue;
            }
            if (entry.getRoot() == null) continue;
            arrayList.add(entry.getRoot());
        }
        return arrayList;
    }

    private static List<Node> getRootNodes(Project project, List<FileObject> list, FilteredNode.NodeFilter nodeFilter, boolean bl) {
        ArrayList<Node> arrayList = new ArrayList<Node>(list.size());
        for (FileObject fileObject : list) {
            try {
                if (!bl && FileUtil.toFile((FileObject)fileObject) == null) continue;
                Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
                Node node = DataObject.find((FileObject)fileObject).getNodeDelegate();
                FilteredNode filteredNode = new FilteredNode(node, nodeFilter, SelectorUtils.getDisplayName(fileObject, project2, project != project2));
                arrayList.add((Node)filteredNode);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {}
        }
        return arrayList;
    }

    private static String getDisplayName(FileObject fileObject, Project project, boolean bl) {
        if (project != null) {
            String string;
            SourceGroup sourceGroup = SelectorUtils.getSourceGroup(fileObject, project);
            String string2 = string = sourceGroup != null ? sourceGroup.getDisplayName() : FileUtil.getFileDisplayName((FileObject)fileObject);
            if (bl) {
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                string = string + " [" + projectInformation.getDisplayName() + "]";
            }
            return string;
        }
        return FileUtil.getFileDisplayName((FileObject)fileObject);
    }

    private static SourceGroup getSourceGroup(FileObject fileObject, Project project) {
        SourceGroup[] sourceGroupArray;
        Sources sources = ProjectUtils.getSources((Project)project);
        for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("java")) {
            if (fileObject != sourceGroup.getRootFolder()) continue;
            return sourceGroup;
        }
        return null;
    }

    public static Node sourcesNode(Project project, FilteredNode.NodeFilter nodeFilter) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (SourceGroup sourceGroup : sourceGroupArray) {
            try {
                FileObject fileObject = sourceGroup.getRootFolder();
                FilteredNode filteredNode = new FilteredNode(DataObject.find((FileObject)fileObject).getNodeDelegate(), nodeFilter);
                filteredNode.setDisplayName(sourceGroup.getDisplayName());
                arrayList.add((Node)filteredNode);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return SelectorUtils.createRootFor(arrayList, project);
    }

    private static Node createRootFor(List<Node> list, Project project) {
        Children.Array array = new Children.Array();
        Node[] nodeArray = new Node[list.size()];
        list.toArray(nodeArray);
        array.add(nodeArray);
        AbstractNode abstractNode = new AbstractNode((Children)array);
        abstractNode.setDisplayName(ProjectUtils.getInformation((Project)project).getDisplayName());
        return abstractNode;
    }

    public static DataObject instantiateTemplate(Project project, FileObject fileObject, DataObject dataObject) throws IOException {
        ObjectNameInputPanel objectNameInputPanel = new ObjectNameInputPanel();
        Node node = SelectorUtils.bundlesNode(project, fileObject, false);
        DataFolder dataFolder = (DataFolder)NodeOperation.getDefault().select(I18nUtil.getBundle().getString("CTL_Template_Dialog_Title"), I18nUtil.getBundle().getString("CTL_Template_Dialog_RootTitle"), node, new NodeAcceptor(){

            public boolean acceptNodes(Node[] nodeArray) {
                if (nodeArray == null || nodeArray.length != 1) {
                    return false;
                }
                DataFolder dataFolder = (DataFolder)nodeArray[0].getCookie(DataFolder.class);
                return dataFolder != null && dataFolder.getPrimaryFile().canWrite();
            }
        }, (Component)objectNameInputPanel)[0].getCookie(DataFolder.class);
        String string = objectNameInputPanel.getText();
        DataObject dataObject2 = string.equals("") ? dataObject.createFromTemplate(dataFolder) : dataObject.createFromTemplate(dataFolder, string);
        try {
            return dataObject2;
        }
        catch (ClassCastException classCastException) {
            throw new UserCancelException();
        }
    }

    public static DataObject selectOrCreateBundle(FileObject fileObject, DataObject dataObject) {
        Node node = SelectorUtils.bundlesNode(null, fileObject, true);
        FileSelector fileSelector = new FileSelector(fileObject, dataObject);
        fileSelector.getDialog(I18nUtil.getBundle().getString("CTL_SelectPropDO_Dialog_Title"), null).setVisible(true);
        return fileSelector.isConfirmed() ? fileSelector.getSelectedDataObject() : null;
    }

    private static class ObjectNameInputPanel
    extends JPanel {
        static final long serialVersionUID = 1980214734060402958L;
        JTextField text;

        public ObjectNameInputPanel() {
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setVgap(5);
            borderLayout.setHgap(5);
            this.setLayout(borderLayout);
            String string = I18nUtil.getBundle().getString("LBL_TemplateName");
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)string);
            this.text = new JTextField();
            this.text.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_TEXT_ObjectNameInputPanel"));
            jLabel.setLabelFor(this.text);
            this.add("West", jLabel);
            this.add("Center", this.text);
        }

        public void requestFocus() {
            this.text.requestFocus();
        }

        public String getText() {
            return this.text.getText();
        }

        public void setText(String string) {
            this.setText(string);
        }
    }
}

