/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.openide.util.Lookup;
import org.openidex.search.SearchType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Utils {
    private static Lookup.Result<SearchType> result;

    private Utils() {
    }

    private static Lookup.Result<SearchType> getSearchTypes0() {
        if (result == null) {
            result = Lookup.getDefault().lookup(new Lookup.Template(SearchType.class));
        }
        return result;
    }

    static Collection<? extends SearchType> getSearchTypes() {
        return Utils.getSearchTypes0().allInstances();
    }

    static Class searchTypeForName(String string) {
        for (Class clazz : Utils.getSearchTypes0().allClasses()) {
            if (!clazz.getName().equals(string)) continue;
            return clazz;
        }
        return null;
    }

    static final Border getExplorerViewBorder() {
        Border border = (Border)UIManager.get("Nb.ScrollPane.border");
        if (border == null) {
            border = BorderFactory.createEtchedBorder();
        }
        return border;
    }

    static List<SearchType> cloneSearchTypes(Collection<? extends SearchType> collection) {
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SearchType> arrayList = new ArrayList<SearchType>(collection.size());
        for (SearchType searchType : collection) {
            arrayList.add((SearchType)searchType.clone());
        }
        return arrayList;
    }
}

