/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.clientproject.AppClientProject;
import org.netbeans.modules.j2ee.clientproject.classpath.ClassPathProviderImpl;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeFactory;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeImplementation;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceLocationProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeFactory;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeImplementation;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopesProvider;
import org.netbeans.modules.j2ee.persistence.spi.support.EntityMappingsMetadataModelHelper;
import org.netbeans.modules.j2ee.persistence.spi.support.PersistenceScopesHelper;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;

public class AppClientPersistenceProvider
implements PersistenceLocationProvider,
PersistenceScopeProvider,
PersistenceScopesProvider,
EntityClassScopeProvider,
PropertyChangeListener {
    private final AppClientProject project;
    private final PropertyEvaluator evaluator;
    private final ClassPathProviderImpl cpProvider;
    private final ScopeImpl scopeImpl = new ScopeImpl();
    private final PersistenceScope persistenceScope = PersistenceScopeFactory.createPersistenceScope((PersistenceScopeImplementation)this.scopeImpl);
    private final EntityClassScope entityClassScope = EntityClassScopeFactory.createEntityClassScope((EntityClassScopeImplementation)this.scopeImpl);
    private final PersistenceScopesHelper scopesHelper = new PersistenceScopesHelper();
    private final EntityMappingsMetadataModelHelper modelHelper;
    private ClassPath projectSourcesClassPath;

    public AppClientPersistenceProvider(AppClientProject appClientProject, PropertyEvaluator propertyEvaluator, ClassPathProviderImpl classPathProviderImpl) {
        this.project = appClientProject;
        this.evaluator = propertyEvaluator;
        this.cpProvider = classPathProviderImpl;
        this.modelHelper = this.createEntityMappingsHelper();
        propertyEvaluator.addPropertyChangeListener((PropertyChangeListener)this);
        this.locationChanged();
    }

    public FileObject getLocation() {
        return this.project.getAPICar().getMetaInf();
    }

    public FileObject createLocation() throws IOException {
        return this.project.getAPICar().getMetaInf();
    }

    public PersistenceScope findPersistenceScope(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            AppClientPersistenceProvider appClientPersistenceProvider = (AppClientPersistenceProvider)project.getLookup().lookup(AppClientPersistenceProvider.class);
            return appClientPersistenceProvider.getPersistenceScope();
        }
        return null;
    }

    public EntityClassScope findEntityClassScope(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            AppClientPersistenceProvider appClientPersistenceProvider = (AppClientPersistenceProvider)project.getLookup().lookup(AppClientPersistenceProvider.class);
            return appClientPersistenceProvider.getEntityClassScope();
        }
        return null;
    }

    public PersistenceScopes getPersistenceScopes() {
        return this.scopesHelper.getPersistenceScopes();
    }

    private PersistenceScope getPersistenceScope() {
        FileObject fileObject = this.persistenceScope.getPersistenceXml();
        if (fileObject != null && fileObject.isValid()) {
            return this.persistenceScope;
        }
        return null;
    }

    private EntityClassScope getEntityClassScope() {
        return this.entityClassScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getProjectSourcesClassPath() {
        AppClientPersistenceProvider appClientPersistenceProvider = this;
        synchronized (appClientPersistenceProvider) {
            if (this.projectSourcesClassPath == null) {
                ClassPathProviderImpl classPathProviderImpl = this.project.getClassPathProvider();
                this.projectSourcesClassPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPathProviderImpl.getProjectSourcesClassPath("classpath/source"), classPathProviderImpl.getProjectSourcesClassPath("classpath/compile")});
            }
            return this.projectSourcesClassPath;
        }
    }

    private EntityMappingsMetadataModelHelper createEntityMappingsHelper() {
        return EntityMappingsMetadataModelHelper.create((ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/source"));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == null || string.equals("meta.inf")) {
            this.locationChanged();
        }
    }

    private void locationChanged() {
        File file = this.project.getCarModule().getMetaInfAsFile();
        if (file != null) {
            File file2 = new File(file, "persistence.xml");
            this.scopesHelper.changePersistenceScope(this.persistenceScope, file2);
            this.modelHelper.changePersistenceXml(file2);
        } else {
            this.scopesHelper.changePersistenceScope(null, null);
            this.modelHelper.changePersistenceXml(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ScopeImpl
    implements PersistenceScopeImplementation,
    EntityClassScopeImplementation {
        private ScopeImpl() {
        }

        public FileObject getPersistenceXml() {
            FileObject fileObject = AppClientPersistenceProvider.this.getLocation();
            if (fileObject == null) {
                return null;
            }
            return fileObject.getFileObject("persistence.xml");
        }

        public ClassPath getClassPath() {
            return AppClientPersistenceProvider.this.getProjectSourcesClassPath();
        }

        public MetadataModel<EntityMappingsMetadata> getEntityMappingsModel(String string) {
            return AppClientPersistenceProvider.this.modelHelper.getEntityMappingsModel(string);
        }

        public MetadataModel<EntityMappingsMetadata> getEntityMappingsModel(boolean bl) {
            return AppClientPersistenceProvider.this.modelHelper.getDefaultEntityMappingsModel(bl);
        }
    }
}

