/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.clientproject.ui.AppClientLogicalViewProvider;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class AppClientSources
implements Sources,
PropertyChangeListener,
ChangeListener {
    private static final String BUILD_DIR_PROP = "${build.dir}";
    private static final String DIST_DIR_PROP = "${dist.dir}";
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testRoots;
    private SourcesHelper sourcesHelper;
    private Sources delegate;
    private boolean externalRootsRegistered;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    AppClientSources(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SourceRoots sourceRoots, SourceRoots sourceRoots2) {
        this.helper = antProjectHelper;
        this.evaluator = propertyEvaluator;
        this.sourceRoots = sourceRoots;
        this.testRoots = sourceRoots2;
        this.sourceRoots.addPropertyChangeListener((PropertyChangeListener)this);
        this.testRoots.addPropertyChangeListener((PropertyChangeListener)this);
        this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
        this.initSources();
    }

    public SourceGroup[] getSourceGroups(final String string) {
        return (SourceGroup[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<SourceGroup[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SourceGroup[] run() {
                Sources sources;
                AppClientSources appClientSources = AppClientSources.this;
                synchronized (appClientSources) {
                    if (AppClientSources.this.delegate == null) {
                        AppClientSources.this.delegate = AppClientSources.this.initSources();
                        AppClientSources.this.delegate.addChangeListener((ChangeListener)AppClientSources.this);
                    }
                    sources = AppClientSources.this.delegate;
                }
                return sources.getSourceGroups(string);
            }
        });
    }

    private Sources initSources() {
        this.sourcesHelper = new SourcesHelper(this.helper, this.evaluator);
        this.register(this.sourceRoots);
        this.register(this.testRoots);
        String string = NbBundle.getMessage(AppClientLogicalViewProvider.class, (String)"LBL_Node_ConfFiles");
        this.sourcesHelper.addPrincipalSourceRoot("${meta.inf}", string, null, null);
        this.sourcesHelper.addNonSourceRoot(BUILD_DIR_PROP);
        this.sourcesHelper.addNonSourceRoot(DIST_DIR_PROP);
        this.externalRootsRegistered = false;
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                if (!AppClientSources.this.externalRootsRegistered) {
                    AppClientSources.this.sourcesHelper.registerExternalRoots(0);
                    AppClientSources.this.externalRootsRegistered = true;
                }
            }
        });
        return this.sourcesHelper.createSources();
    }

    private void register(SourceRoots sourceRoots) {
        String[] stringArray = sourceRoots.getRootProperties();
        String[] stringArray2 = sourceRoots.getRootNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = sourceRoots.getRootDisplayName(stringArray2[i], string);
            String string3 = "${" + string + "}";
            String string4 = "${includes}";
            String string5 = "${excludes}";
            this.sourcesHelper.addPrincipalSourceRoot(string3, string4, string5, string2, null, null);
            this.sourcesHelper.addTypedSourceRoot(string3, string4, string5, "java", string2, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ChangeListener[] changeListenerArray;
        Object object = this;
        synchronized (object) {
            if (this.delegate != null) {
                this.delegate.removeChangeListener((ChangeListener)this);
                this.delegate = null;
            }
        }
        object = this.listeners;
        synchronized (object) {
            if (this.listeners.isEmpty()) {
                return;
            }
            changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        object = new ChangeEvent(this);
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged((ChangeEvent)object);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (SourceRoots.PROP_ROOT_PROPERTIES.equals(string) || "build.dir".equals(string) || "dist.dir".equals(string)) {
            this.fireChange();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChange();
    }
}

