/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.clientproject.AppClientProject;
import org.netbeans.modules.j2ee.clientproject.AppClientProjectUtil;
import org.netbeans.modules.j2ee.clientproject.classpath.ClassPathSupportCallbackImpl;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.AppClientProjectProperties;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.j2ee.common.project.classpath.ClassPathSupport;
import org.netbeans.modules.j2ee.common.project.ui.LibrariesNode;
import org.netbeans.modules.j2ee.common.project.ui.ProjectProperties;
import org.netbeans.modules.j2ee.common.ui.BrokenServerSupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.spi.ejbjar.support.J2eeProjectView;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.client.WebServicesClientView;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientView;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class AppClientLogicalViewProvider
implements LogicalViewProvider {
    private static final RequestProcessor BROKEN_LINKS_RP = new RequestProcessor("AppClientLogicalViewProvider.BROKEN_LINKS_RP");
    private final AppClientProject project;
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper resolver;
    private List<ChangeListener> changeListeners;
    private static final Object KEY_SERVICE_REFS = "serviceRefs";
    private static final String KEY_SETUP_DIR = "setupDir";
    private static final String KEY_CONF_DIR = "confDir";
    private static final String[] BREAKABLE_PROPERTIES = new String[]{"javac.classpath", "debug.classpath", "run.test.classpath", "debug.test.classpath", "javac.test.classpath"};

    public AppClientLogicalViewProvider(AppClientProject appClientProject, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper) {
        this.project = appClientProject;
        assert (appClientProject != null);
        this.helper = updateHelper;
        assert (updateHelper != null);
        this.evaluator = propertyEvaluator;
        assert (propertyEvaluator != null);
        this.resolver = referenceHelper;
    }

    public Node createLogicalView() {
        return new AppClientLogicalViewRootNode();
    }

    public Node findPath(Node node, Object object) {
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (object instanceof FileObject) {
            FileObject fileObject = (FileObject)object;
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (!project.equals(project2)) {
                return null;
            }
            Node[] nodeArray = node.getChildren().getNodes(true);
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node2 = PackageView.findPath((Node)nodeArray[i], (Object)object);
                if (node2 == null) continue;
                return node2;
            }
        }
        return null;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>();
        }
        this.changeListeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            return;
        }
        this.changeListeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBroken() {
        ChangeListener[] changeListenerArray;
        Object object = this;
        synchronized (object) {
            if (this.changeListeners == null) {
                return;
            }
            changeListenerArray = this.changeListeners.toArray(new ChangeListener[this.changeListeners.size()]);
        }
        object = new ChangeEvent(this);
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged((ChangeEvent)object);
        }
    }

    public boolean hasBrokenLinks() {
        return BrokenReferencesSupport.isBroken((AntProjectHelper)this.helper.getAntProjectHelper(), (ReferenceHelper)this.resolver, (String[])this.getBreakableProperties(), (String[])new String[]{"platform.active"});
    }

    public boolean hasInvalidJdkVersion() {
        String string = this.evaluator.getProperty("javac.source");
        String string2 = this.evaluator.getProperty("javac.target");
        if (string == null && string2 == null) {
            return false;
        }
        String string3 = this.evaluator.getProperty("platform.active");
        JavaPlatform javaPlatform = AppClientProjectUtil.getActivePlatform(string3);
        if (javaPlatform == null) {
            return true;
        }
        SpecificationVersion specificationVersion = javaPlatform.getSpecification().getVersion();
        try {
            return string != null && new SpecificationVersion(string).compareTo((Object)specificationVersion) > 0 || string2 != null && new SpecificationVersion(string2).compareTo((Object)specificationVersion) > 0;
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger("global").log(Level.INFO, "Invalid javac.source: " + string + " or javac.target: " + string2 + " of project:" + this.project.getProjectDirectory().getPath());
            return true;
        }
    }

    private String[] getBreakableProperties() {
        SourceRoots sourceRoots = this.project.getSourceRoots();
        String[] stringArray = sourceRoots.getRootProperties();
        sourceRoots = this.project.getTestSourceRoots();
        String[] stringArray2 = sourceRoots.getRootProperties();
        String[] stringArray3 = new String[BREAKABLE_PROPERTIES.length + stringArray.length + stringArray2.length];
        System.arraycopy(BREAKABLE_PROPERTIES, 0, stringArray3, 0, BREAKABLE_PROPERTIES.length);
        System.arraycopy(stringArray, 0, stringArray3, BREAKABLE_PROPERTIES.length, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, BREAKABLE_PROPERTIES.length + stringArray.length, stringArray2.length);
        return stringArray3;
    }

    private static class PreselectPropertiesAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final Project project;
        private final String nodeName;
        private final String panelName;

        public PreselectPropertiesAction(Project project, String string) {
            this(project, string, null);
        }

        public PreselectPropertiesAction(Project project, String string, String string2) {
            super(NbBundle.getMessage(AppClientLogicalViewProvider.class, (String)"LBL_Properties_Action"));
            this.project = project;
            this.nodeName = string;
            this.panelName = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CustomizerProviderImpl customizerProviderImpl = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
            if (customizerProviderImpl != null) {
                customizerProviderImpl.showCustomizer(this.nodeName, this.panelName);
            }
        }
    }

    private static class PackageViewFilterNode
    extends FilterNode {
        private final String nodeName;
        private final Project project;
        Action[] actions;

        public PackageViewFilterNode(SourceGroup sourceGroup, Project project) {
            super(PackageView.createPackageView((SourceGroup)sourceGroup));
            this.project = project;
            this.nodeName = "Sources";
        }

        public Action[] getActions(boolean bl) {
            if (!bl) {
                if (this.actions == null) {
                    Action[] actionArray = super.getActions(bl);
                    this.actions = new Action[actionArray.length + 2];
                    System.arraycopy(actionArray, 0, this.actions, 0, actionArray.length);
                    this.actions[actionArray.length] = null;
                    this.actions[actionArray.length + 1] = new PreselectPropertiesAction(this.project, this.nodeName);
                }
                return this.actions;
            }
            return super.getActions(bl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LogicalViewChildren
    extends Children.Keys<Object>
    implements ChangeListener {
        private static final Object LIBRARIES = "Libs";
        private static final Object TEST_LIBRARIES = "TestLibs";
        private static final String WSDL_FOLDER = "wsdl";
        private final AppClientProject project;
        private final PropertyEvaluator evaluator;
        private final UpdateHelper helper;
        private final ReferenceHelper resolver;
        private final SourceRoots testSources;
        private final WsdlCreationListener wsdlListener;
        private final MetaInfListener metaInfListener;
        private final JaxWsChangeListener jaxWsListener;
        private FileObject wsdlFolder;
        private Car jp;
        private final ClassPathSupport cs;

        public LogicalViewChildren(AppClientProject appClientProject, PropertyEvaluator propertyEvaluator, UpdateHelper updateHelper, ReferenceHelper referenceHelper) {
            this.project = appClientProject;
            this.evaluator = propertyEvaluator;
            this.helper = updateHelper;
            this.resolver = referenceHelper;
            this.testSources = appClientProject.getTestSourceRoots();
            this.metaInfListener = new MetaInfListener();
            this.wsdlListener = new WsdlCreationListener();
            this.jaxWsListener = new JaxWsChangeListener();
            this.cs = new ClassPathSupport(propertyEvaluator, referenceHelper, updateHelper.getAntProjectHelper(), updateHelper, (ClassPathSupport.Callback)new ClassPathSupportCallbackImpl(updateHelper.getAntProjectHelper()));
            Car[] carArray = Car.getCars((Project)appClientProject);
            assert (carArray.length > 0);
            this.jp = carArray[0];
        }

        protected void addNotify() {
            JaxWsModel jaxWsModel;
            FileObject fileObject;
            super.addNotify();
            this.getSources().addChangeListener((ChangeListener)this);
            AntProjectHelper antProjectHelper = this.helper.getAntProjectHelper();
            String string = this.evaluator.getProperty("meta.inf");
            if (string != null && (fileObject = antProjectHelper.resolveFileObject(string)) != null) {
                fileObject.addFileChangeListener((FileChangeListener)this.metaInfListener);
            }
            if ((string = this.evaluator.getProperty("src.dir")) != null && (fileObject = antProjectHelper.resolveFileObject(string)) != null) {
                fileObject.addFileChangeListener((FileChangeListener)this.metaInfListener);
            }
            fileObject = WebServicesClientSupport.getWebServicesClientSupport((FileObject)this.project.getProjectDirectory());
            try {
                if (fileObject != null) {
                    this.wsdlFolder = fileObject.getWsdlFolder(false);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            if (this.wsdlFolder != null) {
                this.wsdlFolder.addFileChangeListener((FileChangeListener)this.wsdlListener);
            }
            if ((jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class)) != null) {
                jaxWsModel.addPropertyChangeListener((PropertyChangeListener)this.jaxWsListener);
            }
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            FileObject fileObject;
            this.setKeys(Collections.emptySet());
            this.getSources().removeChangeListener((ChangeListener)this);
            AntProjectHelper antProjectHelper = this.helper.getAntProjectHelper();
            String string = this.evaluator.getProperty("meta.inf");
            if (string != null && (fileObject = antProjectHelper.resolveFileObject(string)) != null) {
                fileObject.addFileChangeListener((FileChangeListener)this.metaInfListener);
            }
            if ((string = this.evaluator.getProperty("src.dir")) != null && (fileObject = antProjectHelper.resolveFileObject(string)) != null) {
                fileObject.removeFileChangeListener((FileChangeListener)this.metaInfListener);
            }
            if (this.wsdlFolder != null) {
                this.wsdlFolder.removeFileChangeListener((FileChangeListener)this.wsdlListener);
            }
            if ((fileObject = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class)) != null) {
                fileObject.removePropertyChangeListener((PropertyChangeListener)this.jaxWsListener);
            }
            super.removeNotify();
        }

        protected Node[] createNodes(Object object) {
            Node[] nodeArray;
            if (object == LIBRARIES) {
                nodeArray = new Node[]{new LibrariesNode(NbBundle.getMessage(AppClientLogicalViewProvider.class, (String)"CTL_LibrariesNode"), (Project)this.project, this.evaluator, this.helper, this.resolver, "run.classpath", new String[]{"build.classes.dir"}, "platform.active", "j2ee.server.instance", "j2ee.platform.classpath", new Action[]{LibrariesNode.createAddProjectAction((Project)this.project, (SourceRoots)this.project.getSourceRoots()), LibrariesNode.createAddLibraryAction((ReferenceHelper)this.resolver, (SourceRoots)this.project.getSourceRoots(), null), LibrariesNode.createAddFolderAction((AntProjectHelper)this.project.getAntProjectHelper(), (SourceRoots)this.project.getSourceRoots()), null, new PreselectPropertiesAction(this.project, "Libraries", "COMPILE")}, "included-library", this.cs)};
            } else if (object == TEST_LIBRARIES) {
                nodeArray = new Node[]{new LibrariesNode(NbBundle.getMessage(AppClientLogicalViewProvider.class, (String)"CTL_TestLibrariesNode"), (Project)this.project, this.evaluator, this.helper, this.resolver, "run.test.classpath", new String[]{"build.test.classes.dir", "javac.classpath", "build.classes.dir"}, null, null, null, new Action[]{LibrariesNode.createAddProjectAction((Project)this.project, (SourceRoots)this.project.getTestSourceRoots()), LibrariesNode.createAddLibraryAction((ReferenceHelper)this.resolver, (SourceRoots)this.project.getTestSourceRoots(), null), LibrariesNode.createAddFolderAction((AntProjectHelper)this.project.getAntProjectHelper(), (SourceRoots)this.project.getTestSourceRoots()), null, new PreselectPropertiesAction(this.project, "Libraries", "COMPILE_TESTS")}, null, this.cs)};
            } else if (object instanceof SourceGroupKey) {
                nodeArray = new Node[]{PackageView.createPackageView((SourceGroup)((SourceGroupKey)object).group)};
            } else if (object == AppClientLogicalViewProvider.KEY_SETUP_DIR) {
                nodeArray = new Node[]{J2eeProjectView.createServerResourcesNode((Project)this.project)};
            } else if (object == AppClientLogicalViewProvider.KEY_CONF_DIR) {
                nodeArray = new Node[]{J2eeProjectView.createConfigFilesView((FileObject)this.jp.getMetaInf())};
            } else if (object == KEY_SERVICE_REFS) {
                FileObject fileObject;
                WebServicesClientSupport webServicesClientSupport;
                WebServicesClientView webServicesClientView;
                FileObject fileObject2;
                Map map = this.project.getAntProjectHelper().getStandardPropertyEvaluator().getProperties();
                String string = (String)map.get("j2ee.server.instance");
                J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(string);
                Car car = Car.getCar((FileObject)this.project.getProjectDirectory());
                nodeArray = null;
                ArrayList<Node> arrayList = new ArrayList<Node>();
                JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
                JAXWSClientSupport jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.project.getProjectDirectory());
                if (jAXWSClientSupport != null && jaxWsModel != null && jaxWsModel.getClients().length > 0 && (fileObject2 = JAXWSClientView.getJAXWSClientView()) != null) {
                    arrayList.add(fileObject2.createJAXWSClientView((Project)this.project));
                }
                if ((webServicesClientView = WebServicesClientView.getWebServicesClientView((FileObject)(fileObject2 = this.project.getProjectDirectory()))) != null && (webServicesClientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)fileObject2)) != null && !webServicesClientSupport.getServiceClients().isEmpty() && (fileObject = webServicesClientSupport.getWsdlFolder()) != null) {
                    FileObject[] fileObjectArray = fileObject.getChildren();
                    boolean bl = false;
                    for (int i = 0; i < fileObjectArray.length; ++i) {
                        if (!fileObjectArray[i].getExt().equalsIgnoreCase(WSDL_FOLDER)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        arrayList.add(webServicesClientView.createWebServiceClientView(fileObject));
                    }
                }
                nodeArray = arrayList.toArray(new Node[arrayList.size()]);
            } else {
                assert (false) : "Unknown key type";
                nodeArray = new Node[]{};
            }
            return nodeArray;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LogicalViewChildren.this.setKeys(LogicalViewChildren.this.getKeys());
                }
            });
        }

        private Collection<Object> getKeys() {
            File file;
            if (this.project.getProjectDirectory() == null || !this.project.getProjectDirectory().isValid()) {
                return Collections.emptyList();
            }
            Sources sources = this.getSources();
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
            ArrayList<Object> arrayList = new ArrayList<Object>(sourceGroupArray.length);
            arrayList.add(AppClientLogicalViewProvider.KEY_CONF_DIR);
            arrayList.add(AppClientLogicalViewProvider.KEY_SETUP_DIR);
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                arrayList.add(new SourceGroupKey(sourceGroupArray[i]));
            }
            arrayList.add(LIBRARIES);
            URL[] uRLArray = this.testSources.getRootURLs();
            boolean bl = false;
            for (int i = 0; i < uRLArray.length; ++i) {
                file = new File(URI.create(uRLArray[i].toExternalForm()));
                if (!file.exists()) continue;
                bl = true;
                break;
            }
            if (bl) {
                arrayList.add(TEST_LIBRARIES);
            }
            JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
            file = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.project.getProjectDirectory());
            if (file != null && jaxWsModel != null && jaxWsModel.getClients().length > 0) {
                arrayList.add(KEY_SERVICE_REFS);
            } else {
                List list;
                WebServicesClientSupport webServicesClientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)this.project.getProjectDirectory());
                if (webServicesClientSupport != null && (list = webServicesClientSupport.getServiceClients()) != null && !list.isEmpty()) {
                    arrayList.add(KEY_SERVICE_REFS);
                }
            }
            return arrayList;
        }

        private Sources getSources() {
            return ProjectUtils.getSources((Project)this.project);
        }

        private final class JaxWsChangeListener
        implements PropertyChangeListener {
            private JaxWsChangeListener() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LogicalViewChildren.this.refreshKey(KEY_SERVICE_REFS);
                    }
                });
            }
        }

        private final class MetaInfListener
        extends FileChangeAdapter {
            private MetaInfListener() {
            }

            public void fileFolderCreated(FileEvent fileEvent) {
                if (fileEvent.getFile().isFolder() && LogicalViewChildren.WSDL_FOLDER.equals(fileEvent.getFile().getName())) {
                    fileEvent.getFile().addFileChangeListener((FileChangeListener)LogicalViewChildren.this.wsdlListener);
                } else if (fileEvent.getFile().isFolder() && "META-INF".equals(fileEvent.getFile().getName())) {
                    fileEvent.getFile().addFileChangeListener((FileChangeListener)LogicalViewChildren.this.metaInfListener);
                }
            }

            public void fileDeleted(FileEvent fileEvent) {
                if (fileEvent.getFile().isFolder() && LogicalViewChildren.WSDL_FOLDER.equals(fileEvent.getFile().getName())) {
                    fileEvent.getFile().removeFileChangeListener((FileChangeListener)LogicalViewChildren.this.wsdlListener);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            LogicalViewChildren.this.refreshKey(KEY_SERVICE_REFS);
                        }
                    });
                } else if (fileEvent.getFile().isFolder() && "META-INF".equals(fileEvent.getFile().getName())) {
                    fileEvent.getFile().removeFileChangeListener((FileChangeListener)LogicalViewChildren.this.metaInfListener);
                }
            }
        }

        private final class WsdlCreationListener
        extends FileChangeAdapter {
            private WsdlCreationListener() {
            }

            public void fileDataCreated(FileEvent fileEvent) {
                if (LogicalViewChildren.WSDL_FOLDER.equalsIgnoreCase(fileEvent.getFile().getExt())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            LogicalViewChildren.this.refreshKey(KEY_SERVICE_REFS);
                        }
                    });
                }
            }

            public void fileDeleted(FileEvent fileEvent) {
                if (LogicalViewChildren.WSDL_FOLDER.equalsIgnoreCase(fileEvent.getFile().getExt())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            LogicalViewChildren.this.refreshKey(KEY_SERVICE_REFS);
                        }
                    });
                } else if (fileEvent.getFile().isFolder() && LogicalViewChildren.WSDL_FOLDER.equals(fileEvent.getFile().getName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            LogicalViewChildren.this.refreshKey(KEY_SERVICE_REFS);
                        }
                    });
                }
            }
        }

        private static class SourceGroupKey {
            public final SourceGroup group;
            public final FileObject fileObject;

            SourceGroupKey(SourceGroup sourceGroup) {
                this.group = sourceGroup;
                this.fileObject = sourceGroup.getRootFolder();
            }

            public int hashCode() {
                return this.fileObject.hashCode();
            }

            public boolean equals(Object object) {
                if (!(object instanceof SourceGroupKey)) {
                    return false;
                }
                SourceGroupKey sourceGroupKey = (SourceGroupKey)object;
                String string = this.group.getDisplayName();
                String string2 = sourceGroupKey.group.getDisplayName();
                return this.fileObject.equals(sourceGroupKey.fileObject) && string == null ? string2 == null : string.equals(string2);
            }
        }
    }

    private final class AppClientLogicalViewRootNode
    extends AbstractNode {
        private Action brokenLinksAction;
        private BrokenServerAction brokenServerAction;
        private boolean broken;
        private boolean illegalState;

        public AppClientLogicalViewRootNode() {
            super((Children)new LogicalViewChildren(AppClientLogicalViewProvider.this.project, AppClientLogicalViewProvider.this.evaluator, AppClientLogicalViewProvider.this.helper, AppClientLogicalViewProvider.this.resolver), Lookups.singleton((Object)AppClientLogicalViewProvider.this.project));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/clientproject/ui/resources/appclient.gif");
            super.setName(ProjectUtils.getInformation((Project)AppClientLogicalViewProvider.this.project).getDisplayName());
            if (AppClientLogicalViewProvider.this.hasBrokenLinks()) {
                this.broken = true;
            } else if (AppClientLogicalViewProvider.this.hasInvalidJdkVersion()) {
                this.illegalState = true;
            }
            this.brokenLinksAction = new BrokenLinksAction();
            this.brokenServerAction = new BrokenServerAction();
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)AppClientLogicalViewProvider.this.project.getLookup().lookup(J2eeModuleProvider.class);
            j2eeModuleProvider.addInstanceListener((InstanceListener)WeakListeners.create(InstanceListener.class, (EventListener)this.brokenServerAction, (Object)j2eeModuleProvider));
        }

        public String getHtmlDisplayName() {
            String string = super.getDisplayName();
            try {
                string = XMLUtil.toElementContent((String)string);
            }
            catch (CharConversionException charConversionException) {
                return string;
            }
            return this.broken || this.illegalState || this.brokenServerAction.isEnabled() ? "<font color=\"#A40000\">" + string + "</font>" : null;
        }

        public Image getIcon(int n) {
            Image image = super.getIcon(n);
            return this.broken || this.illegalState || this.brokenServerAction.isEnabled() ? Utilities.mergeImages((Image)image, (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)8, (int)0) : image;
        }

        public Image getOpenedIcon(int n) {
            Image image = super.getOpenedIcon(n);
            return this.broken || this.illegalState || this.brokenServerAction.isEnabled() ? Utilities.mergeImages((Image)image, (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)8, (int)0) : image;
        }

        public String getShortDescription() {
            String string = FileUtil.getFileDisplayName((FileObject)AppClientLogicalViewProvider.this.project.getProjectDirectory());
            return NbBundle.getMessage(AppClientLogicalViewProvider.class, (String)"HINT_project_root_node", (Object)string);
        }

        public Action[] getActions(boolean bl) {
            return this.getAdditionalActions();
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String string) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)AppClientLogicalViewProvider.this.project, (String)string);
        }

        private Action[] getAdditionalActions() {
            ResourceBundle resourceBundle = NbBundle.getBundle(AppClientLogicalViewProvider.class);
            ArrayList<Action> arrayList = new ArrayList<Action>(30);
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)AppClientLogicalViewProvider.this.project.getLookup().lookup(J2eeModuleProvider.class);
            arrayList.add(CommonProjectActions.newFileAction());
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)resourceBundle.getString("LBL_BuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)resourceBundle.getString("LBL_RebuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)resourceBundle.getString("LBL_CleanAction_Name"), null));
            if (j2eeModuleProvider != null && j2eeModuleProvider.hasVerifierSupport()) {
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"verify", (String)resourceBundle.getString("LBL_VerifyAction_Name"), null));
            }
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"javadoc", (String)resourceBundle.getString("LBL_JavadocAction_Name"), null));
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)resourceBundle.getString("LBL_RunAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"redeploy", (String)resourceBundle.getString("LBL_RedeployAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)resourceBundle.getString("LBL_DebugAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"test", (String)resourceBundle.getString("LBL_TestAction_Name"), null));
            arrayList.add(null);
            arrayList.add(CommonProjectActions.setAsMainProjectAction());
            arrayList.add(CommonProjectActions.openSubprojectsAction());
            arrayList.add(CommonProjectActions.closeProjectAction());
            arrayList.add(null);
            arrayList.add(CommonProjectActions.renameProjectAction());
            arrayList.add(CommonProjectActions.moveProjectAction());
            arrayList.add(CommonProjectActions.copyProjectAction());
            arrayList.add(CommonProjectActions.deleteProjectAction());
            arrayList.add(null);
            arrayList.add((Action)SystemAction.get(FindAction.class));
            arrayList.add(null);
            arrayList.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
            arrayList.add(null);
            if (this.brokenLinksAction != null && this.brokenLinksAction.isEnabled()) {
                arrayList.add(this.brokenLinksAction);
            }
            if (this.brokenServerAction.isEnabled()) {
                arrayList.add(this.brokenServerAction);
            }
            arrayList.add(CommonProjectActions.customizeProjectAction());
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        private void setBroken(boolean bl) {
            this.broken = bl;
            this.brokenLinksAction.setEnabled(bl);
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.fireDisplayNameChange(null, null);
        }

        private void setIllegalState(boolean bl) {
            this.illegalState = bl;
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.fireDisplayNameChange(null, null);
        }

        private class BrokenServerAction
        extends AbstractAction
        implements InstanceListener,
        PropertyChangeListener {
            private static final long serialVersionUID = 1L;
            private RequestProcessor.Task task = null;
            private boolean brokenServer;

            public BrokenServerAction() {
                this.putValue("Name", NbBundle.getMessage(AppClientLogicalViewProvider.class, (String)"LBL_Fix_Missing_Server_Action"));
                AppClientLogicalViewProvider.this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
                this.checkMissingServer();
            }

            public boolean isEnabled() {
                return this.brokenServer;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                String string2 = AppClientProjectProperties.getProperty("j2ee.platform", AppClientLogicalViewProvider.this.helper.getAntProjectHelper(), "nbproject/project.properties");
                if (string2 == null) {
                    string2 = "1.5";
                    Logger.getLogger(AppClientLogicalViewProvider.class.getName()).warning("project [" + AppClientLogicalViewProvider.this.project.getProjectDirectory() + "] is missing " + "j2ee.platform" + ". " + "default value will be used instead: " + string2);
                    this.updateJ2EESpec(AppClientLogicalViewProvider.this.project, AppClientLogicalViewProvider.this.project.getAntProjectHelper(), string2);
                }
                if ((string = BrokenServerSupport.selectServer((String)string2, (Object)J2eeModule.CLIENT)) != null) {
                    AppClientProjectProperties.setServerInstance(AppClientLogicalViewProvider.this.project, AppClientLogicalViewProvider.this.helper.getAntProjectHelper(), string);
                }
                this.checkMissingServer();
            }

            private void updateJ2EESpec(final Project project, final AntProjectHelper antProjectHelper, final String string) {
                ProjectManager.mutex().postWriteRequest(new Runnable(){

                    public void run() {
                        try {
                            EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                            editableProperties.put("j2ee.platform", string);
                            antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                            ProjectManager.getDefault().saveProject(project);
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                });
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("j2ee.server.instance".equals(propertyChangeEvent.getPropertyName())) {
                    this.checkMissingServer();
                }
            }

            public void changeDefaultInstance(String string, String string2) {
            }

            public void instanceAdded(String string) {
                this.checkMissingServer();
            }

            public void instanceRemoved(String string) {
                this.checkMissingServer();
            }

            private void checkMissingServer() {
                boolean bl = this.brokenServer;
                String string = AppClientProjectProperties.getProperty("j2ee.server.instance", AppClientLogicalViewProvider.this.helper.getAntProjectHelper(), "nbproject/private/private.properties");
                this.brokenServer = BrokenServerSupport.isBroken((String)string);
                if (bl != this.brokenServer) {
                    AppClientLogicalViewRootNode.this.fireIconChange();
                    AppClientLogicalViewRootNode.this.fireOpenedIconChange();
                    AppClientLogicalViewRootNode.this.fireDisplayNameChange(null, null);
                }
            }
        }

        private class BrokenLinksAction
        extends AbstractAction
        implements PropertyChangeListener,
        ChangeListener,
        Runnable {
            private static final long serialVersionUID = 1L;
            private RequestProcessor.Task task = null;
            private final PropertyChangeListener weakPCL;

            public BrokenLinksAction() {
                this.putValue("Name", NbBundle.getMessage(AppClientLogicalViewProvider.class, (String)"LBL_Fix_Broken_Links_Action"));
                this.setEnabled(AppClientLogicalViewRootNode.this.broken);
                AppClientLogicalViewProvider.this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
                this.weakPCL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)JavaPlatformManager.getDefault());
                JavaPlatformManager.getDefault().addPropertyChangeListener(this.weakPCL);
                AppClientLogicalViewProvider.this.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)AppClientLogicalViewProvider.this));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AppClientLogicalViewProvider.this.helper.requestUpdate();
                    BrokenReferencesSupport.showCustomizer((AntProjectHelper)AppClientLogicalViewProvider.this.helper.getAntProjectHelper(), (ReferenceHelper)AppClientLogicalViewProvider.this.resolver, (String[])AppClientLogicalViewProvider.this.getBreakableProperties(), (String[])new String[]{"platform.active"});
                    this.run();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.refsMayChanged();
            }

            public void stateChanged(ChangeEvent changeEvent) {
                this.refsMayChanged();
            }

            public synchronized void run() {
                boolean bl;
                boolean bl2 = AppClientLogicalViewRootNode.this.broken;
                if (bl2 != (bl = AppClientLogicalViewProvider.this.hasBrokenLinks())) {
                    AppClientLogicalViewRootNode.this.setBroken(bl);
                }
                if ((bl2 = AppClientLogicalViewRootNode.this.illegalState) != (bl = AppClientLogicalViewProvider.this.hasInvalidJdkVersion())) {
                    AppClientLogicalViewRootNode.this.setIllegalState(bl);
                }
            }

            private void refsMayChanged() {
                if (this.task == null) {
                    this.task = BROKEN_LINKS_RP.create((Runnable)this);
                }
                this.task.schedule(100);
            }
        }
    }
}

