/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.refactoring;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.xml.schema.model.Choice;
import org.netbeans.modules.xml.schema.model.ComplexContent;
import org.netbeans.modules.xml.schema.model.ComplexContentDefinition;
import org.netbeans.modules.xml.schema.model.ComplexExtension;
import org.netbeans.modules.xml.schema.model.ComplexType;
import org.netbeans.modules.xml.schema.model.ComplexTypeDefinition;
import org.netbeans.modules.xml.schema.model.Element;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.Sequence;
import org.netbeans.modules.xml.schema.model.SequenceDefinition;
import org.netbeans.modules.xml.schema.model.SimpleType;
import org.netbeans.modules.xml.schema.model.TypeContainer;
import org.netbeans.modules.xml.schema.model.visitor.DeepSchemaVisitor;
import org.netbeans.modules.xml.schema.model.visitor.SchemaVisitor;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xpath.AbstractXPathModelHelper;
import org.netbeans.modules.xml.xpath.LocationStep;
import org.netbeans.modules.xml.xpath.StepNodeNameTest;
import org.netbeans.modules.xml.xpath.StepNodeTest;
import org.netbeans.modules.xml.xpath.XPathCoreFunction;
import org.netbeans.modules.xml.xpath.XPathCoreOperation;
import org.netbeans.modules.xml.xpath.XPathException;
import org.netbeans.modules.xml.xpath.XPathExpression;
import org.netbeans.modules.xml.xpath.XPathExpressionPath;
import org.netbeans.modules.xml.xpath.XPathExtensionFunction;
import org.netbeans.modules.xml.xpath.XPathLocationPath;
import org.netbeans.modules.xml.xpath.XPathModel;
import org.netbeans.modules.xml.xpath.XPathOperationOrFuntion;
import org.netbeans.modules.xml.xpath.XPathPredicateExpression;
import org.netbeans.modules.xml.xpath.XPathVariableReference;
import org.netbeans.modules.xml.xpath.visitor.AbstractXPathVisitor;
import org.netbeans.modules.xml.xpath.visitor.XPathVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class XPath
extends AbstractXPathVisitor {
    private Named myTarget;
    private String myOldName;
    private String myPartName;
    private boolean myDoRename;
    private Variable myVariable;
    private Component myComponent;
    private List<XPathExpression> myExpressions;
    private List<ComplexType> myVisitedComplexType;
    private XPathVariableReference myVariableReference;
    private NamedComponentReference<GlobalType> myTypeReference;
    private List<Component> myUsage;
    private static final String INDENT = "  ";

    XPath(List<Component> list, Named named, String string) {
        this.myOldName = string;
        this.myTarget = named;
        this.myUsage = list;
    }

    void visit(String string, Component component) {
        this.visit(string, component, false);
    }

    String rename(String string, Component component) {
        return this.visit(string, component, true);
    }

    private String visit(String string, Component component, boolean bl) {
        if (string == null || string.length() == 0) {
            return string;
        }
        XPathModel xPathModel = AbstractXPathModelHelper.getInstance().newXPathModel();
        this.myVisitedComplexType = new LinkedList<ComplexType>();
        this.myExpressions = new LinkedList<XPathExpression>();
        this.myComponent = component;
        this.myDoRename = bl;
        try {
            XPathExpression xPathExpression = xPathModel.parseExpression(string);
            xPathExpression.accept((XPathVisitor)this);
            if (this.myDoRename) {
                this.rename(this.myTarget.getName());
            }
            return xPathExpression.getExpressionString();
        }
        catch (XPathException xPathException) {
            return string;
        }
    }

    private void rename(String string) {
        for (XPathExpression xPathExpression : this.myExpressions) {
            LocationStep locationStep;
            if (xPathExpression instanceof LocationStep) {
                locationStep = (LocationStep)xPathExpression;
                locationStep.setNodeTest((StepNodeTest)new StepNodeNameTest(this.createName(locationStep.getString(), string)));
                continue;
            }
            if (!(xPathExpression instanceof XPathVariableReference)) continue;
            locationStep = (XPathVariableReference)xPathExpression;
            locationStep.setVariableName(this.createName(locationStep.getVariableName(), string));
        }
    }

    private String createName(String string, String string2) {
        int n = string.indexOf(":");
        if (n == -1) {
            return string2;
        }
        return string.substring(0, n + 1) + string2;
    }

    private String createName(QName qName, String string) {
        String string2 = qName.getLocalPart();
        int n = string2.indexOf(".");
        if (n == -1) {
            return string2;
        }
        return string2.substring(0, n + 1) + string;
    }

    public void visit(XPathExpressionPath xPathExpressionPath) {
        XPathExpression xPathExpression = xPathExpressionPath.getRootExpression();
        this.myVariable = null;
        this.myVariableReference = null;
        if (!xPathExpressionPath.equals(xPathExpression)) {
            xPathExpression.accept((XPathVisitor)this);
        }
        if (this.myVariable == null) {
            return;
        }
        if (this.myVariable == this.myTarget) {
            return;
        }
        LocationStep[] locationStepArray = xPathExpressionPath.getSteps();
        LinkedList<LocationStep> linkedList = new LinkedList<LocationStep>();
        linkedList.add(null);
        if (locationStepArray == null) {
            return;
        }
        for (LocationStep locationStep : locationStepArray) {
            linkedList.add(locationStep);
        }
        this.visit(linkedList);
        this.visit(locationStepArray);
    }

    private void visit(LocationStep[] locationStepArray) {
        if (locationStepArray == null) {
            return;
        }
        for (LocationStep locationStep : locationStepArray) {
            locationStep.accept((XPathVisitor)this);
        }
    }

    private void visit(List<LocationStep> list) {
        this.visitReference((NamedComponentReference)this.myVariable.getMessageType(), this.createList(list), "");
        this.visitReference((NamedComponentReference)this.myVariable.getElement(), this.createList(list), "");
        this.visitReference((NamedComponentReference)this.myVariable.getType(), this.createList(list), "");
    }

    private List<LocationStep> createList(List<LocationStep> list) {
        LinkedList<LocationStep> linkedList = new LinkedList<LocationStep>();
        for (LocationStep locationStep : list) {
            linkedList.add(locationStep);
        }
        return linkedList;
    }

    private void visitPart(Part part, List<LocationStep> list) {
        this.visitReference(part.getElement(), this.createList(list), "");
        this.visitReference(part.getType(), this.createList(list), "");
    }

    private void visitReference(NamedComponentReference namedComponentReference, List<LocationStep> list, String string) {
        if (namedComponentReference != null) {
            this.visitComponent(namedComponentReference.get(), list, string);
        }
    }

    private void visitComponent(Object object, List<LocationStep> list, String string) {
        if (object instanceof ComplexType) {
            this.visitComplexType((ComplexType)object, list, string);
        } else if (object instanceof SimpleType) {
            this.visitSimpleType((SimpleType)object, list, string);
        } else if (object instanceof Element) {
            this.visitElement((Element)object, list, string);
        } else if (object instanceof Message) {
            this.visitMessage((Message)object, list, string);
        } else if (object == null) {
            return;
        }
    }

    private void visitMessage(Message message, List<LocationStep> list, String string) {
        for (Part part : message.getParts()) {
            if (part.equals(this.myTarget)) {
                this.addItem();
                if (this.myDoRename) {
                    this.myExpressions.add((XPathExpression)this.myVariableReference);
                }
            }
            if (!this.myPartName.equals(part.getName())) continue;
            this.visitPart(part, this.createList(list));
        }
    }

    private void visitElement(Element element, List<LocationStep> list, String string) {
        if (this.checkUsages((Component)element, list, false)) {
            return;
        }
        this.myTypeReference = null;
        element.accept((SchemaVisitor)new DeepSchemaVisitor(){

            public void visit(ComplexExtension complexExtension) {
                XPath.this.myTypeReference = complexExtension.getBase();
            }
        });
        this.visitReference(this.myTypeReference, list, string + INDENT);
        if (element instanceof TypeContainer) {
            TypeContainer typeContainer = (TypeContainer)element;
            this.visitReference(typeContainer.getType(), this.createList(list), string + INDENT);
            this.visitComponent(typeContainer.getInlineType(), this.createList(list), string + INDENT);
        }
    }

    private void visitComplexType(ComplexType complexType, List<LocationStep> list, String string) {
        if (this.myVisitedComplexType.contains(complexType)) {
            return;
        }
        this.myVisitedComplexType.add(complexType);
        if (this.checkUsages((Component)complexType, list, true)) {
            return;
        }
        ComplexTypeDefinition complexTypeDefinition = complexType.getDefinition();
        if (complexTypeDefinition instanceof Sequence) {
            this.visitSequence((Sequence)complexTypeDefinition, list, string + INDENT);
        } else if (complexTypeDefinition instanceof Choice) {
            this.visitChoice((Choice)complexTypeDefinition, list, string);
        } else if (complexTypeDefinition instanceof ComplexContent) {
            this.visitComplexContent((ComplexContent)complexTypeDefinition, list, string);
        }
        Collection collection = complexType.getLocalAttributes();
        for (LocalAttribute localAttribute : collection) {
            this.visitAttribute(localAttribute, list, string);
        }
    }

    private void visitAttribute(LocalAttribute localAttribute, List<LocationStep> list, String string) {
        this.checkUsages((Component)localAttribute, list, true);
    }

    private void visitComplexContent(ComplexContent complexContent, List<LocationStep> list, String string) {
        ComplexContentDefinition complexContentDefinition = complexContent.getLocalDefinition();
        if (complexContentDefinition instanceof ComplexExtension) {
            this.visitReference(((ComplexExtension)complexContentDefinition).getBase(), list, string);
        }
    }

    private void visitChoice(Choice choice, List<LocationStep> list, String string) {
        Iterator iterator = choice.getChoices().iterator();
        while (iterator.hasNext()) {
            this.visitChoice((Choice)iterator.next(), this.createList(list), string + INDENT);
        }
        Iterator iterator2 = choice.getSequences().iterator();
        while (iterator2.hasNext()) {
            this.visitSequence((Sequence)iterator2.next(), this.createList(list), string + INDENT);
        }
        Iterator iterator3 = choice.getLocalElements().iterator();
        while (iterator3.hasNext()) {
            this.visitElement((Element)iterator3.next(), this.createList(list), string + INDENT);
        }
        Iterator iterator4 = choice.getElementReferences().iterator();
        while (iterator4.hasNext()) {
            this.visitReference(((ElementReference)iterator4.next()).getRef(), this.createList(list), string + INDENT);
        }
    }

    private void visitSequence(Sequence sequence, List<LocationStep> list, String string) {
        List list2 = sequence.getContent();
        if (list2 == null) {
            return;
        }
        for (SequenceDefinition sequenceDefinition : list2) {
            if (sequenceDefinition instanceof Element) {
                this.visitElement((Element)sequenceDefinition, this.createList(list), string + INDENT);
                continue;
            }
            if (sequenceDefinition instanceof ComplexType) {
                this.visitComplexType((ComplexType)sequenceDefinition, this.createList(list), string + INDENT);
                continue;
            }
            if (sequenceDefinition instanceof SimpleType) {
                this.visitSimpleType((SimpleType)sequenceDefinition, this.createList(list), string + INDENT);
                continue;
            }
            if (sequenceDefinition instanceof ElementReference) {
                this.visitReference(((ElementReference)sequenceDefinition).getRef(), this.createList(list), string + INDENT);
                continue;
            }
            return;
        }
    }

    private void visitSimpleType(SimpleType simpleType, List<LocationStep> list, String string) {
        this.checkUsages((Component)simpleType, list, true);
    }

    public void visit(XPathVariableReference xPathVariableReference) {
        QName qName = xPathVariableReference.getVariableName();
        String string = qName.getLocalPart();
        String string2 = "";
        int n = string.indexOf(".");
        if (n != -1) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        if (!(this.myComponent instanceof BpelEntity)) {
            return;
        }
        Variable[] variableArray = ((BpelModel)((BpelEntity)this.myComponent).getModel()).getProcess().getVariableContainer().getVariables();
        if (variableArray == null) {
            return;
        }
        for (Variable variable : variableArray) {
            if (!variable.getName().equals(string)) continue;
            this.myVariable = variable;
            this.myVariableReference = xPathVariableReference;
            this.myPartName = string2;
            if (this.myVariable != this.myTarget) break;
            this.addItem();
            break;
        }
    }

    public void visit(LocationStep locationStep) {
        XPathPredicateExpression[] xPathPredicateExpressionArray = locationStep.getPredicates();
        if (xPathPredicateExpressionArray == null) {
            return;
        }
        for (XPathPredicateExpression xPathPredicateExpression : xPathPredicateExpressionArray) {
            xPathPredicateExpression.accept((XPathVisitor)this);
        }
    }

    public void visit(XPathCoreFunction xPathCoreFunction) {
        this.visitChildren((XPathOperationOrFuntion)xPathCoreFunction);
    }

    public void visit(XPathCoreOperation xPathCoreOperation) {
        this.visitChildren((XPathOperationOrFuntion)xPathCoreOperation);
    }

    public void visit(XPathExtensionFunction xPathExtensionFunction) {
        this.visitChildren((XPathOperationOrFuntion)xPathExtensionFunction);
    }

    public void visit(XPathLocationPath xPathLocationPath) {
        this.visit(xPathLocationPath.getSteps());
    }

    private boolean checkUsages(Component component, List<LocationStep> list, boolean bl) {
        if (component == null) {
            return false;
        }
        if (list.size() == 0) {
            return false;
        }
        LocationStep locationStep = list.get(0);
        if (this.myTarget.equals(component)) {
            if (locationStep != null && this.equalsIgnorePrefixAndAmpersand(this.myOldName, locationStep.getString())) {
                this.addItem();
                if (this.myDoRename) {
                    this.myExpressions.add((XPathExpression)locationStep);
                }
                return true;
            }
        } else if (bl) {
            list.remove(0);
        }
        return false;
    }

    private boolean equalsIgnorePrefixAndAmpersand(String string, String string2) {
        int n;
        if (string == null || string2 == null) {
            return false;
        }
        if (string2.startsWith("@")) {
            string2 = string2.substring(1);
        }
        if ((n = string2.indexOf(":")) == -1) {
            return string.equals(string2);
        }
        return string.equals(string2.substring(n + 1));
    }

    private void addItem() {
        if (this.myUsage != null) {
            this.myUsage.add(this.myComponent);
        }
    }
}

