/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class AddLibraryAction
extends AbstractAction {
    Project prj;
    Logger LOG = Logger.getLogger(AddLibraryAction.class.getName());

    public AddLibraryAction(Project project, String string) {
        super(string);
        this.prj = project;
    }

    public boolean isEnabled() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(new LibFilter());
        if (jFileChooser.showDialog(null, "choose lib") == 0) {
            File file = jFileChooser.getSelectedFile();
            assert (file != null);
            FileObject fileObject = FileUtil.toFileObject((File)file);
            assert (fileObject != null);
            FileObject fileObject2 = this.prj.getProjectDirectory().getFileObject("lib");
            assert (fileObject2 != null);
            try {
                FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)fileObject.getName());
            }
            catch (IOException iOException) {
                this.LOG.log(Level.WARNING, "Problem adding file: " + file.getName());
            }
        }
    }

    class LibFilter
    extends FileFilter {
        LibFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().endsWith(".jar");
        }

        public String getDescription() {
            return "Java libraries";
        }
    }
}

