/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.extexecution.api.ExecutionDescriptor;
import org.netbeans.modules.extexecution.api.ExecutionService;
import org.netbeans.modules.extexecution.api.input.InputProcessor;
import org.netbeans.modules.extexecution.api.input.InputProcessors;
import org.netbeans.modules.extexecution.api.input.LineProcessor;
import org.netbeans.modules.groovy.grails.api.ExecutionSupport;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grails.api.GrailsRuntime;
import org.netbeans.modules.groovy.grailsproject.actions.ConfigSupport;
import org.netbeans.modules.groovy.grailsproject.actions.RefreshProjectRunnable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CreateWarFileAction
extends AbstractAction
implements LineProcessor {
    private static final Logger LOG = Logger.getLogger(CreateWarFileAction.class.getName());
    private final Project prj;
    private final GrailsProjectConfig prjConfig;
    private final boolean autodeploy;

    public CreateWarFileAction(Project project) {
        super(NbBundle.getMessage(CreateWarFileAction.class, (String)"LBL_CreateWarFile"));
        this.prj = project;
        this.prjConfig = GrailsProjectConfig.forProject((Project)project);
        this.autodeploy = this.prjConfig.getAutoDeployFlag();
    }

    public boolean isEnabled() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        GrailsRuntime grailsRuntime = GrailsRuntime.getInstance();
        if (!grailsRuntime.isConfigured()) {
            ConfigSupport.showConfigurationWarning(grailsRuntime);
            return;
        }
        ProjectInformation projectInformation = (ProjectInformation)this.prj.getLookup().lookup(ProjectInformation.class);
        String string = projectInformation.getDisplayName() + " (" + "war" + ")";
        Callable callable = ExecutionSupport.getInstance().createSimpleCommand("war", GrailsProjectConfig.forProject((Project)this.prj), new String[0]);
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().controllable(true).inputVisible(true).showProgress(true).frontWindow(true);
        if (this.autodeploy) {
            executionDescriptor = executionDescriptor.outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

                public InputProcessor newInputProcessor() {
                    return InputProcessors.bridge((LineProcessor)CreateWarFileAction.this);
                }
            });
        }
        executionDescriptor = executionDescriptor.postExecution((Runnable)new RefreshProjectRunnable(this.prj));
        executionDescriptor = executionDescriptor.optionsPath("org-netbeans-modules-groovy-support-options-GroovyOptionsCategory");
        ExecutionService executionService = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)executionDescriptor, (String)string);
        executionService.run();
    }

    public void processLine(String string) {
        if (string.contains("Done creating WAR") || string.contains("Created WAR")) {
            LOG.log(Level.FINEST, "War file created, copy");
            FileObject fileObject = this.prj.getProjectDirectory();
            LOG.log(Level.FINEST, "Project Directory: " + fileObject.getPath());
            Enumeration enumeration = fileObject.getChildren(false);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                if (fileObject2 == null || !fileObject2.getExt().toUpperCase(Locale.ENGLISH).startsWith("WAR")) continue;
                LOG.log(Level.FINEST, "Extention is OK: " + fileObject2.getExt());
                String string2 = this.prjConfig.getDeployDir();
                LOG.log(Level.FINEST, "Target dir from config: " + string2);
                if (string2 == null || string2.length() <= 0) continue;
                File file = new File(string2);
                FileObject fileObject3 = FileUtil.toFileObject((File)file);
                LOG.log(Level.FINEST, "Copy file (source)     :" + fileObject2.getPath());
                LOG.log(Level.FINEST, "Copy file (destination):" + fileObject3.getPath());
                LOG.log(Level.FINEST, "Copy file (name)       :" + fileObject2.getName());
                try {
                    FileUtil.copyFile((FileObject)fileObject2, (FileObject)fileObject3, (String)fileObject2.getName());
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    public void reset() {
    }

    public void close() {
    }
}

