/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.classpath;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.groovy.grailsproject.classpath.BootClassPathImplementation;
import org.netbeans.modules.groovy.grailsproject.classpath.ProjectClassPathImplementation;
import org.netbeans.modules.groovy.grailsproject.classpath.SourcePathImplementation;
import org.netbeans.modules.groovy.grailsproject.classpath.SourceRoots;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class ClassPathProviderImpl
implements ClassPathProvider {
    private final File projectDirectory;
    private final SourceRoots sourceRoots;
    private final SourceRoots testSourceRoots;
    private final ClassPath[] cache = new ClassPath[9];
    private final Map<String, FileObject> dirCache = new HashMap<String, FileObject>();

    public ClassPathProviderImpl(SourceRoots sourceRoots, SourceRoots sourceRoots2, File file) {
        this.projectDirectory = file;
        assert (this.projectDirectory != null);
        this.sourceRoots = sourceRoots;
        this.testSourceRoots = sourceRoots2;
    }

    private synchronized FileObject getDir(String string) {
        FileObject fileObject = this.dirCache.get(string);
        return fileObject;
    }

    private FileObject[] getPrimarySrcPath() {
        return this.sourceRoots.getRoots();
    }

    private FileObject[] getTestSrcDir() {
        return this.testSourceRoots.getRoots();
    }

    private FileObject getBuildClassesDir() {
        return this.getDir("build.classes.dir");
    }

    private FileObject getBuildJar() {
        return this.getDir("dist.jar");
    }

    private FileObject getBuildTestClassesDir() {
        return this.getDir("build.test.classes.dir");
    }

    private int getType(FileObject fileObject) {
        FileObject fileObject2;
        int n;
        FileObject[] fileObjectArray = this.getPrimarySrcPath();
        for (n = 0; n < fileObjectArray.length; ++n) {
            fileObject2 = fileObjectArray[n];
            if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return 0;
        }
        fileObjectArray = this.getTestSrcDir();
        for (n = 0; n < fileObjectArray.length; ++n) {
            fileObject2 = fileObjectArray[n];
            if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return 1;
        }
        FileObject fileObject3 = this.getBuildClassesDir();
        if (fileObject3 != null && (fileObject3.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject))) {
            return 2;
        }
        fileObject3 = this.getBuildJar();
        if (fileObject3 != null && fileObject3.equals(fileObject)) {
            return 4;
        }
        fileObject3 = this.getBuildTestClassesDir();
        if (fileObject3 != null && (fileObject3.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject))) {
            return 3;
        }
        return -1;
    }

    private ClassPath getCompileTimeClasspath(FileObject fileObject) {
        int n = this.getType(fileObject);
        return this.getCompileTimeClasspath(n);
    }

    private synchronized ClassPath getCompileTimeClasspath(int n) {
        if (n < 0 || n > 1) {
            return null;
        }
        ClassPath classPath = this.cache[2 + n];
        if (classPath == null) {
            classPath = n == 0 ? ClassPathFactory.createClassPath((ClassPathImplementation)new ProjectClassPathImplementation(FileUtil.toFileObject((File)this.projectDirectory))) : ClassPathFactory.createClassPath((ClassPathImplementation)new ProjectClassPathImplementation(FileUtil.toFileObject((File)this.projectDirectory)));
            this.cache[2 + n] = classPath;
        }
        return classPath;
    }

    private synchronized ClassPath getRunTimeClasspath(FileObject fileObject) {
        ClassPath classPath;
        int n = this.getType(fileObject);
        if (n < 0 || n > 4) {
            return null;
        }
        if (n > 1) {
            n -= 2;
        }
        if ((classPath = this.cache[4 + n]) == null) {
            // empty if block
        }
        return classPath;
    }

    private ClassPath getSourcepath(FileObject fileObject) {
        int n = this.getType(fileObject);
        return this.getSourcepath(n);
    }

    private synchronized ClassPath getSourcepath(int n) {
        if (n < 0 || n > 1) {
            return null;
        }
        ClassPath classPath = this.cache[n];
        if (classPath == null) {
            switch (n) {
                case 0: {
                    classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.sourceRoots));
                    break;
                }
                case 1: {
                    classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.testSourceRoots));
                }
            }
        }
        this.cache[n] = classPath;
        return classPath;
    }

    private synchronized ClassPath getBootClassPath() {
        ClassPath classPath = this.cache[7];
        if (classPath == null) {
            this.cache[7] = classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new BootClassPathImplementation());
        }
        return classPath;
    }

    public ClassPath findClassPath(FileObject fileObject, String string) {
        if (string.equals("classpath/compile")) {
            return this.getCompileTimeClasspath(fileObject);
        }
        if (string.equals("classpath/execute")) {
            return this.getRunTimeClasspath(fileObject);
        }
        if (string.equals("classpath/source")) {
            return this.getSourcepath(fileObject);
        }
        if (string.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        return null;
    }

    public ClassPath[] getProjectClassPaths(String string) {
        if ("classpath/boot".equals(string)) {
            return new ClassPath[]{this.getBootClassPath()};
        }
        if ("classpath/compile".equals(string)) {
            ClassPath[] classPathArray = new ClassPath[]{this.getCompileTimeClasspath(0), this.getCompileTimeClasspath(1)};
            return classPathArray;
        }
        if ("classpath/source".equals(string)) {
            ClassPath[] classPathArray = new ClassPath[]{this.getSourcepath(0), this.getSourcepath(1)};
            return classPathArray;
        }
        assert (false);
        return null;
    }

    public ClassPath getProjectSourcesClassPath(String string) {
        if ("classpath/boot".equals(string)) {
            return this.getBootClassPath();
        }
        if ("classpath/compile".equals(string)) {
            return this.getCompileTimeClasspath(0);
        }
        if ("classpath/source".equals(string)) {
            return this.getSourcepath(0);
        }
        assert (false);
        return null;
    }
}

