/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.GetProjectLocationStep;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.WizardSettingsPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class GetProjectLocationPanel
extends WizardSettingsPanel
implements DocumentListener {
    private GetProjectLocationStep parentStep;
    private JButton browsLocationJButton;
    private JLabel projectFolderLabel;
    private JTextField projectFolderTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JCheckBox setAsMainCheckBox;

    boolean valid(WizardDescriptor wizardDescriptor) {
        return this.projectNameTextField.getText().length() > 0 && new File(this.projectLocationTextField.getText()).isDirectory();
    }

    void read(WizardDescriptor wizardDescriptor) {
        File file = (File)wizardDescriptor.getProperty("projectFolder");
        file = file == null || file.getParentFile() == null || !file.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : file.getParentFile();
        Integer n = (Integer)wizardDescriptor.getProperty("WizardPanel_GrailsProjectCounter");
        String string = NbBundle.getMessage(GetProjectLocationPanel.class, (String)"TXT_GrailsApplication");
        int n2 = n;
        String string2 = (String)wizardDescriptor.getProperty("name");
        if (string2 == null) {
            while ((string2 = this.validFreeProjectName(file, string, n2)) == null) {
                ++n2;
            }
        }
        this.projectLocationTextField.setText(file.getAbsolutePath());
        this.projectFolderTextField.setText(file.getAbsolutePath() + File.separatorChar + this.projectNameTextField.getText());
        this.projectNameTextField.setText(string2);
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("projectFolder", (Object)new File(this.projectFolderTextField.getText().trim()));
        wizardDescriptor.putProperty("projectName", (Object)this.projectNameTextField.getText());
        this.parentStep.fireChangeEvent();
    }

    public GetProjectLocationPanel(GetProjectLocationStep getProjectLocationStep) {
        this.parentStep = getProjectLocationStep;
        this.initComponents();
        this.setName(NbBundle.getMessage(GetProjectLocationPanel.class, (String)"LAB_ConfigureProject"));
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.projectNameTextField.getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectLocationLabel = new JLabel();
        this.projectFolderLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationTextField = new JTextField();
        this.projectFolderTextField = new JTextField();
        this.browsLocationJButton = new JButton();
        this.setAsMainCheckBox = new JCheckBox();
        this.projectNameLabel.setDisplayedMnemonic('N');
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.projectNameLabel.text"));
        this.projectLocationLabel.setDisplayedMnemonic('L');
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.projectLocationLabel.text"));
        this.projectFolderLabel.setDisplayedMnemonic('F');
        this.projectFolderLabel.setLabelFor(this.projectFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectFolderLabel, (String)NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.projectFolderLabel.text"));
        this.projectNameTextField.setText(NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.projectNameTextField.text"));
        this.projectLocationTextField.setText(NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.projectLocationTextField.text"));
        this.projectFolderTextField.setEditable(false);
        this.projectFolderTextField.setText(NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.projectFolderTextField.text"));
        this.browsLocationJButton.setMnemonic('o');
        Mnemonics.setLocalizedText((AbstractButton)this.browsLocationJButton, (String)NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.browsLocationJButton.text"));
        this.browsLocationJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GetProjectLocationPanel.this.browsLocationJButtonActionPerformed(actionEvent);
            }
        });
        this.setAsMainCheckBox.setMnemonic('M');
        this.setAsMainCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.setAsMainCheckBox, (String)NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.setAsMainCheckBox.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.setAsMainCheckBox).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectLocationLabel).add((Component)this.projectFolderLabel).add((Component)this.projectNameLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.projectLocationTextField, -1, 216, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browsLocationJButton)).add((Component)this.projectNameTextField, -1, 309, Short.MAX_VALUE).add((Component)this.projectFolderTextField, -1, 309, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectNameLabel).add((Component)this.projectNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectLocationLabel).add((Component)this.browsLocationJButton).add((Component)this.projectLocationTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectFolderLabel).add((Component)this.projectFolderTextField, -2, -1, -2)).add(18, 18, 18).add((Component)this.setAsMainCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.projectNameLabel.AccessibleContext.accessibleDescription"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.projectLocationLabel.AccessibleContext.accessibleDescription"));
        this.projectFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.projectFolderLabel.AccessibleContext.accessibleDescription"));
        this.projectNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.projectNameTextField.AccessibleContext.accessibleName"));
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.projectNameTextField.AccessibleContext.accessibleDescription"));
        this.projectLocationTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.projectLocationTextField.AccessibleContext.accessibleName"));
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.projectLocationTextField.AccessibleContext.accessibleDescription"));
        this.projectFolderTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.projectFolderTextField.AccessibleContext.accessibleName"));
        this.projectFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.projectFolderTextField.AccessibleContext.accessibleDescription"));
        this.browsLocationJButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.browsLocationJButton.AccessibleContext.accessibleDescription"));
        this.setAsMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.setAsMainCheckBox.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.AccessibleContext.accessibleDescription"));
    }

    private void browsLocationJButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setDialogTitle(NbBundle.getMessage(GetProjectLocationPanel.class, (String)"GetProjectLocationPanel.FileChooserTitle"));
        jFileChooser.setFileSelectionMode(1);
        String string = this.projectLocationTextField.getText();
        if (string.length() > 0 && (file = new File(string)).exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            file = jFileChooser.getSelectedFile();
            this.projectLocationTextField.setText(file.getAbsolutePath());
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
    }

    private void updateTexts(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.projectNameTextField.getDocument() || document == this.projectLocationTextField.getDocument()) {
            String string = this.projectNameTextField.getText();
            String string2 = this.projectLocationTextField.getText();
            this.getProjectFolderTextField().setText(new File(string2, string).getAbsolutePath());
            this.parentStep.fireChangeEvent();
        }
    }

    public JTextField getProjectFolderTextField() {
        return this.projectFolderTextField;
    }

    private String validFreeProjectName(File file, String string, int n) {
        String string2 = MessageFormat.format(string, n);
        File file2 = new File(file, string2);
        return file2.exists() ? null : string2;
    }
}

