/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import java.text.MessageFormat;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.ddl.impl.CreateTable;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.actions.GrabTableHelper;
import org.netbeans.modules.db.explorer.dlg.GrabTableProgressPanel;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.WindowManager;

public class GrabTableAction
extends DatabaseAction {
    static final long serialVersionUID = -7685449970256732671L;

    protected boolean enable(Node[] nodeArray) {
        return nodeArray != null && nodeArray.length == 1;
    }

    public void performAction(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return;
        }
        Node node = nodeArray[0];
        try {
            DatabaseNodeInfo databaseNodeInfo = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
            DatabaseNodeInfo databaseNodeInfo2 = databaseNodeInfo.getParent(this.nodename);
            Specification specification = (Specification)databaseNodeInfo2.getSpecification();
            String string = (String)databaseNodeInfo2.get("table");
            CreateTable createTable = specification.createCommandCreateTable(string);
            GrabTableWorker grabTableWorker = new GrabTableWorker(databaseNodeInfo2);
            Enumeration enumeration = grabTableWorker.execute();
            JFileChooser jFileChooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
            jFileChooser.setDialogType(1);
            jFileChooser.setDialogTitle(GrabTableAction.bundle().getString("GrabTableFileSaveDialogTitle"));
            jFileChooser.setSelectedFile(new File(string + ".grab"));
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".grab");
                }

                public String getDescription() {
                    return DatabaseAction.bundle().getString("GrabTableFileTypeDescription");
                }
            });
            Frame frame = WindowManager.getDefault().getMainWindow();
            boolean bl = true;
            File file = null;
            while (bl) {
                if (jFileChooser.showSaveDialog(frame) == 0) {
                    file = jFileChooser.getSelectedFile();
                    if (file == null) continue;
                    if (file.exists()) {
                        JButton jButton = new JButton(GrabTableAction.bundle().getString("Yes"));
                        JButton jButton2 = new JButton(GrabTableAction.bundle().getString("No"));
                        Object object = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)MessageFormat.format(GrabTableAction.bundle().getString("MSG_ReplaceFileOrNot"), file.getName()), GrabTableAction.bundle().getString("GrabTableFileSaveDialogTitle"), 0, 3, new Object[]{jButton, jButton2}, (Object)jButton));
                        if (!object.equals(jButton)) continue;
                        bl = false;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                return;
            }
            new GrabTableHelper().execute(specification, string, enumeration, file);
        }
        catch (Exception exception) {
            DbUtilities.reportError(GrabTableAction.bundle().getString("ERR_UnableToGrabTable"), exception.getMessage());
        }
    }

    private static final class GrabTableWorker {
        private DatabaseNodeInfo nfo;
        private Task task;
        private Dialog dialog;
        private ProgressHandle progressHandle;
        private Enumeration enumeration;
        private DatabaseException exception;

        public GrabTableWorker(DatabaseNodeInfo databaseNodeInfo) {
            this.nfo = databaseNodeInfo;
        }

        public Enumeration execute() throws DatabaseException {
            this.progressHandle = ProgressHandleFactory.createHandle(null);
            GrabTableProgressPanel grabTableProgressPanel = new GrabTableProgressPanel();
            grabTableProgressPanel.setProgressComponent(ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progressHandle));
            String string = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("GrabTableProgressDialogTitle");
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)grabTableProgressPanel, string, true, new Object[0], DialogDescriptor.NO_OPTION, 0, null, null);
            this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            this.dialog.setResizable(false);
            if (this.dialog instanceof JDialog) {
                ((JDialog)this.dialog).setDefaultCloseOperation(0);
            }
            this.progressHandle.start();
            this.task = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        GrabTableWorker.this.enumeration = GrabTableWorker.this.nfo.getChildren().elements();
                    }
                    catch (DatabaseException databaseException) {
                        GrabTableWorker.this.exception = databaseException;
                    }
                }
            });
            this.task.addTaskListener(new TaskListener(){

                public void taskFinished(Task task) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            GrabTableWorker.this.dialog.setVisible(false);
                        }
                    });
                }
            });
            if (!this.task.isFinished()) {
                this.dialog.setVisible(true);
            }
            this.dialog.dispose();
            this.progressHandle.finish();
            if (this.exception != null) {
                throw this.exception;
            }
            return this.enumeration;
        }
    }
}

