/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DatabaseSpecification;
import org.netbeans.lib.ddl.DatabaseSpecificationFactory;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.util.PListReader;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseDriver;
import org.netbeans.modules.db.explorer.DbMetaDataListenerSupport;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.ProcedureNodeInfo;
import org.netbeans.modules.db.explorer.infos.RootNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableListNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableNodeInfo;
import org.netbeans.modules.db.explorer.infos.ViewNodeInfo;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseNodeInfo
extends ConcurrentHashMap<String, Object>
implements Node.Cookie,
Comparable {
    public static final String SPECIFICATION_FACTORY = "specfactory";
    public static final String SPECIFICATION = "spec";
    public static final String DRIVER_SPECIFICATION = "drvspec";
    public static final String DBPRODUCT = "dbproduct";
    public static final String DBVERSION = "dbversion";
    public static final String SUPPORTED_DBS = "suppdbs";
    public static final String DRIVER = "driver";
    public static final String DBDRIVER = "dbdriver";
    public static final String DATABASE = "db";
    public static final String URL = "url";
    public static final String PREFIX = "prefix";
    public static final String CONNECTION = "connection";
    public static final String CODE = "code";
    public static final String NODE = "node";
    public static final String CLASS = "class";
    public static final String INFOCLASS = "infoclass";
    public static final String NAME = "name";
    public static final String USER = "user";
    public static final String SCHEMA = "schema";
    public static final String PASSWORD = "password";
    public static final String CHILDREN = "children";
    public static final String ACTIONS = "actions";
    public static final String ICONBASE = "iconbase";
    public static final String PROPERTIES = "properties";
    public static final String RESULTSET = "resultset";
    public static final String REMEMBER_PWD = "rememberpwd";
    public static final String WRITABLE = "writable";
    public static final String DELETABLE = "deletable";
    public static final String DESCRIPTION = "description";
    public static final String READONLYDB = "readonlydatabase";
    public static final String GROUPSUP = "groupbysupport";
    public static final String OJOINSUP = "outerjoinsupport";
    public static final String UNIONSUP = "unionsupport";
    public static final String SYSTEM_ACTION = "system";
    public static final String CHILDREN_ORDERING = "children_ordering";
    public static final String READONLY = "readOnly";
    public static final String PERM = "perm";
    public static final String ADAPTOR = "adaptor";
    public static final String ADAPTOR_CLASSNAME = "adaptorClass";
    public static final String REGISTERED_NODE = "registered";
    private static Map gtab = null;
    static final String gtabfile = "org/netbeans/modules/db/resources/explorer.plist";
    private boolean connected = false;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final UUID uuid = UUID.randomUUID();
    private static final Logger LOGGER = Logger.getLogger(DatabaseNodeInfo.class.getName());
    private DatabaseNodeInfo parent = null;
    private PropertyChangeSupport pcs = null;
    private Set connectionpcsKeys = null;
    private PropertyChangeSupport driverpcs = null;
    private Set driverpcsKeys = null;
    static final long serialVersionUID = 1176243907461868244L;

    public static synchronized Map getGlobalNodeInfo() {
        if (gtab == null) {
            gtab = DatabaseNodeInfo.readInfo();
        }
        return gtab;
    }

    public static Map readInfo() {
        HashMap hashMap;
        try {
            ClassLoader classLoader = DatabaseNodeInfo.class.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(gtabfile);
            if (inputStream == null) {
                String string = MessageFormat.format(DatabaseNodeInfo.bundle().getString("EXC_UnableToOpenStream"), gtabfile);
                throw new Exception(string);
            }
            PListReader pListReader = new PListReader(inputStream);
            hashMap = pListReader.getData();
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            hashMap = null;
        }
        return hashMap;
    }

    public static Object getGlobalNodeInfo(String string) {
        return DatabaseNodeInfo.getGlobalNodeInfo().get(string);
    }

    public static DatabaseNodeInfo createNodeInfo(DatabaseNodeInfo databaseNodeInfo, String string) throws DatabaseException {
        DatabaseNodeInfo databaseNodeInfo2 = null;
        String string2 = (String)((Map)DatabaseNodeInfo.getGlobalNodeInfo().get(string)).get(INFOCLASS);
        if (string2 != null) {
            try {
                databaseNodeInfo2 = (DatabaseNodeInfo)Class.forName(string2).newInstance();
            }
            catch (Exception exception) {
                throw new DatabaseException(exception);
            }
        } else {
            String string3 = MessageFormat.format(DatabaseNodeInfo.bundle().getString("EXC_UnableToFindClassInfo"), string);
            throw new DatabaseException(string3);
        }
        if (databaseNodeInfo2 == null) {
            String string4 = MessageFormat.format(DatabaseNodeInfo.bundle().getString("EXC_UnableToCreateNodeInfo"), string);
            throw new DatabaseException(string4);
        }
        databaseNodeInfo2.setParentInfo(databaseNodeInfo, string);
        return databaseNodeInfo2;
    }

    public static DatabaseNodeInfo createNodeInfo(DatabaseNodeInfo databaseNodeInfo, String string, HashMap hashMap) throws DatabaseException {
        int n = 1;
        String string2 = null;
        DatabaseNodeInfo databaseNodeInfo2 = DatabaseNodeInfo.createNodeInfo(databaseNodeInfo, string);
        Vector vector = (Vector)databaseNodeInfo2.get(RESULTSET);
        Iterator iterator = vector.iterator();
        Hashtable hashtable = new Hashtable();
        while (iterator.hasNext()) {
            Object v;
            string2 = (String)iterator.next();
            if (!string2.equals("unused") && (v = hashMap.get(new Integer(n))) != null) {
                hashtable.put(string2, v);
            }
            ++n;
        }
        databaseNodeInfo2.putAll(hashtable);
        databaseNodeInfo2.put(string, (Object)databaseNodeInfo2.getName());
        if (databaseNodeInfo != null && databaseNodeInfo.isReadOnly()) {
            databaseNodeInfo2.setReadOnly(true);
        }
        return databaseNodeInfo2;
    }

    public DatabaseNodeInfo() {
    }

    public DatabaseNodeInfo(DatabaseNodeInfo databaseNodeInfo, String string) throws DatabaseException {
        DatabaseNodeInfo databaseNodeInfo2 = new DatabaseNodeInfo();
        databaseNodeInfo2.setParentInfo(databaseNodeInfo, string);
    }

    public void setParentInfo(DatabaseNodeInfo databaseNodeInfo, String string) throws DatabaseException {
        Map map;
        if (databaseNodeInfo != null) {
            this.putAll(databaseNodeInfo);
            this.parent = databaseNodeInfo;
        }
        if ((map = (Map)DatabaseNodeInfo.getGlobalNodeInfo(string)) != null) {
            this.putAll(map);
        }
        this.put(CODE, (Object)string);
        if (databaseNodeInfo != null && databaseNodeInfo.isReadOnly()) {
            this.setReadOnly(true);
        }
    }

    public DatabaseNodeInfo getParent() {
        return this.parent;
    }

    public DatabaseNodeInfo getParent(String string) {
        DatabaseNodeInfo databaseNodeInfo;
        if (string != null) {
            for (databaseNodeInfo = this; databaseNodeInfo != null; databaseNodeInfo = databaseNodeInfo.getParent()) {
                String string2 = databaseNodeInfo.getCode();
                if (!string2.equals(string)) continue;
                return databaseNodeInfo;
            }
        }
        return databaseNodeInfo;
    }

    public boolean canAdd(Map map, String string) {
        return true;
    }

    public boolean canWrite(Map map, String string, boolean bl) {
        if (this.isReadOnly()) {
            return false;
        }
        String string2 = (String)map.get(WRITABLE);
        if (string2 != null) {
            return string2.toUpperCase().equals("YES");
        }
        return bl;
    }

    private PropertyChangeSupport getConnectionPCS() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    private PropertyChangeSupport getDriverPCS() {
        if (this.driverpcs == null) {
            this.driverpcs = new PropertyChangeSupport(this);
        }
        return this.driverpcs;
    }

    private Set getDriverPCSKeys() {
        if (this.driverpcsKeys == null) {
            this.driverpcsKeys = new HashSet();
            this.driverpcsKeys.add(NAME);
            this.driverpcsKeys.add(URL);
            this.driverpcsKeys.add(PREFIX);
            this.driverpcsKeys.add(ADAPTOR_CLASSNAME);
        }
        return this.driverpcsKeys;
    }

    private Set getConnectionPCSKeys() {
        if (this.connectionpcsKeys == null) {
            this.connectionpcsKeys = new HashSet();
            this.connectionpcsKeys.add(SCHEMA);
            this.connectionpcsKeys.add(USER);
            this.connectionpcsKeys.add(DATABASE);
        }
        return this.connectionpcsKeys;
    }

    @Override
    public Object put(String string, Object object) {
        Object v = this.get(string);
        if (string == null) {
            throw new NullPointerException();
        }
        if (object != null) {
            super.put(string, object);
        } else {
            this.remove(string);
        }
        if (this.getDriverPCSKeys().contains(string)) {
            this.getDriverPCS().firePropertyChange(string, v, object);
        }
        if (this.getConnectionPCSKeys().contains(string)) {
            this.getConnectionPCS().firePropertyChange(string, null, object);
        }
        return v;
    }

    public void delete() throws IOException {
    }

    public void refreshChildren() throws DatabaseException {
        this.put(CHILDREN, (Object)new Vector());
        this.getChildren();
        this.notifyChange();
    }

    public String getShortDescription() {
        return "";
    }

    protected void fireRefresh() {
        ConnectionNodeInfo connectionNodeInfo;
        boolean bl = true;
        if (!(this instanceof TableListNodeInfo)) {
            bl = false;
            if (!(this instanceof TableNodeInfo)) {
                return;
            }
        }
        if ((connectionNodeInfo = (ConnectionNodeInfo)this.getParent(CONNECTION)) == null) {
            return;
        }
        DatabaseConnection databaseConnection = ConnectionList.getDefault().getConnection(connectionNodeInfo.getDatabaseConnection());
        if (databaseConnection != null) {
            if (bl) {
                DbMetaDataListenerSupport.fireTablesChanged(databaseConnection.getDatabaseConnection());
            } else {
                String string = (String)this.get("table");
                DbMetaDataListenerSupport.fireTableChanged(databaseConnection.getDatabaseConnection(), string);
            }
        }
    }

    public Object getProperty(String string) {
        return this.get(string);
    }

    public void setProperty(String string, Object object) {
        this.put(string, object);
        this.notifyChange();
    }

    public void addConnectionListener(PropertyChangeListener propertyChangeListener) {
        this.getConnectionPCS().addPropertyChangeListener(propertyChangeListener);
    }

    public void removeConnectionListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void addDriverListener(PropertyChangeListener propertyChangeListener) {
        this.getDriverPCS().addPropertyChangeListener(propertyChangeListener);
    }

    public void removeDriverListener(PropertyChangeListener propertyChangeListener) {
        this.getDriverPCS().removePropertyChangeListener(propertyChangeListener);
    }

    public DatabaseSpecificationFactory getSpecificationFactory() {
        return (DatabaseSpecificationFactory)this.get(SPECIFICATION_FACTORY);
    }

    public void setSpecificationFactory(DatabaseSpecificationFactory databaseSpecificationFactory) {
        this.put(SPECIFICATION_FACTORY, (Object)databaseSpecificationFactory);
        this.put(SUPPORTED_DBS, (Object)databaseSpecificationFactory.supportedDatabases());
    }

    protected String getDatabaseAdaptorClassName() {
        return "org.netbeans.lib.ddl.adaptors.DefaultAdaptor";
    }

    public DatabaseSpecification getSpecification() {
        DatabaseSpecification databaseSpecification = (DatabaseSpecification)this.get(SPECIFICATION);
        if (databaseSpecification == null) {
            return databaseSpecification;
        }
        String string = this.getDatabaseAdaptorClassName();
        if (!databaseSpecification.getMetaDataAdaptorClassName().equals(string)) {
            databaseSpecification.setMetaDataAdaptorClassName(string);
        }
        return databaseSpecification;
    }

    public void setSpecification(DatabaseSpecification databaseSpecification) {
        this.put(SPECIFICATION, (Object)databaseSpecification);
    }

    public String getDriver() {
        return (String)this.get(DRIVER);
    }

    public void setDriver(String string) {
        this.put(DRIVER, (Object)string);
        this.notifyChange();
    }

    public Connection getConnection() {
        return (Connection)this.get(CONNECTION);
    }

    public void setConnection(Connection connection) throws DatabaseException {
        Connection connection2 = this.getConnection();
        if (connection != null) {
            if (connection2 != null && connection2.equals(connection)) {
                return;
            }
            this.put(CONNECTION, (Object)connection);
            this.setConnected(true);
        } else {
            this.remove(CONNECTION);
            this.setConnected(false);
        }
        if (connection != null && this.isReadOnly()) {
            Enumeration enumeration = this.getChildren().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseNodeInfo databaseNodeInfo = (DatabaseNodeInfo)enumeration.nextElement();
                databaseNodeInfo.setReadOnly(true);
            }
        }
        this.getConnectionPCS().firePropertyChange(CONNECTION, connection2, connection);
        this.notifyChange();
    }

    private synchronized void setConnected(boolean bl) {
        this.connected = bl;
    }

    public synchronized boolean isConnected() {
        if (this instanceof ConnectionNodeInfo) {
            return this.connected;
        }
        ConnectionNodeInfo connectionNodeInfo = (ConnectionNodeInfo)this.getParent(CONNECTION);
        return connectionNodeInfo.isConnected();
    }

    public DatabaseConnection getDatabaseConnection() {
        DatabaseConnection databaseConnection = new DatabaseConnection(this.getDriver(), this.getDatabase(), this.getUser(), this.getPassword());
        if (this.get(REMEMBER_PWD) != null) {
            databaseConnection.setRememberPassword((Boolean)this.get(REMEMBER_PWD));
        } else {
            databaseConnection.setRememberPassword(Boolean.FALSE);
        }
        databaseConnection.setSchema(this.getSchema());
        databaseConnection.setDriverName((String)this.get("drivername"));
        return databaseConnection;
    }

    public DatabaseDriver getDatabaseDriver() {
        return (DatabaseDriver)this.get(DBDRIVER);
    }

    public void setDatabaseConnection(DBConnection dBConnection) {
        String string = dBConnection.getPassword();
        this.put(DRIVER, (Object)dBConnection.getDriver());
        this.put(DATABASE, (Object)dBConnection.getDatabase());
        this.put(USER, (Object)dBConnection.getUser());
        this.put(SCHEMA, (Object)dBConnection.getSchema());
        if (string != null) {
            this.put(PASSWORD, (Object)string);
        }
        this.put(REMEMBER_PWD, (Object)dBConnection.rememberPassword());
        this.put("drivername", (Object)dBConnection.getDriverName());
        this.notifyChange();
    }

    public String getCode() {
        return (String)this.get(CODE);
    }

    public void setCode(String string) {
        this.put(CODE, (Object)string);
    }

    public String getName() {
        return (String)this.get(NAME);
    }

    public void setName(String string) {
        this.put(NAME, (Object)string);
        this.notifyChange();
    }

    public String getUser() {
        return (String)this.get(USER);
    }

    public void setUser(String string) {
        this.put(USER, (Object)string);
    }

    public String getSchema() {
        return (String)this.get(SCHEMA);
    }

    public void setSchema(String string) {
        this.put(SCHEMA, (Object)string);
        this.notifyChange();
    }

    public String getDatabase() {
        return (String)this.get(DATABASE);
    }

    public void setDatabase(String string) {
        this.put(DATABASE, (Object)string);
        this.notifyChange();
    }

    public String getPassword() {
        return (String)this.get(PASSWORD);
    }

    public void setPassword(String string) {
        this.put(PASSWORD, (Object)string);
        this.notifyChange();
    }

    public String getTable() {
        return (String)this.get("table");
    }

    public String getView() {
        return (String)this.get("view");
    }

    public void setTable(String string) {
        this.put("table", (Object)string);
        this.notifyChange();
    }

    public String getIconBase() {
        return (String)this.get(ICONBASE);
    }

    public void setIconBase(String string) {
        this.put(ICONBASE, (Object)string);
        this.notifyChange();
    }

    public String getDisplayName() {
        String string = (String)this.get("displayname");
        if (string == null || "{name}".equals(string)) {
            return this.getName();
        }
        return string;
    }

    public void setDisplayName(String string) {
        this.put("displayname", (Object)string);
        this.notifyChange();
    }

    public String getURL() {
        return (String)this.get(URL);
    }

    public void setURL(String string) {
        this.put(URL, (Object)string);
        this.notifyChange();
    }

    public Properties getConnectionProperties() {
        Properties properties = new Properties();
        try {
            properties.put(USER, this.getUser());
            properties.put(PASSWORD, this.getPassword());
            properties.put(SCHEMA, this.getSchema());
        }
        catch (Exception exception) {
            properties = null;
        }
        return properties;
    }

    protected void initChildren(Vector vector) throws DatabaseException {
    }

    public boolean isChildrenInitialized() {
        Vector vector = (Vector)this.get(CHILDREN);
        return vector.size() > 0 && vector.elementAt(0) instanceof DatabaseNodeInfo;
    }

    public Vector getChildren() throws DatabaseException {
        Vector vector = (Vector)this.get(CHILDREN);
        if (this.isChildrenInitialized()) {
            return vector;
        }
        Vector vector2 = new Vector();
        this.initChildren(vector2);
        vector2.addAll(vector);
        for (int i = 0; i < vector2.size(); ++i) {
            Object e = vector2.elementAt(i);
            if (!(e instanceof String)) continue;
            DatabaseNodeInfo databaseNodeInfo = DatabaseNodeInfo.createNodeInfo(this, (String)e);
            vector2.setElementAt(databaseNodeInfo, i);
        }
        vector = vector2;
        this.put(CHILDREN, (Object)vector);
        return vector;
    }

    private void printChildren(String string, Vector vector) {
        System.out.println("");
        System.out.println(string);
        for (Object e : vector) {
            StringBuffer stringBuffer = new StringBuffer(e.getClass().getName());
            if (e instanceof DatabaseNodeInfo) {
                stringBuffer.append(": " + ((DatabaseNodeInfo)e).getDisplayName());
            } else {
                stringBuffer.append(": " + e.toString());
            }
            System.out.println(stringBuffer.toString());
        }
    }

    public void addChild(DatabaseNodeInfo databaseNodeInfo) throws DatabaseException {
        this.addChild(databaseNodeInfo, true);
    }

    public void addChild(DatabaseNodeInfo databaseNodeInfo, boolean bl) throws DatabaseException {
        this.getChildren().add(databaseNodeInfo);
        if (bl) {
            this.notifyChange();
        }
    }

    public void removeChild(DatabaseNodeInfo databaseNodeInfo) throws DatabaseException {
        this.removeChild(databaseNodeInfo, true);
    }

    public synchronized void removeChild(DatabaseNodeInfo databaseNodeInfo, boolean bl) throws DatabaseException {
        this.getChildren().remove(databaseNodeInfo);
        if (bl) {
            this.notifyChange();
        }
    }

    public void setChildren(Vector vector) {
        this.setChildren(vector, true);
    }

    public void setChildren(Vector vector, boolean bl) {
        this.put(CHILDREN, (Object)vector);
        if (bl) {
            this.notifyChange();
        }
    }

    public Vector getActions() {
        Vector<SystemAction> vector = (Vector<SystemAction>)this.get(ACTIONS);
        if ((vector = (Vector)vector.clone()) == null) {
            vector = new Vector<SystemAction>();
            this.put(ACTIONS, (Object)vector);
        }
        if (vector.size() == 0) {
            return vector;
        }
        boolean bl = this.isReadOnly();
        for (int i = 0; i < vector.size(); ++i) {
            SystemAction systemAction;
            block12: {
                Object e = vector.elementAt(i);
                systemAction = null;
                if (e instanceof Map) {
                    Map map = (Map)e;
                    try {
                        Object object;
                        String string = (String)map.get(PERM);
                        if (bl && string != null && string instanceof String && string.indexOf("write") != -1) {
                            vector.setElementAt(null, i);
                            continue;
                        }
                        boolean bl2 = false;
                        String string2 = (String)map.get(SYSTEM_ACTION);
                        if (string2 != null) {
                            bl2 = string2.toUpperCase().equals("YES");
                        }
                        String string3 = (String)map.get(NODE);
                        String string4 = (String)map.get(CLASS);
                        if (!bl2) {
                            String string5 = (String)map.get(NAME);
                            try {
                                object = DatabaseNodeInfo.bundle().getString(string5);
                            }
                            catch (MissingResourceException missingResourceException) {
                                object = string5;
                                String string6 = MessageFormat.format(DatabaseNodeInfo.bundle().getString("ERR_UnableToLocateLocalizedMenuItem"), string5);
                                System.out.println(string6);
                            }
                            systemAction = SystemAction.get(Class.forName(string4).asSubclass(SystemAction.class));
                            ((DatabaseAction)systemAction).setName((String)object);
                            ((DatabaseAction)systemAction).setNode(string3);
                            break block12;
                        }
                        object = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                        if (object == null) {
                            object = this.getClass().getClassLoader();
                        }
                        systemAction = SystemAction.get(Class.forName(string4, true, (ClassLoader)object).asSubclass(SystemAction.class));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            vector.setElementAt(systemAction, i);
        }
        return vector;
    }

    @Override
    public String toString() {
        String string = "";
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            string = string + k + ": " + this.get(k) + "\n";
        }
        return string;
    }

    public boolean isDebugMode() {
        return RootNodeInfo.getOption().getDebugMode();
    }

    public void setDebugMode(boolean bl) {
        RootNodeInfo.getOption().setDebugMode(bl);
    }

    public boolean isReadOnly() {
        Boolean bl = (Boolean)this.get(READONLY);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public void setReadOnly(boolean bl) {
        this.put(READONLY, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        this.notifyChange();
    }

    public DriverSpecification getDriverSpecification() {
        return (DriverSpecification)this.get(DRIVER_SPECIFICATION);
    }

    public void setDriverSpecification(DriverSpecification driverSpecification) {
        this.put(DRIVER_SPECIFICATION, (Object)driverSpecification);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    protected void notifyChange() {
        this.changeSupport.fireChange();
    }

    protected static ResourceBundle bundle() {
        return NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DatabaseNodeInfo databaseNodeInfo = (DatabaseNodeInfo)object;
        return this.uuid == databaseNodeInfo.uuid || this.uuid != null && this.uuid.equals(databaseNodeInfo.uuid);
    }

    @Override
    public int hashCode() {
        int n = 3;
        n = 19 * n + (this.uuid != null ? this.uuid.hashCode() : 0);
        return n;
    }

    public int compareTo(Object object) {
        DatabaseNodeInfo databaseNodeInfo = (DatabaseNodeInfo)object;
        if (this.equals(databaseNodeInfo)) {
            return 0;
        }
        Map map = null;
        if (this.parent != null) {
            map = (Map)this.parent.get(CHILDREN_ORDERING);
        }
        if (map != null) {
            boolean bl;
            boolean bl2 = bl = !(this instanceof TableNodeInfo) && !(this instanceof ViewNodeInfo) && !(this instanceof ProcedureNodeInfo);
            if (bl) {
                Integer n = (Integer)map.get(this.get(CLASS));
                int n2 = n != null ? n : Integer.MAX_VALUE;
                Integer n3 = null;
                n3 = (Integer)map.get(databaseNodeInfo.get(CLASS));
                int n4 = n3 != null ? n3 : Integer.MAX_VALUE;
                int n5 = n2 - n4;
                if (n5 != 0) {
                    return n5;
                }
            }
        }
        return this.getDisplayName() != null ? this.getDisplayName().compareTo(databaseNodeInfo.getDisplayName()) : 1;
    }
}

