/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableOwnerOperations;

public class TableListNodeInfo
extends DatabaseNodeInfo
implements TableOwnerOperations {
    static final long serialVersionUID = -6156362126513404875L;
    public static final Logger LOGGER = Logger.getLogger(TableListNodeInfo.class.getName());

    protected void initChildren(Vector vector) throws DatabaseException {
        if (!this.isConnected()) {
            return;
        }
        try {
            List list;
            String[] stringArray = new String[]{"TABLE"};
            DriverSpecification driverSpecification = this.getDriverSpecification();
            DatabaseMetaData databaseMetaData = driverSpecification.getMetaData();
            try {
                list = "Oracle".equals(databaseMetaData.getDatabaseProductName()) ? (databaseMetaData.getDatabaseMajorVersion() >= 10 ? this.getOracleRecycleBinTables(databaseMetaData) : Collections.EMPTY_LIST) : Collections.EMPTY_LIST;
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.INFO, null, throwable);
                list = Collections.EMPTY_LIST;
            }
            driverSpecification.getTables("%", stringArray);
            ResultSet resultSet = driverSpecification.getResultSet();
            if (resultSet != null) {
                HashMap hashMap = new HashMap();
                while (resultSet.next()) {
                    hashMap = driverSpecification.getRow();
                    DatabaseNodeInfo databaseNodeInfo = DatabaseNodeInfo.createNodeInfo(this, "table", hashMap);
                    if (databaseNodeInfo != null) {
                        if (!list.contains(databaseNodeInfo.getName())) {
                            databaseNodeInfo.put("table", (Object)databaseNodeInfo.getName());
                            vector.add(databaseNodeInfo);
                        }
                    } else {
                        throw new Exception(TableListNodeInfo.bundle().getString("EXC_UnableToCreateNodeInformationForTable"));
                    }
                    hashMap.clear();
                }
                resultSet.close();
            }
        }
        catch (Exception exception) {
            DatabaseException databaseException = new DatabaseException(exception.getMessage());
            databaseException.initCause(exception);
            throw databaseException;
        }
    }

    public void addTable(String string) throws DatabaseException {
        this.refreshChildren();
    }

    public TableNodeInfo getChildrenTableInfo(TableNodeInfo tableNodeInfo) {
        String string = tableNodeInfo.getCode();
        String string2 = tableNodeInfo.getName();
        try {
            Enumeration enumeration = this.getChildren().elements();
            while (enumeration.hasMoreElements()) {
                TableNodeInfo tableNodeInfo2 = (TableNodeInfo)enumeration.nextElement();
                if (!tableNodeInfo2.getCode().equals(string) || !tableNodeInfo2.getName().equals(string2)) continue;
                return tableNodeInfo2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getOracleRecycleBinTables(DatabaseMetaData databaseMetaData) {
        List<String> list = new ArrayList();
        try {
            Statement statement = databaseMetaData.getConnection().createStatement();
            try {
                ResultSet resultSet = statement.executeQuery("SELECT OBJECT_NAME FROM RECYCLEBIN WHERE TYPE = 'TABLE'");
                try {
                    while (resultSet.next()) {
                        list.add(resultSet.getString("OBJECT_NAME"));
                    }
                }
                finally {
                    resultSet.close();
                }
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger("global").log(Level.INFO, null, sQLException);
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    public String getDisplayName() {
        return TableListNodeInfo.bundle().getString("NDN_Tables");
    }

    public String getShortDescription() {
        return TableListNodeInfo.bundle().getString("ND_TableList");
    }

    protected void notifyChange() {
        super.notifyChange();
        this.fireRefresh();
    }
}

