/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.util;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcUrl
extends HashMap<String, String> {
    private JDBCDriver driver;
    private String url;
    private ArrayList<String> urlComponents;
    private ArrayList<String> staticComponents;
    private HashSet<String> supportedTokens = new HashSet();
    private HashSet<String> requiredTokens = new HashSet();
    private final boolean parseUrl;
    public static final String TOKEN_DB = "<DB>";
    public static final String TOKEN_HOST = "<HOST>";
    public static final String TOKEN_PORT = "<PORT>";
    public static final String TOKEN_SERVERNAME = "<SERVERNAME>";
    public static final String TOKEN_ADDITIONAL = "<ADDITIONAL>";
    public static final String TOKEN_TNSNAME = "<TNSNAME>";
    public static final String TOKEN_SID = "<SID>";
    public static final String TOKEN_SERVICENAME = "<SERVICE>";
    public static final String TOKEN_DSN = "<DSN>";
    public static final String TOKEN_INSTANCE = "<INSTANCE>";
    private static final String OPTIONAL_START = "[";
    private static final String OPTIONAL_END = "]";
    private static Set<String> DB_HOST_PORT_TOKEN_SET = new HashSet<String>();
    private final String name;
    private final String className;
    private final String urlTemplate;
    private final String type;

    public JdbcUrl(String string, String string2, String string3, String string4, boolean bl) {
        this.name = string;
        this.className = string2;
        this.type = string3;
        this.urlTemplate = string4;
        this.parseUrl = bl;
        if (bl) {
            this.extractUrlComponents();
        }
    }

    public JdbcUrl(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, false);
    }

    public JdbcUrl(JDBCDriver jDBCDriver, String string, String string2) {
        this(jDBCDriver.getDisplayName(), jDBCDriver.getClassName(), string, string2);
        this.driver = jDBCDriver;
    }

    public JdbcUrl(JDBCDriver jDBCDriver) {
        this(jDBCDriver, null, null);
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    public boolean urlIsParsed() {
        return this.parseUrl;
    }

    public void setDriver(JDBCDriver jDBCDriver) {
        this.driver = jDBCDriver;
    }

    public JDBCDriver getDriver() {
        return this.driver;
    }

    public String getDisplayName() {
        if (this.isEmpty(this.getType())) {
            return this.getName();
        }
        return this.getName() + " (" + this.getType() + ")";
    }

    public boolean supportsToken(String string) {
        return this.supportedTokens.contains(string);
    }

    public boolean requiresToken(String string) {
        return this.requiredTokens.contains(string);
    }

    private boolean hasAllRequiredTokens() {
        Set set = this.keySet();
        for (String string : this.requiredTokens) {
            if (set.contains(string)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof JdbcUrl)) {
            return false;
        }
        JdbcUrl jdbcUrl = (JdbcUrl)object;
        return jdbcUrl.getDisplayName().equals(this.getDisplayName());
    }

    @Override
    public int hashCode() {
        int n = 3;
        n = 97 * n + (this.getDisplayName() != null ? this.getDisplayName().hashCode() : 0);
        return n;
    }

    protected boolean isEmpty(String string) {
        return string == null || string.equals("");
    }

    private MalformedURLException createMalformedURLException() {
        return new MalformedURLException(JdbcUrl.getMessage("ERR_InvalidURL", this.getUrlTemplate()));
    }

    private boolean isOptionalStart(String string) {
        return string.equals(OPTIONAL_START);
    }

    private boolean isOptionalStart(char c) {
        return c == '[';
    }

    private boolean isOptionalEnd(String string) {
        return string.equals(OPTIONAL_END);
    }

    private boolean isOptionalEnd(char c) {
        return c == ']';
    }

    private boolean isToken(String string) {
        return string.startsWith("<") && string.endsWith(">");
    }

    private boolean isTokenStart(char c) {
        return c == '<';
    }

    private boolean isTokenEnd(char c) {
        return c == '>';
    }

    public String getUrl() {
        if (!this.urlIsParsed()) {
            return this.url;
        }
        if (!this.hasAllRequiredTokens()) {
            return "";
        }
        int n = this.urlComponents.size();
        UrlSection urlSection = new UrlSection();
        for (int i = 0; i < n; ++i) {
            String string = this.urlComponents.get(i);
            if (this.isOptionalStart(string)) {
                urlSection.setOptionalChild(new OptionalSection());
                urlSection = urlSection.getOptionalChild();
                continue;
            }
            if (this.isOptionalEnd(string)) {
                UrlSection urlSection2 = ((OptionalSection)urlSection).getParent();
                urlSection2.addText(urlSection.getText());
                urlSection = urlSection2;
                continue;
            }
            if (this.supportedTokens.contains(string)) {
                urlSection.setValue((String)this.get(string));
                continue;
            }
            urlSection.addText(string);
        }
        return urlSection.getText();
    }

    public void setUrl(String string) throws MalformedURLException {
        if (!this.urlIsParsed()) {
            this.url = string;
            return;
        }
        this.clear();
        UrlBuffer urlBuffer = new UrlBuffer(string);
        int n = this.urlComponents.size();
        for (int i = 0; i < n; ++i) {
            String string2;
            String string3 = this.urlComponents.get(i);
            if (this.isToken(string3)) {
                string2 = this.getTokenValue(urlBuffer);
                if (this.isEmpty(string2)) {
                    throw this.createMalformedURLException();
                }
                this.put(string3, string2);
                continue;
            }
            if (this.isOptionalStart(string3)) {
                i = this.readOptionalValue(urlBuffer, i + 1);
                continue;
            }
            string2 = urlBuffer.urlSubString();
            if (string2 == null || !string2.startsWith(string3)) {
                throw this.createMalformedURLException();
            }
            this.skipStaticText(urlBuffer, string3);
        }
    }

    private static String getMessage(String string, String ... stringArray) {
        return NbBundle.getMessage(JdbcUrl.class, (String)string, (Object[])stringArray);
    }

    private void extractUrlComponents() {
        this.urlComponents = new ArrayList();
        int n = this.urlTemplate.length();
        boolean bl = false;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = this.urlTemplate.charAt(i);
            if (this.isTokenStart(c)) {
                assert (!bl);
                stringBuffer = this.addComponent(stringBuffer);
                stringBuffer.append(c);
                bl = true;
                continue;
            }
            if (this.isTokenEnd(c)) {
                assert (bl);
                stringBuffer.append(c);
                String string = stringBuffer.toString();
                if (n2 == 0) {
                    this.requiredTokens.add(string);
                }
                this.supportedTokens.add(string);
                stringBuffer = this.addComponent(stringBuffer);
                bl = false;
                continue;
            }
            if (this.isOptionalStart(c)) {
                ++n2;
                stringBuffer = this.addComponent(stringBuffer);
                this.urlComponents.add(OPTIONAL_START);
                continue;
            }
            if (this.isOptionalEnd(c)) {
                --n2;
                stringBuffer = this.addComponent(stringBuffer);
                this.urlComponents.add(OPTIONAL_END);
                continue;
            }
            stringBuffer.append(c);
        }
        this.setStaticComponents();
        this.validateUrlComponents();
    }

    private void setStaticComponents() {
        this.staticComponents = new ArrayList();
        for (String string : this.urlComponents) {
            if (this.isToken(string) || this.isOptionalStart(string) || this.isOptionalEnd(string)) continue;
            this.staticComponents.add(string);
        }
    }

    private StringBuffer addComponent(StringBuffer stringBuffer) {
        if (stringBuffer.length() > 0) {
            this.urlComponents.add(stringBuffer.toString());
            return new StringBuffer();
        }
        return stringBuffer;
    }

    private void validateUrlComponents() {
        int n = this.urlComponents.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string = this.urlComponents.get(i);
            if (string.startsWith("<")) {
                assert (this.isToken(string));
                if (i + 1 != n) assert (!this.isToken(this.urlComponents.get(i + 1)));
                continue;
            }
            if (this.isOptionalStart(string)) {
                ++n2;
                continue;
            }
            if (!this.isOptionalEnd(string)) continue;
            --n2;
        }
        assert (n2 == 0);
    }

    private int readOptionalValue(UrlBuffer urlBuffer, int n) throws MalformedURLException {
        int n2 = this.urlComponents.size();
        boolean bl = false;
        while (n < n2) {
            String string = this.urlComponents.get(n);
            if (this.isOptionalEnd(string)) {
                return n;
            }
            if (this.isOptionalStart(string)) {
                n = this.readOptionalValue(urlBuffer, n + 1);
            } else if (this.isToken(string)) {
                String string2 = this.getTokenValue(urlBuffer);
                if (!this.isEmpty(string2)) {
                    this.put(string, string2);
                } else if (bl) {
                    throw this.createMalformedURLException();
                }
            } else {
                int n3 = 0;
                String string3 = urlBuffer.urlSubString();
                if (string3 == null || !string3.startsWith(string)) {
                    do {
                        if (this.isOptionalStart(string = this.urlComponents.get(++n))) {
                            ++n3;
                        }
                        if (!this.isOptionalEnd(string) || n3 <= 0) continue;
                        --n3;
                        string = this.urlComponents.get(++n);
                    } while (!this.isOptionalEnd(string) || n3 > 0);
                    return n;
                }
                bl = true;
                this.skipStaticText(urlBuffer, string);
            }
            ++n;
        }
        throw this.createMalformedURLException();
    }

    private String getTokenValue(UrlBuffer urlBuffer) {
        if (urlBuffer.isEOF()) {
            return null;
        }
        int n = this.findStaticText(urlBuffer);
        String string = null;
        if (n < 0) {
            string = urlBuffer.urlSubString();
            urlBuffer.incrementIndex(string.length());
            return string;
        }
        string = urlBuffer.urlSubString().substring(0, n);
        urlBuffer.incrementIndex(n);
        return string;
    }

    private int findStaticText(UrlBuffer urlBuffer) {
        if (urlBuffer.isEOF()) {
            return -1;
        }
        int n = -1;
        String string = urlBuffer.currentStatic();
        while (n < 0 && string != null) {
            n = urlBuffer.urlSubString().indexOf(string);
            if (n >= 0) continue;
            string = urlBuffer.nextStatic();
        }
        return n;
    }

    private void skipStaticText(UrlBuffer urlBuffer, String string) {
        assert (urlBuffer.currentStatic() != null);
        assert (urlBuffer.currentStatic().equals(string));
        urlBuffer.nextStatic();
        urlBuffer.incrementIndex(string.length());
    }

    static {
        DB_HOST_PORT_TOKEN_SET.add(TOKEN_DB);
        DB_HOST_PORT_TOKEN_SET.add(TOKEN_HOST);
        DB_HOST_PORT_TOKEN_SET.add(TOKEN_PORT);
        DB_HOST_PORT_TOKEN_SET.add(TOKEN_ADDITIONAL);
    }

    private class OptionalSection
    extends UrlSection {
        private boolean hasValue;
        UrlSection parent;

        private OptionalSection() {
        }

        public void setParent(UrlSection urlSection) {
            this.parent = urlSection;
        }

        private UrlSection getParent() {
            return this.parent;
        }

        public void setValue(String string) {
            if (!JdbcUrl.this.isEmpty(string)) {
                this.hasValue = true;
                super.setValue(string);
            }
        }

        public String getText() {
            if (this.hasValue) {
                return super.getText();
            }
            return "";
        }
    }

    private class UrlSection {
        StringBuffer textBuf = new StringBuffer();
        OptionalSection optionalChild;

        private UrlSection() {
        }

        public String getText() {
            return this.textBuf.toString();
        }

        public void addText(String string) {
            if (string != null) {
                this.textBuf.append(string);
            }
        }

        public void setOptionalChild(OptionalSection optionalSection) {
            this.optionalChild = optionalSection;
            optionalSection.setParent(this);
        }

        public OptionalSection getOptionalChild() {
            return this.optionalChild;
        }

        public void setValue(String string) {
            this.addText(string);
        }
    }

    private class UrlBuffer {
        int index = 0;
        int staticsIndex = 0;
        int length;
        String url;

        private UrlBuffer(String string) {
            this.url = string;
            this.length = string.length();
        }

        private String getFullUrl() {
            return this.url;
        }

        private String urlSubString() {
            if (this.index < this.length) {
                return this.url.substring(this.index);
            }
            return null;
        }

        private void incrementIndex(int n) {
            this.index += n;
        }

        private boolean isEOF() {
            return this.index >= this.length;
        }

        private String currentStatic() {
            if (this.staticsIndex < JdbcUrl.this.staticComponents.size()) {
                return (String)JdbcUrl.this.staticComponents.get(this.staticsIndex);
            }
            return null;
        }

        private String nextStatic() {
            ++this.staticsIndex;
            return this.currentStatic();
        }
    }
}

