/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extexecution.api;

import javax.swing.event.ChangeListener;
import org.netbeans.modules.extexecution.api.input.InputProcessor;
import org.netbeans.modules.extexecution.api.print.LineConvertor;
import org.openide.windows.InputOutput;

public final class ExecutionDescriptor {
    private final Runnable preExecution;
    private final Runnable postExecution;
    private final boolean suspend;
    private final boolean progress;
    private final boolean front;
    private final boolean input;
    private final boolean controllable;
    private final LineConvertorFactory outConvertorFactory;
    private final LineConvertorFactory errConvertorFactory;
    private final InputProcessorFactory outProcessorFactory;
    private final InputProcessorFactory errProcessorFactory;
    private final InputOutput inputOutput;
    private final RerunCondition rerunCondition;
    private final String optionsPath;

    public ExecutionDescriptor() {
        this(new DescriptorData());
    }

    private ExecutionDescriptor(DescriptorData descriptorData) {
        this.preExecution = descriptorData.preExecution;
        this.postExecution = descriptorData.postExecution;
        this.suspend = descriptorData.suspend;
        this.progress = descriptorData.progress;
        this.front = descriptorData.front;
        this.input = descriptorData.input;
        this.controllable = descriptorData.controllable;
        this.outConvertorFactory = descriptorData.outConvertorFactory;
        this.errConvertorFactory = descriptorData.errConvertorFactory;
        this.outProcessorFactory = descriptorData.outProcessorFactory;
        this.errProcessorFactory = descriptorData.errProcessorFactory;
        this.inputOutput = descriptorData.inputOutput;
        this.rerunCondition = descriptorData.rerunCondition;
        this.optionsPath = descriptorData.optionsPath;
    }

    public ExecutionDescriptor inputOutput(InputOutput inputOutput) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.inputOutput(inputOutput));
    }

    InputOutput getInputOutput() {
        return this.inputOutput;
    }

    public ExecutionDescriptor controllable(boolean bl) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.controllable(bl));
    }

    boolean isControllable() {
        return this.controllable;
    }

    public ExecutionDescriptor frontWindow(boolean bl) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.frontWindow(bl));
    }

    boolean isFrontWindow() {
        return this.front;
    }

    public ExecutionDescriptor inputVisible(boolean bl) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.inputVisible(bl));
    }

    boolean isInputVisible() {
        return this.input;
    }

    public ExecutionDescriptor showProgress(boolean bl) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.showProgress(bl));
    }

    boolean showProgress() {
        return this.progress;
    }

    public ExecutionDescriptor showSuspended(boolean bl) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.showSuspended(bl));
    }

    boolean showSuspended() {
        return this.suspend;
    }

    public ExecutionDescriptor outProcessorFactory(InputProcessorFactory inputProcessorFactory) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.outProcessorFactory(inputProcessorFactory));
    }

    InputProcessorFactory getOutProcessorFactory() {
        return this.outProcessorFactory;
    }

    public ExecutionDescriptor errProcessorFactory(InputProcessorFactory inputProcessorFactory) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.errProcessorFactory(inputProcessorFactory));
    }

    InputProcessorFactory getErrProcessorFactory() {
        return this.errProcessorFactory;
    }

    public ExecutionDescriptor outConvertorFactory(LineConvertorFactory lineConvertorFactory) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.outConvertorFactory(lineConvertorFactory));
    }

    LineConvertorFactory getOutConvertorFactory() {
        return this.outConvertorFactory;
    }

    public ExecutionDescriptor errConvertorFactory(LineConvertorFactory lineConvertorFactory) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.errConvertorFactory(lineConvertorFactory));
    }

    LineConvertorFactory getErrConvertorFactory() {
        return this.errConvertorFactory;
    }

    public ExecutionDescriptor preExecution(Runnable runnable) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.preExecution(runnable));
    }

    Runnable getPreExecution() {
        return this.preExecution;
    }

    public ExecutionDescriptor postExecution(Runnable runnable) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.postExecution(runnable));
    }

    Runnable getPostExecution() {
        return this.postExecution;
    }

    public ExecutionDescriptor rerunCondition(RerunCondition rerunCondition) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.rerunCondition(rerunCondition));
    }

    RerunCondition getRerunCondition() {
        return this.rerunCondition;
    }

    public ExecutionDescriptor optionsPath(String string) {
        DescriptorData descriptorData = new DescriptorData(this);
        return new ExecutionDescriptor(descriptorData.optionsPath(string));
    }

    String getOptionsPath() {
        return this.optionsPath;
    }

    private static final class DescriptorData {
        private Runnable preExecution;
        private Runnable postExecution;
        private boolean suspend;
        private boolean progress;
        private boolean front;
        private boolean input;
        private boolean controllable;
        private LineConvertorFactory outConvertorFactory;
        private LineConvertorFactory errConvertorFactory;
        private InputProcessorFactory outProcessorFactory;
        private InputProcessorFactory errProcessorFactory;
        private InputOutput inputOutput;
        private RerunCondition rerunCondition;
        private String optionsPath;

        public DescriptorData() {
        }

        public DescriptorData(ExecutionDescriptor executionDescriptor) {
            this.preExecution = executionDescriptor.preExecution;
            this.postExecution = executionDescriptor.postExecution;
            this.suspend = executionDescriptor.suspend;
            this.progress = executionDescriptor.progress;
            this.front = executionDescriptor.front;
            this.input = executionDescriptor.input;
            this.controllable = executionDescriptor.controllable;
            this.outConvertorFactory = executionDescriptor.outConvertorFactory;
            this.errConvertorFactory = executionDescriptor.errConvertorFactory;
            this.outProcessorFactory = executionDescriptor.outProcessorFactory;
            this.errProcessorFactory = executionDescriptor.errProcessorFactory;
            this.input = executionDescriptor.input;
            this.rerunCondition = executionDescriptor.rerunCondition;
            this.optionsPath = executionDescriptor.optionsPath;
        }

        public DescriptorData inputOutput(InputOutput inputOutput) {
            this.inputOutput = inputOutput;
            return this;
        }

        public DescriptorData controllable(boolean bl) {
            this.controllable = bl;
            return this;
        }

        public DescriptorData frontWindow(boolean bl) {
            this.front = bl;
            return this;
        }

        public DescriptorData inputVisible(boolean bl) {
            this.input = bl;
            return this;
        }

        public DescriptorData showProgress(boolean bl) {
            this.progress = bl;
            return this;
        }

        public DescriptorData showSuspended(boolean bl) {
            this.suspend = bl;
            return this;
        }

        public DescriptorData outProcessorFactory(InputProcessorFactory inputProcessorFactory) {
            this.outProcessorFactory = inputProcessorFactory;
            return this;
        }

        public DescriptorData errProcessorFactory(InputProcessorFactory inputProcessorFactory) {
            this.errProcessorFactory = inputProcessorFactory;
            return this;
        }

        public DescriptorData outConvertorFactory(LineConvertorFactory lineConvertorFactory) {
            this.outConvertorFactory = lineConvertorFactory;
            return this;
        }

        public DescriptorData errConvertorFactory(LineConvertorFactory lineConvertorFactory) {
            this.errConvertorFactory = lineConvertorFactory;
            return this;
        }

        public DescriptorData preExecution(Runnable runnable) {
            this.preExecution = runnable;
            return this;
        }

        public DescriptorData postExecution(Runnable runnable) {
            this.postExecution = runnable;
            return this;
        }

        public DescriptorData rerunCondition(RerunCondition rerunCondition) {
            this.rerunCondition = rerunCondition;
            return this;
        }

        public DescriptorData optionsPath(String string) {
            this.optionsPath = string;
            return this;
        }
    }

    public static interface LineConvertorFactory {
        public LineConvertor newLineConvertor();
    }

    public static interface InputProcessorFactory {
        public InputProcessor newInputProcessor();
    }

    public static interface RerunCondition {
        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);

        public boolean isRerunPossible();
    }
}

