/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extexecution.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExternalProcessBuilder
implements Callable<Process> {
    private static final String USE_PROXY_AUTHENTICATION = "useProxyAuthentication";
    private static final String PROXY_AUTHENTICATION_USERNAME = "proxyAuthenticationUsername";
    private static final String PROXY_AUTHENTICATION_PASSWORD = "proxyAuthenticationPassword";
    private final String executable;
    private final File workingDirectory;
    private final boolean redirectErrorStream;
    private final List<String> arguments = new ArrayList<String>();
    private final List<File> paths = new ArrayList<File>();
    private final Map<String, String> envVariables = new HashMap<String, String>();

    public ExternalProcessBuilder(String string) {
        this(new BuilderData(string));
    }

    private ExternalProcessBuilder(BuilderData builderData) {
        this.executable = builderData.executable;
        this.workingDirectory = builderData.workingDirectory;
        this.redirectErrorStream = builderData.redirectErrorStream;
        this.arguments.addAll(builderData.arguments);
        this.paths.addAll(builderData.paths);
        this.envVariables.putAll(builderData.envVariables);
    }

    public ExternalProcessBuilder workingDirectory(File file) {
        Parameters.notNull((CharSequence)"workingDirectory", (Object)file);
        BuilderData builderData = new BuilderData(this);
        return new ExternalProcessBuilder(builderData.workingDirectory(file));
    }

    public ExternalProcessBuilder redirectErrorStream(boolean bl) {
        BuilderData builderData = new BuilderData(this);
        return new ExternalProcessBuilder(builderData.redirectErrorStream(bl));
    }

    public ExternalProcessBuilder prependPath(File file) {
        Parameters.notNull((CharSequence)"path", (Object)file);
        BuilderData builderData = new BuilderData(this);
        return new ExternalProcessBuilder(builderData.prependPath(file));
    }

    public ExternalProcessBuilder addArgument(String string) {
        Parameters.notNull((CharSequence)"argument", (Object)string);
        BuilderData builderData = new BuilderData(this);
        return new ExternalProcessBuilder(builderData.addArgument(string));
    }

    public ExternalProcessBuilder addEnvironmentVariable(String string, String string2) {
        Parameters.notNull((CharSequence)"name", (Object)string);
        Parameters.notNull((CharSequence)"value", (Object)string2);
        BuilderData builderData = new BuilderData(this);
        return new ExternalProcessBuilder(builderData.addEnvironmentVariable(string, string2));
    }

    @Override
    public Process call() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.executable);
        List<String> list = this.buildArguments();
        arrayList.addAll(list);
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        if (stringArray != null && Utilities.isWindows()) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].indexOf(32) == -1 || stringArray[i].indexOf(34) != -1) continue;
                stringArray[i] = '\"' + stringArray[i] + '\"';
            }
        }
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        if (this.workingDirectory != null) {
            processBuilder.directory(this.workingDirectory);
        }
        Map<String, String> map = processBuilder.environment();
        Map<String, String> map2 = this.buildEnvironment(map);
        map.putAll(map2);
        this.adjustProxy(processBuilder);
        processBuilder.redirectErrorStream(this.redirectErrorStream);
        return processBuilder.start();
    }

    Map<String, String> buildEnvironment(Map<String, String> map) {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        hashMap.putAll(this.envVariables);
        Object object2 = "PATH";
        if (Utilities.isWindows()) {
            object2 = "Path";
            object = hashMap.keySet().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (!"PATH".equals(string.toUpperCase(Locale.ENGLISH))) continue;
                object2 = string;
                break;
            }
        }
        if ((object = (String)hashMap.get(object2)) == null) {
            object = "";
        }
        for (File file : this.paths) {
            object = file.getAbsolutePath().replace(" ", "\\ ") + File.pathSeparator + (String)object;
        }
        if (!"".equals(((String)object).trim())) {
            hashMap.put((String)object2, (String)object);
        }
        return hashMap;
    }

    private List<String> buildArguments() {
        return new ArrayList<String>(this.arguments);
    }

    private void adjustProxy(ProcessBuilder processBuilder) {
        Map<String, String> map;
        String string = ExternalProcessBuilder.getNetBeansHttpProxy();
        if (string != null && (map = processBuilder.environment()).get("HTTP_PROXY") == null && map.get("http_proxy") == null) {
            map.put("HTTP_PROXY", string);
            map.put("http_proxy", string);
        }
    }

    private static String getNetBeansHttpProxy() {
        int n;
        String string = System.getProperty("http.proxyHost");
        if (string == null) {
            return null;
        }
        String string2 = System.getProperty("http.proxyPort");
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = 8080;
        }
        Preferences preferences = NbPreferences.root().node("org/netbeans/core");
        boolean bl = preferences.getBoolean(USE_PROXY_AUTHENTICATION, false);
        String string3 = "";
        if (bl) {
            string3 = preferences.get(PROXY_AUTHENTICATION_USERNAME, "") + ":" + preferences.get(PROXY_AUTHENTICATION_PASSWORD, "") + '@';
        }
        if (string.indexOf(58) == -1) {
            string = "http://" + string3 + string;
        }
        return string + ":" + n;
    }

    private static class BuilderData {
        private final String executable;
        private File workingDirectory;
        private boolean redirectErrorStream;
        private List<String> arguments = new ArrayList<String>();
        private List<File> paths = new ArrayList<File>();
        private Map<String, String> envVariables = new HashMap<String, String>();

        public BuilderData(String string) {
            this.executable = string;
        }

        public BuilderData(ExternalProcessBuilder externalProcessBuilder) {
            this.executable = externalProcessBuilder.executable;
            this.workingDirectory = externalProcessBuilder.workingDirectory;
            this.redirectErrorStream = externalProcessBuilder.redirectErrorStream;
            this.arguments.addAll(externalProcessBuilder.arguments);
            this.paths.addAll(externalProcessBuilder.paths);
            this.envVariables.putAll(externalProcessBuilder.envVariables);
        }

        public BuilderData workingDirectory(File file) {
            assert (file != null);
            this.workingDirectory = file;
            return this;
        }

        public BuilderData redirectErrorStream(boolean bl) {
            this.redirectErrorStream = bl;
            return this;
        }

        public BuilderData prependPath(File file) {
            assert (file != null);
            this.paths.add(file);
            return this;
        }

        public BuilderData addArgument(String string) {
            assert (string != null);
            this.arguments.add(string);
            return this;
        }

        public BuilderData addEnvironmentVariable(String string, String string2) {
            assert (string != null);
            assert (string2 != null);
            this.envVariables.put(string, string2);
            return this;
        }
    }
}

