/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extexecution.api.print;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.extexecution.api.print.ConvertedLine;
import org.netbeans.modules.extexecution.api.print.LineConvertor;
import org.netbeans.modules.extexecution.print.FindFileListener;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LineConvertors {
    private static final Logger LOGGER = Logger.getLogger(LineConvertors.class.getName());

    private LineConvertors() {
    }

    public static LineConvertor filePattern(LineConvertor lineConvertor, FileLocator fileLocator, Pattern pattern, Pattern pattern2, int n, int n2) {
        Parameters.notNull((CharSequence)"linePattern", (Object)pattern);
        if (n < 0) {
            throw new IllegalArgumentException("File goup must be non negative: " + n);
        }
        return new FilePatternConvertor(lineConvertor, fileLocator, pattern, pattern2, n, n2);
    }

    public static LineConvertor httpUrl(LineConvertor lineConvertor) {
        return new HttpUrlConvertor(lineConvertor);
    }

    private static List<ConvertedLine> chain(LineConvertor lineConvertor, String string) {
        if (lineConvertor != null) {
            return lineConvertor.convert(string);
        }
        return Collections.singletonList(new SimpleConvertedLine(string));
    }

    private static class UrlOutputListener
    implements OutputListener {
        private final URL url;

        public UrlOutputListener(URL uRL) {
            this.url = uRL;
        }

        public void outputLineAction(OutputEvent outputEvent) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(this.url);
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }
    }

    private static class SimpleConvertedLine
    implements ConvertedLine {
        private final String text;
        private final OutputListener listner;

        public SimpleConvertedLine(String string) {
            this(string, null);
        }

        public SimpleConvertedLine(String string, OutputListener outputListener) {
            this.text = string;
            this.listner = outputListener;
        }

        public OutputListener getListener() {
            return this.listner;
        }

        public String getText() {
            return this.text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HttpUrlConvertor
    implements LineConvertor {
        private final LineConvertor chain;
        private final Pattern pattern = Pattern.compile(".*(((http)|(https))://\\S+)(\\s.*|$)");

        public HttpUrlConvertor(LineConvertor lineConvertor) {
            this.chain = lineConvertor;
        }

        @Override
        public List<ConvertedLine> convert(String string) {
            Matcher matcher = this.pattern.matcher(string);
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                try {
                    URL uRL = new URL(string2);
                    return Collections.singletonList(new SimpleConvertedLine(string, new UrlOutputListener(uRL)));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return LineConvertors.chain(this.chain, string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilePatternConvertor
    implements LineConvertor {
        private final LineConvertor chain;
        private final FileLocator locator;
        private final Pattern linePattern;
        private final Pattern filePattern;
        private final int fileGroup;
        private final int lineGroup;

        public FilePatternConvertor(LineConvertor lineConvertor, FileLocator fileLocator, Pattern pattern, Pattern pattern2) {
            this(lineConvertor, fileLocator, pattern, pattern2, 1, 2);
        }

        public FilePatternConvertor(LineConvertor lineConvertor, FileLocator fileLocator, Pattern pattern, Pattern pattern2, int n, int n2) {
            this.chain = lineConvertor;
            this.locator = fileLocator;
            this.linePattern = pattern;
            this.fileGroup = n;
            this.lineGroup = n2;
            this.filePattern = pattern2;
        }

        @Override
        public List<ConvertedLine> convert(String string) {
            if (string.length() > 400) {
                return LineConvertors.chain(this.chain, string);
            }
            Matcher matcher = this.linePattern.matcher(string);
            if (matcher.matches()) {
                String string2 = null;
                int n = -1;
                if (this.fileGroup >= 0) {
                    string2 = matcher.group(this.fileGroup);
                    if (string2.startsWith("\"")) {
                        string2 = string2.substring(1);
                    }
                    if (string2.startsWith("./")) {
                        string2 = string2.substring(2);
                    }
                    if (this.filePattern != null && !this.filePattern.matcher(string2).matches()) {
                        return LineConvertors.chain(this.chain, string);
                    }
                }
                if (this.lineGroup >= 0) {
                    String string3 = matcher.group(this.lineGroup);
                    try {
                        n = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.log(Level.INFO, null, numberFormatException);
                        n = 0;
                    }
                }
                return Collections.singletonList(new SimpleConvertedLine(string, new FindFileListener(string2, n, this.locator)));
            }
            return LineConvertors.chain(this.chain, string);
        }
    }

    public static interface FileLocator {
        public FileObject find(String var1);
    }
}

