/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extexecution.print;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.extexecution.api.print.LineConvertors;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class FindFileListener
implements OutputListener {
    private static final Logger LOGGER = Logger.getLogger(FindFileListener.class.getName());
    private final String file;
    private final int lineno;
    private final LineConvertors.FileLocator fileLocator;

    public FindFileListener(String string, int n, LineConvertors.FileLocator fileLocator) {
        if (n < 0) {
            n = 0;
        }
        this.file = string;
        this.lineno = n;
        this.fileLocator = fileLocator;
    }

    public void outputLineSelected(OutputEvent outputEvent) {
    }

    public void outputLineAction(OutputEvent outputEvent) {
        FileObject fileObject = this.findFile(this.file);
        if (fileObject != null) {
            FindFileListener.open(fileObject, this.lineno);
        }
    }

    private FileObject findFile(String string) {
        Object object;
        if (this.fileLocator != null && (object = this.fileLocator.find(string)) != null) {
            return object;
        }
        object = new File(string);
        if (((File)object).isFile()) {
            return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)object));
        }
        LOGGER.warning("Cannot resolve file for \"" + string + "\" path.");
        return null;
    }

    public void outputLineCleared(OutputEvent outputEvent) {
    }

    public static boolean open(final FileObject fileObject, final int n) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FindFileListener.open(fileObject, n);
                }
            });
            return true;
        }
        try {
            StyledDocument styledDocument;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (editorCookie != null && lineCookie != null && (styledDocument = editorCookie.openDocument()) != null) {
                int n2 = n;
                if (n2 < 1) {
                    n2 = 1;
                }
                try {
                    Line.Set set = lineCookie.getLineSet();
                    Line line = set.getCurrent(n2 - 1);
                    if (line != null) {
                        line.show(2);
                        return true;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if ((styledDocument = (OpenCookie)dataObject.getCookie(OpenCookie.class)) != null) {
                styledDocument.open();
                return true;
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
        }
        return false;
    }
}

