/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class FileBuiltQueryImpl
implements FileBuiltQueryImplementation,
PropertyChangeListener,
Runnable {
    protected final AntProjectHelper helper;
    private static final Object NONE = "NONE";
    private final Map<FileObject, Object> statuses = new WeakHashMap<FileObject, Object>();
    private FileObject srcRoot = null;

    public FileBuiltQueryImpl(AntProjectHelper antProjectHelper, ProjectConfigurationsHelper projectConfigurationsHelper) {
        this.helper = antProjectHelper;
        projectConfigurationsHelper.addPropertyChangeListener(this);
    }

    protected FileObject getSrcRoot() {
        String string;
        if (this.srcRoot == null && (string = this.helper.getStandardPropertyEvaluator().getProperty("src.dir")) != null) {
            this.srcRoot = this.helper.resolveFileObject(string);
        }
        return this.srcRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBuiltQuery.Status getStatus(FileObject fileObject) {
        StatusImpl statusImpl;
        Object object;
        Object object2 = this.statuses;
        synchronized (object2) {
            object = this.statuses.get(fileObject);
        }
        if (object == NONE) {
            return null;
        }
        object2 = (Reference)object;
        StatusImpl statusImpl2 = statusImpl = object2 != null ? (StatusImpl)((Reference)object2).get() : null;
        if (statusImpl == null) {
            statusImpl = this.createStatus(fileObject);
            Map<FileObject, Object> map = this.statuses;
            synchronized (map) {
                if (statusImpl != null) {
                    this.statuses.put(fileObject, new WeakReference<StatusImpl>(statusImpl));
                } else {
                    this.statuses.put(fileObject, NONE);
                }
            }
        }
        return statusImpl;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        RequestProcessor.getDefault().post((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        FileObject[] fileObjectArray;
        Map<FileObject, Object> map = this.statuses;
        synchronized (map) {
            fileObjectArray = this.statuses.keySet().toArray(new FileObject[this.statuses.size()]);
        }
        for (int i = 0; i < fileObjectArray.length; ++i) {
            StatusImpl statusImpl = (StatusImpl)this.getStatus(fileObjectArray[i]);
            if (statusImpl == null) continue;
            statusImpl.isBuilt();
        }
    }

    private StatusImpl createStatus(FileObject fileObject) {
        FileObject fileObject2 = this.getSrcRoot();
        if (fileObject2 != null && fileObject != null && FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject) && fileObject.getExt().equals("java")) {
            try {
                return new StatusImpl(fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private final class StatusImpl
    implements FileBuiltQuery.Status,
    PropertyChangeListener,
    FileChangeListener,
    Runnable {
        private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
        private Boolean built = null;
        private final DataObject source;
        private FileObject oldTarget = null;
        private FileChangeListener weekListener = null;

        StatusImpl(FileObject fileObject) throws DataObjectNotFoundException {
            this.source = DataObject.find((FileObject)fileObject);
            this.source.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.source));
            fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fileObject));
        }

        private synchronized File getTarget() {
            FileObject fileObject = FileBuiltQueryImpl.this.getSrcRoot();
            FileObject fileObject2 = this.source.getPrimaryFile();
            if (fileObject == null || fileObject2 == null) {
                return null;
            }
            String string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
            String string2 = FileBuiltQueryImpl.this.helper.getStandardPropertyEvaluator().getProperty("build.classes.dir");
            File file = string == null || !string.endsWith(".java") || string2 == null ? null : FileBuiltQueryImpl.this.helper.resolveFile(string2 + "/" + string.substring(0, string.length() - 4) + "class");
            FileObject fileObject3 = null;
            for (File file2 = file; !(fileObject3 != null && fileObject3.isValid() || file2 == null); file2 = file2.getParentFile()) {
                fileObject3 = FileUtil.toFileObject(file2);
            }
            if (!Utilities.compareObjects((Object)this.oldTarget, (Object)fileObject3)) {
                if (this.oldTarget != null && this.weekListener != null) {
                    this.oldTarget.removeFileChangeListener(this.weekListener);
                }
                if (fileObject3 != null) {
                    this.weekListener = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fileObject3);
                    fileObject3.addFileChangeListener(this.weekListener);
                    fileObject3.getChildren();
                }
                this.oldTarget = fileObject3;
            }
            return file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isBuilt() {
            boolean bl;
            boolean bl2 = false;
            StatusImpl statusImpl = this;
            synchronized (statusImpl) {
                bl = this.isReallyBuilt();
                if (this.built != null && this.built != bl) {
                    bl2 = true;
                }
                this.built = bl;
            }
            if (bl2) {
                this.fireChange();
            }
            return bl;
        }

        private boolean isReallyBuilt() {
            File file = this.getTarget();
            FileObject fileObject = this.source.getPrimaryFile();
            if (!this.source.isValid() || this.source.isModified() || file == null || fileObject == null) {
                return false;
            }
            return file.lastModified() >= fileObject.lastModified().getTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ChangeListener[] changeListenerArray;
            Object object = this.listeners;
            synchronized (object) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            object = new ChangeEvent(this);
            for (int i = 0; i < changeListenerArray.length; ++i) {
                changeListenerArray[i].stateChanged((ChangeEvent)object);
            }
        }

        private void update() {
            RequestProcessor.getDefault().post((Runnable)this);
        }

        public void run() {
            this.isBuilt();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            assert (propertyChangeEvent.getSource() instanceof DataObject);
            if ("modified".equals(propertyChangeEvent.getPropertyName())) {
                this.update();
            }
        }

        public void fileChanged(FileEvent fileEvent) {
            this.update();
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.update();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.update();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.update();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.update();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public String toString() {
            return "FBQI.StatusImpl[" + this.source.getPrimaryFile() + " -> " + this.getTarget() + "]";
        }
    }
}

