/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.AddAPIPanel;
import org.netbeans.spi.mobility.project.ui.customizer.CustomizerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.VisualPropertyGroup;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CustomizerPermissions
extends JPanel
implements CustomizerPanel,
VisualPropertyGroup,
ListSelectionListener {
    static final String[] PROPERTY_GROUP = new String[]{"manifest.apipermissions"};
    protected JTable table;
    protected StorableTableModel tableModel;
    private VisualPropertySupport vps;
    private String configuration;
    private String configurationProfileValue;
    private String defaultProfileValue;
    private JButton bAdd;
    private JButton bRemove;
    private JCheckBox cDefault;
    private JLabel lError;
    private JLabel lTable;
    private JScrollPane scrollPane;

    public CustomizerPermissions() {
        this.initComponents();
        this.initAccessibility();
        this.tableModel = new StorableTableModel();
        this.table = new JTable(this.tableModel);
        this.scrollPane.setViewportView(this.table);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        TableColumn tableColumn2 = this.table.getColumnModel().getColumn(1);
        tableColumn.setResizable(true);
        tableColumn.setPreferredWidth(300);
        tableColumn2.setResizable(true);
        tableColumn2.setPreferredWidth(80);
    }

    private void initComponents() {
        this.cDefault = new JCheckBox();
        this.lTable = new JLabel();
        this.scrollPane = new JScrollPane();
        this.bAdd = new JButton();
        this.bRemove = new JButton();
        this.lError = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.cDefault, (String)NbBundle.getMessage(CustomizerPermissions.class, (String)"LBL_Use_Default"));
        this.cDefault.setMargin(new Insets(0, 0, 0, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cDefault, gridBagConstraints);
        this.lTable.setLabelFor(this.lTable);
        Mnemonics.setLocalizedText((JLabel)this.lTable, (String)NbBundle.getMessage(CustomizerPermissions.class, (String)"LBL_Perm_Table"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 6);
        this.add((Component)this.lTable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bAdd, (String)NbBundle.getMessage(CustomizerPermissions.class, (String)"LBL_Perm_Add"));
        this.bAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPermissions.this.bAddActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 11, 5, 0);
        this.add((Component)this.bAdd, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bRemove, (String)NbBundle.getMessage(CustomizerPermissions.class, (String)"LBL_Perm_Remove"));
        this.bRemove.setEnabled(false);
        this.bRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPermissions.this.bRemoveActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 11, 5, 0);
        this.add((Component)this.bRemove, gridBagConstraints);
        this.lError.setForeground(new Color(89, 79, 191));
        Mnemonics.setLocalizedText((JLabel)this.lError, (String)NbBundle.getMessage(CustomizerPermissions.class, (String)"ERR_Perm_NotUsed"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.lError, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPermissions.class, (String)"ACSN_Perm"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPermissions.class, (String)"ACSD_Perm"));
    }

    private void bAddActionPerformed(ActionEvent actionEvent) {
        final AddAPIPanel addAPIPanel = new AddAPIPanel(this.tableModel.getKeys());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addAPIPanel, NbBundle.getMessage(CustomizerPermissions.class, (String)"TITLE_AddAPI"), true, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (NotifyDescriptor.OK_OPTION.equals(actionEvent.getSource())) {
                    int n = CustomizerPermissions.this.tableModel.addRow(addAPIPanel.getAPIName());
                    CustomizerPermissions.this.table.getSelectionModel().setSelectionInterval(n, n);
                }
            }
        });
        addAPIPanel.setDialogDescriptor(dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    private void bRemoveActionPerformed(ActionEvent actionEvent) {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        this.tableModel.removeRow(n);
        int n2 = this.tableModel.getRowCount();
        if (n2 <= 0) {
            this.table.getSelectionModel().clearSelection();
        } else if (n < n2) {
            this.table.getSelectionModel().setSelectionInterval(n, n);
        } else {
            this.table.getSelectionModel().setSelectionInterval(n2 - 1, n2 - 1);
        }
    }

    public void initValues(ProjectProperties projectProperties, String string) {
        this.configuration = string;
        this.configurationProfileValue = (String)projectProperties.get(VisualPropertySupport.translatePropertyName(string, "platform.profile", false));
        this.defaultProfileValue = (String)projectProperties.get("platform.profile");
        this.vps = VisualPropertySupport.getDefault(projectProperties);
        this.vps.register(this.cDefault, string, this);
    }

    public String[] getGroupPropertyNames() {
        return PROPERTY_GROUP;
    }

    public void initGroupValues(boolean bl) {
        String string = null;
        if (this.configuration != null) {
            string = this.configurationProfileValue;
        }
        if (string == null) {
            string = this.defaultProfileValue;
        }
        boolean bl2 = string != null && !string.equals("MIDP-1.0");
        this.vps.register(this.tableModel, new String[]{"manifest.apipermissions"}, bl);
        this.bAdd.setEnabled(!bl);
        this.bRemove.setEnabled(!bl);
        this.table.setEnabled(!bl);
        this.lTable.setEnabled(!bl);
        this.table.setBackground(UIManager.getDefaults().getColor(bl ? "TextField.inactiveBackground" : "Table.background"));
        this.valueChanged(null);
        this.lError.setVisible(!bl2);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.bRemove.setEnabled(this.table.isEnabled() && this.table.getSelectedRow() >= 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StorableTableModel
    extends AbstractTableModel
    implements VisualPropertySupport.StorableTableModel {
        private HashMap<String, String> map = new HashMap();
        private final ArrayList<Item> items = new ArrayList();
        private static final long serialVersionUID = -6523408202243150812L;

        public HashSet<String> getKeys() {
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < this.items.size(); ++i) {
                hashSet.add(this.items.get(i).getName());
            }
            return hashSet;
        }

        @Override
        public int getRowCount() {
            return this.items.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return NbBundle.getMessage(CustomizerPermissions.class, (String)"LBL_Perm_Column_API");
                }
                case 1: {
                    return NbBundle.getMessage(CustomizerPermissions.class, (String)"LBL_Perm_Column_Required");
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Boolean.class;
                }
            }
            return null;
        }

        @Override
        public synchronized Object[] getDataDelegates() {
            this.updateMapFromItems();
            return new Object[]{this.map};
        }

        @Override
        public Object getValueAt(int n, int n2) {
            assert (n < this.items.size());
            switch (n2) {
                case 0: {
                    return this.items.get(n);
                }
                case 1: {
                    return this.items.get(n).isRequired();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            assert (n2 == 1 && object instanceof Boolean);
            this.items.get(n).setRequired((Boolean)object);
            this.fireTableRowsUpdated(n, n);
        }

        @Override
        public synchronized void setDataDelegates(Object[] objectArray) {
            assert (objectArray != null);
            this.map = objectArray[0] == null ? new HashMap() : (HashMap)objectArray[0];
            this.updateItemsFromMap();
            this.fireTableDataChanged();
        }

        public void updateItemsFromMap() {
            StringTokenizer stringTokenizer;
            this.items.clear();
            String string = this.map.get("MIDlet-Permissions");
            if (string != null) {
                stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    this.items.add(new Item(stringTokenizer.nextToken().trim(), true));
                }
            }
            if ((string = this.map.get("MIDlet-Permissions-Opt")) != null) {
                stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    this.items.add(new Item(stringTokenizer.nextToken().trim(), false));
                }
            }
        }

        public void updateMapFromItems() {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int i = 0; i < this.items.size(); ++i) {
                Item item = this.items.get(i);
                if (item.isRequired()) {
                    arrayList.add(item.getName());
                    continue;
                }
                arrayList2.add(item.getName());
            }
            this.map = new HashMap();
            if (arrayList.size() > 0) {
                this.map.put("MIDlet-Permissions", this.commaSeparatedList(arrayList));
            }
            if (arrayList2.size() > 0) {
                this.map.put("MIDlet-Permissions-Opt", this.commaSeparatedList(arrayList2));
            }
        }

        public String commaSeparatedList(ArrayList<String> arrayList) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(arrayList.get(i));
                }
            }
            return stringBuffer.toString();
        }

        public int addRow(String string) {
            int n = this.items.size();
            this.items.add(new Item(string, true));
            this.fireTableRowsInserted(n, n);
            return n;
        }

        public void removeRow(int n) {
            assert (n < this.items.size());
            this.items.remove(n);
            this.fireTableRowsDeleted(n, this.items.size() + 1);
        }

        static class Item {
            private final String name;
            private boolean required;

            public Item(String string, boolean bl) {
                this.name = string;
                this.required = bl;
            }

            public String getName() {
                return this.name;
            }

            public boolean isRequired() {
                return this.required;
            }

            public void setRequired(boolean bl) {
                this.required = bl;
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

