/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Image;
import java.io.File;
import java.net.URI;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class VisualClassPathItem {
    public static final int TYPE_JAR = 0;
    public static final int TYPE_LIBRARY = 1;
    public static final int TYPE_ARTIFACT = 2;
    public static final int TYPE_CLASSPATH = 3;
    public static final int TYPE_FOLDER = 4;
    private static final String RESOURCE_ICON_JAR = "org/netbeans/modules/project/support/customizer/resources/jar.gif";
    private static final String RESOURCE_ICON_FOLDER = "org/netbeans/modules/project/support/customizer/resources/folder.gif";
    private static final String RESOURCE_ICON_LIBRARY = "org/netbeans/modules/project/support/customizer/resources/libraries.gif";
    private static final String RESOURCE_ICON_ARTIFACT = "org/netbeans/modules/project/support/customizer/resources/projectDependencies.gif";
    private static final String RESOURCE_ICON_CLASSPATH = "org/netbeans/modules/project/support/customizer/resources/project.gif";
    private static final String RESOURCE_ICON_BROKEN = "org/netbeans/modules/project/support/customizer/resources/brokenProjectBadge.gif";
    private static Icon ICON_JAR;
    private static Icon ICON_LIBRARY;
    private static Icon ICON_ARTIFACT;
    private static Icon ICON_CLASSPATH;
    private static Icon ICON_FOLDER;
    private static Icon ICON_BROKEN_JAR;
    private static Icon ICON_BROKEN_LIBRARY;
    private static Icon ICON_BROKEN_ARTIFACT;
    private static Icon ICON_BROKEN_CLASSPATH;
    private static Icon ICON_BROKEN_FOLDER;
    private int type;
    private Object cpElement;
    private String display;
    private String rawText;
    private URI uri;
    private boolean extra = false;

    public static VisualClassPathItem create(Library library) {
        if (library == null) {
            throw new IllegalArgumentException("library must not be null");
        }
        String string = library.getName();
        return new VisualClassPathItem(library, 1, "${libs." + string + ".classpath}", library.getDisplayName());
    }

    public static VisualClassPathItem create(AntArtifact antArtifact, URI uRI) {
        String string;
        if (uRI == null) {
            throw new IllegalArgumentException("artifactURI must not be null");
        }
        if (antArtifact == null) {
            throw new IllegalArgumentException("artifact must not be null");
        }
        try {
            string = FileUtil.normalizeFile((File)new File(antArtifact.getScriptLocation().getParentFile().toURI().resolve(uRI))).getPath();
        }
        catch (Exception exception) {
            string = uRI.getPath();
        }
        return new VisualClassPathItem(antArtifact, uRI, 2, null, string);
    }

    public static VisualClassPathItem create(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        return new VisualClassPathItem(file, VisualClassPathItem.isJar(file.getName()) ? 0 : 4, null, file.getPath());
    }

    private static boolean isJar(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.toLowerCase()).endsWith(".jar") || string.endsWith(".zip");
    }

    public void setExtra(boolean bl) {
        this.extra = bl;
    }

    public boolean isExtra() {
        return this.extra;
    }

    public VisualClassPathItem(AntArtifact antArtifact, URI uRI, int n, String string, String string2) {
        this(antArtifact, n, string, string2);
        this.uri = uRI;
    }

    public VisualClassPathItem(Object object, int n, String string, String string2) {
        this.cpElement = object;
        this.type = n;
        this.display = string2;
        this.rawText = string;
    }

    public Object getElement() {
        return this.cpElement;
    }

    public URI getURI() {
        return this.uri;
    }

    public int getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.display;
    }

    public String getRawText() {
        return this.rawText;
    }

    public boolean canDelete() {
        return this.getType() != 3;
    }

    public Icon getIcon() {
        switch (this.getType()) {
            case 0: {
                return this.getElement() != null ? ICON_JAR : ICON_BROKEN_JAR;
            }
            case 4: {
                return this.getElement() != null ? ICON_FOLDER : ICON_BROKEN_FOLDER;
            }
            case 1: {
                return this.getElement() != null ? ICON_LIBRARY : ICON_BROKEN_LIBRARY;
            }
            case 2: {
                return this.getElement() != null ? ICON_ARTIFACT : ICON_BROKEN_ARTIFACT;
            }
            case 3: {
                return this.getElement() != null ? ICON_CLASSPATH : ICON_BROKEN_CLASSPATH;
            }
        }
        return null;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public int hashCode() {
        int n = this.getType();
        switch (this.getType()) {
            case 2: {
                AntArtifact antArtifact = (AntArtifact)this.getElement();
                if (antArtifact == null) {
                    if (this.rawText == null) break;
                    n += this.rawText.hashCode();
                    break;
                }
                n += antArtifact.getType().hashCode();
                n += antArtifact.getScriptLocation().hashCode();
                n += this.uri.hashCode();
                break;
            }
            default: {
                Object object = this.getElement();
                if (object == null) break;
                n += object.hashCode();
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VisualClassPathItem)) {
            return false;
        }
        VisualClassPathItem visualClassPathItem = (VisualClassPathItem)object;
        if (this.getType() != visualClassPathItem.getType()) {
            return false;
        }
        switch (this.getType()) {
            case 2: {
                AntArtifact antArtifact = (AntArtifact)this.getElement();
                AntArtifact antArtifact2 = (AntArtifact)visualClassPathItem.getElement();
                if (antArtifact == null || antArtifact2 == null) {
                    return this.getRawText() != null && visualClassPathItem.getRawText() != null && this.getRawText().equals(visualClassPathItem.getRawText());
                }
                if (antArtifact.getType() != antArtifact2.getType()) {
                    return false;
                }
                if (!antArtifact.getScriptLocation().equals(antArtifact2.getScriptLocation())) {
                    return false;
                }
                return this.getURI().equals(visualClassPathItem.getURI());
            }
        }
        Object object2 = this.getElement();
        Object object3 = visualClassPathItem.getElement();
        if (object3 == null && object2 == null && visualClassPathItem.getRawText().equals(this.getRawText())) {
            return true;
        }
        if (object2 == null && object3 instanceof Library && this.toString().equals(visualClassPathItem.toString()) && visualClassPathItem.getRawText().equals(this.getRawText())) {
            return true;
        }
        if (object2 == null) {
            return false;
        }
        return object2.equals(visualClassPathItem.getElement());
    }

    static {
        Image image = Utilities.loadImage((String)RESOURCE_ICON_BROKEN);
        Image image2 = Utilities.loadImage((String)RESOURCE_ICON_JAR);
        ICON_JAR = new ImageIcon(image2);
        ICON_BROKEN_JAR = new ImageIcon(Utilities.mergeImages((Image)image2, (Image)image, (int)8, (int)0));
        image2 = Utilities.loadImage((String)RESOURCE_ICON_LIBRARY);
        ICON_LIBRARY = new ImageIcon(image2);
        ICON_BROKEN_LIBRARY = new ImageIcon(Utilities.mergeImages((Image)image2, (Image)image, (int)8, (int)0));
        image2 = Utilities.loadImage((String)RESOURCE_ICON_ARTIFACT);
        ICON_ARTIFACT = new ImageIcon(image2);
        ICON_BROKEN_ARTIFACT = new ImageIcon(Utilities.mergeImages((Image)image2, (Image)image, (int)8, (int)0));
        image2 = Utilities.loadImage((String)RESOURCE_ICON_CLASSPATH);
        ICON_CLASSPATH = new ImageIcon(image2);
        ICON_BROKEN_CLASSPATH = new ImageIcon(Utilities.mergeImages((Image)image2, (Image)image, (int)8, (int)0));
        image2 = Utilities.loadImage((String)RESOURCE_ICON_FOLDER);
        ICON_FOLDER = new ImageIcon(image2);
        ICON_BROKEN_FOLDER = new ImageIcon(Utilities.mergeImages((Image)image2, (Image)image, (int)8, (int)0));
    }
}

