/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.security;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.mobility.project.security.KeyStoreRepository;
import org.netbeans.modules.mobility.project.ui.customizer.ErrorPanel;
import org.netbeans.modules.mobility.project.ui.wizard.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AddKeystorePanel
extends JPanel
implements ActionListener,
DocumentListener {
    static String location = System.getProperty("user.home", "");
    private DialogDescriptor dd;
    private JButton bBrowseFile;
    private JButton bBrowseLocation;
    private ButtonGroup buttonGroup;
    private JLabel lFile;
    private JLabel lLocation;
    private JLabel lName;
    private JLabel lPassword;
    private JLabel lPasswordConfirm;
    private ErrorPanel pError;
    private JRadioButton rExisting;
    private JRadioButton rNew;
    private JTextField tFile;
    private JTextField tLocation;
    private JTextField tName;
    private JPasswordField tPassword;
    private JPasswordField tPasswordConfirm;

    public AddKeystorePanel() {
        this.initComponents();
        this.initAccessibility();
        this.rNew.addActionListener(this);
        this.rExisting.addActionListener(this);
        this.tName.getDocument().addDocumentListener(this);
        this.tLocation.getDocument().addDocumentListener(this);
        this.tPassword.getDocument().addDocumentListener(this);
        this.tPasswordConfirm.getDocument().addDocumentListener(this);
        this.tFile.getDocument().addDocumentListener(this);
        this.rNew.setSelected(true);
        this.tName.setText("keystore.ks");
        this.tLocation.setText(location);
        this.tFile.setText(location);
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.rNew = new JRadioButton();
        this.lName = new JLabel();
        this.tName = new JTextField();
        this.lLocation = new JLabel();
        this.tLocation = new JTextField();
        this.bBrowseLocation = new JButton();
        this.lPassword = new JLabel();
        this.tPassword = new JPasswordField();
        this.lPasswordConfirm = new JLabel();
        this.tPasswordConfirm = new JPasswordField();
        this.rExisting = new JRadioButton();
        this.lFile = new JLabel();
        this.tFile = new JTextField();
        this.bBrowseFile = new JButton();
        this.pError = new ErrorPanel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        this.buttonGroup.add(this.rNew);
        this.rNew.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rNew, (String)NbBundle.getMessage(AddKeystorePanel.class, (String)"LBL_AddKeystore_CreateNew"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.rNew, gridBagConstraints);
        this.rNew.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSD_AddKeystore_New"));
        this.lName.setLabelFor(this.tName);
        Mnemonics.setLocalizedText((JLabel)this.lName, (String)NbBundle.getMessage(AddKeystorePanel.class, (String)"LBL_AddKeystore_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 12, 5);
        this.add((Component)this.lName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.tName, gridBagConstraints);
        this.tName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSD_AddKeystore_Name"));
        this.lLocation.setLabelFor(this.tLocation);
        Mnemonics.setLocalizedText((JLabel)this.lLocation, (String)NbBundle.getMessage(AddKeystorePanel.class, (String)"LBL_AddKeystore_Folder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 0, 5);
        this.add((Component)this.lLocation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tLocation, gridBagConstraints);
        this.tLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSD_AddKeystore_Folder"));
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowseLocation, (String)NbBundle.getMessage(AddKeystorePanel.class, (String)"LBL_AddKeystore_BrowseFolder"));
        this.bBrowseLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddKeystorePanel.this.bBrowseLocationActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.bBrowseLocation, gridBagConstraints);
        this.bBrowseLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSD_AddKeystore_Browse1"));
        this.lPassword.setLabelFor(this.tPassword);
        Mnemonics.setLocalizedText((JLabel)this.lPassword, (String)NbBundle.getMessage(AddKeystorePanel.class, (String)"LBL_AddKeystore_Password"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 16, 12, 5);
        this.add((Component)this.lPassword, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 12, 0);
        this.add((Component)this.tPassword, gridBagConstraints);
        this.tPassword.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSD_AddKeystore_Password"));
        this.lPasswordConfirm.setLabelFor(this.tPasswordConfirm);
        Mnemonics.setLocalizedText((JLabel)this.lPasswordConfirm, (String)NbBundle.getMessage(AddKeystorePanel.class, (String)"LBL_AddKeystore_ConfirmPassword"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 0, 5);
        this.add((Component)this.lPasswordConfirm, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tPasswordConfirm, gridBagConstraints);
        this.tPasswordConfirm.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSD_AddKeystore_Password2"));
        this.buttonGroup.add(this.rExisting);
        Mnemonics.setLocalizedText((AbstractButton)this.rExisting, (String)NbBundle.getMessage(AddKeystorePanel.class, (String)"LBL_AddKeystore_AddExisting"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 12, 0);
        this.add((Component)this.rExisting, gridBagConstraints);
        this.rExisting.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSD_AddKeystore_Existing"));
        this.lFile.setLabelFor(this.tFile);
        Mnemonics.setLocalizedText((JLabel)this.lFile, (String)NbBundle.getMessage(AddKeystorePanel.class, (String)"LBL_AddKeystore_File"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 0, 5);
        this.add((Component)this.lFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.add((Component)this.tFile, gridBagConstraints);
        this.tFile.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSD_AddKeystore_Keystore"));
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowseFile, (String)NbBundle.getMessage(AddKeystorePanel.class, (String)"LBL_AddKeystore_BrowseFile"));
        this.bBrowseFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddKeystorePanel.this.bBrowseFileActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.bBrowseFile, gridBagConstraints);
        this.bBrowseFile.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSD_AddKeystore_Browse2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pError, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSN_AddKeystore"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddKeystorePanel.class, (String)"ACSD_AddKeystore"));
    }

    protected void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.dd = dialogDescriptor;
        this.dd.setHelpCtx(new HelpCtx(AddKeystorePanel.class));
        this.actionPerformed(null);
    }

    public String getErrorMessage() {
        if (this.rNew.isSelected()) {
            String string = this.tName.getText();
            if (string == null || "".equals(string)) {
                return "ERR_EmptyKSFileName";
            }
            File file = new File(this.tLocation.getText());
            if (!(file.exists() && file.isDirectory() && file.canWrite())) {
                return "ERR_KSFolderNotExists";
            }
            if ((file = new File(file, string)).exists()) {
                return "ERR_KSFileExists";
            }
            if (KeyStoreRepository.getDefault().getKeyStore(file.getAbsolutePath(), false) != null) {
                return "ERR_KSFileAlreadyAdded";
            }
            if (this.tPassword.getPassword().length < 6) {
                return "ERR_PasswordSmall";
            }
            if (!new String(this.tPassword.getPassword()).equals(new String(this.tPasswordConfirm.getPassword()))) {
                return "ERR_PasswordsNotEqual";
            }
        } else {
            File file = new File(this.tFile.getText());
            if (!file.exists() || !file.isFile()) {
                return "ERR_KSFileNotExists";
            }
        }
        return null;
    }

    public void checkErrors() {
        boolean bl;
        String string = this.getErrorMessage();
        this.pError.setErrorMessage(string != null ? NbBundle.getMessage(AddKeystorePanel.class, (String)string) : null);
        boolean bl2 = bl = string == null;
        if (this.dd != null && bl != this.dd.isValid()) {
            this.dd.setValid(bl);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = this.rNew.isSelected();
        this.lName.setEnabled(bl);
        this.tName.setEnabled(bl);
        this.lLocation.setEnabled(bl);
        this.tLocation.setEnabled(bl);
        this.bBrowseLocation.setEnabled(bl);
        this.lPassword.setEnabled(bl);
        this.tPassword.setEnabled(bl);
        this.lPasswordConfirm.setEnabled(bl);
        this.tPasswordConfirm.setEnabled(bl);
        this.lFile.setEnabled(!bl);
        this.tFile.setEnabled(!bl);
        this.bBrowseFile.setEnabled(!bl);
        this.checkErrors();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkErrors();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkErrors();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkErrors();
    }

    private void bBrowseFileActionPerformed(ActionEvent actionEvent) {
        String string = Utils.browseFilter(this, this.tFile.getText(), NbBundle.getMessage(AddKeystorePanel.class, (String)"TITLE_SelectKeystore"), 0, new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                if (!file.isFile()) {
                    return false;
                }
                String string = file.getName();
                int n = string.lastIndexOf(46);
                if (n < 0) {
                    return false;
                }
                return ".ks".equals(string = string.substring(n).toLowerCase()) || ".keystore".equals(string) || ".p12".equals(string) || ".pkcs12".equals(string) || ".jks".equals(string);
            }

            public String getDescription() {
                return NbBundle.getMessage(AddKeystorePanel.class, (String)"LBL_KeystoreFileFilter");
            }
        });
        if (string == null) {
            return;
        }
        File file = new File(string);
        location = (file = file.getParentFile()) != null ? file.getAbsolutePath() : string;
        this.tFile.setText(string);
    }

    private void bBrowseLocationActionPerformed(ActionEvent actionEvent) {
        String string = Utils.browseFolder(this, this.tLocation.getText(), NbBundle.getMessage(AddKeystorePanel.class, (String)"TITLE_SelectKeystoresFolder"));
        if (string == null) {
            return;
        }
        location = string;
        this.tLocation.setText(location);
    }

    public static KeyStoreRepository.KeyStoreBean showAddKeystorePanel() {
        KeyStoreRepository.KeyStoreBean keyStoreBean;
        AddKeystorePanel addKeystorePanel = new AddKeystorePanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addKeystorePanel, NbBundle.getMessage(AddKeystorePanel.class, (String)"TITLE_AddKeystore"), true, null);
        addKeystorePanel.setDialogDescriptor(dialogDescriptor);
        addKeystorePanel.checkErrors();
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != NotifyDescriptor.OK_OPTION) {
            return null;
        }
        if (addKeystorePanel.rNew.isSelected()) {
            String string = addKeystorePanel.tLocation.getText() + File.separator + addKeystorePanel.tName.getText();
            if (!string.endsWith(".ks") && !string.endsWith(".keystore")) {
                string = string + ".ks";
            }
            if ((keyStoreBean = KeyStoreRepository.getDefault().getKeyStore(string, false)) == null) {
                keyStoreBean = KeyStoreRepository.KeyStoreBean.create(string, new String(addKeystorePanel.tPassword.getPassword()));
                keyStoreBean.openKeyStore(true);
                KeyStoreRepository.getDefault().addKeyStore(keyStoreBean);
            }
        } else {
            String string = addKeystorePanel.tFile.getText();
            keyStoreBean = KeyStoreRepository.getDefault().getKeyStore(string, true);
        }
        return keyStoreBean;
    }
}

