/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.security;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.netbeans.modules.mobility.project.security.KeyStoreRepository;
import org.netbeans.modules.mobility.project.ui.customizer.ErrorPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class EnterPasswordPanel
extends JPanel
implements ActionListener {
    private ErrorPanel errorPanel1;
    private JCheckBox jCheckBoxRemember;
    private JLabel jLabelMessage;
    private JLabel jLabelPassword;
    private JLabel jLabelUsername;
    private JPasswordField jPasswordField;
    private JTextField jTextFieldUsername;

    public static String getKeystorePassword(String string) {
        if (string == null) {
            return null;
        }
        return EnterPasswordPanel.getKeystorePassword(KeyStoreRepository.getDefault().getKeyStore(string, true));
    }

    public static String getAliasPassword(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        KeyStoreRepository.KeyStoreBean keyStoreBean = KeyStoreRepository.getDefault().getKeyStore(string, false);
        if (keyStoreBean == null || !keyStoreBean.isOpened()) {
            return null;
        }
        return EnterPasswordPanel.getAliasPassword(keyStoreBean, keyStoreBean.getAlias(string2));
    }

    public static String getKeyfilePassword(String string) {
        EnterPasswordPanel enterPasswordPanel = new EnterPasswordPanel(NbBundle.getMessage(EnterPasswordPanel.class, (String)"LBL_EnterKeyfilePassword", (Object)string), null, false, true, true);
        Object object = KeyStoreRepository.getDefault().getPassword(string);
        if (object instanceof String) {
            enterPasswordPanel.jPasswordField.setText((String)object);
        }
        String string2 = enterPasswordPanel.showDialog();
        if (KeyStoreRepository.rememberPasswords) {
            if (string2 != null) {
                KeyStoreRepository.getDefault().putPassword(string, string2);
            }
        } else {
            KeyStoreRepository.getDefault().removePassword(string);
        }
        return string2;
    }

    public static String[] getConnectionUsernameAndPassword(String string, String string2) {
        String[] stringArray;
        EnterPasswordPanel enterPasswordPanel = new EnterPasswordPanel(NbBundle.getMessage(EnterPasswordPanel.class, (String)"LBL_EnterConnectionPassword", (Object)string), string2 == null ? "" : string2, true, false, true);
        Object object = KeyStoreRepository.getDefault().getPassword(EnterPasswordPanel.getKey(string, string2));
        if (object instanceof String) {
            enterPasswordPanel.jPasswordField.setText((String)object);
        } else if (object instanceof String[]) {
            enterPasswordPanel.jTextFieldUsername.setText(((String[])object)[0]);
            enterPasswordPanel.jPasswordField.setText(((String[])object)[1]);
        }
        String string3 = enterPasswordPanel.showDialog();
        string2 = enterPasswordPanel.jTextFieldUsername.getText();
        if (KeyStoreRepository.rememberPasswords) {
            if (string3 != null) {
                KeyStoreRepository.getDefault().putPassword(string, new String[]{string2, string3});
                KeyStoreRepository.getDefault().putPassword(EnterPasswordPanel.getKey(string, string2), string3);
            }
        } else {
            KeyStoreRepository.getDefault().removePassword(string);
            KeyStoreRepository.getDefault().removePassword(EnterPasswordPanel.getKey(string, string2));
        }
        if (string3 == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = string2;
            stringArray = stringArray2;
            stringArray2[1] = string3;
        }
        return stringArray;
    }

    private static String getKey(String string, String string2) {
        return string2 == null || string2.length() == 0 ? string : string2 + '@' + string;
    }

    public static String getConnectionPassword(String string, String string2) {
        EnterPasswordPanel enterPasswordPanel = new EnterPasswordPanel(NbBundle.getMessage(EnterPasswordPanel.class, (String)"LBL_EnterConnectionPassword", (Object)string), string2 == null ? "" : string2, false, false, true);
        Object object = KeyStoreRepository.getDefault().getPassword(EnterPasswordPanel.getKey(string, string2));
        if (object instanceof String) {
            enterPasswordPanel.jPasswordField.setText((String)object);
        }
        String string3 = enterPasswordPanel.showDialog();
        if (KeyStoreRepository.rememberPasswords) {
            if (string3 != null) {
                KeyStoreRepository.getDefault().putPassword(EnterPasswordPanel.getKey(string, string2), string3);
            }
        } else {
            KeyStoreRepository.getDefault().removePassword(EnterPasswordPanel.getKey(string, string2));
        }
        return string3;
    }

    public static String getKeystorePassword(KeyStoreRepository.KeyStoreBean keyStoreBean) {
        String string;
        if (keyStoreBean == null) {
            return null;
        }
        if (keyStoreBean.isOpened()) {
            return keyStoreBean.getPassword();
        }
        EnterPasswordPanel enterPasswordPanel = new EnterPasswordPanel(NbBundle.getMessage(EnterPasswordPanel.class, (String)"LBL_EnterKeystorePassword", (Object)keyStoreBean.getKeyStorePath()), null, false, false, false);
        while ((string = enterPasswordPanel.showDialog()) != null) {
            keyStoreBean.setPassword(string);
            if (keyStoreBean.openKeyStore()) {
                return string;
            }
            enterPasswordPanel.setKeystoreErrorMessage();
        }
        return null;
    }

    public static String getAliasPassword(KeyStoreRepository.KeyStoreBean keyStoreBean, KeyStoreRepository.KeyStoreBean.KeyAliasBean keyAliasBean) {
        String string;
        if (keyStoreBean == null || keyAliasBean == null || !keyStoreBean.isOpened()) {
            return null;
        }
        if (keyAliasBean.isOpened()) {
            return keyAliasBean.getPassword();
        }
        EnterPasswordPanel enterPasswordPanel = new EnterPasswordPanel(NbBundle.getMessage(EnterPasswordPanel.class, (String)"LBL_EnterAliasPassword", (Object)keyStoreBean.getKeyStorePath(), (Object)keyAliasBean.getAlias()), null, false, false, false);
        while ((string = enterPasswordPanel.showDialog()) != null) {
            keyAliasBean.setPassword(string.length() == 0 ? keyStoreBean.getPassword() : string);
            if (keyAliasBean.open()) {
                return keyAliasBean.getPassword();
            }
            enterPasswordPanel.setAliasErrorMessage();
        }
        return null;
    }

    private EnterPasswordPanel(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        this.initComponents();
        this.initAccessibility();
        this.jLabelMessage.setText(string);
        if (string2 == null) {
            this.jLabelUsername.setVisible(false);
            this.jTextFieldUsername.setVisible(false);
        } else {
            this.jTextFieldUsername.setText(string2);
            if (!bl) {
                this.jTextFieldUsername.setEditable(false);
            }
        }
        if (bl2) {
            this.jLabelPassword.setText(NbBundle.getMessage(EnterPasswordPanel.class, (String)"LBL_Password_Passphrase"));
        }
        if (bl3) {
            this.jCheckBoxRemember.setSelected(KeyStoreRepository.rememberPasswords);
            this.jCheckBoxRemember.addActionListener(this);
        } else {
            this.jCheckBoxRemember.setVisible(false);
        }
    }

    private String showDialog() {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(EnterPasswordPanel.class, (String)"TITLE_EnterPassword"), true, 2, NotifyDescriptor.OK_OPTION, null);
        dialogDescriptor.setHelpCtx(new HelpCtx(EnterPasswordPanel.class));
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor))) {
            return String.valueOf(this.jPasswordField.getPassword());
        }
        return null;
    }

    private void setKeystoreErrorMessage() {
        this.errorPanel1.setErrorMessage(NbBundle.getMessage(EnterPasswordPanel.class, (String)"ERR_KeystoreError"));
    }

    private void setAliasErrorMessage() {
        this.errorPanel1.setErrorMessage(NbBundle.getMessage(EnterPasswordPanel.class, (String)"ERR_AliasError"));
    }

    private void initComponents() {
        this.jLabelMessage = new JLabel();
        this.jLabelUsername = new JLabel();
        this.jTextFieldUsername = new JTextField();
        this.jLabelPassword = new JLabel();
        this.jPasswordField = new JPasswordField();
        this.jCheckBoxRemember = new JCheckBox();
        this.errorPanel1 = new ErrorPanel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabelMessage, gridBagConstraints);
        this.jLabelUsername.setLabelFor(this.jTextFieldUsername);
        Mnemonics.setLocalizedText((JLabel)this.jLabelUsername, (String)NbBundle.getMessage(EnterPasswordPanel.class, (String)"LBL_PasswordPanel_Username"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabelUsername, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 12, 0);
        this.add((Component)this.jTextFieldUsername, gridBagConstraints);
        this.jLabelPassword.setLabelFor(this.jPasswordField);
        Mnemonics.setLocalizedText((JLabel)this.jLabelPassword, (String)NbBundle.getMessage(EnterPasswordPanel.class, (String)"LBL_Password_Password"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabelPassword, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 12, 0);
        this.add((Component)this.jPasswordField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxRemember, (String)NbBundle.getMessage(EnterPasswordPanel.class, (String)"LBL_PasswordPanel_Remember"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jCheckBoxRemember, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.errorPanel1, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EnterPasswordPanel.class, (String)"ACSN_EnterKeystorePassword"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EnterPasswordPanel.class, (String)"ACSD_EnterKeystorePassword"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        KeyStoreRepository.rememberPasswords = this.jCheckBoxRemember.isSelected();
    }
}

