/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Profile;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.openide.awt.Mnemonics;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformSelectionPanelGUI
extends JPanel
implements ActionListener {
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    private final DefaultComboBoxModel deviceModel;
    private final HashMap<String, J2MEPlatform.J2MEProfile> name2profile = new HashMap();
    private String reqCfg;
    private String reqProf;
    private TemplateWizard wiz;
    private int firstConfigWidth = -1;
    private ButtonGroup cfgGroup;
    private JComboBox jComboBoxTarget;
    private JComboBox jComboDevice;
    private JLabel jLabelConfig;
    private JLabel jLabelDevice;
    private JLabel jLabelProfile;
    private JLabel jLabelTarget;
    private JPanel jPanelConfig;
    private JPanel jPanelProfile;
    private JSeparator jSeparator1;
    private ButtonGroup profGroup;

    public PlatformSelectionPanelGUI() {
        this.initComponents();
        this.initAccessibility();
        this.deviceModel = new DefaultComboBoxModel();
        this.jComboDevice.setModel(this.deviceModel);
        JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null));
        Arrays.sort(javaPlatformArray, new Comparator<JavaPlatform>(){

            @Override
            public int compare(JavaPlatform javaPlatform, JavaPlatform javaPlatform2) {
                return javaPlatform.getDisplayName().compareTo(javaPlatform2.getDisplayName());
            }
        });
        this.jComboBoxTarget.setModel(new DefaultComboBoxModel<JavaPlatform>(javaPlatformArray));
        HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile> hashMap = new HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile>();
        HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile> hashMap2 = new HashMap<J2MEPlatform.J2MEProfile, J2MEPlatform.J2MEProfile>();
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            if (!(javaPlatformArray[i] instanceof J2MEPlatform)) continue;
            J2MEPlatform j2MEPlatform = (J2MEPlatform)javaPlatformArray[i];
            Profile[] profileArray = j2MEPlatform.getSpecification().getProfiles();
            for (int j = 0; j < profileArray.length; ++j) {
                if (!(profileArray[j] instanceof J2MEPlatform.J2MEProfile)) continue;
                J2MEPlatform.J2MEProfile j2MEProfile = (J2MEPlatform.J2MEProfile)profileArray[j];
                if ("configuration".equals(j2MEProfile.getType())) {
                    j2MEProfile = this.takeBetter(j2MEProfile, (J2MEPlatform.J2MEProfile)hashMap.remove(j2MEProfile));
                    hashMap.put(j2MEProfile, j2MEProfile);
                    continue;
                }
                if (!"profile".equals(j2MEProfile.getType())) continue;
                j2MEProfile = this.takeBetter(j2MEProfile, (J2MEPlatform.J2MEProfile)hashMap2.remove(j2MEProfile));
                hashMap2.put(j2MEProfile, j2MEProfile);
            }
        }
        J2MEPlatform.J2MEProfile[] j2MEProfileArray = hashMap.values().toArray(new J2MEPlatform.J2MEProfile[hashMap.size()]);
        this.initAllConfigurations(j2MEProfileArray);
        j2MEProfileArray = hashMap2.values().toArray(new J2MEPlatform.J2MEProfile[hashMap2.size()]);
        this.initAllProfiles(j2MEProfileArray);
        this.jComboBoxTarget.addActionListener(this);
        this.jComboDevice.addActionListener(this);
    }

    private J2MEPlatform.J2MEProfile takeBetter(J2MEPlatform.J2MEProfile j2MEProfile, J2MEPlatform.J2MEProfile j2MEProfile2) {
        if (j2MEProfile == null) {
            return j2MEProfile2;
        }
        if (j2MEProfile2 == null) {
            return j2MEProfile;
        }
        return j2MEProfile.getDisplayNameWithVersion().length() > j2MEProfile2.getDisplayNameWithVersion().length() ? j2MEProfile : j2MEProfile2;
    }

    private void initAllConfigurations(J2MEPlatform.J2MEProfile[] j2MEProfileArray) {
        Arrays.sort(j2MEProfileArray);
        for (int i = 0; i < j2MEProfileArray.length; ++i) {
            JRadioButton jRadioButton = new JRadioButton(j2MEProfileArray[i].toString());
            jRadioButton.setToolTipText(j2MEProfileArray[i].getDisplayNameWithVersion());
            jRadioButton.setActionCommand(j2MEProfileArray[i].toString());
            this.cfgGroup.add(jRadioButton);
            this.jPanelConfig.add(jRadioButton);
            Dimension dimension = jRadioButton.getPreferredSize();
            if (this.firstConfigWidth == -1) {
                this.firstConfigWidth = dimension.width + 30;
                jRadioButton.setPreferredSize(new Dimension(this.firstConfigWidth, dimension.height));
            } else {
                jRadioButton.setPreferredSize(new Dimension(this.firstConfigWidth, dimension.height));
            }
            jRadioButton.addActionListener(this);
        }
    }

    private void initAllProfiles(J2MEPlatform.J2MEProfile[] j2MEProfileArray) {
        Arrays.sort(j2MEProfileArray);
        for (int i = 0; i < j2MEProfileArray.length; ++i) {
            JRadioButton jRadioButton = new JRadioButton(j2MEProfileArray[i].toString());
            jRadioButton.setToolTipText(j2MEProfileArray[i].getDisplayNameWithVersion());
            jRadioButton.setActionCommand(j2MEProfileArray[i].toString());
            this.profGroup.add(jRadioButton);
            jRadioButton.setPreferredSize(new Dimension(this.firstConfigWidth, jRadioButton.getPreferredSize().height));
            this.jPanelProfile.add(jRadioButton);
            jRadioButton.addActionListener(this);
        }
    }

    public synchronized void setValues(TemplateWizard templateWizard, J2MEPlatform j2MEPlatform, J2MEPlatform.Device device, String string, String string2) {
        this.wiz = templateWizard;
        this.reqCfg = string;
        this.reqProf = string2;
        this.jComboBoxTarget.setSelectedItem(j2MEPlatform);
        this.updateDevices(device, string, string2);
    }

    private synchronized void updateDevices(J2MEPlatform.Device device, String string, String string2) {
        J2MEPlatform.Device[] deviceArray;
        String string3;
        J2MEPlatform j2MEPlatform = this.getPlatform();
        String string4 = string3 = device == null ? null : device.getName();
        if (string3 == null && (deviceArray = this.getDevice()) != null) {
            string3 = deviceArray.getName();
        }
        this.deviceModel.setSelectedItem(null);
        this.deviceModel.removeAllElements();
        if (j2MEPlatform != null) {
            deviceArray = j2MEPlatform.getDevices();
            for (int i = 0; i < deviceArray.length; ++i) {
                this.deviceModel.addElement(deviceArray[i]);
                if (!deviceArray[i].getName().equals(string3)) continue;
                this.deviceModel.setSelectedItem(deviceArray[i]);
            }
            if (this.deviceModel.getSelectedItem() == null && deviceArray.length > 0) {
                this.deviceModel.setSelectedItem(deviceArray[0]);
            }
        }
        this.updateConfigsAndProfiles(string, string2);
    }

    private synchronized void updateConfigsAndProfiles(String string, String string2) {
        J2MEPlatform.Device device = this.getDevice();
        String string3 = null;
        String string4 = null;
        this.name2profile.clear();
        if (device != null) {
            J2MEPlatform.J2MEProfile[] j2MEProfileArray = device.getProfiles();
            for (int i = 0; i < j2MEProfileArray.length; ++i) {
                this.name2profile.put(j2MEProfileArray[i].toString(), j2MEProfileArray[i]);
                if (!j2MEProfileArray[i].isDefault()) continue;
                if ("configuration".equals(j2MEProfileArray[i].getType())) {
                    string3 = j2MEProfileArray[i].toString();
                    continue;
                }
                if (!"profile".equals(j2MEProfileArray[i].getType())) continue;
                string4 = j2MEProfileArray[i].toString();
            }
        }
        this.updateGroup(this.cfgGroup, string, this.name2profile.keySet(), string3);
        this.updateGroup(this.profGroup, string2, this.name2profile.keySet(), string4);
        this.updateErrorMessage();
    }

    private void updateGroup(ButtonGroup buttonGroup, String string, Set<String> set, String string2) {
        ItemSelectable itemSelectable;
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        ItemSelectable itemSelectable2 = null;
        while (enumeration.hasMoreElements()) {
            itemSelectable = (JRadioButton)enumeration.nextElement();
            String string3 = ((AbstractButton)itemSelectable).getActionCommand();
            ((AbstractButton)itemSelectable).setEnabled(set.contains(string3));
            if (string != null && string.equals(string3)) {
                buttonGroup.setSelected(((AbstractButton)itemSelectable).getModel(), true);
            }
            if (string2 == null || !string2.equals(string3)) continue;
            itemSelectable2 = itemSelectable;
        }
        itemSelectable = buttonGroup.getSelection();
        if (!(itemSelectable != null && itemSelectable.isEnabled() || itemSelectable2 == null)) {
            buttonGroup.setSelected(itemSelectable2.getModel(), true);
        }
    }

    public void updateErrorMessage() {
        boolean bl;
        boolean bl2 = this.reqCfg != null && !this.name2profile.containsKey(this.reqCfg);
        boolean bl3 = bl = this.reqProf != null && !this.name2profile.containsKey(this.reqProf);
        if (this.wiz != null) {
            String string = null;
            if (bl2 && bl) {
                string = NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"ERR_PlatformSelection_Platform_does_not_support_2", (Object)this.reqCfg, (Object)this.reqProf);
            } else if (bl2) {
                string = NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"ERR_PlatformSelection_Platform_does_not_support_1", (Object)this.reqCfg);
            } else if (bl) {
                string = NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"ERR_PlatformSelection_Platform_does_not_support_1", (Object)this.reqProf);
            }
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)string);
        }
    }

    public J2MEPlatform getPlatform() {
        return (J2MEPlatform)this.jComboBoxTarget.getSelectedItem();
    }

    public J2MEPlatform.Device getDevice() {
        return (J2MEPlatform.Device)this.deviceModel.getSelectedItem();
    }

    public J2MEPlatform.J2MEProfile getConfiguration() {
        ButtonModel buttonModel = this.cfgGroup.getSelection();
        return buttonModel == null ? null : this.name2profile.get(buttonModel.getActionCommand());
    }

    public J2MEPlatform.J2MEProfile getProfile() {
        ButtonModel buttonModel = this.profGroup.getSelection();
        return buttonModel == null ? null : this.name2profile.get(buttonModel.getActionCommand());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.jComboBoxTarget.equals(actionEvent.getSource())) {
            this.updateDevices(null, null, null);
        } else if (this.jComboDevice.equals(actionEvent.getSource())) {
            this.updateConfigsAndProfiles(null, null);
        }
    }

    private void initComponents() {
        this.cfgGroup = new ButtonGroup();
        this.profGroup = new ButtonGroup();
        this.jLabelTarget = new JLabel();
        this.jComboBoxTarget = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jLabelDevice = new JLabel();
        this.jComboDevice = new JComboBox();
        this.jLabelConfig = new JLabel();
        this.jPanelConfig = new JPanel();
        this.jLabelProfile = new JLabel();
        this.jPanelProfile = new JPanel();
        this.setName(NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"TITLE_PlatformSelection"));
        this.setLayout(new GridBagLayout());
        this.jLabelTarget.setLabelFor(this.jComboBoxTarget);
        Mnemonics.setLocalizedText((JLabel)this.jLabelTarget, (String)NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"LBL_PlatformSelection_TargetPlatform"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jLabelTarget, gridBagConstraints);
        this.jLabelTarget.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"ACSD_PlatSel_Platform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.jComboBoxTarget, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabelDevice.setLabelFor(this.jComboDevice);
        Mnemonics.setLocalizedText((JLabel)this.jLabelDevice, (String)NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"LBL_PlatformSelection_Device"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabelDevice, gridBagConstraints);
        this.jLabelDevice.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"ACSD_PlatSel_Device"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 0, 0);
        this.add((Component)this.jComboDevice, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabelConfig, (String)NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"LBL_PlatformSelection_DeviceConfiguration"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabelConfig, gridBagConstraints);
        this.jPanelConfig.setLayout(new GridLayout(1, 0, 5, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 0, 0);
        this.add((Component)this.jPanelConfig, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabelProfile, (String)NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"LBL_PlatformSelection_DeviceProfile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.add((Component)this.jLabelProfile, gridBagConstraints);
        this.jPanelProfile.setLayout(new GridLayout(1, 0, 5, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 12, 0);
        this.add((Component)this.jPanelProfile, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"ACSN_PlatformSelection"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PlatformSelectionPanelGUI.class, (String)"ACSD_PlatformSelection"));
    }

    @Override
    public Dimension getPreferredSize() {
        return PREF_DIM;
    }
}

