/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard.imports;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.mobility.project.J2MEProjectGenerator;
import org.netbeans.modules.mobility.project.ui.wizard.Utils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SourcesPanel
extends JPanel
implements DocumentListener {
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    public static final String SOURCES_LOCATION = "SourcesLocation";
    public static final String JAD_LOCATION = "JadLocation";
    private static final String JAD = "jad";
    private boolean updateJad;
    private JButton bBrowse;
    private JButton bBrowseJad;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel2;
    private JTextField tJad;
    private JTextField tLocation;

    public SourcesPanel() {
        this.initComponents();
        this.initAccessibility();
        this.updateJad = true;
        this.tJad.getDocument().addDocumentListener(this);
    }

    public synchronized void addListener(DocumentListener documentListener) {
        this.tLocation.getDocument().addDocumentListener(documentListener);
        this.tJad.getDocument().addDocumentListener(documentListener);
    }

    public synchronized void removeListener(DocumentListener documentListener) {
        this.tLocation.getDocument().removeDocumentListener(documentListener);
        this.tJad.getDocument().removeDocumentListener(documentListener);
    }

    public synchronized void readData(TemplateWizard templateWizard) {
        Object object = templateWizard.getProperty(SOURCES_LOCATION);
        if (object != null) {
            this.tLocation.setText((String)object);
        } else {
            FileObject fileObject = Templates.getExistingSourcesFolder((WizardDescriptor)templateWizard);
            File file = fileObject == null ? null : FileUtil.toFile((FileObject)fileObject);
            this.tLocation.setText(file == null ? "" : file.getAbsolutePath());
        }
        object = templateWizard.getProperty(JAD_LOCATION);
        boolean bl = this.updateJad;
        this.tJad.setText(object != null ? (String)object : "");
        this.updateJad = bl;
    }

    public synchronized void storeData(TemplateWizard templateWizard) {
        String string = this.tLocation.getText();
        templateWizard.putProperty(SOURCES_LOCATION, (Object)string);
        templateWizard.putProperty(JAD_LOCATION, (Object)this.tJad.getText());
        String string2 = new File(string).getName();
        templateWizard.putProperty("ProjectName", (Object)("Imported Project" + (string2 != null ? " - " + string2 + '1' : "1")));
        String string3 = null;
        String string4 = null;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            File file = new File(this.tJad.getText());
            J2MEProjectGenerator.loadJadManifest(hashMap, file);
            string3 = (String)hashMap.get("MicroEdition-Configuration");
            string4 = (String)hashMap.get("MicroEdition-Profile");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        templateWizard.putProperty("RequiredConfiguration", string3);
        templateWizard.putProperty("RequiredProfile", string4);
    }

    public String getLocationText() {
        return this.tLocation.getText();
    }

    public String getJadLocation() {
        return this.tJad.getText();
    }

    public synchronized void setJadLocation(String string) {
        boolean bl = this.updateJad;
        this.tJad.setText(string);
        this.updateJad = bl;
    }

    public boolean hasUpdateJad() {
        return this.updateJad;
    }

    public synchronized void changedUpdate(DocumentEvent documentEvent) {
        this.updateJad = false;
    }

    public synchronized void insertUpdate(DocumentEvent documentEvent) {
        this.updateJad = false;
    }

    public synchronized void removeUpdate(DocumentEvent documentEvent) {
        this.updateJad = false;
    }

    protected boolean isJadDocumentEvent(DocumentEvent documentEvent) {
        return documentEvent.getDocument() == this.tJad.getDocument();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.tLocation = new JTextField();
        this.bBrowse = new JButton();
        this.jLabel3 = new JLabel();
        this.tJad = new JTextField();
        this.bBrowseJad = new JButton();
        this.jPanel2 = new JPanel();
        this.setName(NbBundle.getMessage(SourcesPanel.class, (String)"TITLE_Sources"));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SourcesPanel.class, (String)"LBL_Sources_Info"));
        this.jLabel1.setVerticalAlignment(1);
        this.jLabel1.setPreferredSize(new Dimension(400, 54));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setLabelFor(this.tLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SourcesPanel.class, (String)"LBL_Sources_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 6);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.add((Component)this.tLocation, gridBagConstraints);
        this.tLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcesPanel.class, (String)"ACSD_Sources_Location"));
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowse, (String)NbBundle.getMessage(SourcesPanel.class, (String)"LBL_Sources_Browse"));
        this.bBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourcesPanel.this.bBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 0);
        this.add((Component)this.bBrowse, gridBagConstraints);
        this.bBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcesPanel.class, (String)"ACSD_Sources_Browse1"));
        this.jLabel3.setLabelFor(this.tJad);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SourcesPanel.class, (String)"LBL_Sources_Jad"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 6);
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.add((Component)this.tJad, gridBagConstraints);
        this.tJad.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcesPanel.class, (String)"ACSD_Sources_JAD"));
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowseJad, (String)NbBundle.getMessage(SourcesPanel.class, (String)"LBL_Sources_BrowseJad"));
        this.bBrowseJad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourcesPanel.this.bBrowseJadActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 5, 0);
        this.add((Component)this.bBrowseJad, gridBagConstraints);
        this.bBrowseJad.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcesPanel.class, (String)"ACSD_Sources_Browse2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourcesPanel.class, (String)"ACSN_Sources"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcesPanel.class, (String)"ACSD_Sources"));
    }

    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    private void bBrowseJadActionPerformed(ActionEvent actionEvent) {
        String string;
        String string2 = this.tJad.getText();
        if (string2 == null || "".equals(string2)) {
            string2 = this.tLocation.getText();
        }
        if (string2 == null || "".equals(string2)) {
            string2 = System.getProperty("user.home", "");
        }
        if ((string = Utils.browseFilter(this, string2, NbBundle.getMessage(SourcesPanel.class, (String)"TITLE_Sources_JadManifestLocation"), 0, new FileFilter(){

            public boolean accept(File file) {
                if (!file.exists() || !file.canRead()) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                if (!file.isFile()) {
                    return false;
                }
                String string = file.getName();
                int n = string.lastIndexOf(46);
                if (n >= 0) {
                    string = string.substring(n + 1);
                }
                return SourcesPanel.JAD.equals(string = string.toLowerCase()) || "mf".equals(string);
            }

            public String getDescription() {
                return NbBundle.getMessage(SourcesPanel.class, (String)"LBL_Sources_JadManifestFilter");
            }
        })) != null) {
            this.tJad.setText(string);
        }
    }

    private void bBrowseActionPerformed(ActionEvent actionEvent) {
        String string;
        String string2 = this.tLocation.getText();
        if (string2 == null || "".equals(string2)) {
            string2 = System.getProperty("user.home", "");
        }
        if ((string = Utils.browseFolder(this, string2, NbBundle.getMessage(SourcesPanel.class, (String)"TITLE_Sources_Location"))) != null) {
            this.tLocation.setText(string);
        }
    }

    static class WizardPanel
    implements WizardDescriptor.FinishablePanel,
    DocumentListener {
        SourcesPanel component;
        TemplateWizard wizard;
        Collection<ChangeListener> listeners = new ArrayList<ChangeListener>();
        boolean valid = false;

        WizardPanel() {
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        public Component getComponent() {
            if (this.component == null) {
                this.component = new SourcesPanel();
                this.component.addListener(this);
                this.checkValid(true);
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(SourcesPanel.class);
        }

        public boolean isFinishPanel() {
            return false;
        }

        public void showError(String string) {
            if (this.wizard != null) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)string);
            }
        }

        public boolean isValid() {
            return this.isValid(false);
        }

        public boolean isValid(boolean bl) {
            Project project;
            String string;
            boolean bl2;
            File file = FileUtil.normalizeFile((File)new File(this.component.getLocationText()).getAbsoluteFile());
            boolean bl3 = bl2 = this.component.getLocationText().length() > 0 && file != null && file.exists() && file.isDirectory();
            if (!bl2) {
                this.showError(NbBundle.getMessage(SourcesPanel.class, (String)"ERR_Sources_InvalidLocation"));
                return false;
            }
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (bl && this.component.hasUpdateJad()) {
                file = this.findJadManifest(file);
                this.component.removeListener(this);
                this.component.setJadLocation(file != null ? file.getAbsolutePath() : "");
                this.component.addListener(this);
            }
            if (!"".equals(string = this.component.getJadLocation())) {
                file = new File(string);
                boolean bl4 = bl2 = file.exists() && file.isFile() && file.canRead();
                if (!bl2) {
                    this.showError(NbBundle.getMessage(SourcesPanel.class, (String)(this.component.hasUpdateJad() ? "ERR_Sources_InvalidAutoJadLocation" : "ERR_Sources_InvalidJadLocation")));
                    return false;
                }
            }
            Project project2 = project = fileObject == null ? null : FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project != null && Arrays.asList(OpenProjects.getDefault().getOpenProjects()).contains(project)) {
                ProjectInformation projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
                String string2 = projectInformation == null ? project.getProjectDirectory().getPath() : projectInformation.getDisplayName();
                this.showError(NbBundle.getMessage(SourcesPanel.class, (String)"WARN_Sources_Clashing", (Object)string2));
            } else {
                this.showError(null);
            }
            return true;
        }

        private File findJadManifest(File file) {
            Object object;
            File[] fileArray = file.listFiles();
            File file2 = Utils.findSubFile(fileArray, file.getName() + ".jad");
            if (file2 != null) {
                return file2;
            }
            file2 = Utils.findAnyFile(fileArray, SourcesPanel.JAD);
            if (file2 != null) {
                return file2;
            }
            file2 = Utils.findSubFile(fileArray, "manifest.mf");
            if (file2 != null) {
                return file2;
            }
            File file3 = Utils.findSubFile(fileArray, "META-INF");
            if (file3 != null && file3.isDirectory()) {
                object = file3.listFiles();
                file2 = Utils.findSubFile((File[])object, "manifest.mf");
                if (file2 != null) {
                    return file2;
                }
                file2 = Utils.findAnyFile((File[])object, "mf");
                if (file2 != null) {
                    return file2;
                }
                file2 = Utils.findSubFile((File[])object, SourcesPanel.JAD);
                if (file2 != null) {
                    return file2;
                }
            }
            if ((file2 = Utils.findAnyFile(fileArray, "mf")) != null) {
                return file2;
            }
            object = file.getParentFile();
            if (object != null) {
                File[] fileArray2 = ((File)object).listFiles();
                file2 = Utils.findSubFile(fileArray2, file.getName() + ".jad");
                if (file2 != null) {
                    return file2;
                }
                file2 = Utils.findAnyFile(fileArray2, SourcesPanel.JAD);
                if (file2 != null) {
                    return file2;
                }
                file2 = Utils.findSubFile(fileArray2, "manifest.mf");
                if (file2 != null) {
                    return file2;
                }
                file2 = Utils.findAnyFile(fileArray2, "mf");
                if (file2 != null) {
                    return file2;
                }
            }
            return null;
        }

        public void readSettings(Object object) {
            this.wizard = (TemplateWizard)object;
            ((SourcesPanel)this.getComponent()).readData(this.wizard);
            Component component = this.getComponent();
            Object object2 = ((JComponent)component).getClientProperty("NewProjectWizard_Title");
            if (object2 != null) {
                this.wizard.putProperty("NewProjectWizard_Title", object2);
            }
        }

        public void storeSettings(Object object) {
            this.wizard = (TemplateWizard)object;
            ((SourcesPanel)this.getComponent()).storeData(this.wizard);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireStateChange() {
            ChangeListener[] changeListenerArray;
            Object object = this;
            synchronized (object) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            object = new ChangeEvent(this);
            for (int i = 0; i < changeListenerArray.length; ++i) {
                changeListenerArray[i].stateChanged((ChangeEvent)object);
            }
        }

        void checkValid(boolean bl) {
            if (this.isValid(bl) != this.valid) {
                this.valid ^= true;
                this.fireStateChange();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.checkValid(!this.component.isJadDocumentEvent(documentEvent));
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.checkValid(!this.component.isJadDocumentEvent(documentEvent));
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.checkValid(!this.component.isJadDocumentEvent(documentEvent));
        }
    }
}

