/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.mobility.project.support;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.mobility.antext.preprocessor.CommentingPreProcessor;
import org.netbeans.modules.mobility.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.VisualClassPathItem;
import org.netbeans.spi.mobility.deployment.DeploymentPlugin;
import org.netbeans.spi.mobility.project.PropertyParser;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DefaultPropertyParsers {
    public static final PropertyParser STRING_PARSER = new StringParser();
    public static final PropertyParser BOOLEAN_PARSER = new BooleanParser();
    public static final PropertyParser INVERSE_BOOLEAN_PARSER = new InverseBooleanParser();
    public static final PropertyParser PATH_PARSER = new PathParser();
    public static final PropertyParser PLATFORM_PARSER = new PlatformParser();
    public static final PropertyParser INTEGER_PARSER = new IntegerParser();
    public static final PropertyParser MANIFEST_PROPERTY_PARSER = new ManifestPropertyParser();
    public static final PropertyParser FILE_REFERENCE_PARSER = new FileReferenceParser();
    public static final PropertyParser ABILITIES_PARSER = new AbilitiesParser();
    public static final PropertyParser DEPLOYMENT_TYPE_PARSER = new DeploymentTypeParser();
    public static final PropertyParser DEBUG_LEVEL_PARSER = new DebugLevelParser();

    private static class AbilitiesParser
    implements PropertyParser {
        private AbilitiesParser() {
        }

        public Object decode(String string, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            return CommentingPreProcessor.decodeAbilitiesMap((String)string);
        }

        public String encode(Object object, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            return CommentingPreProcessor.encodeAbilitiesMap((Map)((Map)object));
        }
    }

    private static class ManifestPropertyParser
    implements PropertyParser {
        private ManifestPropertyParser() {
        }

        public Object decode(String string, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            try {
                String string2;
                if (string == null) {
                    return null;
                }
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
                HashMap<String, String> hashMap = new HashMap<String, String>();
                while ((string2 = bufferedReader.readLine()) != null) {
                    int n = string2.indexOf(58);
                    if (n < 0) continue;
                    hashMap.put(string2.substring(0, n), string2.substring(n + 1).trim());
                }
                return hashMap;
            }
            catch (IOException iOException) {
                assert (false) : iOException;
                return null;
            }
        }

        public String encode(Object object, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            HashMap hashMap = (HashMap)object;
            if (hashMap == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : hashMap.keySet()) {
                String string2;
                if (string == null || (string2 = (String)hashMap.get(string)) == null) continue;
                stringBuffer.append(string).append(": ").append(string2).append('\n');
            }
            return stringBuffer.toString();
        }
    }

    private static class DeploymentTypeParser
    implements PropertyParser {
        private DeploymentTypeParser() {
        }

        public Object decode(String string, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            for (DeploymentPlugin deploymentPlugin : Lookup.getDefault().lookup(new Lookup.Template(DeploymentPlugin.class)).allInstances()) {
                if (!deploymentPlugin.getDeploymentMethodName().equals(string)) continue;
                return deploymentPlugin.getDeploymentMethodDisplayName();
            }
            return "";
        }

        public String encode(Object object, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            for (DeploymentPlugin deploymentPlugin : Lookup.getDefault().lookup(new Lookup.Template(DeploymentPlugin.class)).allInstances()) {
                if (!deploymentPlugin.getDeploymentMethodDisplayName().equals(object)) continue;
                return deploymentPlugin.getDeploymentMethodName();
            }
            return null;
        }
    }

    private static class PlatformParser
    implements PropertyParser {
        private PlatformParser() {
        }

        public Object decode(String string, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms();
            for (int i = 0; i < javaPlatformArray.length; ++i) {
                String string2 = (String)javaPlatformArray[i].getProperties().get("platform.ant.name");
                if (string2 == null || !string2.equals(string)) continue;
                return javaPlatformArray[i].getDisplayName();
            }
            return JavaPlatformManager.getDefault().getDefaultPlatform().getDisplayName();
        }

        public String encode(Object object, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms((String)object, null);
            if (javaPlatformArray.length == 0) {
                return null;
            }
            return (String)javaPlatformArray[0].getProperties().get("platform.ant.name");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathParser
    implements PropertyParser {
        private static final String LIBRARY_PREFIX = "${libs.";
        private static final String ARTIFACT_PREFIX = "${reference.";
        private static final String[][] WELL_KNOWN_PATHS = new String[][]{{"libs.classpath", NbBundle.getMessage(J2MEProjectProperties.class, (String)"LBL_JavacClasspath_DisplayName")}};

        private PathParser() {
        }

        @Override
        public List<VisualClassPathItem> decode(String string, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            String[] stringArray = PropertyUtils.tokenizePath((String)string);
            ArrayList<VisualClassPathItem> arrayList = new ArrayList<VisualClassPathItem>(stringArray.length);
            for (String string2 : stringArray) {
                String string3;
                Object object;
                VisualClassPathItem visualClassPathItem = null;
                int n = -1;
                for (int i = 0; i < WELL_KNOWN_PATHS.length; ++i) {
                    if (!WELL_KNOWN_PATHS[i][0].equals(PathParser.getAntPropertyName(string2))) continue;
                    n = i;
                    break;
                }
                if (n != -1) {
                    visualClassPathItem = new VisualClassPathItem(string2, 3, string2, WELL_KNOWN_PATHS[n][1]);
                } else if (string2.startsWith(LIBRARY_PREFIX)) {
                    String string4 = string2.substring(LIBRARY_PREFIX.length(), string2.lastIndexOf(46));
                    object = LibraryManager.getDefault().getLibrary(string4);
                    string3 = object != null ? object.getDisplayName() : string4;
                    visualClassPathItem = new VisualClassPathItem(object, 1, string2, string3);
                } else if (string2.startsWith(ARTIFACT_PREFIX)) {
                    Object[] objectArray = referenceHelper.findArtifactAndLocation(string2);
                    object = null;
                    if (objectArray[0] != null && objectArray[1] != null && (string3 = antProjectHelper.getStandardPropertyEvaluator().getProperty(PathParser.getAntPropertyName(string2))) != null) {
                        object = FileUtil.normalizeFile((File)antProjectHelper.resolveFile(string3));
                    }
                    visualClassPathItem = new VisualClassPathItem((AntArtifact)objectArray[0], (URI)objectArray[1], 2, string2, object != null ? ((File)object).getPath() : string2.substring(ARTIFACT_PREFIX.length(), string2.lastIndexOf(46)));
                } else {
                    String string5 = antProjectHelper.getStandardPropertyEvaluator().getProperty(PathParser.getAntPropertyName(string2));
                    object = null;
                    if (string5 != null) {
                        object = FileUtil.normalizeFile((File)antProjectHelper.resolveFile(string5));
                    }
                    string3 = object != null ? ((File)object).getName() : PathParser.getAntPropertyName(string2);
                    String string6 = object != null ? ((File)object).getPath() : string3;
                    visualClassPathItem = new VisualClassPathItem(object, this.isJar(string3) ? 0 : 4, string2, string6);
                }
                arrayList.add(visualClassPathItem);
            }
            return arrayList;
        }

        private boolean isJar(String string) {
            if (string == null) {
                return false;
            }
            return (string = string.toLowerCase()).endsWith(".jar") || string.endsWith(".zip");
        }

        @Override
        public String encode(Object object, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            Iterator iterator = ((List)object).iterator();
            StringBuffer stringBuffer = new StringBuffer();
            while (iterator.hasNext()) {
                VisualClassPathItem visualClassPathItem = (VisualClassPathItem)iterator.next();
                if (visualClassPathItem.getElement() == null) {
                    if (visualClassPathItem.getRawText() == null) continue;
                    stringBuffer.append(visualClassPathItem.getRawText());
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(File.pathSeparatorChar);
                    continue;
                }
                switch (visualClassPathItem.getType()) {
                    case 0: 
                    case 4: {
                        File file = (File)visualClassPathItem.getElement();
                        String string = referenceHelper.createForeignFileReference(file, "jar");
                        stringBuffer.append(string);
                        break;
                    }
                    case 1: {
                        stringBuffer.append(visualClassPathItem.getRawText());
                        break;
                    }
                    case 2: {
                        AntArtifact antArtifact = (AntArtifact)visualClassPathItem.getElement();
                        URI uRI = visualClassPathItem.getURI();
                        String string = referenceHelper.addReference(antArtifact, uRI);
                        stringBuffer.append(string);
                        break;
                    }
                    case 3: {
                        stringBuffer.append((String)visualClassPathItem.getElement());
                    }
                }
                if (!iterator.hasNext()) continue;
                stringBuffer.append(File.pathSeparatorChar);
            }
            return stringBuffer.toString();
        }

        static String getAntPropertyName(String string) {
            if (string != null && string.startsWith("${") && string.endsWith("}")) {
                return string.substring(2, string.length() - 1);
            }
            return string;
        }
    }

    private static class InverseBooleanParser
    extends BooleanParser {
        private InverseBooleanParser() {
        }

        public Object decode(String string, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            return (Boolean)super.decode(string, antProjectHelper, referenceHelper) != false ? Boolean.FALSE : Boolean.TRUE;
        }

        public String encode(Object object, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            return super.encode((Boolean)object != false ? Boolean.FALSE : Boolean.TRUE, antProjectHelper, referenceHelper);
        }
    }

    private static class IntegerParser
    implements PropertyParser {
        private IntegerParser() {
        }

        public Object decode(String string, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            return Integer.decode(string);
        }

        public String encode(Object object, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            return object.toString();
        }
    }

    private static class BooleanParser
    implements PropertyParser {
        private BooleanParser() {
        }

        public Object decode(String string, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            String string2;
            if (string != null && ("true".equals(string2 = string.toLowerCase()) || "yes".equals(string2) || "enabled".equals(string2))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public String encode(Object object, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            return (Boolean)object != false ? "true" : "false";
        }
    }

    private static class FileReferenceParser
    implements PropertyParser {
        private FileReferenceParser() {
        }

        public Object decode(String string, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            if (string == null || !string.startsWith("${") || !string.endsWith("}")) {
                return string;
            }
            String string2 = string.substring(2, string.length() - 1);
            String string3 = antProjectHelper.getProperties("nbproject/project.properties").getProperty(string2);
            if (string3 == null) {
                string3 = antProjectHelper.getProperties("nbproject/private/private.properties").getProperty(string2);
            }
            if (string3 == null) {
                return string;
            }
            File file = new File(string3);
            return FileUtil.normalizeFile((File)(file.isAbsolute() ? file : new File(FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory()), string3))).getAbsolutePath();
        }

        public String encode(Object object, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            File file = new File((String)object);
            return referenceHelper.createForeignFileReference(FileUtil.normalizeFile((File)(file.isAbsolute() ? file : new File(FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory()), (String)object))), "anyfile");
        }
    }

    private static class DebugLevelParser
    implements PropertyParser {
        private DebugLevelParser() {
        }

        public Object decode(String string, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            return string == null || string.trim().length() == 0 ? "debug" : string.trim();
        }

        public String encode(Object object, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            String string = ((String)object).trim();
            return string.length() == 0 ? "debug" : string;
        }
    }

    private static class StringParser
    implements PropertyParser {
        private StringParser() {
        }

        public Object decode(String string, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            return string;
        }

        public String encode(Object object, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
            return object.toString();
        }
    }
}

