/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.composer.ScreenManager;
import org.netbeans.modules.mobility.svgcore.composer.actions.HighlightAction;
import org.netbeans.modules.mobility.svgcore.view.svg.AbstractSVGToggleAction;

public final class HighlightActionFactory
extends AbstractComposerActionFactory {
    private final ExtendedAction m_highlightAction = new ExtendedAction("svg_toggle_highlight"){

        protected boolean isSelectedImpl() {
            return HighlightActionFactory.this.getScreenManager().getHighlightObject();
        }

        protected boolean setIsSelectedImpl(boolean bl) {
            return HighlightActionFactory.this.getScreenManager().setHighlightObject(bl);
        }
    };
    private final ExtendedAction m_tooltipAction = new ExtendedAction("svg_toggle_tooltip"){

        protected boolean isSelectedImpl() {
            return HighlightActionFactory.this.getScreenManager().getShowTooltip();
        }

        protected boolean setIsSelectedImpl(boolean bl) {
            return HighlightActionFactory.this.getScreenManager().setShowTooltip(bl);
        }
    };

    public HighlightActionFactory(SceneManager sceneManager) {
        super(sceneManager);
    }

    public synchronized ComposerAction startAction(AWTEvent aWTEvent, boolean bl) {
        if (!bl && aWTEvent.getID() == 503 && !this.m_sceneMgr.containsAction(HighlightAction.class)) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            SVGObject[] sVGObjectArray = this.m_sceneMgr.getPerseusController().getObjectsAt(mouseEvent.getX(), mouseEvent.getY());
            if (sVGObjectArray != null && sVGObjectArray.length > 0 && sVGObjectArray[0] != null) {
                return new HighlightAction(this, sVGObjectArray[0]);
            }
        }
        if (aWTEvent.getID() == 2533) {
            this.m_highlightAction.animStarted();
            this.m_tooltipAction.animStarted();
        } else if (aWTEvent.getID() == 2534) {
            this.m_highlightAction.animStopped();
            this.m_tooltipAction.animStopped();
        } else if (aWTEvent.getID() == 2535) {
            this.m_highlightAction.refresh();
            this.m_tooltipAction.refresh();
        }
        return null;
    }

    public Action[] getMenuActions() {
        return new Action[]{this.m_highlightAction, this.m_tooltipAction};
    }

    private ScreenManager getScreenManager() {
        return this.getSceneManager().getScreenManager();
    }

    private abstract class ExtendedAction
    extends AbstractSVGToggleAction {
        private boolean m_state;

        protected ExtendedAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setIsSelectedImpl(!this.isSelectedImpl());
            this.refresh();
        }

        public void animStarted() {
            this.m_state = this.setIsSelectedImpl(false);
            this.setEnabled(false);
        }

        public void animStopped() {
            this.setIsSelectedImpl(this.m_state);
            this.setEnabled(true);
        }

        public void refresh() {
            this.setIsSelected(this.isSelectedImpl());
        }

        protected abstract boolean isSelectedImpl();

        protected abstract boolean setIsSelectedImpl(boolean var1);
    }
}

