/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.netbeans.modules.mobility.svgcore.composer.ActionMouseCursor;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.ComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.composer.actions.ScaleActionFactory;

public final class ScaleYActionFactory
extends ScaleActionFactory {
    private static final ActionMouseCursor SCALE_N_MOUSE_CURSOR = new ActionMouseCursor(8, 2);
    private static final ActionMouseCursor SCALE_S_MOUSE_CURSOR = new ActionMouseCursor(9, 2);

    public ScaleYActionFactory(SceneManager sceneManager) {
        super(sceneManager);
    }

    public synchronized ComposerAction startAction(AWTEvent aWTEvent, boolean bl) {
        MouseEvent mouseEvent;
        SVGObject sVGObject;
        if (!bl && !this.m_sceneMgr.isReadOnly() && aWTEvent.getID() == 501 && (sVGObject = this.getObjectToScaleAt(mouseEvent = (MouseEvent)aWTEvent)) != null) {
            return new ScaleYAction(this, sVGObject, mouseEvent);
        }
        return null;
    }

    public ActionMouseCursor getMouseCursor(MouseEvent mouseEvent, boolean bl) {
        SVGObject sVGObject = this.getSelectedObject();
        if (!bl && sVGObject != null) {
            if (this.isNScalePoint(sVGObject, mouseEvent)) {
                return SCALE_N_MOUSE_CURSOR;
            }
            if (this.isSScalePoint(sVGObject, mouseEvent)) {
                return SCALE_S_MOUSE_CURSOR;
            }
        }
        return null;
    }

    private SVGObject getObjectToScaleAt(MouseEvent mouseEvent) {
        SVGObject sVGObject = this.getSelectedObject();
        if (sVGObject != null && (this.isNScalePoint(sVGObject, mouseEvent) || this.isSScalePoint(sVGObject, mouseEvent))) {
            return sVGObject;
        }
        return null;
    }

    private boolean isNScalePoint(SVGObject sVGObject, MouseEvent mouseEvent) {
        return sVGObject.getOutline().isAtScaleNHandlePoint(mouseEvent.getX(), mouseEvent.getY());
    }

    private boolean isSScalePoint(SVGObject sVGObject, MouseEvent mouseEvent) {
        return sVGObject.getOutline().isAtScaleSHandlePoint(mouseEvent.getX(), mouseEvent.getY());
    }

    private static class ScaleYAction
    extends ScaleActionFactory.ScaleAction {
        public ScaleYAction(ComposerActionFactory composerActionFactory, SVGObject sVGObject, MouseEvent mouseEvent) {
            super(composerActionFactory, sVGObject, mouseEvent);
        }

        public boolean consumeEvent(AWTEvent aWTEvent, boolean bl) {
            if (!bl && aWTEvent.getID() == 506) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                Rectangle rectangle = this.m_scaled.getScreenBBox();
                this.m_scaled.scale(1.0f, this.calculateScaleY(mouseEvent.getY()));
                rectangle.add(this.m_scaled.getScreenBBox());
                this.m_factory.getSceneManager().getScreenManager().repaint(rectangle, 5);
            } else {
                this.actionCompleted();
                this.m_scaled.commitChanges();
            }
            return false;
        }

        public ActionMouseCursor getMouseCursor(boolean bl) {
            return bl ? null : SCALE_N_MOUSE_CURSOR;
        }
    }
}

