/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;

public class ComponentGroup
implements ActionListener,
ChangeListener {
    private final ComponentWrapper[] m_wrappers;
    private boolean m_isUpdateInProgress = false;

    public ComponentGroup(Object ... objectArray) {
        this.m_wrappers = new ComponentWrapper[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof JComponent) {
                this.m_wrappers[i] = ComponentWrapper.wrap((JComponent)object);
            } else if (object instanceof ComponentWrapper) {
                this.m_wrappers[i] = (ComponentWrapper)object;
            } else {
                throw new IllegalArgumentException("Illegal object");
            }
            this.m_wrappers[i].addListener(this);
        }
    }

    public ComponentWrapper findWrapper(JComponent jComponent) {
        for (ComponentWrapper componentWrapper : this.m_wrappers) {
            if (componentWrapper.m_delegate != jComponent) continue;
            return componentWrapper;
        }
        return null;
    }

    public float getValue() {
        return this.m_wrappers[0].getValue();
    }

    public boolean valueChanged(JComponent jComponent) {
        for (int i = 0; i < this.m_wrappers.length; ++i) {
            if (this.m_wrappers[i].m_delegate != jComponent) continue;
            return this.valueChanged(i);
        }
        SceneManager.log(Level.SEVERE, "Component " + jComponent + " not found!");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean valueChanged(int n) {
        if (!this.m_isUpdateInProgress) {
            try {
                boolean bl;
                this.m_isUpdateInProgress = true;
                float f = this.m_wrappers[n].getValue();
                for (bl = false; bl < this.m_wrappers.length; bl += 1) {
                    if (bl == n) continue;
                    this.m_wrappers[bl].setValue(f);
                }
                bl = true;
                return bl;
            }
            finally {
                this.m_isUpdateInProgress = false;
            }
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        if (this.valueChanged(jComponent)) {
            this.refresh(jComponent);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JComponent jComponent = (JComponent)changeEvent.getSource();
        if (this.valueChanged(jComponent)) {
            this.refresh(jComponent);
        }
    }

    protected void refresh(JComponent jComponent) {
    }

    public static class SliderWrapper
    extends ComponentWrapper {
        protected SliderWrapper(JSlider jSlider) {
            super(jSlider);
        }

        public float getValue() {
            return (float)((JSlider)this.m_delegate).getValue() / 100.0f;
        }

        public void setValue(float f) {
            ((JSlider)this.m_delegate).setValue(Math.round(f * 100.0f));
        }
    }

    public static abstract class ComponentWrapper {
        protected final JComponent m_delegate;

        public abstract float getValue();

        public abstract void setValue(float var1);

        protected ComponentWrapper(JComponent jComponent) {
            this.m_delegate = jComponent;
        }

        protected void addListener(ComponentGroup componentGroup) {
            if (this.m_delegate instanceof JSpinner) {
                ((JSpinner)this.m_delegate).addChangeListener(componentGroup);
            } else if (this.m_delegate instanceof JSlider) {
                ((JSlider)this.m_delegate).addChangeListener(componentGroup);
            } else if (this.m_delegate instanceof JComboBox) {
                ((JComboBox)this.m_delegate).addActionListener(componentGroup);
            }
        }

        public static ComponentWrapper wrap(JComponent jComponent) {
            if (jComponent instanceof JSpinner) {
                return ComponentWrapper.wrap((JSpinner)jComponent);
            }
            if (jComponent instanceof JSlider) {
                return ComponentWrapper.wrap((JSlider)jComponent);
            }
            throw new IllegalArgumentException("Could not wrap " + jComponent);
        }

        public static ComponentWrapper wrap(JSpinner jSpinner) {
            return new ComponentWrapper(jSpinner){

                public float getValue() {
                    return ((Number)((JSpinner)this.m_delegate).getValue()).floatValue();
                }

                public void setValue(float f) {
                    JSpinner jSpinner = (JSpinner)this.m_delegate;
                    Object object = jSpinner.getValue();
                    if (object instanceof Integer) {
                        jSpinner.setValue(new Integer(Math.round(f)));
                    } else {
                        jSpinner.setValue(new Double(f));
                    }
                }
            };
        }

        public static ComponentWrapper wrap(JSlider jSlider) {
            return new SliderWrapper(jSlider);
        }
    }
}

