/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.codegen.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Logger;
import org.netbeans.modules.compapp.javaee.annotation.handler.JarInJarClassFileLoader;
import org.netbeans.modules.compapp.javaee.codegen.model.AbstractProject;
import org.netbeans.modules.compapp.javaee.codegen.model.JavaEEProject;
import org.netbeans.modules.compapp.javaee.util.ProjectUtil;

public class JarInJarProject
extends AbstractProject {
    private static Logger logger = Logger.getLogger(JarInJarProject.class.getName());
    private static String WEB_CLASSES_DIR = "WEB-INF/classes/";
    protected URL jarPathUrl;
    protected String root = "";

    public JarInJarProject(URL uRL) {
        this.jarPathUrl = uRL;
        String string = this.jarPathUrl.toString();
        if (string.endsWith(".war")) {
            this.projType = JavaEEProject.ProjectType.WEB;
            this.root = WEB_CLASSES_DIR;
        } else {
            this.projType = JavaEEProject.ProjectType.EJB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanForEndpoints() throws IOException {
        URLConnection uRLConnection = this.jarPathUrl.openConnection();
        JarURLConnection jarURLConnection = null;
        JarInputStream jarInputStream = null;
        InputStream inputStream = null;
        try {
            if (uRLConnection instanceof JarURLConnection) {
                jarURLConnection = (JarURLConnection)uRLConnection;
                inputStream = jarURLConnection.getInputStream();
                jarInputStream = new JarInputStream(inputStream);
                JarEntry jarEntry = jarInputStream.getNextJarEntry();
                JarInJarClassFileLoader jarInJarClassFileLoader = new JarInJarClassFileLoader(this.jarPathUrl, this.root);
                while (jarEntry != null) {
                    if (jarEntry.getName().endsWith(".class")) {
                        logger.finest("Checking Annotation in:" + jarEntry.getName());
                        this.handleAnnotations(jarInJarClassFileLoader, jarEntry);
                    }
                    jarEntry = jarInputStream.getNextJarEntry();
                }
            }
        }
        finally {
            ProjectUtil.close(jarInputStream);
            ProjectUtil.close(inputStream);
        }
    }
}

