/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.sunresources;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.netbeans.api.project.Project;
import org.netbeans.modules.compapp.javaee.sunresources.generated.sunresources13.AdminObjectResource;
import org.netbeans.modules.compapp.javaee.sunresources.generated.sunresources13.ConnectorConnectionPool;
import org.netbeans.modules.compapp.javaee.sunresources.generated.sunresources13.ConnectorResource;
import org.netbeans.modules.compapp.javaee.sunresources.generated.sunresources13.JdbcConnectionPool;
import org.netbeans.modules.compapp.javaee.sunresources.generated.sunresources13.JdbcResource;
import org.netbeans.modules.compapp.javaee.sunresources.generated.sunresources13.ObjectFactory;
import org.netbeans.modules.compapp.javaee.sunresources.generated.sunresources13.Property;
import org.netbeans.modules.compapp.javaee.sunresources.generated.sunresources13.Resources;
import org.netbeans.modules.compapp.javaee.sunresources.tool.archive.FileUtil;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAggregator {
    private Project p;
    private List<ResourceEntry> resources = new ArrayList<ResourceEntry>();
    private JAXBContext jc;
    private Unmarshaller unmarshaller;
    private List<PoolEntry> pools = new ArrayList<PoolEntry>();

    public ResourceAggregator() throws Exception {
        this(null);
    }

    public ResourceAggregator(Project project) throws Exception {
        this.p = project;
        this.jc = JAXBContext.newInstance((String)"org.netbeans.modules.compapp.javaee.sunresources.generated.sunresources13", (ClassLoader)this.getClass().getClassLoader());
        this.unmarshaller = this.jc.createUnmarshaller();
    }

    public Project getProject() {
        return this.p;
    }

    public List<ResourceEntry> getResources() {
        return this.resources;
    }

    public void createResource(Object object, FileObject fileObject) {
        ResourceEntry resourceEntry = new ResourceEntry();
        resourceEntry.resource = object;
        resourceEntry.fileObject = fileObject;
        this.resources.add(resourceEntry);
    }

    public void addResource(File file) throws Exception {
        Resources resources = (Resources)this.unmarshaller.unmarshal(file);
        List<Object> list = resources.getCustomResourceOrExternalJndiResourceOrJdbcResourceOrMailResourceOrPersistenceManagerFactoryResourceOrAdminObjectResourceOrConnectorResourceOrResourceAdapterConfigOrJdbcConnectionPoolOrConnectorConnectionPool();
        for (Object object : list) {
            Object object2;
            if (object instanceof ConnectorConnectionPool || object instanceof JdbcConnectionPool) {
                object2 = new PoolEntry();
                ((PoolEntry)object2).pool = object;
                this.pools.add((PoolEntry)object2);
                continue;
            }
            object2 = new ResourceEntry();
            ((ResourceEntry)object2).resource = object;
            this.resources.add((ResourceEntry)object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(FileObject fileObject) throws Exception {
        InputStream inputStream = null;
        try {
            inputStream = fileObject.getInputStream();
            Resources resources = (Resources)this.unmarshaller.unmarshal(inputStream);
            List<Object> list = resources.getCustomResourceOrExternalJndiResourceOrJdbcResourceOrMailResourceOrPersistenceManagerFactoryResourceOrAdminObjectResourceOrConnectorResourceOrResourceAdapterConfigOrJdbcConnectionPoolOrConnectorConnectionPool();
            for (Object object : list) {
                Object object2;
                if (object instanceof ConnectorConnectionPool || object instanceof JdbcConnectionPool) {
                    object2 = new PoolEntry();
                    ((PoolEntry)object2).pool = object;
                    ((PoolEntry)object2).fileObject = fileObject;
                    this.pools.add((PoolEntry)object2);
                    continue;
                }
                object2 = new ResourceEntry();
                ((ResourceEntry)object2).resource = object;
                ((ResourceEntry)object2).fileObject = fileObject;
                this.resources.add((ResourceEntry)object2);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String toSunResourcesXML() throws Exception {
        ObjectFactory objectFactory = new ObjectFactory();
        Resources resources = objectFactory.createResources();
        for (ResourceEntry object2 : this.resources) {
            resources.getCustomResourceOrExternalJndiResourceOrJdbcResourceOrMailResourceOrPersistenceManagerFactoryResourceOrAdminObjectResourceOrConnectorResourceOrResourceAdapterConfigOrJdbcConnectionPoolOrConnectorConnectionPool().add(object2.resource);
        }
        for (PoolEntry poolEntry : this.pools) {
            resources.getCustomResourceOrExternalJndiResourceOrJdbcResourceOrMailResourceOrPersistenceManagerFactoryResourceOrAdminObjectResourceOrConnectorResourceOrResourceAdapterConfigOrJdbcConnectionPoolOrConnectorConnectionPool().add(poolEntry.pool);
        }
        Iterator<Object> iterator = this.jc.createMarshaller();
        iterator.setProperty("jaxb.formatted.output", Boolean.TRUE);
        iterator.setProperty("com.sun.xml.bind.xmlDeclaration", Boolean.FALSE);
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        stringWriter.write("<!DOCTYPE resources PUBLIC \"-//Sun Microsystems, Inc.//DTD Application Server 9.0 Resource Definitions //EN\" \"http://www.sun.com/software/appserver/dtds/sun-resources_1_3.dtd\">\n");
        iterator.marshal(resources, stringWriter);
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToSunXML(int n) throws Exception {
        Object object = this.resources.get((int)n).resource;
        FileObject fileObject = this.resources.get((int)n).fileObject;
        if (fileObject == null) {
            throw new Exception(NbBundle.getMessage(ResourceAggregator.class, (String)"EXC_fileobject_null"));
        }
        ObjectFactory objectFactory = new ObjectFactory();
        Resources resources = objectFactory.createResources();
        for (ResourceEntry object2 : this.resources) {
            if (object2.fileObject == null || !object2.fileObject.equals(fileObject)) continue;
            resources.getCustomResourceOrExternalJndiResourceOrJdbcResourceOrMailResourceOrPersistenceManagerFactoryResourceOrAdminObjectResourceOrConnectorResourceOrResourceAdapterConfigOrJdbcConnectionPoolOrConnectorConnectionPool().add(object2.resource);
        }
        this.addReferencedPool(object, resources);
        FileLock fileLock = fileObject.lock();
        try {
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            PrintWriter printWriter = new PrintWriter(outputStream);
            try {
                Marshaller marshaller = this.jc.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                marshaller.marshal((Object)resources, (Writer)printWriter);
            }
            finally {
                FileUtil.safeclose(printWriter);
                FileUtil.safeclose(outputStream);
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToSunXML(int n, File file) throws Exception {
        ResourceEntry resourceEntry = this.resources.get(n);
        ObjectFactory objectFactory = new ObjectFactory();
        Resources resources = objectFactory.createResources();
        resources.getCustomResourceOrExternalJndiResourceOrJdbcResourceOrMailResourceOrPersistenceManagerFactoryResourceOrAdminObjectResourceOrConnectorResourceOrResourceAdapterConfigOrJdbcConnectionPoolOrConnectorConnectionPool().add(resourceEntry.resource);
        this.addReferencedPool(resourceEntry.resource, resources);
        PrintWriter printWriter = new PrintWriter(file);
        try {
            Marshaller marshaller = this.jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)resources, (Writer)printWriter);
        }
        finally {
            printWriter.close();
        }
        resourceEntry.orphanStatus = OrphanStatus.BOTH;
        resourceEntry.fileObject = org.openide.filesystems.FileUtil.toFileObject((File)file);
    }

    public void deleteResourceFile(int n) throws Exception {
        ResourceEntry resourceEntry = this.resources.get(n);
        if (resourceEntry == null || resourceEntry.orphanStatus == OrphanStatus.ANNO_ONLY || resourceEntry.fileObject == null) {
            throw new Exception(NbBundle.getMessage(ResourceAggregator.class, (String)"EXC_error_delete"));
        }
        FileObject fileObject = resourceEntry.fileObject;
        for (ResourceEntry resourceEntry2 : this.findResourcesByFileObject(fileObject)) {
            if (resourceEntry2.orphanStatus == OrphanStatus.FILE_ONLY) {
                this.resources.remove(resourceEntry2);
                continue;
            }
            if (resourceEntry2.orphanStatus != OrphanStatus.BOTH) continue;
            resourceEntry2.fileObject = null;
            resourceEntry2.orphanStatus = OrphanStatus.ANNO_ONLY;
        }
        fileObject.delete();
    }

    private ArrayList<ResourceEntry> findResourcesByFileObject(FileObject fileObject) {
        ArrayList<ResourceEntry> arrayList = new ArrayList<ResourceEntry>();
        for (ResourceEntry resourceEntry : this.resources) {
            if (resourceEntry.fileObject == null || !resourceEntry.fileObject.equals(fileObject)) continue;
            arrayList.add(resourceEntry);
        }
        return arrayList;
    }

    private void addReferencedPool(Object object, Resources resources) {
        PoolEntry poolEntry;
        String string;
        if (object instanceof ConnectorResource) {
            string = ((ConnectorResource)object).getPoolName();
            poolEntry = this.getConnectorConnectionPoolEntry(string);
            if (poolEntry == null) {
                poolEntry = this.createDefaultConnectorConnectionPool(string);
            }
            if (poolEntry != null && poolEntry.pool instanceof ConnectorConnectionPool) {
                resources.getCustomResourceOrExternalJndiResourceOrJdbcResourceOrMailResourceOrPersistenceManagerFactoryResourceOrAdminObjectResourceOrConnectorResourceOrResourceAdapterConfigOrJdbcConnectionPoolOrConnectorConnectionPool().add(poolEntry.pool);
            }
        }
        if (object instanceof JdbcResource) {
            string = ((JdbcResource)object).getPoolName();
            poolEntry = this.getJdbcConnectionPoolEntry(string);
            if (poolEntry == null) {
                poolEntry = this.createDefaultJdbcConnectionPool(string);
            }
            if (poolEntry != null && poolEntry.pool instanceof JdbcConnectionPool) {
                resources.getCustomResourceOrExternalJndiResourceOrJdbcResourceOrMailResourceOrPersistenceManagerFactoryResourceOrAdminObjectResourceOrConnectorResourceOrResourceAdapterConfigOrJdbcConnectionPoolOrConnectorConnectionPool().add(poolEntry.pool);
            }
        }
    }

    public void close() {
    }

    public ResourceEntry getAdminObjectResourceEntry(String string) {
        for (ResourceEntry resourceEntry : this.resources) {
            AdminObjectResource adminObjectResource;
            if (!(resourceEntry.resource instanceof AdminObjectResource) || !(adminObjectResource = (AdminObjectResource)resourceEntry.resource).getJndiName().equals(string)) continue;
            return resourceEntry;
        }
        return null;
    }

    public ResourceEntry addAdminObjectResourceEntry(String string, String string2, String string3, Properties properties) {
        AdminObjectResource adminObjectResource = new AdminObjectResource();
        adminObjectResource.setJndiName(string);
        adminObjectResource.setResType(string2);
        adminObjectResource.setResAdapter(string3);
        adminObjectResource.setDescription("");
        Object object = properties.propertyNames();
        while (object.hasMoreElements()) {
            String string4 = (String)object.nextElement();
            String string5 = properties.getProperty(string4);
            Property property = new Property();
            property.setName(string4);
            property.setValue(string5);
            adminObjectResource.getProperty().add(property);
        }
        object = new ResourceEntry();
        ((ResourceEntry)object).resource = adminObjectResource;
        ((ResourceEntry)object).orphanStatus = OrphanStatus.ANNO_ONLY;
        ((ResourceEntry)object).obsolete = false;
        this.resources.add((ResourceEntry)object);
        return object;
    }

    public ResourceEntry getConnectorResourceResourceEntry(String string) {
        for (ResourceEntry resourceEntry : this.resources) {
            ConnectorResource connectorResource;
            if (!(resourceEntry.resource instanceof ConnectorResource) || !(connectorResource = (ConnectorResource)resourceEntry.resource).getJndiName().equals(string)) continue;
            return resourceEntry;
        }
        return null;
    }

    public ResourceEntry addConnectorResourceEntry(String string, String string2, String string3) {
        ConnectorResource connectorResource = new ConnectorResource();
        connectorResource.setJndiName(string);
        String string4 = string;
        int n = 1;
        while (this.getConnectorConnectionPoolEntry(string4) != null) {
            string4 = string4 + Integer.toString(n);
        }
        connectorResource.setPoolName(string4);
        connectorResource.setDescription("");
        ConnectorConnectionPool connectorConnectionPool = new ConnectorConnectionPool();
        connectorConnectionPool.setName(string4);
        connectorConnectionPool.setResourceAdapterName(string3);
        connectorConnectionPool.setConnectionDefinitionName(string2);
        connectorConnectionPool.setDescription("");
        PoolEntry poolEntry = new PoolEntry();
        poolEntry.pool = connectorConnectionPool;
        this.pools.add(poolEntry);
        ResourceEntry resourceEntry = new ResourceEntry();
        resourceEntry.resource = connectorResource;
        resourceEntry.orphanStatus = OrphanStatus.ANNO_ONLY;
        resourceEntry.obsolete = false;
        this.resources.add(resourceEntry);
        return resourceEntry;
    }

    public PoolEntry getConnectorConnectionPoolEntry(String string) {
        for (PoolEntry poolEntry : this.pools) {
            ConnectorConnectionPool connectorConnectionPool;
            if (!(poolEntry.pool instanceof ConnectorConnectionPool) || !(connectorConnectionPool = (ConnectorConnectionPool)poolEntry.pool).getName().equals(string)) continue;
            return poolEntry;
        }
        return null;
    }

    public ResourceEntry getJdbcResourceResourceEntry(String string) {
        for (ResourceEntry resourceEntry : this.resources) {
            JdbcResource jdbcResource;
            if (!(resourceEntry.resource instanceof JdbcResource) || !(jdbcResource = (JdbcResource)resourceEntry.resource).getJndiName().equals(string)) continue;
            return resourceEntry;
        }
        return null;
    }

    public ResourceEntry addJdbcResourceEntry(String string, String string2, String string3) {
        JdbcResource jdbcResource = new JdbcResource();
        jdbcResource.setJndiName(string);
        String string4 = string;
        int n = 1;
        while (this.getJdbcConnectionPoolEntry(string4) != null) {
            string4 = string4 + Integer.toString(n);
        }
        jdbcResource.setPoolName(string4);
        jdbcResource.setDescription("");
        JdbcConnectionPool jdbcConnectionPool = new JdbcConnectionPool();
        jdbcConnectionPool.setName(string4);
        jdbcConnectionPool.setResType(string2);
        jdbcConnectionPool.setDatasourceClassname(string3);
        jdbcConnectionPool.setDescription("");
        PoolEntry poolEntry = new PoolEntry();
        poolEntry.pool = jdbcConnectionPool;
        this.pools.add(poolEntry);
        ResourceEntry resourceEntry = new ResourceEntry();
        resourceEntry.resource = jdbcResource;
        resourceEntry.orphanStatus = OrphanStatus.ANNO_ONLY;
        resourceEntry.obsolete = false;
        this.resources.add(resourceEntry);
        return resourceEntry;
    }

    public PoolEntry getJdbcConnectionPoolEntry(String string) {
        for (PoolEntry poolEntry : this.pools) {
            JdbcConnectionPool jdbcConnectionPool;
            if (!(poolEntry.pool instanceof JdbcConnectionPool) || !(jdbcConnectionPool = (JdbcConnectionPool)poolEntry.pool).getName().equals(string)) continue;
            return poolEntry;
        }
        return null;
    }

    public PoolEntry createDefaultConnectorConnectionPool(String string) {
        ConnectorConnectionPool connectorConnectionPool = new ConnectorConnectionPool();
        connectorConnectionPool.setName(string);
        connectorConnectionPool.setResourceAdapterName("jmsra");
        connectorConnectionPool.setConnectionDefinitionName("javax.jms.ConnectionFactory");
        connectorConnectionPool.setDescription("");
        PoolEntry poolEntry = new PoolEntry();
        poolEntry.pool = connectorConnectionPool;
        this.pools.add(poolEntry);
        return poolEntry;
    }

    public PoolEntry createDefaultJdbcConnectionPool(String string) {
        JdbcConnectionPool jdbcConnectionPool = new JdbcConnectionPool();
        jdbcConnectionPool.setName(string);
        jdbcConnectionPool.setDatasourceClassname("org.apache.derby.jdbc.ClientDataSource");
        jdbcConnectionPool.setDescription("");
        PoolEntry poolEntry = new PoolEntry();
        poolEntry.pool = jdbcConnectionPool;
        this.pools.add(poolEntry);
        return poolEntry;
    }

    public static class ResourceUsage {
        public String sourceName;
        public SourceType sourceType;
    }

    public static class PoolEntry {
        public Object pool;
        public FileObject fileObject;
    }

    public static class ResourceEntry {
        public Object resource;
        public FileObject fileObject;
        public OrphanStatus orphanStatus = OrphanStatus.FILE_ONLY;
        public boolean obsolete = true;
        public List<ResourceUsage> usages = new ArrayList<ResourceUsage>();

        public void addResourceUsage(String string, SourceType sourceType) {
            ResourceUsage resourceUsage = new ResourceUsage();
            resourceUsage.sourceName = string;
            resourceUsage.sourceType = sourceType;
            this.usages.add(resourceUsage);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SourceType {
        EJB,
        MDB,
        DD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OrphanStatus {
        FILE_ONLY,
        ANNO_ONLY,
        BOTH;

    }
}

