/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.sunresources.tool;

import java.io.File;
import javax.swing.JComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.modules.compapp.javaee.sunresources.ResourceAggregator;
import org.netbeans.modules.compapp.javaee.sunresources.actions.WidgetMoveProvider;
import org.netbeans.modules.compapp.javaee.sunresources.tool.archive.ApplicationArchive;
import org.netbeans.modules.compapp.javaee.sunresources.tool.archive.Archive;
import org.netbeans.modules.compapp.javaee.sunresources.tool.archive.ArchiveConstants;
import org.netbeans.modules.compapp.javaee.sunresources.tool.archive.EJBArchive;
import org.netbeans.modules.compapp.javaee.sunresources.tool.archive.WebArchive;
import org.netbeans.modules.compapp.javaee.sunresources.tool.graph.CMapScene;
import org.netbeans.modules.compapp.javaee.sunresources.tool.graph.VisualUtil;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class JavaEETool {
    private ArchiveConstants.ArchiveType type;
    private Project p;
    private Archive archive;
    private CMapScene scene;
    private boolean valid = true;

    public JavaEETool(File file) throws Exception {
    }

    public JavaEETool(ArchiveConstants.ArchiveType archiveType, Project project) throws Exception {
        this.type = archiveType;
        this.p = project;
        if (archiveType == ArchiveConstants.ArchiveType.EAR) {
            this.archive = new ApplicationArchive(project);
        } else if (archiveType == ArchiveConstants.ArchiveType.EJB) {
            this.archive = new EJBArchive(project);
        } else if (archiveType == ArchiveConstants.ArchiveType.WAR) {
            this.archive = new WebArchive(project);
        } else {
            throw new Exception(NbBundle.getMessage(JavaEETool.class, (String)"EXC_unknown_archive", (Object)archiveType.toString()));
        }
        this.archive.open();
        this.scene = VisualUtil.constructCMapScene(this.archive);
        this.scene.registerNodeWidgetAction(this.scene.createWidgetHoverAction());
        WidgetAction widgetAction = ActionFactory.createMoveAction(null, (MoveProvider)new WidgetMoveProvider(this.archive.getJAXBHandler()));
        this.scene.registerNodeWidgetAction(widgetAction);
    }

    public void close() throws Exception {
        this.archive.close();
        this.archive = null;
        this.valid = false;
    }

    public ResourceAggregator getResourceAggregator() {
        this.isValid();
        return this.archive.getResourceAggregator();
    }

    public FileObject getResourceDir() {
        this.isValid();
        return this.archive.getResourceDir();
    }

    public JComponent getGraphView() {
        this.isValid();
        JComponent jComponent = this.scene.getView();
        if (jComponent == null) {
            jComponent = this.scene.createView();
        }
        return jComponent;
    }

    private void isValid() {
        if (!this.valid) {
            throw new IllegalStateException(NbBundle.getMessage(JavaEETool.class, (String)"EXC_already_closed"));
        }
    }

    public static void main(String[] stringArray) {
        File file = new File("C:/temp/EnterpriseApplication4.ear");
        File file2 = new File("C:/temp");
    }
}

