/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.sunresources.tool.annotation;

import java.util.Collection;
import java.util.Properties;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.Field;
import org.netbeans.modules.classfile.Method;
import org.netbeans.modules.classfile.Parameter;
import org.netbeans.modules.classfile.Variable;
import org.netbeans.modules.compapp.javaee.sunresources.ResourceAggregator;
import org.netbeans.modules.compapp.javaee.sunresources.tool.annotation.EJBAnnoWrapper;
import org.netbeans.modules.compapp.javaee.sunresources.tool.annotation.EJBsAnnoWrapper;
import org.netbeans.modules.compapp.javaee.sunresources.tool.annotation.ResourceAnnoWrapper;
import org.netbeans.modules.compapp.javaee.sunresources.tool.annotation.ResourcesAnnoWrapper;
import org.netbeans.modules.compapp.javaee.sunresources.tool.annotation.WebServiceRefAnnoWrapper;
import org.netbeans.modules.compapp.javaee.sunresources.tool.annotation.WebServiceRefsAnnoWrapper;
import org.netbeans.modules.compapp.javaee.sunresources.tool.cmap.CMapNode;
import org.netbeans.modules.compapp.javaee.sunresources.tool.cmap.EJBDepend;
import org.netbeans.modules.compapp.javaee.sunresources.tool.cmap.ResourceDepend;
import org.netbeans.modules.compapp.javaee.sunresources.tool.cmap.ResourceNode;

public class DependencyAnnotation {
    private ResourceAggregator resAggregator;

    public DependencyAnnotation(ResourceAggregator resourceAggregator) {
        this.resAggregator = resourceAggregator;
    }

    public void fillDependencyInfo(CMapNode cMapNode, ClassFile classFile) {
        Object object2;
        this.handleEJBDep(cMapNode, classFile);
        this.handleResourceDep(cMapNode, classFile);
        this.handleWebServiceRef(cMapNode, classFile);
        Collection collection = classFile.getVariables();
        for (Object object2 : collection) {
            this.handleEJBDep(cMapNode, (Field)object2);
            this.handleResourceDep(cMapNode, (Field)object2);
            this.handleWebServiceRef(cMapNode, (Field)object2);
        }
        Collection collection2 = classFile.getMethods();
        object2 = collection2.iterator();
        while (object2.hasNext()) {
            Method method = (Method)object2.next();
            this.handleEJBDep(cMapNode, (Field)method);
            this.handleResourceDep(cMapNode, (Field)method);
            this.handleWebServiceRef(cMapNode, (Field)method);
        }
    }

    private void handleEJBDep(CMapNode cMapNode, ClassFile classFile) {
        ClassName className = ClassName.getClassName((String)"javax/ejb/EJB");
        ClassName className2 = ClassName.getClassName((String)"javax/ejb/EJBs");
        if (classFile.isAnnotationPresent(className)) {
            this.processEJBDep(cMapNode, new EJBAnnoWrapper(classFile.getAnnotation(className)), classFile);
        } else if (classFile.isAnnotationPresent(className2)) {
            EJBsAnnoWrapper eJBsAnnoWrapper = new EJBsAnnoWrapper(classFile.getAnnotation(className2));
            EJBAnnoWrapper[] eJBAnnoWrapperArray = eJBsAnnoWrapper.value();
            for (int i = 0; i < eJBAnnoWrapperArray.length; ++i) {
                this.processEJBDep(cMapNode, eJBAnnoWrapperArray[i], classFile);
            }
        }
    }

    private void handleEJBDep(CMapNode cMapNode, Field field) {
        ClassName className = ClassName.getClassName((String)"javax/ejb/EJB");
        ClassName className2 = ClassName.getClassName((String)"javax/ejb/EJBs");
        if (field.isAnnotationPresent(className)) {
            this.processEJBDep(cMapNode, new EJBAnnoWrapper(field.getAnnotation(className)), field);
        } else if (field.isAnnotationPresent(className2)) {
            EJBsAnnoWrapper eJBsAnnoWrapper = new EJBsAnnoWrapper(field.getAnnotation(className2));
            EJBAnnoWrapper[] eJBAnnoWrapperArray = eJBsAnnoWrapper.value();
            for (int i = 0; i < eJBAnnoWrapperArray.length; ++i) {
                this.processEJBDep(cMapNode, eJBAnnoWrapperArray[i], field);
            }
        }
    }

    private void processEJBDep(CMapNode cMapNode, EJBAnnoWrapper eJBAnnoWrapper, ClassFile classFile) {
        EJBDepend eJBDepend = new EJBDepend(cMapNode);
        String string = eJBAnnoWrapper.beanInterface();
        if (!string.equals("java.lang.Object")) {
            eJBDepend.setTargetIntfName(string);
        }
        cMapNode.getEjbDepends().add(eJBDepend);
    }

    private void processEJBDep(CMapNode cMapNode, EJBAnnoWrapper eJBAnnoWrapper, Field field) {
        EJBDepend eJBDepend = new EJBDepend(cMapNode);
        String string = eJBAnnoWrapper.beanInterface();
        if (!string.equals("java.lang.Object")) {
            eJBDepend.setTargetIntfName(string);
        } else if (field instanceof Variable) {
            eJBDepend.setTargetIntfName(ClassName.getClassName((String)field.getDescriptor()).getExternalName());
        } else if (field instanceof Method) {
            Method method = (Method)field;
            if (!this.isSetter(method)) {
                System.out.println("found @EJB annotation declared on a non-setter method");
                return;
            }
            eJBDepend.setTargetIntfName(ClassName.getClassName((String)((Parameter)method.getParameters().get(0)).getDescriptor()).getExternalName());
        }
        cMapNode.getEjbDepends().add(eJBDepend);
    }

    private void handleResourceDep(CMapNode cMapNode, ClassFile classFile) {
        ClassName className = ClassName.getClassName((String)"javax/annotation/Resource");
        ClassName className2 = ClassName.getClassName((String)"javax/annotation/Resources");
        if (classFile.isAnnotationPresent(className)) {
            this.processResourceDep(cMapNode, new ResourceAnnoWrapper(classFile.getAnnotation(className)), classFile);
        } else if (classFile.isAnnotationPresent(className2)) {
            ResourcesAnnoWrapper resourcesAnnoWrapper = new ResourcesAnnoWrapper(classFile.getAnnotation(className2));
            ResourceAnnoWrapper[] resourceAnnoWrapperArray = resourcesAnnoWrapper.value();
            for (int i = 0; i < resourceAnnoWrapperArray.length; ++i) {
                this.processResourceDep(cMapNode, resourceAnnoWrapperArray[i], classFile);
            }
        }
    }

    private void handleResourceDep(CMapNode cMapNode, Field field) {
        ClassName className = ClassName.getClassName((String)"javax/annotation/Resource");
        ClassName className2 = ClassName.getClassName((String)"javax/annotation/Resources");
        if (field.isAnnotationPresent(className)) {
            this.processResourceDep(cMapNode, new ResourceAnnoWrapper(field.getAnnotation(className)), field);
        } else if (field.isAnnotationPresent(className2)) {
            ResourcesAnnoWrapper resourcesAnnoWrapper = new ResourcesAnnoWrapper(field.getAnnotation(className2));
            ResourceAnnoWrapper[] resourceAnnoWrapperArray = resourcesAnnoWrapper.value();
            for (int i = 0; i < resourceAnnoWrapperArray.length; ++i) {
                this.processResourceDep(cMapNode, resourceAnnoWrapperArray[i], field);
            }
        }
    }

    private void processResourceDep(CMapNode cMapNode, ResourceAnnoWrapper resourceAnnoWrapper, ClassFile classFile) {
        String string = resourceAnnoWrapper.type();
        ResourceDepend resourceDepend = new ResourceDepend(cMapNode);
        if (!string.equals("java.lang.Object")) {
            resourceDepend.setTargetResType(string);
        }
        if (this.isSimpleEnvEntry(resourceDepend.getTargetResType())) {
            return;
        }
        if (!resourceAnnoWrapper.name().equals("")) {
            resourceDepend.setTargetResJndiName(resourceAnnoWrapper.name());
        }
        resourceDepend.setMappedName(resourceAnnoWrapper.mappedName());
        cMapNode.getResDepends().add(resourceDepend);
        String string2 = classFile.getName().getPackage().replace('.', '/') + "/" + classFile.getSourceFileName();
        this.handleServerResource(resourceDepend, string2);
    }

    private void processResourceDep(CMapNode cMapNode, ResourceAnnoWrapper resourceAnnoWrapper, Field field) {
        Object object;
        String string = resourceAnnoWrapper.type();
        ResourceDepend resourceDepend = new ResourceDepend(cMapNode);
        if (!string.equals("java.lang.Object")) {
            resourceDepend.setTargetResType(string);
        } else if (field instanceof Variable) {
            resourceDepend.setTargetResType(ClassName.getClassName((String)field.getDescriptor()).getExternalName());
        } else if (field instanceof Method) {
            object = (Method)field;
            if (!this.isSetter((Method)object)) {
                System.out.println("found @Resource annotation declared on a non-setter method");
                return;
            }
            resourceDepend.setTargetResType(ClassName.getClassName((String)((Parameter)object.getParameters().get(0)).getDescriptor()).getExternalName());
        }
        if (this.isSimpleEnvEntry(resourceDepend.getTargetResType())) {
            return;
        }
        if (!resourceAnnoWrapper.name().equals("")) {
            resourceDepend.setTargetResJndiName(resourceAnnoWrapper.name());
        } else if (field instanceof Variable) {
            resourceDepend.setTargetResJndiName(field.getName());
        } else if (field instanceof Method) {
            object = (Method)field;
            if (!this.isSetter((Method)object)) {
                System.out.println("found @Resource annotation declared on a non-setter method");
                return;
            }
            resourceDepend.setTargetResJndiName(this.getJavaBeanPropName((Method)object));
        }
        resourceDepend.setMappedName(resourceAnnoWrapper.mappedName());
        cMapNode.getResDepends().add(resourceDepend);
        object = field.getClassFile().getName().getPackage().replace('.', '/') + "/" + field.getClassFile().getSourceFileName();
        this.handleServerResource(resourceDepend, (String)object);
    }

    private void handleServerResource(ResourceDepend resourceDepend, String string) {
        if (this.isAdminObjectResource(resourceDepend.getTargetResType())) {
            resourceDepend.setType(ResourceNode.ResourceType.JMS);
            ResourceAggregator.ResourceEntry resourceEntry = this.resAggregator.getAdminObjectResourceEntry(resourceDepend.getMappedName());
            if (resourceEntry == null) {
                Properties properties = new Properties();
                properties.setProperty("Name", resourceDepend.getTargetResJndiName());
                resourceEntry = this.resAggregator.addAdminObjectResourceEntry(resourceDepend.getMappedName(), resourceDepend.getTargetResType(), "jmsra", properties);
            } else {
                resourceEntry.obsolete = false;
                if (resourceEntry.orphanStatus == ResourceAggregator.OrphanStatus.FILE_ONLY) {
                    resourceEntry.orphanStatus = ResourceAggregator.OrphanStatus.BOTH;
                }
            }
            resourceEntry.addResourceUsage(string, null);
        } else if (this.isConnectorResource(resourceDepend.getTargetResType())) {
            resourceDepend.setType(ResourceNode.ResourceType.OTHER);
            ResourceAggregator.ResourceEntry resourceEntry = this.resAggregator.getConnectorResourceResourceEntry(resourceDepend.getMappedName());
            if (resourceEntry == null) {
                resourceEntry = this.resAggregator.addConnectorResourceEntry(resourceDepend.getMappedName(), resourceDepend.getTargetResType(), "jmsra");
            } else {
                resourceEntry.obsolete = false;
                if (resourceEntry.orphanStatus == ResourceAggregator.OrphanStatus.FILE_ONLY) {
                    resourceEntry.orphanStatus = ResourceAggregator.OrphanStatus.BOTH;
                }
            }
            resourceEntry.addResourceUsage(string, null);
        } else if (this.isJdbcResource(resourceDepend.getTargetResType())) {
            resourceDepend.setType(ResourceNode.ResourceType.OTHER);
            ResourceAggregator.ResourceEntry resourceEntry = this.resAggregator.getJdbcResourceResourceEntry(resourceDepend.getTargetResJndiName());
            if (resourceEntry == null) {
                resourceEntry = this.resAggregator.addJdbcResourceEntry(resourceDepend.getTargetResJndiName(), resourceDepend.getTargetResType(), "org.apache.derby.jdbc.ClientDataSource");
            } else {
                resourceEntry.obsolete = false;
                if (resourceEntry.orphanStatus == ResourceAggregator.OrphanStatus.FILE_ONLY) {
                    resourceEntry.orphanStatus = ResourceAggregator.OrphanStatus.BOTH;
                }
            }
            resourceEntry.addResourceUsage(string, null);
        } else if (this.isOtherResource(resourceDepend.getTargetResType())) {
            resourceDepend.setType(ResourceNode.ResourceType.OTHER);
        }
    }

    private void handleWebServiceRef(CMapNode cMapNode, ClassFile classFile) {
        ClassName className = ClassName.getClassName((String)"javax/xml/ws/WebServiceRef");
        ClassName className2 = ClassName.getClassName((String)"javax/xml/ws/WebServiceRefs");
        if (classFile.isAnnotationPresent(className)) {
            this.processWebServiceRef(cMapNode, new WebServiceRefAnnoWrapper(classFile.getAnnotation(className)), classFile);
        } else if (classFile.isAnnotationPresent(className2)) {
            WebServiceRefsAnnoWrapper webServiceRefsAnnoWrapper = new WebServiceRefsAnnoWrapper(classFile.getAnnotation(className2));
            WebServiceRefAnnoWrapper[] webServiceRefAnnoWrapperArray = webServiceRefsAnnoWrapper.value();
            for (int i = 0; i < webServiceRefAnnoWrapperArray.length; ++i) {
                this.processWebServiceRef(cMapNode, webServiceRefAnnoWrapperArray[i], classFile);
            }
        }
    }

    private void handleWebServiceRef(CMapNode cMapNode, Field field) {
        ClassName className = ClassName.getClassName((String)"javax/xml/ws/WebServiceRef");
        ClassName className2 = ClassName.getClassName((String)"javax/xml/ws/WebServiceRefs");
        if (field.isAnnotationPresent(className)) {
            this.processWebServiceRef(cMapNode, new WebServiceRefAnnoWrapper(field.getAnnotation(className)), field);
        } else if (field.isAnnotationPresent(className2)) {
            WebServiceRefsAnnoWrapper webServiceRefsAnnoWrapper = new WebServiceRefsAnnoWrapper(field.getAnnotation(className2));
            WebServiceRefAnnoWrapper[] webServiceRefAnnoWrapperArray = webServiceRefsAnnoWrapper.value();
            for (int i = 0; i < webServiceRefAnnoWrapperArray.length; ++i) {
                this.processWebServiceRef(cMapNode, webServiceRefAnnoWrapperArray[i], field);
            }
        }
    }

    private void processWebServiceRef(CMapNode cMapNode, WebServiceRefAnnoWrapper webServiceRefAnnoWrapper, ClassFile classFile) {
        String string;
        String string2 = webServiceRefAnnoWrapper.type();
        ResourceDepend resourceDepend = new ResourceDepend(cMapNode);
        resourceDepend.setType(ResourceNode.ResourceType.WEBSERVICE);
        String string3 = "";
        if (!string2.equals("java.lang.Object")) {
            resourceDepend.setTargetResType(string2);
            string3 = string2.substring(string2.lastIndexOf(".") + 1);
        }
        if (!webServiceRefAnnoWrapper.name().equals("")) {
            resourceDepend.setTargetResJndiName(webServiceRefAnnoWrapper.name());
        }
        if ((string = webServiceRefAnnoWrapper.mappedName()).equals("")) {
            resourceDepend.setMappedName(string3);
        } else {
            resourceDepend.setMappedName(string);
        }
        resourceDepend.getProps().setProperty("wsdlLocation", webServiceRefAnnoWrapper.wsdlLocation());
        cMapNode.getResDepends().add(resourceDepend);
    }

    private void processWebServiceRef(CMapNode cMapNode, WebServiceRefAnnoWrapper webServiceRefAnnoWrapper, Field field) {
        Object object;
        String string = webServiceRefAnnoWrapper.type();
        ResourceDepend resourceDepend = new ResourceDepend(cMapNode);
        resourceDepend.setType(ResourceNode.ResourceType.WEBSERVICE);
        String string2 = "";
        if (!string.equals("java.lang.Object")) {
            resourceDepend.setTargetResType(string);
            string2 = string.substring(string.lastIndexOf(".") + 1);
        } else if (field instanceof Variable) {
            resourceDepend.setTargetResType(ClassName.getClassName((String)field.getDescriptor()).getExternalName());
            string2 = ClassName.getClassName((String)field.getDescriptor()).getSimpleName();
        } else if (field instanceof Method) {
            object = (Method)field;
            if (!this.isSetter((Method)object)) {
                System.out.println("found @WebServiceRef annotation declared on a non-setter method");
                return;
            }
            ClassName className = ClassName.getClassName((String)((Parameter)object.getParameters().get(0)).getDescriptor());
            resourceDepend.setTargetResType(className.getExternalName());
            string2 = className.getSimpleName();
        }
        if (!webServiceRefAnnoWrapper.name().equals("")) {
            resourceDepend.setTargetResJndiName(webServiceRefAnnoWrapper.name());
        } else if (field instanceof Variable) {
            resourceDepend.setTargetResJndiName(field.getName());
        } else if (field instanceof Method) {
            object = (Method)field;
            if (!this.isSetter((Method)object)) {
                System.out.println("found @WebServiceRef annotation declared on a non-setter method");
                return;
            }
            resourceDepend.setTargetResJndiName(this.getJavaBeanPropName((Method)object));
        }
        object = webServiceRefAnnoWrapper.mappedName();
        if (((String)object).equals("")) {
            resourceDepend.setMappedName(string2);
        } else {
            resourceDepend.setMappedName((String)object);
        }
        resourceDepend.getProps().setProperty("wsdlLocation", webServiceRefAnnoWrapper.wsdlLocation());
        cMapNode.getResDepends().add(resourceDepend);
    }

    private boolean isSimpleEnvEntry(String string) {
        return string.equals(String.class.getName()) || string.equals(Character.class.getName()) || string.equals(Integer.class.getName()) || string.equals(Boolean.class.getName()) || string.equals(Double.class.getName()) || string.equals(Byte.class.getName()) || string.equals(Short.class.getName()) || string.equals(Long.class.getName()) || string.equals(Float.class.getName());
    }

    private boolean isAdminObjectResource(String string) {
        return string.equals("javax.jms.Queue") || string.equals("javax.jms.Topic") || string.equals("javax.jms.Destination");
    }

    private boolean isConnectorResource(String string) {
        return string.equals("javax.jms.ConnectionFactory") || string.equals("javax.jms.QueueConnectionFactory") || string.equals("javax.jms.TopicConnectionFactory") || string.equals("javax.jms.XAQueueConnectionFactory") || string.equals("javax.jms.XATopicConnectionFactory");
    }

    private boolean isJdbcResource(String string) {
        return string.equals("javax.sql.DataSource") || string.equals("javax.sql.XADataSource") || string.equals("javax.sql.ConnectionPoolDataSource");
    }

    private boolean isOtherResource(String string) {
        return true;
    }

    private boolean isSetter(Method method) {
        return method.getName().startsWith("set") && method.getParameters().size() == 1;
    }

    private String getJavaBeanPropName(Method method) {
        String string = method.getName().substring(3, 4).toLowerCase();
        String string2 = method.getName().substring(4);
        return string + string2;
    }
}

