/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.sunresources.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditorSupport;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.compapp.javaee.sunresources.generated.sunresources13.Property;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SunResourcePropertyEditor
extends PropertyEditorSupport {
    private List<Property> propertyList;

    public SunResourcePropertyEditor(List<Property> list) {
        this.propertyList = list;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        PropertyModel propertyModel = new PropertyModel();
        PropertyPanel propertyPanel = new PropertyPanel(propertyModel);
        return propertyPanel;
    }

    private class PropertyModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Property Name", "Property Value"};

        private PropertyModel() {
        }

        public int getRowCount() {
            return SunResourcePropertyEditor.this.propertyList.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            Property property = (Property)SunResourcePropertyEditor.this.propertyList.get(n);
            if (n2 == 0) {
                return property.getName();
            }
            return property.getValue();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 1 || !(object instanceof String)) {
                return;
            }
            Property property = (Property)SunResourcePropertyEditor.this.propertyList.get(n);
            property.setValue((String)object);
            this.fireTableDataChanged();
        }

        public void addRow(String string, String string2) {
            Property property = new Property();
            property.setName(string);
            property.setValue(string2);
            SunResourcePropertyEditor.this.propertyList.add(property);
            this.fireTableDataChanged();
        }

        public void deleteRow(int n) {
            SunResourcePropertyEditor.this.propertyList.remove(n);
            this.fireTableDataChanged();
        }
    }

    private class PropertyPanel
    extends JPanel {
        private PropertyModel model;
        private JTable table;

        public PropertyPanel(PropertyModel propertyModel) {
            super(new BorderLayout());
            this.setPreferredSize(new Dimension(400, 200));
            this.model = propertyModel;
            this.table = new JTable(propertyModel);
            this.table.setSelectionMode(0);
            JScrollPane jScrollPane = new JScrollPane(this.table);
            PopupListener popupListener = new PopupListener();
            this.table.addMouseListener(popupListener);
            jScrollPane.addMouseListener(popupListener);
            this.add(jScrollPane);
        }

        class PopupListener
        extends MouseAdapter {
            PopupListener() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.createPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.createPopup(mouseEvent);
            }

            private void createPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem("Add");
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            PopupListener.this.addItem_performed();
                        }
                    });
                    JMenuItem jMenuItem2 = new JMenuItem("Delete");
                    jMenuItem2.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            PopupListener.this.deleteItem_performed();
                        }
                    });
                    if (PropertyPanel.this.table.getSelectedRow() == -1 || PropertyPanel.this.model.getRowCount() == 0) {
                        jMenuItem2.setEnabled(false);
                    }
                    jPopupMenu.add(jMenuItem);
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(jMenuItem2);
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            private void addItem_performed() {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new GridLayout(2, 2));
                JTextField jTextField = new JTextField();
                jTextField.setPreferredSize(new Dimension(100, 20));
                JTextField jTextField2 = new JTextField();
                jTextField2.setPreferredSize(new Dimension(100, 20));
                jPanel.add(new JLabel("Property Name"));
                jPanel.add(jTextField);
                jPanel.add(new JLabel("Property Value"));
                jPanel.add(jTextField2);
                String string = "Add Property";
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, string, true, 2, NotifyDescriptor.OK_OPTION, 0, null, null);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.setVisible(true);
                if (dialogDescriptor.getValue().equals(NotifyDescriptor.CANCEL_OPTION)) {
                    return;
                }
                PropertyPanel.this.model.addRow(jTextField.getText(), jTextField2.getText());
            }

            private void deleteItem_performed() {
                PropertyPanel.this.model.deleteRow(PropertyPanel.this.table.getSelectedRow());
            }
        }
    }
}

