/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.jbiserver;

import java.awt.Dialog;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.swing.SwingUtilities;
import org.netbeans.modules.compapp.projects.jbi.JbiActionProvider;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.projects.jbi.ui.NoSelectedServerWarning;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.JbiProjectProperties;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerString;
import org.netbeans.modules.j2ee.deployment.impl.ServerTarget;
import org.netbeans.modules.j2ee.deployment.plugins.spi.OptionalDeploymentManagerFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.StartServer;
import org.netbeans.modules.sun.manager.jbi.management.JBIClassLoader;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JbiManager {
    public static final String URL_ATTR = "url";
    public static final String HOSTNAME_ATTR = "hostname";
    public static final String PORT_ATTR = "port";
    public static final String USERNAME_ATTR = "username";
    public static final String PASSWORD_ATTR = "password";
    private static Map<String, JBIClassLoader> loaderMap;

    public static JBIClassLoader getJBIClassLoader(String string) {
        JBIClassLoader jBIClassLoader;
        if (loaderMap == null) {
            loaderMap = new HashMap<String, JBIClassLoader>();
        }
        if ((jBIClassLoader = loaderMap.get(string)) == null) {
            try {
                J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(string);
                if (JbiManager.isAppServer(j2eePlatform)) {
                    jBIClassLoader = new JBIClassLoader(new Empty().getClass().getClassLoader());
                    File[] fileArray = j2eePlatform.getPlatformRoots();
                    for (int i = 0; i < fileArray.length; ++i) {
                        File file = fileArray[i];
                        String string2 = file.getAbsolutePath();
                        File file2 = new File(string2 + "/lib/appserv-rt.jar");
                        if (!file2.exists()) continue;
                        jBIClassLoader.addURL(file2);
                        break;
                    }
                    loaderMap.put(string, jBIClassLoader);
                }
            }
            catch (Exception exception) {
                jBIClassLoader = null;
                exception.printStackTrace(System.out);
            }
        }
        return jBIClassLoader;
    }

    public static boolean isRunningAppServer(JbiProject jbiProject) {
        if (jbiProject == null) {
            return false;
        }
        JbiProjectProperties jbiProjectProperties = jbiProject.getProjectProperties();
        String string = (String)jbiProjectProperties.get("j2ee.server.instance");
        return JbiManager.isRunningAppServer(string);
    }

    public static boolean isRunningAppServer(String string) {
        StartServer startServer;
        if (string == null) {
            return false;
        }
        J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(string);
        if (!JbiManager.isAppServer(j2eePlatform)) {
            return false;
        }
        Properties properties = JbiManager.getServerInstanceProperties(string);
        String string2 = properties.getProperty(URL_ATTR);
        String string3 = properties.getProperty(USERNAME_ATTR);
        String string4 = properties.getProperty(PASSWORD_ATTR);
        String string5 = Deployment.getDefault().getServerID(string);
        if (string2 != null && string3 != null && string4 != null && string5 != null && (startServer = JbiManager.getStartServer(string5, string2, string3, string4)) != null) {
            return startServer.isRunning();
        }
        return false;
    }

    public static void startServer(JbiProject jbiProject, boolean bl) {
        JbiProjectProperties jbiProjectProperties = jbiProject.getProjectProperties();
        String string = (String)jbiProjectProperties.get("j2ee.server.instance");
        assert (string != null);
        JbiManager.startServer(string, bl);
    }

    public static void startServer(String string, boolean bl) {
        assert (!SwingUtilities.isEventDispatchThread()) : "This should not be called from the EDT.";
        if (JbiManager.isRunningAppServer(string)) {
            return;
        }
        ServerInstance serverInstance = null;
        try {
            serverInstance = ServerRegistry.getInstance().getServerInstance(string);
        }
        catch (Exception exception) {
            return;
        }
        if (serverInstance == null) {
            System.out.println("Bad target server ID: " + string);
            return;
        }
        ServerString serverString = new ServerString(serverInstance);
        ServerInstance serverInstance2 = serverString.getServerInstance();
        if (serverString == null || serverInstance2 == null) {
            System.out.println("Make sure a target server is set in project properties.");
        }
        ServerTarget[] serverTargetArray = serverInstance2.getTargets();
        if (bl) {
            while (!JbiManager.isRunningAppServer(string)) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
        }
    }

    public static boolean isSelectedServer(JbiProject jbiProject) {
        String[] stringArray;
        AntProjectHelper antProjectHelper = jbiProject.getAntProjectHelper();
        String string = antProjectHelper.getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
        if (string == null || !JbiManager.isAppServer(string)) {
            stringArray = JbiManager.getAppServers();
            if (stringArray.length < 1) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JbiActionProvider.class, (String)"MSG_NoInstalledServerError"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return false;
            }
            NoSelectedServerWarning noSelectedServerWarning = new NoSelectedServerWarning(stringArray);
            Object[] objectArray = new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION};
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)noSelectedServerWarning, NbBundle.getMessage(NoSelectedServerWarning.class, (String)"CTL_NoSelectedServerWarning_Title"), true, objectArray, objectArray[0], 0, null, null);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() != objectArray[0]) {
                return false;
            }
            string = noSelectedServerWarning.getSelectedInstance();
            if (string != null) {
                JbiProjectProperties jbiProjectProperties = jbiProject.getProjectProperties();
                jbiProjectProperties.put("j2ee.server.instance", string);
                jbiProjectProperties.store();
            }
            dialog.dispose();
        }
        if (string == null) {
            stringArray = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JbiActionProvider.class, (String)"MSG_NoSelectedServerError"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)stringArray);
            return false;
        }
        return true;
    }

    public static Properties getServerInstanceProperties(String string) {
        if (string == null) {
            return null;
        }
        Properties properties = new Properties();
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("/J2EE/InstalledServers");
        FileObject[] fileObjectArray = fileObject.getChildren();
        String string2 = Deployment.getDefault().getServerID(string);
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject2 = fileObjectArray[i];
            String string3 = (String)fileObjectArray[i].getAttribute(URL_ATTR);
            if (string3 == null || !string3.equals(string)) continue;
            String string4 = (String)fileObject2.getAttribute(USERNAME_ATTR);
            String string5 = (String)fileObject2.getAttribute(PASSWORD_ATTR);
            String string6 = string3.substring(string3.lastIndexOf("::") + 2);
            String string7 = string6.substring(0, string6.indexOf(":"));
            String string8 = string6.substring(string6.indexOf(":") + 1);
            properties.put(URL_ATTR, string3);
            properties.put(HOSTNAME_ATTR, string7);
            properties.put(PORT_ATTR, string8);
            properties.put(USERNAME_ATTR, string4);
            properties.put(PASSWORD_ATTR, string5);
            break;
        }
        return properties;
    }

    private static StartServer getStartServer(String string, String string2, String string3, String string4) {
        try {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource("/J2EE/DeploymentPlugins/" + string + "/Factory.instance");
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
            DeploymentFactory deploymentFactory = (DeploymentFactory)instanceCookie.instanceCreate();
            DeploymentManager deploymentManager = deploymentFactory.getDeploymentManager(string2, string3, string4);
            fileObject = fileSystem.findResource("J2EE/DeploymentPlugins/" + string + "/OptionalFactory.instance");
            dataObject = DataObject.find((FileObject)fileObject);
            instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
            OptionalDeploymentManagerFactory optionalDeploymentManagerFactory = (OptionalDeploymentManagerFactory)instanceCookie.instanceCreate();
            StartServer startServer = optionalDeploymentManagerFactory.getStartServer(deploymentManager);
            return startServer;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean isGlassFish(File file) {
        File file2 = new File(file.getAbsolutePath() + "/lib/dtds/sun-web-app_2_5-0.dtd");
        return file2.exists();
    }

    public static boolean appServerInstalled() {
        Deployment deployment = Deployment.getDefault();
        String[] stringArray = deployment.getServerInstanceIDs();
        for (int i = 0; i < stringArray.length; ++i) {
            J2eePlatform j2eePlatform = deployment.getJ2eePlatform(stringArray[i]);
            if (j2eePlatform == null || !JbiManager.isAppServer(j2eePlatform)) continue;
            return true;
        }
        return false;
    }

    public static String[] getAppServers() {
        Deployment deployment = Deployment.getDefault();
        String[] stringArray = deployment.getServerInstanceIDs();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            J2eePlatform j2eePlatform = deployment.getJ2eePlatform(stringArray[i]);
            if (j2eePlatform == null || !JbiManager.isAppServer(j2eePlatform)) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isAppServer(String string) {
        J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(string);
        if (j2eePlatform != null) {
            return JbiManager.isAppServer(j2eePlatform);
        }
        return false;
    }

    static boolean isAppServer(J2eePlatform j2eePlatform) {
        File[] fileArray = j2eePlatform.getClasspathEntries();
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getPath();
            if (string.indexOf("javaee.jar") <= 0 && string.indexOf("j2ee.jar") <= 0) continue;
            return true;
        }
        return false;
    }

    static class Empty {
        Empty() {
        }
    }
}

