/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.api;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.compapp.javaee.util.ProjectUtil;
import org.netbeans.modules.compapp.projects.jbi.api.JbiBindingInfo;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentStatus;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiDefaultComponentInfo {
    public static final String COMP_ID = "id";
    public static final String COMP_NAME = "name";
    public static final String COMP_DESC = "description";
    public static final String COMP_TYPE = "type";
    public static final String COMP_NAMESPACE = "namespace";
    public static final String COMP_ICON = "icon";
    public static final String PROJ_ICON = "projectIcon";
    public static final String FILE_ICON = "fileIcon";
    private static final String OLD_NAME_PREFIX = "com.sun.";
    private static final String NEW_NAME_PREFIX = "sun-";
    public static final String SB_COMP_RESOURCE_NAME = "SeeBeyondJbiComponents";
    public static final String COMP_RESOURCE_NAME = "JbiComponents";
    public static final String WSDLEDITOR_NAME = "WSDLEditor";
    public static final String WSDL_ICON_NAME = "SystemFileSystem.icon";
    private static Logger sLogger = Logger.getLogger(JbiDefaultComponentInfo.class.getName());
    private static JbiDefaultComponentInfo singleton = null;
    private static ChangeSupport changeSupport = null;
    private static LayerFSChangeListener lfsListener = null;
    private List<JBIComponentStatus> componentList = new ArrayList<JBIComponentStatus>();
    private Map<String, JBIComponentStatus> componentMap = new HashMap<String, JBIComponentStatus>();
    private Map<String, URL> bcIconMap = new HashMap<String, URL>();
    private Map<String, JbiBindingInfo> bindingInfoHash = new HashMap<String, JbiBindingInfo>();
    private List<JbiBindingInfo> bindingInfoList = new ArrayList<JbiBindingInfo>();

    private JbiDefaultComponentInfo() {
    }

    protected void init() {
        this.componentList = new ArrayList<JBIComponentStatus>();
        this.componentMap = new HashMap<String, JBIComponentStatus>();
        this.bcIconMap = new HashMap<String, URL>();
        this.bindingInfoHash = new HashMap<String, JbiBindingInfo>();
        this.bindingInfoList = new ArrayList<JbiBindingInfo>();
        try {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource(WSDLEDITOR_NAME);
            JbiDefaultComponentInfo.loadJbiDefaultComponentInfoForSDLEditor(fileObject);
            FileObject fileObject2 = fileSystem.findResource(COMP_RESOURCE_NAME);
            JbiDefaultComponentInfo.loadJbiDefaultComponentInfoFromFileObject(fileObject2);
            FileObject fileObject3 = fileSystem.findResource(SB_COMP_RESOURCE_NAME);
            JbiDefaultComponentInfo.loadJbiDefaultComponentInfoFromFileObject(fileObject3);
        }
        catch (Exception exception) {
            sLogger.log(Level.FINE, exception.getMessage(), exception);
        }
    }

    public static JbiDefaultComponentInfo getJbiDefaultComponentInfo() {
        if (singleton == null) {
            try {
                singleton = new JbiDefaultComponentInfo();
                singleton.init();
                changeSupport = new ChangeSupport((Object)singleton);
                lfsListener = new LayerFSChangeListener();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return singleton;
    }

    private static void loadJbiDefaultComponentInfoForSDLEditor(FileObject fileObject) {
        if (fileObject != null) {
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            DataObject[] dataObjectArray = dataFolder.getChildren();
            for (int i = 0; i < dataObjectArray.length; ++i) {
                String string = dataObjectArray[i].getName();
                if (!string.equalsIgnoreCase("binding")) continue;
                DataObject[] dataObjectArray2 = DataFolder.findFolder((FileObject)dataObjectArray[i].getPrimaryFile()).getChildren();
                for (int j = 0; j < dataObjectArray2.length; ++j) {
                    String string2 = dataObjectArray2[j].getName().toLowerCase();
                    FileObject fileObject2 = dataObjectArray2[i].getPrimaryFile();
                    URL uRL = (URL)fileObject2.getAttribute(WSDL_ICON_NAME);
                    if (uRL == null) continue;
                    JbiDefaultComponentInfo.singleton.bcIconMap.put(string2, uRL);
                }
            }
        }
    }

    private static void loadJbiDefaultComponentInfoFromFileObject(FileObject fileObject) {
        if (fileObject != null) {
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            for (DataObject dataObject : dataFolder.getChildren()) {
                String string = dataObject.getName();
                String string2 = "";
                String string3 = "";
                String string4 = "";
                String string5 = "Installed";
                URL uRL = null;
                URL uRL2 = null;
                ArrayList<String> arrayList = new ArrayList<String>();
                FileObject fileObject2 = dataObject.getPrimaryFile();
                JBIComponentStatus jBIComponentStatus = fileObject2.getAttributes();
                while (jBIComponentStatus.hasMoreElements()) {
                    String string6 = (String)jBIComponentStatus.nextElement();
                    Object object = fileObject2.getAttribute(string6);
                    if (string6.equals(COMP_ID)) {
                        string2 = (String)object;
                        continue;
                    }
                    if (string6.equals(COMP_DESC)) {
                        string3 = (String)object;
                        continue;
                    }
                    if (string6.equals(COMP_TYPE)) {
                        string4 = (String)object;
                        continue;
                    }
                    if (string6.equals(COMP_NAMESPACE)) {
                        arrayList.add((String)object);
                        continue;
                    }
                    if (string6.equals(PROJ_ICON)) {
                        uRL = (URL)object;
                        continue;
                    }
                    if (!string6.equals(FILE_ICON)) continue;
                    uRL2 = (URL)object;
                }
                if ("Binding".equals(string4) && dataObject instanceof DataFolder) {
                    for (JBIComponentStatus jBIComponentStatus2 : ((DataFolder)dataObject).getChildren()) {
                        String string7;
                        FileObject fileObject3 = jBIComponentStatus2.getPrimaryFile();
                        String string8 = fileObject3.getName();
                        int n = string8.indexOf(46);
                        if (n > 0) {
                            string8 = string8.substring(0, n).toLowerCase();
                        }
                        if ((string7 = (String)fileObject3.getAttribute(COMP_NAMESPACE)) == null) continue;
                        arrayList.add(string7);
                        JbiDefaultComponentInfo.addBindingInfo(string2, string8, string3, string7);
                    }
                }
                if (string2.length() <= 0 || JbiDefaultComponentInfo.singleton.componentMap.containsKey(string2)) continue;
                jBIComponentStatus = new JBIComponentStatus(string2, string3, string4, string5, arrayList);
                jBIComponentStatus.setProjectIconURL(uRL);
                jBIComponentStatus.setFileIconURL(uRL2);
                JbiDefaultComponentInfo.singleton.componentList.add(jBIComponentStatus);
                JbiDefaultComponentInfo.singleton.componentMap.put(string2, jBIComponentStatus);
            }
        }
    }

    private static void addBindingInfo(String string, String string2, String string3, String string4) {
        URL uRL = null;
        for (String string5 : JbiDefaultComponentInfo.singleton.bcIconMap.keySet()) {
            if (!string5.startsWith(string2)) continue;
            uRL = JbiDefaultComponentInfo.singleton.bcIconMap.get(string5);
            break;
        }
        if (uRL != null) {
            JbiBindingInfo jbiBindingInfo = new JbiBindingInfo(string, string2, uRL, string3, string4);
            JbiDefaultComponentInfo.singleton.bindingInfoHash.put(string, jbiBindingInfo);
            JbiDefaultComponentInfo.singleton.bindingInfoList.add(jbiBindingInfo);
        }
    }

    public void reload() {
        sLogger.fine("in reloading JbiDefaultComponentInfo......");
        this.init();
        if (changeSupport != null) {
            this.fireChangeEvent();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        changeSupport.removeChangeListener(changeListener);
        changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        sLogger.fine("removing the jbi def comp info change listener...");
        changeSupport.removeChangeListener(changeListener);
    }

    protected void fireChangeEvent() {
        changeSupport.fireChange();
    }

    public List<JBIComponentStatus> getComponentList() {
        return this.componentList;
    }

    public Map<String, JBIComponentStatus> getComponentHash() {
        return this.componentMap;
    }

    public List<JbiBindingInfo> getBindingInfoList() {
        return this.bindingInfoList;
    }

    public JbiBindingInfo getBindingInfo(String string) {
        return this.bindingInfoHash.get(string);
    }

    public static String getDisplayName(String string) {
        int n;
        if (string.startsWith(OLD_NAME_PREFIX)) {
            int n2 = string.indexOf(45);
            if (n2 > 0) {
                return string.substring(OLD_NAME_PREFIX.length(), n2);
            }
        } else if (string.startsWith(NEW_NAME_PREFIX) && (n = string.lastIndexOf(45)) > 0) {
            return string.substring(NEW_NAME_PREFIX.length(), n);
        }
        return string;
    }

    public static boolean isJavaEEProject(Project project) {
        return ProjectUtil.isJavaEEProject(project);
    }

    public static JbiBindingInfo getBindingInfo(Port port) {
        ExtensibilityElement extensibilityElement;
        String string;
        JbiDefaultComponentInfo jbiDefaultComponentInfo = JbiDefaultComponentInfo.getJbiDefaultComponentInfo();
        if (jbiDefaultComponentInfo == null) {
            return null;
        }
        List list = port.getExtensibilityElements();
        if (list.size() > 0 && (string = (extensibilityElement = (ExtensibilityElement)list.get(0)).getQName().getNamespaceURI()) != null) {
            for (JbiBindingInfo jbiBindingInfo : jbiDefaultComponentInfo.getBindingInfoList()) {
                String string2 = jbiBindingInfo.getNameSpace();
                if (!string.equalsIgnoreCase(string2)) continue;
                return jbiBindingInfo;
            }
        }
        return null;
    }

    private static class LayerFSChangeListener {
        private FileChangeListener mFileChangeListener = null;
        private RequestProcessor mReqProcessor = null;
        private Runnable mRunnable;

        public LayerFSChangeListener() {
            this.initRequestProcessor();
            this.initFileChangeAdapter();
            this.registerFileChangeListener();
        }

        private void initRequestProcessor() {
            if (this.mReqProcessor == null) {
                this.mReqProcessor = new RequestProcessor("NewJbiPluginInstalled", 1);
                this.mRunnable = new Runnable(){

                    public void run() {
                        sLogger.fine("Running NewJbiPluginInstalled RequestProcessor");
                        if (singleton != null) {
                            singleton.reload();
                        }
                    }
                };
            }
        }

        private void initFileChangeAdapter() {
            if (this.mFileChangeListener != null) {
                sLogger.fine("Layer FS FileChangeListener already created");
                return;
            }
            this.mFileChangeListener = new FileChangeAdapter(){

                public void fileFolderCreated(FileEvent fileEvent) {
                    LayerFSChangeListener.this.onFileFolderCreated(fileEvent);
                }
            };
        }

        private void onFileFolderCreated(FileEvent fileEvent) {
            boolean bl = false;
            FileObject fileObject = fileEvent.getFile();
            FileObject fileObject2 = fileObject.getParent();
            String string = null;
            if (fileObject2 != null) {
                string = fileObject2.getNameExt();
            }
            if (JbiDefaultComponentInfo.COMP_RESOURCE_NAME.equals(string) || JbiDefaultComponentInfo.SB_COMP_RESOURCE_NAME.equals(string)) {
                bl = true;
            }
            if (bl) {
                int n = 5000;
                sLogger.fine("in LayerFS file folder created. post reload. " + fileEvent.getFile().getNameExt());
                this.mReqProcessor.post(this.mRunnable, n);
            }
        }

        private void registerFileChangeListener() {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            fileSystem.addFileChangeListener(this.mFileChangeListener);
        }
    }
}

