/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntArtifactChooser
extends JPanel
implements PropertyChangeListener {
    private List<String> artifactTypes;
    private JLabel jLabelJarFiles;
    private JLabel jLabelName;
    private JList jListArtifacts;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldName;

    public AntArtifactChooser(List<String> list, JFileChooser jFileChooser) {
        this.artifactTypes = list;
        this.initComponents();
        this.jListArtifacts.setModel(new DefaultListModel());
        jFileChooser.addPropertyChangeListener(this);
    }

    public AntArtifactChooser(String string, JFileChooser jFileChooser) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        this.artifactTypes = arrayList;
        this.initComponents();
        this.jListArtifacts.setModel(new DefaultListModel());
        jFileChooser.addPropertyChangeListener(this);
    }

    private void initComponents() {
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabelJarFiles = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListArtifacts = new JList();
        this.jLabelName.setLabelFor(this.jTextFieldName);
        Mnemonics.setLocalizedText((JLabel)this.jLabelName, (String)NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AACH_ProjectName_JLabel"));
        this.jTextFieldName.setEditable(false);
        this.jTextFieldName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AntArtifactChooser.class, (String)"ACS_AACH_ProjectName_A11YDesc"));
        this.jLabelJarFiles.setLabelFor(this.jListArtifacts);
        Mnemonics.setLocalizedText((JLabel)this.jLabelJarFiles, (String)NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AACH_ProjectJarFiles_JLabel"));
        this.jScrollPane1.setViewportView(this.jListArtifacts);
        this.jListArtifacts.getAccessibleContext().setAccessibleName(NbBundle.getBundle(AntArtifactChooser.class).getString("ACS_AACH_ProjectJarFiles_A11YName"));
        this.jListArtifacts.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AntArtifactChooser.class, (String)"ACS_AACH_ProjectJarFiles_A11YDesc"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabelName).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jTextFieldName, -1, 248, Short.MAX_VALUE).add(12, 12, 12)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabelJarFiles).addContainerGap(176, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 248, Short.MAX_VALUE).add(12, 12, 12)))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabelName).addPreferredGap(0).add((Component)this.jTextFieldName, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabelJarFiles).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 111, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("SelectedFilesChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
            JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
            File[] fileArray = jFileChooser.getSelectedFiles();
            List<Project> list = this.getProjects(fileArray);
            this.populateAccessory(list);
        }
    }

    private List<Project> getProjects(File[] fileArray) {
        ArrayList<Project> arrayList = new ArrayList<Project>();
        if (fileArray == null || fileArray.length == 0) {
            return arrayList;
        }
        try {
            ProjectManager projectManager = ProjectManager.getDefault();
            for (File file : fileArray) {
                Project project;
                FileObject fileObject = FileUtil.toFileObject((File)file);
                if (fileObject == null || (project = projectManager.findProject(fileObject)) == null) continue;
                arrayList.add(project);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList;
    }

    private void populateAccessory(List<Project> list) {
        Object object;
        assert (list != null);
        DefaultListModel defaultListModel = (DefaultListModel)this.jListArtifacts.getModel();
        defaultListModel.clear();
        if (list.size() == 0) {
            this.jTextFieldName.setText("");
        } else if (list.size() == 1) {
            object = ProjectUtils.getInformation((Project)list.get(0)).getDisplayName();
            this.jTextFieldName.setText((String)object);
        } else {
            object = NbBundle.getMessage(AntArtifactChooser.class, (String)"N_PROJECTS", (Object)list.size());
            this.jTextFieldName.setText((String)object);
        }
        for (Project project : list) {
            AntArtifactProvider antArtifactProvider = (AntArtifactProvider)project.getLookup().lookup(AntArtifactProvider.class);
            if (antArtifactProvider == null) continue;
            AntArtifact[] antArtifactArray = antArtifactProvider.getBuildArtifacts();
            Iterator<String> iterator = null;
            if (antArtifactArray == null) continue;
            block1: for (int i = 0; i < antArtifactArray.length; ++i) {
                for (String string : this.artifactTypes) {
                    if (!antArtifactArray[i].getType().startsWith(string)) continue;
                    defaultListModel.addElement(new ArtifactItem(antArtifactArray[i]));
                    continue block1;
                }
            }
        }
    }

    private static void applyFilefilters(JFileChooser jFileChooser, List<FileFilter> list, FileFilter fileFilter) {
        if (list != null) {
            if (fileFilter == null) {
                fileFilter = jFileChooser.getFileFilter();
            }
            for (FileFilter fileFilter2 : list) {
                jFileChooser.addChoosableFileFilter(fileFilter2);
            }
            if (fileFilter != null) {
                jFileChooser.setFileFilter(fileFilter);
            }
        }
    }

    public static AntArtifact[] showDialog(List<String> list, Project project, List<FileFilter> list2, FileFilter fileFilter) {
        Object object;
        JFileChooser jFileChooser = ProjectChooser.projectChooser();
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setDialogTitle(NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AACH_Title"));
        jFileChooser.setApproveButtonText(NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AACH_SelectProject"));
        AntArtifactChooser antArtifactChooser = new AntArtifactChooser(list, jFileChooser);
        jFileChooser.setAccessory(antArtifactChooser);
        if (project != null && (object = project.getProjectDirectory().getParent()) != null) {
            jFileChooser.setCurrentDirectory(FileUtil.toFile((FileObject)object));
        }
        if (list2 != null) {
            AntArtifactChooser.applyFilefilters(jFileChooser, list2, fileFilter);
        }
        if (jFileChooser.showOpenDialog(null) == 0) {
            object = (DefaultListModel)antArtifactChooser.jListArtifacts.getModel();
            AntArtifact[] antArtifactArray = new AntArtifact[((DefaultListModel)object).size()];
            for (int i = 0; i < antArtifactArray.length; ++i) {
                antArtifactArray[i] = ((ArtifactItem)((DefaultListModel)object).getElementAt(i)).getArtifact();
            }
            return antArtifactArray;
        }
        return null;
    }

    public static AntArtifact[] showDialog(String string, Project project) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        return AntArtifactChooser.showDialog(arrayList, project, null, null);
    }

    private static class ArtifactItem {
        private AntArtifact artifact;

        ArtifactItem(AntArtifact antArtifact) {
            this.artifact = antArtifact;
        }

        AntArtifact getArtifact() {
            return this.artifact;
        }

        public String toString() {
            return this.artifact.getArtifactLocations()[0].toString();
        }
    }
}

