/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.test.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JToolBar;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.test.ui.TestCaseResultNode;
import org.netbeans.modules.compapp.test.ui.TestcaseNode;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class DiffTopComponent
extends TopComponent {
    private static final Logger mLogger = Logger.getLogger("org.netbeans.modules.compapp.test.ui.DiffTopComponent");
    private static final ImageIcon FIRST_ICON = new ImageIcon(TestcaseNode.class.getResource("/org/netbeans/modules/compapp/test/ui/resources/first.gif"));
    private static final ImageIcon LAST_ICON = new ImageIcon(TestcaseNode.class.getResource("/org/netbeans/modules/compapp/test/ui/resources/last.gif"));
    private static final ImageIcon PREV_ICON = new ImageIcon(TestcaseNode.class.getResource("/org/netbeans/modules/compapp/test/ui/resources/prev.gif"));
    private static final ImageIcon NEXT_ICON = new ImageIcon(TestcaseNode.class.getResource("/org/netbeans/modules/compapp/test/ui/resources/next.gif"));
    private static final ImageIcon REFRESH_ICON = new ImageIcon(TestcaseNode.class.getResource("/org/netbeans/modules/compapp/test/ui/resources/refresh.gif"));
    private TestcaseNode mTestcaseNode;
    private Action mFirstAct = new DiffAction("First", NbBundle.getMessage(DiffTopComponent.class, (String)"LBL_First"), FIRST_ICON){

        public void actionPerformed(ActionEvent actionEvent) {
            if (DiffTopComponent.this.mDiffView == null || DiffTopComponent.this.mDiffCount == 0) {
                return;
            }
            if (0 < DiffTopComponent.this.mDiffNo) {
                DiffTopComponent.this.mDiffNo = 0;
                DiffTopComponent.this.mDiffView.setCurrentDifference(DiffTopComponent.this.mDiffNo);
                DiffTopComponent.this.refreshButtons();
            }
        }
    };
    private Action mLastAct = new DiffAction("Last", NbBundle.getMessage(DiffTopComponent.class, (String)"LBL_Last"), LAST_ICON){

        public void actionPerformed(ActionEvent actionEvent) {
            if (DiffTopComponent.this.mDiffView == null || DiffTopComponent.this.mDiffCount == 0) {
                return;
            }
            if (DiffTopComponent.this.mDiffNo < DiffTopComponent.this.mDiffCount - 1) {
                DiffTopComponent.this.mDiffNo = DiffTopComponent.this.mDiffCount - 1;
                DiffTopComponent.this.mDiffView.setCurrentDifference(DiffTopComponent.this.mDiffNo);
                DiffTopComponent.this.refreshButtons();
            }
        }
    };
    private Action mNextAct = new DiffAction("Next", NbBundle.getMessage(DiffTopComponent.class, (String)"LBL_Next"), NEXT_ICON){

        public void actionPerformed(ActionEvent actionEvent) {
            if (DiffTopComponent.this.mDiffView == null || DiffTopComponent.this.mDiffCount == 0) {
                return;
            }
            int n = DiffTopComponent.this.mDiffView.getCurrentDifference();
            if (DiffTopComponent.this.mDiffNo < DiffTopComponent.this.mDiffCount - 1) {
                DiffTopComponent.this.mDiffNo++;
                DiffTopComponent.this.mDiffView.setCurrentDifference(DiffTopComponent.this.mDiffNo);
                DiffTopComponent.this.refreshButtons();
            }
        }
    };
    private Action mPrevAct = new DiffAction("Previous", NbBundle.getMessage(DiffTopComponent.class, (String)"LBL_Previous"), PREV_ICON){

        public void actionPerformed(ActionEvent actionEvent) {
            if (DiffTopComponent.this.mDiffView == null || DiffTopComponent.this.mDiffCount == 0) {
                return;
            }
            if (0 < DiffTopComponent.this.mDiffNo) {
                DiffTopComponent.this.mDiffNo--;
                DiffTopComponent.this.mDiffView.setCurrentDifference(DiffTopComponent.this.mDiffNo);
                DiffTopComponent.this.refreshButtons();
            }
        }
    };
    private Action mRefreshAct = new DiffAction("Refresh", NbBundle.getMessage(DiffTopComponent.class, (String)"LBL_Refresh"), REFRESH_ICON){

        public void actionPerformed(ActionEvent actionEvent) {
            DiffTopComponent.this.refreshView(true);
        }
    };
    private JToolBar mToolBar;
    private JLabel mGoToLbl = new JLabel(NbBundle.getMessage(TestcaseNode.class, (String)"LBL_Goto"));
    private JComboBox mDiffComboBox;
    private ActionListener mDiffActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            DiffTopComponent.this.mDiffNo = DiffTopComponent.this.mDiffComboBox.getSelectedIndex();
            DiffTopComponent.this.mDiffView.setCurrentDifference(DiffTopComponent.this.mDiffNo);
            DiffTopComponent.this.refreshButtons();
        }
    };
    private int mDiffCount;
    private int mDiffNo;
    private JComboBox mActualComboBox;
    private ActionListener mActualActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            DiffTopComponent.this.mActualFileName = (String)DiffTopComponent.this.mActualComboBox.getSelectedItem();
            DiffTopComponent.this.refreshView(true);
        }
    };
    private String mActualFileName;
    private DiffView mDiffView;

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DiffTopComponent.class, (String)"ACSN_DiffmToolBar"));
        jToolBar.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DiffTopComponent.class, (String)"ACSD_DiffmToolBar"));
        jToolBar.addSeparator();
        this.mActualComboBox = new JComboBox();
        this.mActualComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string = (String)object;
                String string2 = TestCaseResultNode.getActualResultTimeStamp(string);
                return super.getListCellRendererComponent((JList<?>)jList, string2, n, bl, bl2);
            }
        });
        int n = (int)this.mActualComboBox.getMinimumSize().getHeight();
        this.mActualComboBox.setMinimumSize(new Dimension(60, n));
        this.mActualComboBox.addActionListener(this.mActualActionListener);
        this.mActualComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DiffTopComponent.class, (String)"ACSN_ActualComboBox"));
        this.mActualComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DiffTopComponent.class, (String)"ACSD_ActualComboBox"));
        jToolBar.add(this.mActualComboBox);
        jToolBar.addSeparator();
        jToolBar.add(this.mFirstAct);
        jToolBar.add(this.mPrevAct);
        jToolBar.add(this.mNextAct);
        jToolBar.add(this.mLastAct);
        jToolBar.addSeparator();
        jToolBar.add(this.mGoToLbl);
        this.mDiffComboBox = new JComboBox();
        this.mDiffComboBox.setMinimumSize(new Dimension(30, n));
        this.mDiffComboBox.setMaximumSize(new Dimension(30, n));
        this.mDiffComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DiffTopComponent.class, (String)"ACSN_DiffComboBox"));
        this.mDiffComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DiffTopComponent.class, (String)"ACSD_DiffComboBox"));
        this.mDiffComboBox.addActionListener(this.mDiffActionListener);
        jToolBar.add(this.mDiffComboBox);
        jToolBar.addSeparator();
        jToolBar.add(this.mRefreshAct);
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.setBorderPainted(false);
        return jToolBar;
    }

    private void refreshButtons() {
        this.mFirstAct.setEnabled(this.mDiffNo > 0);
        this.mPrevAct.setEnabled(this.mDiffNo > 0);
        this.mNextAct.setEnabled(this.mDiffNo + 1 < this.mDiffCount);
        this.mLastAct.setEnabled(this.mDiffNo + 1 < this.mDiffCount);
        if (0 < this.mDiffCount) {
            this.mDiffComboBox.removeActionListener(this.mDiffActionListener);
            this.mDiffComboBox.setSelectedIndex(this.mDiffNo);
            this.mDiffComboBox.repaint();
            this.mDiffComboBox.addActionListener(this.mDiffActionListener);
        }
    }

    void refreshView(boolean bl, boolean bl2) {
        if (bl2) {
            this.mActualFileName = null;
        }
        this.refreshView(bl);
    }

    void refreshView(boolean bl, String string) {
        this.mActualFileName = string;
        this.refreshView(bl);
    }

    private void refreshView(boolean bl) {
        try {
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.mToolBar = this.createToolBar();
            List<String> list = this.mTestcaseNode.getSortedResultFileNameList(true);
            int n = list.size();
            this.mActualComboBox.removeActionListener(this.mActualActionListener);
            this.mActualComboBox.removeAllItems();
            for (int i = 0; i < n; ++i) {
                this.mActualComboBox.addItem(list.get(n - i - 1));
            }
            if (this.mActualFileName == null || !list.contains(this.mActualFileName)) {
                this.mActualFileName = n > 0 ? list.get(n - 1) : null;
            }
            if (this.mActualFileName != null) {
                this.mActualComboBox.setSelectedItem(this.mActualFileName);
                this.mActualComboBox.addActionListener(this.mActualActionListener);
                Diff diff = Diff.getDefault();
                StreamSource streamSource = this.mTestcaseNode.getExpectedStreamSource();
                StreamSource streamSource2 = this.mTestcaseNode.getActualStreamSource(this.mActualFileName);
                this.mDiffView = diff.createDiff(streamSource2, streamSource);
                this.mDiffCount = this.mDiffView.getDifferenceCount();
                this.mDiffNo = 0;
                if (this.mDiffCount > 0) {
                    this.mDiffView.setCurrentDifference(this.mDiffNo);
                }
                this.mDiffComboBox.removeActionListener(this.mDiffActionListener);
                this.mDiffComboBox.removeAllItems();
                for (int i = 0; i < this.mDiffCount; ++i) {
                    this.mDiffComboBox.addItem(new Integer(i));
                }
                this.mDiffComboBox.addActionListener(this.mDiffActionListener);
                this.add(this.mDiffView.getComponent(), "Center");
                this.add(this.mToolBar, "North");
                this.refreshButtons();
                this.setFocusable(true);
            }
            if (bl) {
                this.invalidate();
                this.validate();
            }
        }
        catch (Exception exception) {
            mLogger.log(Level.SEVERE, NbBundle.getMessage(TestcaseNode.class, (String)"MSG_Fail_to_setup_diff_view", (Object)this.mTestcaseNode.getName()), exception);
        }
    }

    public DiffTopComponent(TestcaseNode testcaseNode) {
        this.mTestcaseNode = testcaseNode;
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestcaseNode.class, (String)"ACSN_Diff_Top_Component"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestcaseNode.class, (String)"ACSD_Diff_Top_Component"));
        this.refreshView(false);
        JbiProject jbiProject = this.mTestcaseNode.getProject();
        Set set = (Set)jbiProject.getLookup().lookup(Set.class);
        if (set != null) {
            set.add(this);
        }
    }

    public String getDisplayName() {
        return NbBundle.getMessage(TestcaseNode.class, (String)"LBL_Diff_Top_Component", (Object)this.mTestcaseNode.getName());
    }

    public int getPersistenceType() {
        return 2;
    }

    protected void componentClosed() {
        super.componentClosed();
        this.mTestcaseNode.releaseDiffTopComponent();
        JbiProject jbiProject = this.mTestcaseNode.getProject();
        Set set = (Set)jbiProject.getLookup().lookup(Set.class);
        if (set != null && set.contains((Object)this)) {
            set.remove((Object)this);
        }
    }

    protected String preferredID() {
        return "TestcaseDiffTopComponent" + Math.random();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    abstract class DiffAction
    extends AbstractAction {
        public DiffAction(String string, String string2, Icon icon) {
            super(string, icon);
            this.putValue("ShortDescription", string2);
        }
    }
}

