/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.test.ui;

import java.beans.PropertyEditor;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.compapp.test.ui.PropertySpec;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyFileWrapper {
    private static final Logger mLogger = Logger.getLogger("org.netbeans.modules.compapp.projects.jbi.ui.PropertyFileWrapper");
    private List<PropertySpec> mPropertySpecList;
    private FileObject mFileObject;
    private EditableProperties mProperties;
    private Sheet mSheet;

    public PropertyFileWrapper(FileObject fileObject, List<PropertySpec> list) {
        this.mFileObject = fileObject;
        this.mPropertySpecList = list;
        this.mProperties = new EditableProperties(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties() {
        InputStream inputStream = null;
        try {
            this.mProperties.clear();
            inputStream = this.mFileObject.getInputStream();
            this.mProperties.load(inputStream);
        }
        catch (Exception exception) {
            mLogger.log(Level.SEVERE, NbBundle.getMessage(PropertyFileWrapper.class, (String)"LBL_Fail_to_load_properties_from_file", (Object)this.mFileObject.getNameExt()), exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Sheet getSheet() {
        if (this.mSheet != null) {
            return this.mSheet;
        }
        this.loadProperties();
        Sheet sheet = new Sheet();
        Sheet.Set set = null;
        HashMap<String, Sheet.Set> hashMap = new HashMap<String, Sheet.Set>();
        for (PropertySpec propertySpec : this.mPropertySpecList) {
            String string = propertySpec.getCategoryName();
            if (hashMap.containsKey(string)) {
                set = (Sheet.Set)hashMap.get(string);
            } else {
                set = new Sheet.Set();
                set.setName(string);
                set.setDisplayName(propertySpec.getCategoryDisplayName());
                hashMap.put(string, set);
                sheet.put(set);
            }
            set.put((Node.Property)new PropertyWrapper(propertySpec));
        }
        this.mSheet = sheet;
        return sheet;
    }

    class PropertyWrapper
    extends PropertySupport {
        PropertySpec mSpec;
        PropertyEditor mEditor;

        public PropertyWrapper(PropertySpec propertySpec) {
            super(propertySpec.getName(), propertySpec.getType(), propertySpec.getDisplayName(), propertySpec.getShortDescription(), propertySpec.canRead(), propertySpec.canWrite());
            this.mSpec = propertySpec;
            this.mEditor = this.mSpec.hasEditorType() ? this.mSpec.getPropertyEditor() : super.getPropertyEditor();
        }

        public Object getValue() {
            String string = PropertyFileWrapper.this.mProperties.getProperty(this.mSpec.getName());
            if (string == null) {
                return this.mSpec.getDefaultValue();
            }
            Class clazz = this.mSpec.getType();
            if (string != null && clazz != String.class) {
                if (clazz == Boolean.class) {
                    return new Boolean(string);
                }
                if (clazz == Integer.class) {
                    return new Integer(string);
                }
                if (clazz == Double.class) {
                    return new Double(string);
                }
                if (clazz == Long.class) {
                    return new Long(string);
                }
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object object) {
            try {
                PropertyFileWrapper.this.mProperties.put(this.mSpec.getName(), object.toString());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PropertyFileWrapper.this.mProperties.store((OutputStream)byteArrayOutputStream);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                FileLock fileLock = PropertyFileWrapper.this.mFileObject.lock();
                OutputStream outputStream = PropertyFileWrapper.this.mFileObject.getOutputStream(fileLock);
                try {
                    outputStream.write(byArray);
                }
                finally {
                    outputStream.close();
                    fileLock.releaseLock();
                }
            }
            catch (Exception exception) {
                mLogger.log(Level.SEVERE, NbBundle.getMessage(PropertyFileWrapper.class, (String)"LBL_Fail_to_set_property", (Object)(this.mSpec.getCategoryName() + "." + this.mSpec.getName())), exception);
            }
        }

        public PropertyEditor getPropertyEditor() {
            return this.mEditor;
        }
    }
}

