/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.test.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.compapp.projects.jbi.api.JbiBindingInfo;
import org.netbeans.modules.compapp.projects.jbi.api.JbiDefaultComponentInfo;
import org.netbeans.modules.compapp.test.ui.wizards.NewTestcaseOperationWizardPanel;
import org.netbeans.modules.compapp.test.ui.wizards.NewTestcaseWsdlVisualPanel;
import org.netbeans.modules.compapp.test.wsdl.Util;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class NewTestcaseOperationVisualPanel
extends JPanel {
    private JScrollPane mScrollPanel;
    private JTree mTree;
    private NewTestcaseOperationWizardPanel mPanel;
    private WSDLModel wsdlModel;
    private JLabel jLabelOperations;
    private JLabel jLabelSelectedOperation;
    private JPanel jPanel1;
    private JTextField jTextFieldSelectedOperation;

    public NewTestcaseOperationVisualPanel(NewTestcaseOperationWizardPanel newTestcaseOperationWizardPanel) {
        this.mPanel = newTestcaseOperationWizardPanel;
        this.initComponents();
        this.mScrollPanel = new JScrollPane();
        this.mTree = new JTree();
        this.mTree.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewTestcaseWsdlVisualPanel.class, (String)"ACS_OperationTree_A11YName"));
        final TreeSelectionModel treeSelectionModel = this.mTree.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        treeSelectionModel.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                BindingOperation bindingOperation = NewTestcaseOperationVisualPanel.this.getSelectedBindingOperation();
                try {
                    NewTestcaseOperationVisualPanel.this.jTextFieldSelectedOperation.setText(bindingOperation == null ? "" : NewTestcaseOperationVisualPanel.getOperationSignature(bindingOperation));
                    NewTestcaseOperationVisualPanel.this.mPanel.fireChangeEvent();
                }
                catch (Exception exception) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)exception.getMessage(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    treeSelectionModel.clearSelection();
                }
            }
        });
        this.mTree.setRootVisible(false);
        this.mTree.setEditable(false);
        ToolTipManager.sharedInstance().registerComponent(this.mTree);
        this.mTree.setCellRenderer(new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                Object object2 = defaultMutableTreeNode.getUserObject();
                if (object2 instanceof Port) {
                    Port port = (Port)object2;
                    Binding binding = (Binding)port.getBinding().get();
                    String string = port.getName() + " (" + "Binding=\"" + binding.getName() + "\")";
                    jLabel.setText(string);
                    JbiBindingInfo jbiBindingInfo = JbiDefaultComponentInfo.getBindingInfo(port);
                    if (jbiBindingInfo != null) {
                        jLabel.setToolTipText("binding type: " + jbiBindingInfo.getBindingType());
                    } else {
                        jLabel.setToolTipText(null);
                    }
                } else if (object2 instanceof BindingOperation) {
                    jLabel.setText(((BindingOperation)object2).getName());
                    jLabel.setToolTipText(null);
                }
                return jLabel;
            }
        });
        this.mScrollPanel.setViewportView(this.mTree);
        this.jLabelOperations.setLabelFor(this.mTree);
        GroupLayout groupLayout = (GroupLayout)this.jPanel1.getLayout();
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.mScrollPanel, -1, 400, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.mScrollPanel, -1, 275, Short.MAX_VALUE));
    }

    public String getName() {
        return NbBundle.getMessage(NewTestcaseOperationVisualPanel.class, (String)"LBL_Select_the_operation_to_test");
    }

    public void setWsdlModel(WSDLModel wSDLModel) {
        if (this.wsdlModel == wSDLModel) {
            return;
        }
        this.wsdlModel = wSDLModel;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        for (Port port : Util.getSortedPorts(wSDLModel)) {
            Binding binding = (Binding)port.getBinding().get();
            List<BindingOperation> list = Util.getSortedBindingOperations(binding);
            if (list == null || list.size() <= 0) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(port);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            for (BindingOperation bindingOperation : list) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(bindingOperation);
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                defaultMutableTreeNode3.setAllowsChildren(false);
            }
        }
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.mTree.setModel(defaultTreeModel);
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.mTree.expandPath(new TreePath(((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i)).getPath()));
        }
    }

    private Port getSelectedPort() {
        Object object = this.mTree.getLastSelectedPathComponent();
        if (object == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        if (defaultMutableTreeNode.getUserObject() instanceof BindingOperation) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            return (Port)defaultMutableTreeNode2.getUserObject();
        }
        return null;
    }

    public Binding getSelectedBinding() {
        Port port = this.getSelectedPort();
        if (port != null) {
            return (Binding)port.getBinding().get();
        }
        return null;
    }

    public BindingOperation getSelectedBindingOperation() {
        Object object;
        Object object2 = this.mTree.getLastSelectedPathComponent();
        if (object2 != null && (object = ((DefaultMutableTreeNode)object2).getUserObject()) instanceof BindingOperation) {
            return (BindingOperation)object;
        }
        return null;
    }

    public JTree getBindingTree() {
        return this.mTree;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabelSelectedOperation = new JLabel();
        this.jTextFieldSelectedOperation = new JTextField();
        this.jLabelOperations = new JLabel();
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 255, Short.MAX_VALUE));
        this.jLabelSelectedOperation.setLabelFor(this.jTextFieldSelectedOperation);
        Mnemonics.setLocalizedText((JLabel)this.jLabelSelectedOperation, (String)NbBundle.getMessage(NewTestcaseOperationVisualPanel.class, (String)"LBL_The_operation_selected"));
        this.jTextFieldSelectedOperation.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabelOperations, (String)"Binding &Operations:");
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.jLabelSelectedOperation).addPreferredGap(0).add((Component)this.jTextFieldSelectedOperation, -1, 297, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.jLabelOperations).addContainerGap()).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.jLabelOperations).addPreferredGap(0).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jLabelSelectedOperation).add((Component)this.jTextFieldSelectedOperation, -2, -1, -2))));
        this.jLabelSelectedOperation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewTestcaseOperationVisualPanel.class, (String)"ACS_SELECTED_OPERATION_LABEL"));
        this.jLabelOperations.getAccessibleContext().setAccessibleName("Binding Operations:");
        this.jLabelOperations.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewTestcaseOperationVisualPanel.class, (String)"ACS_BINDING_OPERATIONS"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewTestcaseOperationVisualPanel.class, (String)"ACS_NewTestcaseOperationVisualPanel_A11YDesc"));
    }

    private static String getOperationSignature(BindingOperation bindingOperation) {
        Operation operation = (Operation)bindingOperation.getOperation().get();
        if (operation == null) {
            String string = NbBundle.getMessage(NewTestcaseOperationVisualPanel.class, (String)"MSG_MISSING_OPERATION_FOR_BINDING_OPERATION", (Object)bindingOperation.getName());
            throw new RuntimeException(string);
        }
        Input input = operation.getInput();
        Output output = operation.getOutput();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(operation.getName() + "(");
        if (input != null) {
            stringBuffer.append(input.getMessage().getQName().getLocalPart());
        }
        stringBuffer.append("): ");
        if (output != null) {
            stringBuffer.append(output.getMessage().getQName().getLocalPart());
        } else {
            stringBuffer.append("void");
        }
        return stringBuffer.toString();
    }
}

