/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.test.wsdl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.netbeans.modules.compapp.test.wsdl.BindingSupport;
import org.netbeans.modules.compapp.test.wsdl.SampleXmlUtil;
import org.netbeans.modules.compapp.test.wsdl.SoapBindingOperationSupport;
import org.netbeans.modules.compapp.test.wsdl.Util;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPAddress;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBody;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPHeader;
import org.openide.util.NbBundle;

public class SoapBindingSupport
implements BindingSupport {
    private static final Logger mLog = Logger.getLogger("org.netbeans.modules.compapp.test.wsdl.SoapBindingSupport");
    private final QName mEnvelopeQName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
    private final QName mBodyQName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body");
    private final QName mHeaderQName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Header");
    private final ResourceBundle mRb = ResourceBundle.getBundle("org.netbeans.modules.compapp.test.wsdl.Bundle");
    private Binding mBinding;
    private Definitions mDefinition;
    private SchemaTypeLoader mSchemaTypeLoader;

    public SoapBindingSupport(Binding binding, Definitions definitions, SchemaTypeLoader schemaTypeLoader) {
        this.mBinding = binding;
        this.mDefinition = definitions;
        this.mSchemaTypeLoader = schemaTypeLoader;
    }

    public String[] getEndpoints() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Service service : this.mDefinition.getServices()) {
            for (Port port : service.getPorts()) {
                List list;
                SOAPAddress sOAPAddress;
                if (port.getBinding().get() != this.mBinding || (sOAPAddress = (SOAPAddress)Util.getAssignableExtensiblityElement(list = port.getExtensibilityElements(), SOAPAddress.class)) == null) continue;
                arrayList.add(sOAPAddress.getLocation());
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String buildRequest(BindingOperation bindingOperation, Map map) throws Exception {
        boolean bl = false;
        Object v = map.get("buildOptional");
        bl = v == null ? false : (Boolean)v;
        SoapBindingOperationSupport soapBindingOperationSupport = new SoapBindingOperationSupport(this.mBinding, bindingOperation);
        boolean bl2 = soapBindingOperationSupport.isInputSoapEncoded();
        SampleXmlUtil sampleXmlUtil = new SampleXmlUtil(bl2);
        sampleXmlUtil.setIgnoreOptional(!bl);
        XmlObject xmlObject = XmlObject.Factory.newInstance();
        XmlCursor xmlCursor = xmlObject.newCursor();
        xmlCursor.toNextToken();
        xmlCursor.beginElement(this.mEnvelopeQName);
        xmlCursor.insertNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xmlCursor.insertNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        xmlCursor.insertAttributeWithValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance", "http://schemas.xmlsoap.org/soap/envelope/ http://schemas.xmlsoap.org/soap/envelope/");
        xmlCursor.toFirstChild();
        xmlCursor.beginElement(this.mBodyQName);
        xmlCursor.toFirstChild();
        if (soapBindingOperationSupport.isRpc()) {
            this.buildRpcRequest(soapBindingOperationSupport, xmlCursor, sampleXmlUtil);
        } else {
            this.buildDocumentRequest(soapBindingOperationSupport, xmlCursor, sampleXmlUtil);
        }
        this.addHeaders(bindingOperation, xmlCursor, sampleXmlUtil);
        xmlCursor.dispose();
        try {
            return Util.getPrettyText(xmlObject);
        }
        catch (Exception exception) {
            return xmlObject.xmlText();
        }
    }

    private void addHeaders(BindingOperation bindingOperation, XmlCursor xmlCursor, SampleXmlUtil sampleXmlUtil) throws Exception {
        List list = bindingOperation.getBindingInput().getExtensibilityElements();
        List<ExtensibilityElement> list2 = Util.getAssignableExtensiblityElementList(list, SOAPHeader.class);
        if (list2.isEmpty()) {
            return;
        }
        xmlCursor.toStartDoc();
        xmlCursor.toChild(this.mEnvelopeQName);
        xmlCursor.toFirstChild();
        xmlCursor.beginElement(this.mHeaderQName);
        xmlCursor.toFirstChild();
        int n = list2.size();
        block0: for (int i = 0; i < n; ++i) {
            SOAPHeader sOAPHeader = (SOAPHeader)list2.get(i);
            String string = ((Message)sOAPHeader.getMessage().get()).getName();
            String string2 = sOAPHeader.getPart();
            for (Message message : this.mDefinition.getMessages()) {
                if (!message.getName().equals(string)) continue;
                for (Part part : message.getParts()) {
                    if (!part.getName().equals(string2)) continue;
                    if (part != null) {
                        this.createElementForPart(part, xmlCursor, sampleXmlUtil);
                        continue block0;
                    }
                    mLog.log(Level.SEVERE, NbBundle.getMessage(SoapBindingSupport.class, (String)"LBL_Header_has_missing_part", (Object)string2));
                    continue block0;
                }
            }
        }
    }

    private void createElementForPart(Part part, XmlCursor xmlCursor, SampleXmlUtil sampleXmlUtil) throws Exception {
        if (part.getElement() != null) {
            QName qName = part.getElement().getQName();
            xmlCursor.beginElement(qName);
            SchemaGlobalElement schemaGlobalElement = this.mSchemaTypeLoader.findElement(qName);
            if (schemaGlobalElement != null) {
                xmlCursor.toFirstChild();
                sampleXmlUtil.createSampleForType(schemaGlobalElement.getType(), xmlCursor);
            }
            xmlCursor.toParent();
        } else {
            QName qName = part.getType().getQName();
            xmlCursor.beginElement(new QName(this.mDefinition.getTargetNamespace(), part.getName()));
            SchemaType schemaType = this.mSchemaTypeLoader.findType(qName);
            if (schemaType != null) {
                xmlCursor.toFirstChild();
                sampleXmlUtil.createSampleForType(schemaType, xmlCursor);
            }
            xmlCursor.toParent();
        }
    }

    private void buildDocumentRequest(SoapBindingOperationSupport soapBindingOperationSupport, XmlCursor xmlCursor, SampleXmlUtil sampleXmlUtil) throws Exception {
        Part[] partArray = soapBindingOperationSupport.getInputParts();
        if (partArray.length > 1) {
            mLog.log(Level.SEVERE, NbBundle.getMessage(SoapBindingSupport.class, (String)"LBL_Document_style_operation_cannot_have_more_than_one_part"));
        }
        for (int i = 0; i < partArray.length; ++i) {
            XmlCursor xmlCursor2 = xmlCursor.newCursor();
            xmlCursor2.toLastChild();
            this.createElementForPart(partArray[i], xmlCursor2, sampleXmlUtil);
            xmlCursor2.dispose();
        }
    }

    private void buildRpcRequest(SoapBindingOperationSupport soapBindingOperationSupport, XmlCursor xmlCursor, SampleXmlUtil sampleXmlUtil) throws Exception {
        BindingOperation bindingOperation = soapBindingOperationSupport.getBindingOperation();
        List list = bindingOperation.getBindingInput().getExtensibilityElements();
        SOAPBody sOAPBody = (SOAPBody)Util.getAssignableExtensiblityElement(list, SOAPBody.class);
        String string = this.mDefinition.getTargetNamespace();
        if (sOAPBody != null && sOAPBody.getNamespace() != null) {
            string = sOAPBody.getNamespace();
        }
        xmlCursor.beginElement(new QName(string, bindingOperation.getName()));
        if (sampleXmlUtil.isSoapEnc()) {
            xmlCursor.insertAttributeWithValue(new QName("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"), "http://schemas.xmlsoap.org/soap/encoding/");
        }
        Part[] partArray = soapBindingOperationSupport.getInputParts();
        for (int i = 0; i < partArray.length; ++i) {
            Part part = partArray[i];
            XmlCursor xmlCursor2 = xmlCursor.newCursor();
            xmlCursor2.toLastChild();
            xmlCursor2.insertElement(part.getName());
            xmlCursor2.toPrevToken();
            if (part.getType() != null && part.getType().getQName() != null) {
                SchemaType schemaType = this.mSchemaTypeLoader.findType(part.getType().getQName());
                sampleXmlUtil.createSampleForType(schemaType, xmlCursor2);
            } else if (part.getElement() != null) {
                this.createElementForPart(part, xmlCursor2, sampleXmlUtil);
            } else {
                mLog.log(Level.SEVERE, NbBundle.getMessage(SoapBindingSupport.class, (String)"LBL_Type_cannot_be_found", (Object)part.getType().getQName()));
            }
            xmlCursor2.dispose();
        }
    }
}

