/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.test.wsdl;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final Logger mLog = Logger.getLogger("org.netbeans.modules.compapp.test.wsdl.Util");

    public static ExtensibilityElement getAssignableExtensiblityElement(List<ExtensibilityElement> list, Class clazz) {
        List<ExtensibilityElement> list2 = Util.getAssignableExtensiblityElementList(list, clazz);
        return list2.size() > 0 ? list2.get(0) : null;
    }

    public static List<ExtensibilityElement> getAssignableExtensiblityElementList(List<ExtensibilityElement> list, Class clazz) {
        ArrayList<ExtensibilityElement> arrayList = new ArrayList<ExtensibilityElement>();
        for (ExtensibilityElement extensibilityElement : list) {
            if (!clazz.isAssignableFrom(extensibilityElement.getClass())) continue;
            arrayList.add(extensibilityElement);
        }
        return arrayList;
    }

    public static String getPrettyText(XmlObject xmlObject) throws Exception {
        StringWriter stringWriter = new StringWriter();
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setSavePrettyPrint();
        xmlOptions.setSavePrettyPrintIndent(2);
        xmlOptions.setSaveNoXmlDecl();
        xmlOptions.setSaveAggressiveNamespaces();
        xmlObject.save((Writer)stringWriter, xmlOptions);
        return stringWriter.toString();
    }

    private static void getBindings(WSDLModel wSDLModel, boolean bl, Collection<Binding> collection) {
        Definitions definitions = wSDLModel.getDefinitions();
        collection.addAll(definitions.getBindings());
        if (bl) {
            for (Import import_ : definitions.getImports()) {
                try {
                    WSDLModel wSDLModel2 = import_.getImportedWSDLModel();
                    Util.getBindings(wSDLModel2, bl, collection);
                }
                catch (CatalogModelException catalogModelException) {
                    Exceptions.printStackTrace((Throwable)catalogModelException);
                }
            }
        }
    }

    public static List<Binding> getSortedBindings(WSDLModel wSDLModel) {
        ArrayList<Binding> arrayList = new ArrayList<Binding>();
        Util.getBindings(wSDLModel, true, arrayList);
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Binding)object).getName().compareTo(((Binding)object2).getName());
            }

            public boolean equals(Object object) {
                return this == object;
            }
        });
        return arrayList;
    }

    private static void getPorts(WSDLModel wSDLModel, boolean bl, Collection<Port> collection) {
        Definitions definitions = wSDLModel.getDefinitions();
        for (Service service : definitions.getServices()) {
            collection.addAll(service.getPorts());
        }
        if (bl) {
            for (Service service : definitions.getImports()) {
                try {
                    WSDLModel wSDLModel2 = service.getImportedWSDLModel();
                    Util.getPorts(wSDLModel2, bl, collection);
                }
                catch (CatalogModelException catalogModelException) {
                    Exceptions.printStackTrace((Throwable)catalogModelException);
                }
            }
        }
    }

    public static List<Port> getSortedPorts(WSDLModel wSDLModel) {
        ArrayList<Port> arrayList = new ArrayList<Port>();
        Util.getPorts(wSDLModel, true, arrayList);
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Port)object).getName().compareTo(((Port)object2).getName());
            }

            public boolean equals(Object object) {
                return this == object;
            }
        });
        return arrayList;
    }

    public static List<BindingOperation> getSortedBindingOperations(Binding binding) {
        ArrayList<BindingOperation> arrayList = new ArrayList<BindingOperation>(binding.getBindingOperations());
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((BindingOperation)object).getName().compareTo(((BindingOperation)object2).getName());
            }

            public boolean equals(Object object) {
                return this == object;
            }
        });
        return arrayList;
    }
}

