/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates.textsync;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.codetemplates.textsync.TextRegion;
import org.netbeans.lib.editor.codetemplates.textsync.TextRegionManager;
import org.netbeans.lib.editor.codetemplates.textsync.TextSync;
import org.netbeans.lib.editor.codetemplates.textsync.TextSyncGroup;
import org.netbeans.lib.editor.codetemplates.textsync.TextSyncGroupEditingNotify;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;

public final class TextRegionEditing {
    static final Logger LOG = Logger.getLogger(TextRegionEditing.class.getName());
    private static final TextSyncGroupEditingNotify EMPTY_GROUP_EDITING = new TextSyncGroupEditingNotify(){

        public void deactivated(TextRegionEditing textRegionEditing, TextSync textSync) {
        }

        public void released(TextRegionEditing textRegionEditing) {
        }

        public void textSyncActivated(TextRegionEditing textRegionEditing, int n) {
        }

        public void textSyncModified(TextRegionEditing textRegionEditing) {
        }
    };
    private JTextComponent component;
    private Stack<GroupEditing> groupEditings;
    private Highlighting highlighting;
    private boolean overridingKeys;
    private ActionMap origActionMap;

    public static TextRegionEditing get(JTextComponent jTextComponent) {
        TextRegionEditing textRegionEditing = (TextRegionEditing)jTextComponent.getClientProperty(TextRegionEditing.class);
        if (textRegionEditing == null) {
            textRegionEditing = new TextRegionEditing(jTextComponent);
            jTextComponent.putClientProperty(TextRegionEditing.class, textRegionEditing);
        }
        return textRegionEditing;
    }

    private TextRegionEditing(JTextComponent jTextComponent) {
        this.component = jTextComponent;
        this.component.addPropertyChangeListener(DocChangeListener.INSTANCE);
        this.highlighting = new Highlighting(this);
        this.groupEditings = new Stack();
    }

    public void startGroupEditing(TextSyncGroup textSyncGroup, TextSyncGroupEditingNotify textSyncGroupEditingNotify) {
        GroupEditing groupEditing;
        if (textSyncGroup == null) {
            throw new IllegalArgumentException("textSyncGroup cannot be null");
        }
        if (textSyncGroup.textRegionManager() != this.textRegionManager()) {
            throw new IllegalArgumentException("textSyncGroup=" + textSyncGroup + " does not belong to textRegionManager=" + this.textRegionManager());
        }
        if (textSyncGroupEditingNotify == null) {
            textSyncGroupEditingNotify = EMPTY_GROUP_EDITING;
        }
        if ((groupEditing = this.activeGroupEditing()) != null) {
            groupEditing.notify.deactivated(this, groupEditing.activeTextSync());
        }
        this.groupEditings.push(new GroupEditing(textSyncGroup, textSyncGroupEditingNotify));
        this.activateTextSync(this.findEditableTextSyncIndex(0, 1, true, false), true);
    }

    public void stopGroupEditing(TextSyncGroup textSyncGroup) {
        if (this.activeTextSyncGroup() == textSyncGroup) {
            this.releaseActiveGroup(false);
        }
    }

    public TextSyncGroup activeTextSyncGroup() {
        GroupEditing groupEditing = this.activeGroupEditing();
        return groupEditing != null ? groupEditing.group : null;
    }

    public int activeTextSyncIndex() {
        GroupEditing groupEditing = this.activeGroupEditing();
        return groupEditing != null ? groupEditing.activeTextSyncIndex : -1;
    }

    public TextSync activeTextSync() {
        GroupEditing groupEditing = this.activeGroupEditing();
        return groupEditing != null ? groupEditing.activeTextSync() : null;
    }

    public JTextComponent component() {
        return this.component;
    }

    int findEditableTextSyncIndex(int n, int n2, boolean bl, boolean bl2) {
        TextSyncGroup textSyncGroup = this.activeTextSyncGroup();
        int n3 = textSyncGroup.textSyncsModifiable().size();
        if (n3 == 0) {
            return -1;
        }
        int n4 = -1;
        do {
            TextSync textSync;
            if (n >= n3) {
                if (!bl) break;
                n = 0;
            } else if (n < 0) {
                if (!bl) break;
                n = n3 - 1;
            }
            if (n4 == -1) {
                n4 = n;
            }
            if (!(textSync = textSyncGroup.textSyncs().get(n)).isEditable() && (bl2 || !textSync.isCaretMarker())) continue;
            return n;
        } while ((n += n2) != n4);
        return -1;
    }

    private void activateTextSync(int n, boolean bl) {
        if (n == -1) {
            this.releaseActiveGroup(false);
        } else {
            GroupEditing groupEditing = this.activeGroupEditing();
            int n2 = groupEditing.activeTextSyncIndex;
            groupEditing.activeTextSyncIndex = n;
            TextSync textSync = groupEditing.activeTextSync();
            if (textSync.isCaretMarker()) {
                int n3 = textSync.regions().get(0).startOffset();
                this.component.setCaretPosition(n3);
                this.releaseActiveGroup(false);
            } else {
                this.textRegionManager().setActiveTextSync(textSync, new TextRegionManager.EditingNotify(){

                    public void modified(DocumentEvent documentEvent) {
                        TextRegionEditing.this.docActiveTextSyncModified();
                    }

                    public void outsideModified(DocumentEvent documentEvent) {
                        TextRegionEditing.this.docActiveTextSyncReleased();
                    }
                });
                ((BaseTextUI)this.component.getUI()).getEditorUI().getWordMatch().clear();
                if (bl) {
                    TextRegion textRegion = textSync.masterRegion();
                    this.component.select(textRegion.startOffset(), textRegion.endOffset());
                }
                groupEditing.notify.textSyncActivated(this, n2);
                if (!this.overridingKeys) {
                    this.overridingKeys = true;
                    this.component.addKeyListener(OverrideKeysListener.INSTANCE);
                    this.origActionMap = OverrideAction.installOverrideActionMap(this.component);
                }
            }
        }
        this.highlighting.requestRepaint();
    }

    void docActiveTextSyncModified() {
        GroupEditing groupEditing = this.activeGroupEditing();
        groupEditing.notify.textSyncModified(this);
        this.highlighting.requestRepaint();
    }

    void docActiveTextSyncReleased() {
        this.stopSyncEditing();
    }

    private void releaseActiveGroup(boolean bl) {
        if (!this.groupEditings.isEmpty()) {
            GroupEditing groupEditing = this.groupEditings.pop();
            this.textRegionManager().clearActiveTextSync();
            groupEditing.notify.released(this);
            if ((this.groupEditings.isEmpty() || bl) && this.overridingKeys) {
                this.overridingKeys = false;
                this.component.removeKeyListener(OverrideKeysListener.INSTANCE);
                this.component.setActionMap(this.origActionMap);
            }
            if (bl) {
                while (!this.groupEditings.isEmpty()) {
                    groupEditing = this.groupEditings.pop();
                    groupEditing.notify.released(this);
                }
            } else {
                groupEditing = this.activeGroupEditing();
                if (groupEditing != null) {
                    this.activateTextSync(groupEditing.activeTextSyncIndex, false);
                }
            }
        }
        this.highlighting.requestRepaint();
    }

    private void stopSyncEditing() {
        this.releaseActiveGroup(true);
    }

    private GroupEditing activeGroupEditing() {
        return this.groupEditings.empty() ? null : this.groupEditings.peek();
    }

    boolean enterAction() {
        TextRegion textRegion = this.activeTextSync().validMasterRegion();
        if (textRegion.startOffset() <= this.component.getCaretPosition() && this.component.getCaretPosition() <= textRegion.endOffset()) {
            this.activateTextSync(this.findEditableTextSyncIndex(this.activeGroupEditing().activeTextSyncIndex + 1, 1, false, false), true);
            return true;
        }
        this.releaseActiveGroup(false);
        return false;
    }

    void escapeAction() {
        this.releaseActiveGroup(false);
    }

    void tabAction() {
        int n = this.findEditableTextSyncIndex(this.activeGroupEditing().activeTextSyncIndex + 1, 1, true, true);
        if (n != -1) {
            this.activateTextSync(n, true);
        }
    }

    void shiftTabAction() {
        int n = this.findEditableTextSyncIndex(this.activeGroupEditing().activeTextSyncIndex - 1, -1, true, true);
        if (n != -1) {
            this.activateTextSync(n, true);
        }
    }

    TextRegionManager textRegionManager() {
        return TextRegionManager.get(this.component.getDocument());
    }

    boolean isActive() {
        return !this.groupEditings.isEmpty();
    }

    Document document() {
        return this.component.getDocument();
    }

    private static final class Highlighting {
        private static final String BAG_DOC_PROPERTY = TextRegionEditing.class.getName() + "-OffsetsBag";
        private TextRegionEditing textRegionEditing;
        private AttributeSet attribs = null;
        private AttributeSet attribsLeft = null;
        private AttributeSet attribsRight = null;
        private AttributeSet attribsMiddle = null;
        private AttributeSet attribsAll = null;

        Highlighting(TextRegionEditing textRegionEditing) {
            this.textRegionEditing = textRegionEditing;
        }

        void requestRepaint() {
            TextRegion textRegion;
            Document document = this.textRegionEditing.document();
            TextSync textSync = this.textRegionEditing.activeTextSync();
            if (textSync != null && (textRegion = textSync.masterRegion()) != null) {
                Object object;
                if (this.attribs == null) {
                    this.attribs = Highlighting.getSyncedTextBlocksHighlight();
                    object = (Color)this.attribs.getAttribute(StyleConstants.Foreground);
                    Color color = (Color)this.attribs.getAttribute(StyleConstants.Background);
                    this.attribsLeft = Highlighting.createAttribs(StyleConstants.Background, color, EditorStyleConstants.LeftBorderLineColor, object, EditorStyleConstants.TopBorderLineColor, object, EditorStyleConstants.BottomBorderLineColor, object);
                    this.attribsRight = Highlighting.createAttribs(StyleConstants.Background, color, EditorStyleConstants.RightBorderLineColor, object, EditorStyleConstants.TopBorderLineColor, object, EditorStyleConstants.BottomBorderLineColor, object);
                    this.attribsMiddle = Highlighting.createAttribs(StyleConstants.Background, color, EditorStyleConstants.TopBorderLineColor, object, EditorStyleConstants.BottomBorderLineColor, object);
                    this.attribsAll = Highlighting.createAttribs(StyleConstants.Background, color, EditorStyleConstants.LeftBorderLineColor, object, EditorStyleConstants.RightBorderLineColor, object, EditorStyleConstants.TopBorderLineColor, object, EditorStyleConstants.BottomBorderLineColor, object);
                }
                object = new OffsetsBag(document);
                try {
                    int n = textRegion.startOffset();
                    int n2 = textRegion.endOffset();
                    int n3 = Utilities.getLineOffset((BaseDocument)((BaseDocument)document), (int)n);
                    int n4 = Utilities.getLineOffset((BaseDocument)((BaseDocument)document), (int)n2);
                    for (int i = n3; i <= n4; ++i) {
                        int n5 = Math.max(Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)document), (int)i), n);
                        int n6 = Math.min(Utilities.getRowEnd((BaseDocument)((BaseDocument)document), (int)n5), n2);
                        int n7 = n6 - n5;
                        if (n7 == 1) {
                            object.addHighlight(n5, n6, this.attribsAll);
                            continue;
                        }
                        if (n7 <= 1) continue;
                        object.addHighlight(n5, n5 + 1, this.attribsLeft);
                        object.addHighlight(n6 - 1, n6, this.attribsRight);
                        if (n7 <= 2) continue;
                        object.addHighlight(n5 + 1, n6 - 1, this.attribsMiddle);
                    }
                }
                catch (BadLocationException badLocationException) {
                    LOG.log(Level.WARNING, null, badLocationException);
                }
                OffsetsBag offsetsBag = Highlighting.getBag(document);
                offsetsBag.setHighlights(object);
            } else {
                OffsetsBag offsetsBag = Highlighting.getBag(document);
                offsetsBag.clear();
                this.attribs = null;
            }
        }

        private static synchronized OffsetsBag getBag(Document document) {
            OffsetsBag offsetsBag = (OffsetsBag)document.getProperty(BAG_DOC_PROPERTY);
            if (offsetsBag == null) {
                offsetsBag = new OffsetsBag(document);
                document.putProperty(BAG_DOC_PROPERTY, offsetsBag);
            }
            return offsetsBag;
        }

        private static AttributeSet getSyncedTextBlocksHighlight() {
            FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(FontColorSettings.class);
            AttributeSet attributeSet = fontColorSettings.getFontColors("synchronized-text-blocks-ext");
            return attributeSet == null ? SimpleAttributeSet.EMPTY : attributeSet;
        }

        private static AttributeSet createAttribs(Object ... objectArray) {
            assert (objectArray.length % 2 == 0) : "There must be even number of prameters. They are key-value pairs of attributes that will be inserted into the set.";
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            for (int i = objectArray.length / 2 - 1; i >= 0; --i) {
                Object object = objectArray[2 * i];
                Object object2 = objectArray[2 * i + 1];
                if (object == null || object2 == null) continue;
                arrayList.add(object);
                arrayList.add(object2);
            }
            return AttributesUtilities.createImmutable((Object[])arrayList.toArray());
        }

        public static final class HLFactory
        implements HighlightsLayerFactory {
            public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
                return new HighlightsLayer[]{HighlightsLayer.create((String)"org.netbeans.lib.editor.codetemplates.CodeTemplateParametersHighlights", (ZOrder)ZOrder.SHOW_OFF_RACK.forPosition(490), (boolean)true, (HighlightsContainer)Highlighting.getBag(context.getDocument()))};
            }
        }
    }

    private static final class OverrideKeysListener
    implements KeyListener {
        static OverrideKeysListener INSTANCE = new OverrideKeysListener();

        private OverrideKeysListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            TextRegionEditing textRegionEditing = this.textRegionEditing(keyEvent);
            if (!textRegionEditing.isActive()) {
                return;
            }
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            if (KeyStroke.getKeyStroke(27, 0) == keyStroke) {
                textRegionEditing.escapeAction();
                keyEvent.consume();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        private TextRegionEditing textRegionEditing(KeyEvent keyEvent) {
            return TextRegionEditing.get((JTextComponent)keyEvent.getSource());
        }
    }

    private static final class OverrideAction
    extends TextAction {
        private static final String ORIGINAL_ACTION_PROPERTY = "original-action";
        private static final int TAB = 1;
        private static final int SHIFT_TAB = 2;
        private static final int ENTER = 3;
        private final int actionType;

        public static ActionMap installOverrideActionMap(JTextComponent jTextComponent) {
            OverrideAction[] overrideActionArray;
            ActionMap actionMap = jTextComponent.getActionMap();
            ActionMap actionMap2 = new ActionMap();
            for (OverrideAction overrideAction : overrideActionArray = new OverrideAction[]{new OverrideAction(1), new OverrideAction(2), new OverrideAction(3)}) {
                Object object = (String)overrideAction.getValue("Name");
                assert (object != null);
                object = overrideAction.findActionKey(jTextComponent);
                if (object == null) continue;
                Action action = actionMap.get(object);
                overrideAction.putValue(ORIGINAL_ACTION_PROPERTY, action);
                actionMap2.put(object, overrideAction);
            }
            actionMap2.setParent(actionMap);
            jTextComponent.setActionMap(actionMap2);
            return actionMap;
        }

        private static String actionType2Name(int n) {
            switch (n) {
                case 1: {
                    return "insert-tab";
                }
                case 2: {
                    return "remove-tab";
                }
                case 3: {
                    return "insert-break";
                }
            }
            throw new IllegalArgumentException();
        }

        private OverrideAction(int n) {
            super(OverrideAction.actionType2Name(n));
            this.actionType = n;
        }

        private TextRegionEditing textRegionEditing(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                return TextRegionEditing.get(jTextComponent);
            }
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TextRegionEditing textRegionEditing = this.textRegionEditing(actionEvent);
            if (textRegionEditing != null) {
                switch (this.actionType) {
                    case 1: {
                        textRegionEditing.tabAction();
                        break;
                    }
                    case 2: {
                        textRegionEditing.shiftTabAction();
                        break;
                    }
                    case 3: {
                        if (textRegionEditing.enterAction()) break;
                        Action action = (Action)this.getValue(ORIGINAL_ACTION_PROPERTY);
                        action.actionPerformed(actionEvent);
                    }
                }
            }
        }

        Object findActionKey(JTextComponent jTextComponent) {
            KeyStroke keyStroke;
            switch (this.actionType) {
                case 1: {
                    keyStroke = KeyStroke.getKeyStroke(9, 0);
                    break;
                }
                case 2: {
                    keyStroke = KeyStroke.getKeyStroke(9, 1);
                    break;
                }
                case 3: {
                    keyStroke = KeyStroke.getKeyStroke(10, 0);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            Object object = jTextComponent.getInputMap().get(keyStroke);
            return object;
        }
    }

    private static final class DocChangeListener
    implements PropertyChangeListener {
        static final DocChangeListener INSTANCE = new DocChangeListener();

        private DocChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("document".equals(propertyChangeEvent.getPropertyName())) {
                TextRegionEditing.get((JTextComponent)propertyChangeEvent.getSource()).stopSyncEditing();
            }
        }
    }

    private static final class GroupEditing {
        TextSyncGroup group;
        TextSyncGroupEditingNotify notify;
        int activeTextSyncIndex;

        GroupEditing(TextSyncGroup textSyncGroup, TextSyncGroupEditingNotify textSyncGroupEditingNotify) {
            assert (textSyncGroup != null);
            assert (textSyncGroupEditingNotify != null);
            this.group = textSyncGroup;
            this.notify = textSyncGroupEditingNotify;
            this.activeTextSyncIndex = -1;
        }

        TextSync activeTextSync() {
            return this.group.textSyncs().get(this.activeTextSyncIndex);
        }
    }
}

