/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.ChildrenArray;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class EntrySupport {
    private static final Reference<ChildrenArray> EMPTY = new WeakReference<Object>(null);
    public final Children children;
    Reference<ChildrenArray> array = EMPTY;
    protected List<Children.Entry> entries = Collections.emptyList();

    protected EntrySupport(Children children) {
        this.children = children;
    }

    public abstract int getNodesCount(boolean var1);

    public abstract Node[] getNodes(boolean var1);

    public abstract Node getNodeAt(int var1);

    public abstract Node[] testNodes();

    public abstract boolean isInitialized();

    abstract void notifySetEntries();

    abstract void setEntries(Collection<? extends Children.Entry> var1);

    protected final List<Children.Entry> getEntries() {
        return new ArrayList<Children.Entry>(this.entries);
    }

    abstract List<Node> createSnapshot(boolean var1);

    abstract void refreshEntry(Children.Entry var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Lazy
    extends EntrySupport {
        private Map<Children.Entry, EntryInfo> entryToInfo = new HashMap<Children.Entry, EntryInfo>();
        private List<Children.Entry> visibleEntries = Collections.emptyList();
        private static final Logger LAZY_LOG = Logger.getLogger("org.openide.nodes.Children.getArray");
        private static final int prefetchCount = Math.max(Integer.getInteger("org.openide.explorer.VisualizerChildren.prefetchCount", 50), 0);
        private final Object LOCK = new Object();
        private boolean initInProgress = false;
        private boolean inited = false;
        private Thread initThread;
        boolean nodesCreated = false;
        private boolean mustNotifySetEnties = false;

        public Lazy(Children children) {
            super(children);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean checkInit() {
            if (this.inited) {
                return true;
            }
            boolean bl = false;
            Object object = this.LOCK;
            synchronized (object) {
                if (!this.initInProgress) {
                    bl = true;
                    this.initInProgress = true;
                    this.initThread = Thread.currentThread();
                }
            }
            if (bl) {
                class Notify
                implements Runnable {
                    Notify() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = Lazy.this.LOCK;
                        synchronized (object) {
                            Lazy.this.initThread = null;
                            Lazy.this.LOCK.notifyAll();
                        }
                    }
                }
                Notify notify;
                try {
                    this.children.callAddNotify();
                    Object var5_5 = null;
                    notify = new Notify();
                    this.inited = true;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    Notify notify2 = new Notify();
                    this.inited = true;
                    if (Children.MUTEX.isReadAccess()) {
                        Children.MUTEX.postWriteRequest((Runnable)notify2);
                        throw throwable;
                    } else {
                        notify2.run();
                    }
                    throw throwable;
                }
                if (Children.MUTEX.isReadAccess()) {
                    Children.MUTEX.postWriteRequest((Runnable)notify);
                    return true;
                }
                notify.run();
                return true;
            }
            if (Children.MUTEX.isReadAccess() || Children.MUTEX.isWriteAccess() || this.initThread == Thread.currentThread()) {
                this.notifySetEntries();
                return false;
            }
            object = this.LOCK;
            synchronized (object) {
                while (this.initThread != null) {
                    try {
                        this.LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void registerNode(int n, EntryInfo entryInfo) {
            if (n == -1) {
                try {
                    Children.PR.enterWriteAccess();
                    boolean bl = false;
                    Object object = this.LOCK;
                    synchronized (object) {
                        int n2 = 0;
                        boolean bl2 = false;
                        for (Children.Entry entry : this.visibleEntries) {
                            EntryInfo entryInfo2 = this.entryToInfo.get(entry);
                            if (entryInfo2.currentNode() != null) {
                                ++n2;
                            }
                            if (entryInfo2 != entryInfo) continue;
                            bl2 = true;
                        }
                        boolean bl3 = bl = n2 == 0 && bl2;
                        if (bl) {
                            this.inited = false;
                            this.initThread = null;
                            this.initInProgress = false;
                            this.children.callRemoveNotify();
                        }
                    }
                    Object var12_11 = null;
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    Children.PR.exitWriteAccess();
                    throw throwable;
                }
                Children.PR.exitWriteAccess();
                {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node getNodeAt(int n) {
            if (!this.checkInit()) {
                return null;
            }
            Object object = null;
            do {
                Object var7_5;
                Children.Entry entry;
                block7: {
                    block6: {
                        try {
                            Children.PR.enterReadAccess();
                            if (n < this.visibleEntries.size()) break block6;
                            entry = object;
                            var7_5 = null;
                        }
                        catch (Throwable throwable) {
                            var7_5 = null;
                            Children.PR.exitReadAccess();
                            throw throwable;
                        }
                        Children.PR.exitReadAccess();
                        return entry;
                    }
                    entry = this.visibleEntries.get(n);
                    EntryInfo entryInfo = this.entryToInfo.get(entry);
                    object = entryInfo.getNode();
                    if (this.isDummyNode((Node)object)) break block7;
                    Object object2 = object;
                    var7_5 = null;
                    Children.PR.exitReadAccess();
                    return object2;
                }
                this.removeEmptyEntry(entry, null);
                var7_5 = null;
                Children.PR.exitReadAccess();
            } while (!Children.MUTEX.isReadAccess());
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node[] getNodes(boolean bl) {
            Node[] nodeArray;
            if (!this.checkInit()) {
                return new Node[0];
            }
            if (bl) {
                this.children.findChild(null);
            }
            do {
                Object var11_11;
                HashSet<Children.Entry> hashSet;
                block9: {
                    Node[] nodeArray2;
                    hashSet = null;
                    nodeArray = null;
                    try {
                        Children.PR.enterReadAccess();
                        int n = this.entries.size();
                        ArrayList<Node> arrayList = new ArrayList<Node>(n);
                        for (int i = 0; i < n; ++i) {
                            Children.Entry entry = (Children.Entry)this.entries.get(i);
                            EntryInfo entryInfo = this.entryToInfo.get(entry);
                            if (entryInfo.isHidden()) continue;
                            Node node = entryInfo.getNode();
                            if (this.isDummyNode(node)) {
                                if (hashSet == null) {
                                    hashSet = new HashSet<Children.Entry>();
                                }
                                hashSet.add(entry);
                            }
                            arrayList.add(node);
                        }
                        nodeArray = arrayList.toArray(new Node[0]);
                        this.nodesCreated = true;
                        if (hashSet != null) break block9;
                        nodeArray2 = nodeArray;
                        var11_11 = null;
                    }
                    catch (Throwable throwable) {
                        var11_11 = null;
                        Children.PR.exitReadAccess();
                        throw throwable;
                    }
                    Children.PR.exitReadAccess();
                    return nodeArray2;
                }
                this.removeEmptyEntries(hashSet);
                var11_11 = null;
                Children.PR.exitReadAccess();
            } while (!Children.MUTEX.isReadAccess());
            return nodeArray;
        }

        @Override
        public Node[] testNodes() {
            return this.nodesCreated ? this.getNodes(false) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNodesCount(boolean bl) {
            int n;
            this.checkInit();
            try {
                Children.PR.enterReadAccess();
                n = this.visibleEntries.size();
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                Children.PR.exitReadAccess();
                throw throwable;
            }
            Children.PR.exitReadAccess();
            return n;
        }

        @Override
        public boolean isInitialized() {
            return this.inited;
        }

        Children.Entry entryForNode(Node node) {
            for (Map.Entry<Children.Entry, EntryInfo> entry : this.entryToInfo.entrySet()) {
                if (entry.getValue().currentNode() != node) continue;
                return entry.getKey();
            }
            return null;
        }

        final boolean isDummyNode(Node node) {
            return node.getClass().getName().endsWith("EntrySupport$Lazy$DummyNode");
        }

        @Override
        void refreshEntry(Children.Entry entry) {
            if (!this.inited) {
                return;
            }
            EntryInfo entryInfo = this.entryToInfo.get(entry);
            if (entryInfo == null) {
                return;
            }
            Node node = entryInfo.currentNode();
            Node node2 = entryInfo.refreshNode();
            boolean bl = false;
            if (this.isDummyNode(node2)) {
                this.removeEmptyEntry(entry, node);
                bl = true;
            }
            if (node2.equals(node)) {
                return;
            }
            if (node != null && !this.isDummyNode(node)) {
                node.deassignFrom(this.children);
                if (this.children.parent != null) {
                    node.fireParentNodeChange(this.children.parent, null);
                }
                if (!bl) {
                    entryInfo.useNode(node);
                    this.fireSubNodesChangeIdx(false, new int[]{entryInfo.getIndex()}, null, null, null);
                }
                this.children.destroyNodes(new Node[]{node});
            }
            entryInfo.useNode(node2);
            if (!bl) {
                if (this.isDummyNode(node)) {
                    int n = 0;
                    ArrayList<Children.Entry> arrayList = new ArrayList<Children.Entry>();
                    for (Children.Entry entry2 : this.entries) {
                        EntryInfo entryInfo2 = this.entryToInfo.get(entry2);
                        if (entryInfo2 != entryInfo && entryInfo2.isHidden()) continue;
                        entryInfo2.setIndex(n++);
                        arrayList.add(entry2);
                    }
                    this.visibleEntries = arrayList;
                }
                this.fireSubNodesChangeIdx(true, new int[]{entryInfo.getIndex()}, null, null, null);
            }
        }

        @Override
        void notifySetEntries() {
            this.mustNotifySetEnties = true;
        }

        @Override
        void setEntries(Collection<? extends Children.Entry> collection) {
            int n;
            Object object;
            List<Children.Entry> list;
            assert (this.entries.size() == this.entryToInfo.size());
            if (!this.mustNotifySetEnties && !this.inited) {
                this.entries = new ArrayList<Children.Entry>(collection);
                this.visibleEntries = new ArrayList<Children.Entry>(collection);
                this.entryToInfo.keySet().retainAll(this.entries);
                for (int i = 0; i < this.entries.size(); ++i) {
                    Children.Entry entry = (Children.Entry)this.entries.get(i);
                    EntryInfo entryInfo = this.entryToInfo.get(entry);
                    if (entryInfo == null) {
                        entryInfo = new EntryInfo(entry);
                        this.entryToInfo.put(entry, entryInfo);
                    }
                    entryInfo.setIndex(i);
                }
                return;
            }
            HashSet<? extends Children.Entry> hashSet = new HashSet<Children.Entry>(collection);
            Iterator iterator = this.entries.iterator();
            int n2 = 0;
            int n3 = 0;
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            List<Children.Entry> list2 = this.visibleEntries;
            HashMap<Children.Entry, EntryInfo> hashMap = null;
            this.visibleEntries = new ArrayList<Children.Entry>();
            while (iterator.hasNext()) {
                list = this.entryToInfo.get(iterator.next());
                if (!hashSet.contains(((EntryInfo)((Object)list)).entry)) {
                    iterator.remove();
                    if (hashMap == null) {
                        hashMap = new HashMap<Children.Entry, EntryInfo>(this.entryToInfo);
                    }
                    this.entryToInfo.remove(((EntryInfo)((Object)list)).entry);
                    if (((EntryInfo)((Object)list)).isHidden()) continue;
                    treeSet.add(new Integer(n3));
                    object = ((EntryInfo)((Object)list)).currentNode();
                    if (object != null) {
                        if (!this.isDummyNode((Node)object)) {
                            ((Node)object).deassignFrom(this.children);
                            if (this.children.parent != null) {
                                ((Node)object).fireParentNodeChange(this.children.parent, null);
                            }
                        }
                        arrayList.add(object);
                    }
                } else {
                    if (((EntryInfo)((Object)list)).isHidden()) continue;
                    ((EntryInfo)((Object)list)).setIndex(n2++);
                    this.visibleEntries.add(((EntryInfo)((Object)list)).entry);
                }
                ++n3;
            }
            if (!treeSet.isEmpty()) {
                list = (List<Children.Entry>)new int[treeSet.size()];
                object = treeSet.iterator();
                for (n = 0; n < ((List<Children.Entry>)list).length; ++n) {
                    list[n] = (List<Children.Entry>)((Object)((Integer)object.next()));
                }
                this.fireSubNodesChangeIdx(false, (int[])list, null, null, new LazySnapshot(list2, hashMap));
                this.children.destroyNodes(arrayList.toArray(new Node[arrayList.size()]));
            }
            if (!(list = this.updateOrder(collection)).isEmpty()) {
                this.entries = new ArrayList<Children.Entry>(collection);
                object = new int[list.size()];
                n = 0;
                int n4 = 0;
                boolean bl = list.size() == 2 && prefetchCount > 0;
                this.visibleEntries = new ArrayList<Children.Entry>();
                for (int i = 0; i < this.entries.size(); ++i) {
                    Children.Entry entry = (Children.Entry)this.entries.get(i);
                    EntryInfo entryInfo = this.entryToInfo.get(entry);
                    if (entryInfo == null) {
                        Node node;
                        entryInfo = new EntryInfo(entry);
                        this.entryToInfo.put(entry, entryInfo);
                        if (bl && this.isDummyNode(node = entryInfo.getNode())) {
                            entryInfo.setIndex(-2);
                            continue;
                        }
                        object[n++] = n4;
                    }
                    if (entryInfo.isHidden()) continue;
                    entryInfo.setIndex(n4++);
                    this.visibleEntries.add(entry);
                }
                if (n == 0) {
                    return;
                }
                if (((Object)object).length != n) {
                    int[] nArray = new int[n];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = (int)object[i];
                    }
                    object = nArray;
                }
                this.fireSubNodesChangeIdx(true, (int[])object, null, null, null);
            }
        }

        private List<Children.Entry> updateOrder(Collection<? extends Children.Entry> collection) {
            LinkedList<Children.Entry> linkedList = new LinkedList<Children.Entry>();
            int[] nArray = new int[this.entries.size()];
            int n = 0;
            int n2 = 0;
            LinkedList<Children.Entry> linkedList2 = null;
            ArrayList<Children.Entry> arrayList = null;
            for (Children.Entry entry : collection) {
                EntryInfo entryInfo = this.entryToInfo.get(entry);
                if (entryInfo == null) {
                    linkedList.add(entry);
                    continue;
                }
                if (linkedList2 == null) {
                    linkedList2 = new LinkedList<Children.Entry>();
                    arrayList = new ArrayList<Children.Entry>();
                }
                linkedList2.add(entry);
                if (entryInfo.isHidden()) continue;
                arrayList.add(entry);
                int n3 = entryInfo.getIndex();
                if (n != n3) {
                    entryInfo.setIndex(n);
                    nArray[n3] = 1 + n;
                    ++n2;
                }
                ++n;
            }
            if (n2 > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == 0) {
                        nArray[i] = i;
                        continue;
                    }
                    int n3 = i;
                    nArray[n3] = nArray[n3] - 1;
                }
                this.entries = linkedList2;
                this.visibleEntries = arrayList;
                Node node = this.children.parent;
                if (node != null) {
                    node.fireReorderChange(nArray);
                }
            }
            return linkedList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Node getNode(Children.Entry entry) {
            EntryInfo entryInfo;
            block3: {
                Node node;
                this.checkInit();
                try {
                    Children.PR.enterReadAccess();
                    entryInfo = this.entryToInfo.get(entry);
                    if (entryInfo != null) break block3;
                    node = null;
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    Children.PR.exitReadAccess();
                    throw throwable;
                }
                Children.PR.exitReadAccess();
                return node;
            }
            Node node = entryInfo.getNode();
            Node node2 = this.isDummyNode(node) ? null : node;
            Object var6_6 = null;
            Children.PR.exitReadAccess();
            return node2;
        }

        protected void fireSubNodesChangeIdx(boolean bl, int[] nArray, Children.Entry entry, List<Node> list, List<Node> list2) {
            if (this.children.parent != null) {
                this.children.parent.fireSubNodesChangeIdx(bl, nArray, entry, list, list2);
            }
        }

        private void removeEmptyEntry(Children.Entry entry, Node node) {
            Children.MUTEX.postWriteRequest((Runnable)new RemoveEmptyEntries(entry, node));
        }

        private void removeEmptyEntries(HashSet<Children.Entry> hashSet) {
            Children.MUTEX.postWriteRequest((Runnable)new RemoveEmptyEntries(hashSet));
        }

        @Override
        List<Node> createSnapshot(boolean bl) {
            return bl ? new DelayedLazySnapshot(this.visibleEntries, new HashMap<Children.Entry, EntryInfo>(this.entryToInfo)) : new LazySnapshot(this.visibleEntries, new HashMap<Children.Entry, EntryInfo>(this.entryToInfo));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class DelayedLazySnapshot
        extends LazySnapshot {
            public DelayedLazySnapshot(List<Children.Entry> list, Map<Children.Entry, EntryInfo> map) {
                super(list, map);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class LazySnapshot
        extends AbstractList<Node> {
            private final List<Children.Entry> entries;
            private final Map<Children.Entry, EntryInfo> entryToInfo;

            public LazySnapshot(List<Children.Entry> list, Map<Children.Entry, EntryInfo> map) {
                this.entries = list;
                this.entryToInfo = map != null ? map : Collections.emptyMap();
            }

            @Override
            public Node get(int n) {
                Children.Entry entry = this.entries.get(n);
                EntryInfo entryInfo = this.entryToInfo.get(entry);
                Node node = entryInfo.getNode();
                if (Lazy.this.isDummyNode(node)) {
                    Lazy.this.removeEmptyEntry(entry, null);
                }
                return node;
            }

            @Override
            public String toString() {
                return this.entries.toString();
            }

            @Override
            public int size() {
                return this.entries.size();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class RemoveEmptyEntries
        implements Runnable {
            private final Children.Entry removeEntry;
            private final HashSet<Children.Entry> emptyEntries;
            private final Node oldNode;

            public RemoveEmptyEntries(Children.Entry entry, Node node) {
                this.removeEntry = entry;
                this.emptyEntries = null;
                this.oldNode = node;
            }

            public RemoveEmptyEntries(HashSet<Children.Entry> hashSet) {
                this.removeEntry = null;
                this.emptyEntries = hashSet;
                this.oldNode = null;
            }

            @Override
            public void run() {
                int n = 0;
                int n2 = 0;
                Object object = new int[this.removeEntry == null ? this.emptyEntries.size() : 1];
                List list = Lazy.this.visibleEntries;
                HashMap<Children.Entry, EntryInfo> hashMap = null;
                Lazy.this.visibleEntries = new ArrayList();
                for (Children.Entry entry : Lazy.this.entries) {
                    EntryInfo entryInfo = (EntryInfo)Lazy.this.entryToInfo.get(entry);
                    if (entryInfo.isHidden()) continue;
                    boolean bl = this.emptyEntries != null ? this.emptyEntries.remove(entry) : this.removeEntry.equals(entry);
                    if (bl) {
                        object[n2++] = entryInfo.getIndex();
                        if (hashMap == null) {
                            hashMap = new HashMap<Children.Entry, EntryInfo>(Lazy.this.entryToInfo);
                        }
                        EntryInfo entryInfo2 = entryInfo.duplicate(this.oldNode);
                        hashMap.put(entryInfo.entry, entryInfo2);
                        entryInfo.setIndex(-2);
                        continue;
                    }
                    Lazy.this.visibleEntries.add(entryInfo.entry);
                    entryInfo.setIndex(n++);
                }
                if (n2 == 0) {
                    return;
                }
                if (n2 < ((int[])object).length) {
                    Object object2 = new int[n2];
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        object2[i] = object[i];
                    }
                    object = object2;
                }
                Lazy.this.fireSubNodesChangeIdx(false, (int[])object, this.removeEntry, Lazy.this.createSnapshot(true), new LazySnapshot(list, hashMap));
            }
        }

        static class DummyNode
        extends AbstractNode {
            public DummyNode() {
                super(Children.LEAF);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class NodeRef
        extends WeakReference<Node>
        implements Runnable {
            private final EntryInfo info;

            public NodeRef(Node node, EntryInfo entryInfo) {
                super(node, Utilities.activeReferenceQueue());
                entryInfo.lazy().registerNode(1, entryInfo);
                this.info = entryInfo;
            }

            @Override
            public void run() {
                this.info.lazy().registerNode(-1, this.info);
            }
        }

        final class EntryInfo {
            final Children.Entry entry;
            private NodeRef refNode;
            private int index = -1;

            public EntryInfo(Children.Entry entry) {
                this.entry = entry;
            }

            final EntryInfo duplicate(Node node) {
                EntryInfo entryInfo = new EntryInfo(this.entry);
                entryInfo.index = this.index;
                entryInfo.refNode = node != null ? new NodeRef(node, entryInfo) : this.refNode;
                return entryInfo;
            }

            final Lazy lazy() {
                return Lazy.this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Node getNode() {
                Object object = Lazy.this.LOCK;
                synchronized (object) {
                    Node node = null;
                    if (this.refNode != null) {
                        node = (Node)this.refNode.get();
                    }
                    if (node == null) {
                        node = this.refreshNode();
                    }
                    return node;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            Node currentNode() {
                Object object = Lazy.this.LOCK;
                synchronized (object) {
                    return this.refNode == null ? null : (Node)this.refNode.get();
                }
            }

            Node refreshNode() {
                Collection<Node> collection = this.entry.nodes();
                if (collection.size() != 1) {
                    LAZY_LOG.fine("Number of nodes for Entry: " + this.entry + " is " + collection.size() + " instead of 1");
                    if (collection.size() == 0) {
                        DummyNode dummyNode = new DummyNode();
                        return this.useNode(dummyNode);
                    }
                }
                return this.useNode(collection.iterator().next());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Node useNode(Node node) {
                Object object = Lazy.this.LOCK;
                synchronized (object) {
                    this.refNode = new NodeRef(node, this);
                    node.assignTo(Lazy.this.children, -1);
                    node.fireParentNodeChange(null, Lazy.this.children.parent);
                    return node;
                }
            }

            final boolean isHidden() {
                return this.index == -2;
            }

            final void setIndex(int n) {
                this.index = n;
            }

            final int getIndex() {
                assert (this.index >= 0) : "When first asked for it has to be set: " + this.index;
                return this.index;
            }

            public String toString() {
                return "EntryInfo for entry: " + this.entry + ", node: " + (this.refNode == null ? null : (Node)this.refNode.get());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Default
    extends EntrySupport {
        private Map<Children.Entry, Info> map;
        private static final Object LOCK = new Object();
        private static final Logger LOG_GET_ARRAY = Logger.getLogger("org.openide.nodes.Children.getArray");
        private Thread initThread;
        private boolean mustNotifySetEnties = false;

        public Default(Children children) {
            super(children);
        }

        @Override
        public boolean isInitialized() {
            ChildrenArray childrenArray = (ChildrenArray)this.array.get();
            return childrenArray != null && childrenArray.isInitialized();
        }

        @Override
        public List<Node> createSnapshot(boolean bl) {
            return new DefaultSnapshot(this.getNodes());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Node[] getNodes() {
            Node[] nodeArray;
            boolean[] blArray = new boolean[2];
            do {
                blArray[1] = this.isInitialized();
                ChildrenArray childrenArray = this.getArray(blArray);
                try {
                    Children.PR.enterReadAccess();
                    nodeArray = childrenArray.nodes();
                }
                finally {
                    Children.PR.exitReadAccess();
                }
                boolean bl = LOG_GET_ARRAY.isLoggable(Level.FINE);
                if (bl) {
                    LOG_GET_ARRAY.fine("  length     : " + (nodeArray == null ? "nodes is null" : Integer.valueOf(nodeArray.length)));
                    LOG_GET_ARRAY.fine("  entries    : " + this.entries);
                    LOG_GET_ARRAY.fine("  init now   : " + this.isInitialized());
                }
                if (!blArray[1]) continue;
                return nodeArray;
            } while (!blArray[0]);
            this.notifySetEntries();
            return nodeArray == null ? new Node[]{} : nodeArray;
        }

        @Override
        public Node[] getNodes(boolean bl) {
            if (bl) {
                boolean bl2 = LOG_GET_ARRAY.isLoggable(Level.FINE);
                if (bl2) {
                    LOG_GET_ARRAY.fine("computing optimal result");
                }
                ChildrenArray childrenArray = this.getArray(null);
                if (bl2) {
                    LOG_GET_ARRAY.fine("optimal result is here: " + childrenArray);
                }
                Node node = this.children.findChild(null);
                if (bl2) {
                    LOG_GET_ARRAY.fine("Find child got: " + node);
                }
            }
            return this.getNodes();
        }

        @Override
        public final int getNodesCount(boolean bl) {
            return this.getNodes(bl).length;
        }

        @Override
        public Node getNodeAt(int n) {
            Node[] nodeArray = this.getNodes();
            return n < nodeArray.length ? nodeArray[n] : null;
        }

        final Node[] justComputeNodes() {
            Object object;
            if (this.map == null) {
                this.map = Collections.synchronizedMap(new HashMap(17));
            }
            LinkedList<Node> linkedList = new LinkedList<Node>();
            for (Children.Entry entry : this.entries) {
                object = this.findInfo(entry);
                try {
                    linkedList.addAll(((Info)object).nodes());
                }
                catch (RuntimeException runtimeException) {
                    NodeOp.warning(runtimeException);
                }
            }
            Node[] nodeArray = linkedList.toArray(new Node[linkedList.size()]);
            for (int i = 0; i < nodeArray.length; ++i) {
                object = nodeArray[i];
                ((Node)object).assignTo(this.children, i);
                ((Node)object).fireParentNodeChange(null, this.children.parent);
            }
            return nodeArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Info findInfo(Children.Entry entry) {
            Map<Children.Entry, Info> map = this.map;
            synchronized (map) {
                Info info = this.map.get(entry);
                if (info == null) {
                    info = new Info(entry);
                    this.map.put(entry, info);
                }
                return info;
            }
        }

        @Override
        void notifySetEntries() {
            this.mustNotifySetEnties = true;
        }

        @Override
        protected void setEntries(Collection<? extends Children.Entry> collection) {
            List<Info> list;
            Node[] nodeArray;
            boolean bl = LOG_GET_ARRAY.isLoggable(Level.FINE);
            ChildrenArray childrenArray = (ChildrenArray)this.array.get();
            if (bl) {
                LOG_GET_ARRAY.fine("setEntries for " + this + " on " + Thread.currentThread());
                LOG_GET_ARRAY.fine("       values: " + collection);
                LOG_GET_ARRAY.fine("       holder: " + childrenArray);
            }
            Node[] nodeArray2 = nodeArray = childrenArray == null ? null : childrenArray.nodes();
            if (this.mustNotifySetEnties) {
                if (childrenArray == null) {
                    childrenArray = this.getArray(null);
                }
                if (nodeArray == null) {
                    childrenArray.entrySupport = this;
                    nodeArray = childrenArray.nodes();
                }
            } else if (childrenArray == null || nodeArray == null) {
                this.entries = new ArrayList<Children.Entry>(collection);
                if (this.map != null) {
                    this.map.keySet().retainAll(new HashSet<Children.Entry>(collection));
                }
                return;
            }
            this.map.keySet().retainAll(new HashSet(this.entries));
            LinkedHashSet<Children.Entry> linkedHashSet = new LinkedHashSet<Children.Entry>(this.entries);
            HashSet<? extends Children.Entry> hashSet = new HashSet<Children.Entry>(collection);
            linkedHashSet.removeAll(hashSet);
            if (!linkedHashSet.isEmpty()) {
                this.updateRemove(nodeArray, linkedHashSet);
                nodeArray = childrenArray.nodes();
            }
            if (!(list = this.updateOrder(nodeArray, collection)).isEmpty()) {
                this.updateAdd(list, new ArrayList<Children.Entry>(collection));
            }
        }

        private void checkInfo(Info info, Children.Entry entry, Collection<? extends Children.Entry> collection, Map<Children.Entry, Info> map) {
            if (info == null) {
                throw new IllegalStateException("Error in " + this.getClass().getName() + " with entry " + entry + " from among " + collection + " in " + map + " probably caused by faulty key implementation." + " The key hashCode() and equals() methods must behave as for an IMMUTABLE object" + " and the hashCode() must return the same value for equals() keys.");
            }
        }

        private void updateRemove(Node[] nodeArray, Set<Children.Entry> set) {
            LinkedList<Node> linkedList = new LinkedList<Node>();
            for (Children.Entry entry : set) {
                Info info = this.map.remove(entry);
                this.checkInfo(info, entry, null, this.map);
                linkedList.addAll(info.nodes());
            }
            this.entries.removeAll(set);
            this.clearNodes();
            this.notifyRemove(linkedList, nodeArray, null);
        }

        private List<Info> updateOrder(Node[] nodeArray, Collection<? extends Children.Entry> collection) {
            Object object;
            LinkedList<Info> linkedList = new LinkedList<Info>();
            HashMap<Info, Integer> hashMap = new HashMap<Info, Integer>();
            int n = 0;
            for (Children.Entry entry : this.entries) {
                object = this.map.get(entry);
                this.checkInfo((Info)object, entry, this.entries, this.map);
                hashMap.put((Info)object, n);
                n += ((Info)object).length();
            }
            this.map.keySet().retainAll(new HashSet(this.entries));
            int[] nArray = new int[nodeArray.length];
            int n2 = 0;
            int n3 = 0;
            object = null;
            for (Children.Entry entry : collection) {
                Info info = this.map.get(entry);
                if (info == null) {
                    info = new Info(entry);
                    linkedList.add(info);
                } else {
                    int n4 = info.length();
                    if (object == null) {
                        object = new LinkedList();
                    }
                    object.add(entry);
                    Integer n5 = (Integer)hashMap.get(info);
                    int n6 = n5;
                    if (n2 != n6) {
                        for (int i = 0; i < n4; ++i) {
                            nArray[n6 + i] = 1 + n2 + i;
                        }
                        n3 += n4;
                    }
                }
                n2 += info.length();
            }
            if (n3 > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == 0) {
                        nArray[i] = i;
                        continue;
                    }
                    int n4 = i;
                    nArray[n4] = nArray[n4] - 1;
                }
                this.entries = object;
                this.clearNodes();
                Node node = this.children.parent;
                if (node != null) {
                    node.fireReorderChange(nArray);
                }
            }
            return linkedList;
        }

        private void updateAdd(Collection<Info> collection, List<Children.Entry> list) {
            LinkedList<Node> linkedList = new LinkedList<Node>();
            for (Info info : collection) {
                linkedList.addAll(info.nodes());
                this.map.put(info.entry, info);
            }
            this.entries = list;
            this.clearNodes();
            this.notifyAdd(linkedList, null);
        }

        @Override
        final void refreshEntry(Children.Entry entry) {
            Collection<Node> collection;
            ChildrenArray childrenArray = (ChildrenArray)this.array.get();
            if (childrenArray == null) {
                return;
            }
            Node[] nodeArray = childrenArray.nodes();
            if (nodeArray == null) {
                return;
            }
            this.map.keySet().retainAll(new HashSet(this.entries));
            Info info = this.map.get(entry);
            if (info == null) {
                return;
            }
            Collection<Node> collection2 = info.nodes();
            if (((Object)collection2).equals(collection = info.entry.nodes())) {
                return;
            }
            HashSet<Node> hashSet = new HashSet<Node>(collection2);
            hashSet.removeAll(new HashSet<Node>(collection));
            if (!hashSet.isEmpty()) {
                collection2.removeAll(hashSet);
                this.clearNodes();
                this.notifyRemove(hashSet, nodeArray, entry);
                nodeArray = childrenArray.nodes();
            }
            List<Node> list = this.refreshOrder(entry, collection2, collection);
            info.useNodes(collection);
            if (!list.isEmpty()) {
                this.clearNodes();
                this.notifyAdd(list, entry);
            }
        }

        private List<Node> refreshOrder(Children.Entry entry, Collection<Node> collection, Collection<Node> collection2) {
            Object object;
            LinkedList<Node> linkedList = new LinkedList<Node>();
            HashSet<Node> hashSet = new HashSet<Node>(collection);
            HashSet<Node> hashSet2 = new HashSet<Node>(hashSet);
            Node[] nodeArray = new Node[collection.size()];
            Iterator<Node> iterator = collection2.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                object = iterator.next();
                if (hashSet.remove(object)) {
                    nodeArray[n++] = object;
                    continue;
                }
                if (!hashSet2.contains(object)) {
                    linkedList.add((Node)object);
                    continue;
                }
                iterator.remove();
            }
            object = NodeOp.computePermutation(collection.toArray(new Node[collection.size()]), nodeArray);
            if (object != null) {
                this.clearNodes();
                this.findInfo(entry).useNodes(Arrays.asList(nodeArray));
                Node node = this.children.parent;
                if (node != null) {
                    node.fireReorderChange((int[])object);
                }
            }
            return linkedList;
        }

        Node[] notifyRemove(Collection<Node> collection, Node[] nodeArray, Children.Entry entry) {
            Node[] nodeArray2 = collection.toArray(new Node[collection.size()]);
            if (this.children.parent != null) {
                this.children.parent.fireSubNodesChange(false, nodeArray2, nodeArray);
                for (Node node : collection) {
                    node.deassignFrom(this.children);
                    node.fireParentNodeChange(this.children.parent, null);
                }
            }
            this.children.destroyNodes(nodeArray2);
            return nodeArray2;
        }

        void notifyAdd(Collection<Node> collection, Children.Entry entry) {
            Node node2;
            for (Node node2 : collection) {
                node2.assignTo(this.children, -1);
                node2.fireParentNodeChange(null, this.children.parent);
            }
            Node[] nodeArray = collection.toArray(new Node[collection.size()]);
            node2 = this.children.parent;
            if (node2 != null) {
                node2.fireSubNodesChange(true, nodeArray, null);
            }
        }

        @Override
        public Node[] testNodes() {
            ChildrenArray childrenArray = (ChildrenArray)this.array.get();
            return childrenArray == null ? null : childrenArray.nodes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private ChildrenArray getArray(boolean[] blArray) {
            ChildrenArray childrenArray;
            final boolean bl = LOG_GET_ARRAY.isLoggable(Level.FINE);
            boolean bl2 = false;
            Object object = LOCK;
            synchronized (object) {
                childrenArray = (ChildrenArray)this.array.get();
                if (childrenArray == null) {
                    childrenArray = new ChildrenArray();
                    this.registerChildrenArray(childrenArray, true);
                    bl2 = true;
                    this.initThread = Thread.currentThread();
                }
            }
            if (bl2) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class SetAndNotify
                implements Runnable {
                    public ChildrenArray toSet;
                    public Children whatSet;

                    SetAndNotify() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = LOCK;
                        synchronized (object) {
                            Default.this.initThread = null;
                            LOCK.notifyAll();
                        }
                        if (bl) {
                            LOG_GET_ARRAY.fine("notifyAll done");
                        }
                    }
                }
                if (bl) {
                    LOG_GET_ARRAY.fine("Initialize " + this + " on " + Thread.currentThread());
                }
                try {
                    this.children.callAddNotify();
                    if (bl) {
                        LOG_GET_ARRAY.fine("addNotify successfully called for " + this + " on " + Thread.currentThread());
                    }
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    boolean bl3 = Children.MUTEX.isReadAccess();
                    if (bl) {
                        LOG_GET_ARRAY.fine("notifyAll for " + this + " on " + Thread.currentThread() + "  notifyLater: " + bl3);
                    }
                    childrenArray.entrySupport = this;
                    SetAndNotify setAndNotify = new SetAndNotify();
                    setAndNotify.toSet = childrenArray;
                    setAndNotify.whatSet = this.children;
                    if (bl3) {
                        Children.MUTEX.postWriteRequest((Runnable)setAndNotify);
                        throw throwable;
                    } else {
                        setAndNotify.run();
                    }
                    throw throwable;
                }
                boolean bl4 = Children.MUTEX.isReadAccess();
                if (bl) {
                    LOG_GET_ARRAY.fine("notifyAll for " + this + " on " + Thread.currentThread() + "  notifyLater: " + bl4);
                }
                childrenArray.entrySupport = this;
                SetAndNotify setAndNotify = new SetAndNotify();
                setAndNotify.toSet = childrenArray;
                setAndNotify.whatSet = this.children;
                if (bl4) {
                    Children.MUTEX.postWriteRequest((Runnable)setAndNotify);
                    return childrenArray;
                }
                setAndNotify.run();
                return childrenArray;
            }
            if (Children.MUTEX.isReadAccess() || Children.MUTEX.isWriteAccess() || this.initThread == Thread.currentThread()) {
                if (bl) {
                    LOG_GET_ARRAY.log(Level.FINE, "cannot initialize better " + this + " on " + Thread.currentThread() + " read access: " + Children.MUTEX.isReadAccess() + " initThread: " + this.initThread, new Exception("StackTrace"));
                }
                if (blArray == null) return childrenArray;
                blArray[0] = true;
                return childrenArray;
            }
            object = LOCK;
            synchronized (object) {
                while (this.initThread != null) {
                    if (bl) {
                        LOG_GET_ARRAY.fine("waiting for children for " + this + " on " + Thread.currentThread());
                    }
                    try {
                        LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!bl) return childrenArray;
            LOG_GET_ARRAY.fine(" children are here for " + this + " on " + Thread.currentThread() + " children " + this.children);
            return childrenArray;
        }

        private void clearNodes() {
            ChildrenArray childrenArray = (ChildrenArray)this.array.get();
            if (childrenArray != null) {
                childrenArray.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void registerChildrenArray(ChildrenArray childrenArray, boolean bl) {
            boolean bl2 = LOG_GET_ARRAY.isLoggable(Level.FINE);
            if (bl2) {
                LOG_GET_ARRAY.fine("registerChildrenArray: " + childrenArray + " weak: " + bl);
            }
            Object object = LOCK;
            synchronized (object) {
                this.array = new ChArrRef(childrenArray, bl);
            }
            if (bl2) {
                LOG_GET_ARRAY.fine("pointed by: " + childrenArray + " to: " + this.array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void finalizedChildrenArray(Reference reference) {
            boolean bl = LOG_GET_ARRAY.isLoggable(Level.FINE);
            try {
                Children.PR.enterWriteAccess();
                if (bl) {
                    LOG_GET_ARRAY.fine("previous array: " + this.array + " caller: " + reference);
                }
                Object object = LOCK;
                synchronized (object) {
                    if (this.array == reference) {
                        this.mustNotifySetEnties = false;
                        this.array = EMPTY;
                        this.children.callRemoveNotify();
                        assert (this.array == EMPTY);
                    }
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                Children.PR.exitWriteAccess();
                throw throwable;
            }
            Children.PR.exitWriteAccess();
        }

        final void finalizeNodes() {
            ChildrenArray childrenArray = (ChildrenArray)this.array.get();
            if (childrenArray != null) {
                childrenArray.finalizeNodes();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ChArrRef
        extends WeakReference<ChildrenArray>
        implements Runnable {
            private final ChildrenArray chArr;

            public ChArrRef(ChildrenArray childrenArray, boolean bl) {
                super(childrenArray, Utilities.activeReferenceQueue());
                this.chArr = bl ? null : childrenArray;
                childrenArray.pointedBy(this);
            }

            @Override
            public ChildrenArray get() {
                return this.chArr != null ? this.chArr : (ChildrenArray)super.get();
            }

            @Override
            public void run() {
                Default.this.finalizedChildrenArray(this);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class DefaultSnapshot
        extends AbstractList<Node> {
            private Node[] nodes;

            public DefaultSnapshot(Node[] nodeArray) {
                this.nodes = nodeArray;
            }

            @Override
            public Node get(int n) {
                return this.nodes != null && n < this.nodes.length ? this.nodes[n] : null;
            }

            @Override
            public int size() {
                return this.nodes != null ? this.nodes.length : 0;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class Info {
            int length;
            final Children.Entry entry;

            public Info(Children.Entry entry) {
                this.entry = entry;
            }

            protected void finalize() {
                Default.this.finalizeNodes();
            }

            public Collection<Node> nodes() {
                ChildrenArray childrenArray = Default.this.getArray(null);
                return childrenArray.nodesFor(this);
            }

            public void useNodes(Collection<Node> collection) {
                ChildrenArray childrenArray = Default.this.getArray(null);
                childrenArray.useNodes(this, collection);
                for (Node node : collection) {
                    node.assignTo(Default.this.children, -1);
                    node.fireParentNodeChange(null, Default.this.children.parent);
                }
            }

            public int length() {
                return this.length;
            }

            public String toString() {
                return "Children.Info[" + this.entry + ",length=" + this.length + "]";
            }
        }
    }
}

