/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeMemberEvent
extends NodeEvent {
    static final long serialVersionUID = -3973509253579305102L;
    private boolean add;
    private Node[] delta;
    private Node[] from;
    private int[] indices;
    private final List<Node> previous;
    Children.Entry sourceEntry;

    NodeMemberEvent(Node node, boolean bl, Node[] nodeArray, Node[] nodeArray2) {
        super(node);
        this.add = bl;
        this.delta = nodeArray;
        this.from = nodeArray2;
        this.previous = null;
    }

    public final boolean isAddEvent() {
        return this.add;
    }

    NodeMemberEvent(Node node, boolean bl, int[] nArray, List<Node> list, List<Node> list2) {
        super(node, list);
        this.add = bl;
        this.indices = nArray;
        Arrays.sort(this.indices);
        this.previous = list2;
    }

    public final Node[] getDelta() {
        if (this.delta == null) {
            assert (this.indices != null) : "Well, indices cannot be null now";
            List<Node> list = this.previous == null ? this.getSnapshot() : this.previous;
            Node[] nodeArray = new Node[this.indices.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                nodeArray[i] = list.get(this.indices[i]);
            }
            this.delta = nodeArray;
        }
        return this.delta;
    }

    public synchronized int[] getDeltaIndices() {
        int n;
        if (this.indices != null) {
            return this.indices;
        }
        if (this.from == null) {
            this.from = this.getNode().getChildren().getNodes();
        }
        List<Node> list = Arrays.asList(this.delta);
        HashSet<Node> hashSet = new HashSet<Node>(list);
        this.indices = new int[this.delta.length];
        int n2 = 0;
        for (n = 0; n < this.from.length && n2 < this.indices.length; ++n) {
            if (!hashSet.contains(this.from[n])) continue;
            this.indices[n2++] = n;
        }
        if (n2 != this.delta.length) {
            StringBuilder stringBuilder = new StringBuilder(1000);
            stringBuilder.append("Some of a set of deleted nodes are not present in the original ones.\n");
            stringBuilder.append("See #15478; you may need to check that your Children.Keys keys are safely comparable.");
            stringBuilder.append("\ni: ").append(n);
            stringBuilder.append("\nj: ").append(n2);
            stringBuilder.append("\nThis: ").append(this);
            stringBuilder.append("\nCurrent state:\n");
            stringBuilder.append(Arrays.asList(this.from));
            stringBuilder.append("\nDelta:\n");
            stringBuilder.append(list);
            throw new IllegalStateException(stringBuilder.toString());
        }
        return this.indices;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[node=");
        stringBuilder.append(this.getSource());
        stringBuilder.append(", add=");
        stringBuilder.append(this.isAddEvent());
        Node[] nodeArray = this.delta;
        int[] nArray = this.getDeltaIndices();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append("\n  ");
            stringBuilder.append(i);
            stringBuilder.append(" at ");
            stringBuilder.append(nArray[i]);
            if (nodeArray == null) continue;
            stringBuilder.append(" = ");
            stringBuilder.append(nodeArray[i]);
        }
        stringBuilder.append("\n]");
        return stringBuilder.toString();
    }
}

