/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger;

import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.bpel.debugger.BpelDebuggerEngineProvider;
import org.netbeans.modules.bpel.debugger.BreakPosition;
import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.DebugException;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;
import org.netbeans.modules.bpel.debugger.api.ProcessInstancesModel;
import org.netbeans.modules.bpel.debugger.api.SourcePath;
import org.netbeans.modules.bpel.debugger.api.breakpoints.BpelBreakpoint;
import org.netbeans.modules.bpel.debugger.api.breakpoints.LineBreakpoint;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.BDIDebugConnector;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.BDIDebugger;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.ProcessInstanceImpl;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.ProcessInstancesModelImpl;
import org.netbeans.modules.bpel.debugger.breakpoints.SBYNActivityBreakpoint;
import org.netbeans.modules.bpel.debugger.breakpoints.SBYNBreakpoint;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.openide.util.NbBundle;

public class BpelDebuggerImpl
extends BpelDebugger {
    private static Logger LOGGER = Logger.getLogger(BpelDebuggerImpl.class.getName());
    private Thread mStartingThread;
    protected BDIDebugConnector mConnector;
    private int mState = 4;
    private BpelDebuggerEngineProvider myDebuggerEngineProvider;
    private Session mSession;
    private AtomicReference<BreakPosition> mCurrentPositionRef = new AtomicReference();
    private AtomicReference<ProcessInstanceImpl> mCurrentProcessInstanceRef = new AtomicReference();
    private Map myBreakpointsMap = Collections.synchronizedMap(new IdentityHashMap());
    private SourcePath mSourcePath;
    private ProcessInstancesModelImpl mProcessInstancesModel;
    private ProcessInstancesModelListener mProcessInstancesModelListener;
    private DebugException mException;
    private SBYNActivityBreakpoint mRunToCursorBreakpoint;

    public BpelDebuggerImpl(ContextProvider contextProvider) {
        super(contextProvider);
        List list = contextProvider.lookup(null, DebuggerEngineProvider.class);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!(list.get(i) instanceof BpelDebuggerEngineProvider)) continue;
            this.myDebuggerEngineProvider = (BpelDebuggerEngineProvider)((Object)list.get(i));
        }
        if (this.myDebuggerEngineProvider == null) {
            throw new IllegalArgumentException("BpelDebuggerEngineProvider have to be used to start BpelDebugger!");
        }
        this.mSession = this.myDebuggerEngineProvider.getSession();
        this.mProcessInstancesModel = new ProcessInstancesModelImpl(this);
        this.mProcessInstancesModelListener = new ProcessInstancesModelListener();
        this.mProcessInstancesModel.addListener(this.mProcessInstancesModelListener);
    }

    public SourcePath getSourcePath() {
        if (this.mSourcePath == null) {
            this.mSourcePath = (SourcePath)this.getLookupProvider().lookupFirst(null, SourcePath.class);
        }
        return this.mSourcePath;
    }

    /*
     * WARNING - void declaration
     */
    public void finish() {
        void var2_5;
        int n = this.getState();
        if (n == 4) {
            return;
        }
        this.setState(4);
        this.mProcessInstancesModel.removeListener(this.mProcessInstancesModelListener);
        for (ProcessInstanceImpl processInstanceImpl : this.mProcessInstancesModel.getProcessInstances()) {
            if (processInstanceImpl.getState() != 2) continue;
            processInstanceImpl.resume();
        }
        this.mProcessInstancesModel.clear();
        if (this.mStartingThread != null) {
            this.mStartingThread.interrupt();
            this.mStartingThread = null;
        }
        Object var2_3 = null;
        if (this.mConnector != null) {
            try {
                this.mConnector.detach();
            }
            catch (Exception exception) {
                Exception exception2 = exception;
            }
        }
        if (n == 1) {
            if (this.getException() != null) {
                this.traceDebugException(NbBundle.getMessage(BpelDebuggerImpl.class, (String)"ERR_UnableToStartSession"), (Exception)this.getException());
            } else {
                this.getTracer().println(NbBundle.getMessage(BpelDebuggerImpl.class, (String)"MSG_StopConnecting"));
            }
        } else if (this.getException() != null) {
            this.traceDebugException(NbBundle.getMessage(BpelDebuggerImpl.class, (String)"ERR_SessionTerminated"), (Exception)this.getException());
        } else {
            this.getTracer().println(NbBundle.getMessage(BpelDebuggerImpl.class, (String)"MSG_SessionFinished"));
        }
        if (var2_5 != null) {
            this.traceDebugException(NbBundle.getMessage(BpelDebuggerImpl.class, (String)"ERR_ErrorWhileDisconnecting"), (Exception)var2_5);
        }
        if (this.myDebuggerEngineProvider.getDestructor() != null) {
            this.myDebuggerEngineProvider.getDestructor().killEngine();
        }
    }

    public void setException(DebugException debugException) {
        if (this.getState() == 4) {
            return;
        }
        this.mException = debugException;
        this.mSession.kill();
    }

    private void setState(int n) {
        if (n == this.mState) {
            return;
        }
        int n2 = this.mState;
        this.mState = n;
        this.firePropertyChange("state", new Integer(n2), new Integer(n));
    }

    public int getState() {
        return this.mState;
    }

    public void setStartingThread(Thread thread) {
        this.mStartingThread = thread;
        this.setState(1);
    }

    public void unsetStartingThread() {
        this.mStartingThread = null;
    }

    public void setRunning(String string, int n) {
        if (BDIDebugConnector.getDebugConnector(string, n) != null) {
            this.setException(new DebugException(NbBundle.getMessage(BpelDebuggerImpl.class, (String)"ERR_AlreadyConnected", (Object)string, (Object)("" + n))));
            return;
        }
        this.getTracer().println(NbBundle.getMessage(BpelDebuggerImpl.class, (String)"MSG_Connecting", (Object)string, (Object)("" + n)));
        this.mConnector = new BDIDebugConnector(this);
        if (!this.mConnector.isInitialized()) {
            this.setException(new DebugException((Throwable)this.mConnector.getException()));
            return;
        }
        this.mConnector.attach(string, n);
        if (!this.mConnector.isAttached()) {
            this.setException(new DebugException(NbBundle.getMessage(BpelDebuggerImpl.class, (String)"ERR_UnableToConnect", (Object)string, (Object)("" + n)), (Throwable)this.mConnector.getException()));
            return;
        }
        this.synchronizeBreakpoints();
        this.getTracer().println(NbBundle.getMessage(BpelDebuggerImpl.class, (String)"MSG_SessionStarted"));
        this.setState(2);
    }

    public ProcessInstancesModelImpl getProcessInstancesModel() {
        return this.mProcessInstancesModel;
    }

    public DebugException getException() {
        return this.mException;
    }

    public BDIDebugger getBDIDebugger() {
        if (this.mConnector != null) {
            return this.mConnector.getBDIDebugger();
        }
        return null;
    }

    public void breakpointAdded(BpelBreakpoint bpelBreakpoint) {
        if (bpelBreakpoint instanceof LineBreakpoint) {
            this.myBreakpointsMap.put(bpelBreakpoint, new SBYNActivityBreakpoint((LineBreakpoint)bpelBreakpoint, this));
        }
    }

    public void breakpointRemoved(BpelBreakpoint bpelBreakpoint) {
        this.myBreakpointsMap.remove(bpelBreakpoint);
    }

    public boolean hasBreakpoint(String string, String string2) {
        SBYNBreakpoint[] sBYNBreakpointArray;
        for (SBYNBreakpoint sBYNBreakpoint : sBYNBreakpointArray = this.getBreakpoints()) {
            if (!sBYNBreakpoint.isEnabled() || !new File(string).equals(new File(sBYNBreakpoint.getURL())) || !string2.equals(sBYNBreakpoint.getXpath())) continue;
            return true;
        }
        return this.mRunToCursorBreakpoint != null && new File(string).equals(new File(this.mRunToCursorBreakpoint.getURL())) && string2.equals(this.mRunToCursorBreakpoint.getXpath());
    }

    private void synchronizeBreakpoints() {
        Breakpoint[] breakpointArray;
        for (Breakpoint breakpoint : breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints()) {
            if (!(breakpoint instanceof LineBreakpoint)) continue;
            LineBreakpoint lineBreakpoint = (LineBreakpoint)breakpoint;
            this.myBreakpointsMap.put(lineBreakpoint, new SBYNActivityBreakpoint(lineBreakpoint, this));
        }
    }

    private void activateSession() {
        if (this.mSession != DebuggerManager.getDebuggerManager().getCurrentSession()) {
            DebuggerManager.getDebuggerManager().setCurrentSession(this.mSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SBYNBreakpoint[] getBreakpoints() {
        Map map = this.myBreakpointsMap;
        synchronized (map) {
            return this.myBreakpointsMap.values().toArray(new SBYNBreakpoint[this.myBreakpointsMap.size()]);
        }
    }

    private void setCurrentPosition(BreakPosition breakPosition) {
        BreakPosition breakPosition2 = this.mCurrentPositionRef.getAndSet(breakPosition);
        this.firePropertyChange("currentPosition", breakPosition2, breakPosition);
        if (breakPosition != null) {
            this.activateSession();
        }
    }

    public void stepInto() {
        ProcessInstanceImpl processInstanceImpl = this.getCurrentProcessInstance();
        if (processInstanceImpl != null) {
            processInstanceImpl.stepInto();
        }
    }

    public void stepOver() {
        ProcessInstanceImpl processInstanceImpl = this.getCurrentProcessInstance();
        if (processInstanceImpl != null) {
            processInstanceImpl.stepOver();
        }
    }

    public void stepOut() {
        ProcessInstanceImpl processInstanceImpl = this.getCurrentProcessInstance();
        if (processInstanceImpl != null) {
            processInstanceImpl.stepOut();
        }
    }

    public void pause() {
        for (ProcessInstanceImpl processInstanceImpl : this.mProcessInstancesModel.getProcessInstances()) {
            processInstanceImpl.pause();
        }
    }

    public void resume() {
        ProcessInstanceImpl processInstanceImpl = this.getCurrentProcessInstance();
        if (processInstanceImpl != null) {
            processInstanceImpl.resume();
        }
        this.setCurrentPosition(null);
    }

    public BreakPosition getCurrentPosition() {
        return this.mCurrentPositionRef.get();
    }

    public ProcessInstanceImpl getCurrentProcessInstance() {
        return this.mCurrentProcessInstanceRef.get();
    }

    public int getCurrentProcessInstanceState() {
        ProcessInstanceImpl processInstanceImpl = this.mCurrentProcessInstanceRef.get();
        if (processInstanceImpl != null) {
            return processInstanceImpl.getState();
        }
        return 0;
    }

    public void setCurrentProcessInstance(ProcessInstance processInstance) {
        ProcessInstanceImpl processInstanceImpl = (ProcessInstanceImpl)processInstance;
        if (processInstanceImpl == null) {
            for (ProcessInstanceImpl processInstanceImpl2 : this.mProcessInstancesModel.getProcessInstances()) {
                if (processInstanceImpl2.getState() != 2) continue;
                processInstanceImpl = processInstanceImpl2;
                break;
            }
        }
        ProcessInstanceImpl processInstanceImpl3 = this.mCurrentProcessInstanceRef.getAndSet(processInstanceImpl);
        this.firePropertyChange("currentProcessInstance", processInstanceImpl3, processInstanceImpl);
        if (processInstanceImpl != null) {
            this.setCurrentPosition(processInstanceImpl.getCurrentPosition());
        } else {
            this.setCurrentPosition(null);
        }
    }

    private void traceDebugException(String string, Exception exception) {
        Throwable throwable;
        if (exception == null) {
            this.getTracer().println(string);
            return;
        }
        String string2 = NbBundle.getMessage(BpelDebuggerImpl.class, (String)"ERR_Separator");
        StringBuffer stringBuffer = new StringBuffer(200);
        if (string != null) {
            stringBuffer.append(string);
        }
        if (exception.getMessage() != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(exception.getMessage());
        }
        if (exception.getCause() != null && (throwable = exception.getCause() instanceof UndeclaredThrowableException ? exception.getCause().getCause() : exception.getCause()).getMessage() != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(throwable.getMessage());
        }
        this.getTracer().println(stringBuffer.toString());
    }

    public void clearRunToCursorBreakpoint() {
        this.mRunToCursorBreakpoint = null;
    }

    public SBYNActivityBreakpoint getRunToCursorBreakpoint() {
        return this.mRunToCursorBreakpoint;
    }

    public void runToCursor(LineBreakpoint lineBreakpoint) {
        this.mRunToCursorBreakpoint = new SBYNActivityBreakpoint(lineBreakpoint, this);
        this.resume();
    }

    private class ProcessInstancesModelListener
    implements ProcessInstancesModel.Listener {
        private ProcessInstancesModelListener() {
        }

        public void processInstanceRemoved(ProcessInstance processInstance) {
            if (processInstance == BpelDebuggerImpl.this.getCurrentProcessInstance()) {
                BpelDebuggerImpl.this.setCurrentProcessInstance(null);
            }
        }

        public void processInstanceAdded(ProcessInstance processInstance) {
        }

        public void processInstanceStateChanged(ProcessInstance processInstance, int n, int n2) {
            if (n2 == 2) {
                BpelDebuggerImpl.this.setCurrentProcessInstance(processInstance);
            } else if (processInstance == BpelDebuggerImpl.this.getCurrentProcessInstance()) {
                BpelDebuggerImpl.this.setCurrentPosition(null);
            }
        }
    }
}

