/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.bdiclient.impl;

import java.util.Hashtable;
import java.util.logging.Logger;
import org.netbeans.modules.bpel.debugger.BpelDebuggerImpl;
import org.netbeans.modules.bpel.debugger.api.DebugException;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.BDIDebugger;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.BPELDebugger;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.DebugListener;
import org.netbeans.modules.bpel.debuggerbdi.rmi.wp.ObjectAdapter;
import org.netbeans.modules.bpel.debuggerbdi.rmi.wp.RMIClient;
import org.netbeans.modules.bpel.debuggerbdi.rmi.wp.RMIServer;
import org.netbeans.modules.bpel.debuggerbdi.rmi.wp.RMIService;
import org.netbeans.modules.bpel.debuggerbdi.rmi.wp.RMIServiceFactory;

public class BDIDebugConnector {
    private static Logger LOGGER = Logger.getLogger(BDIDebugConnector.class.getName());
    private static Hashtable<String, BDIDebugConnector> allConnectors = new Hashtable();
    private boolean mIsInitialized;
    private boolean mIsAttached;
    private RMIService mRmiService;
    private ObjectAdapter mObjectAdapter;
    private RMIServer mRmiServer;
    private Thread mServerThread;
    private DebugListener mListener;
    private BDIDebugger mBDIDebugger;
    private DebugListener mLocalListener;
    private String mHost;
    private int mPort;
    private Exception mException;
    private final BpelDebuggerImpl mDebugger;

    public static synchronized BDIDebugConnector getDebugConnector(String string, int n) {
        return allConnectors.get(string + ":" + n);
    }

    public BDIDebugConnector(BpelDebuggerImpl bpelDebuggerImpl) {
        this.mDebugger = bpelDebuggerImpl;
        this.initializeConnectivity();
        this.mLocalListener = new ClientDebuggerListenerStub();
    }

    private void initializeConnectivity() {
        try {
            this.mRmiService = this.getRMIService();
            this.mRmiServer = this.mRmiService.createServer(0);
            this.mObjectAdapter = this.mRmiServer.createObjectAdapter("root");
            this.mRmiServer.setDefaultAdaptor(this.mObjectAdapter);
            this.mObjectAdapter.start();
            this.mServerThread = new Thread((Runnable)this.mRmiServer);
            this.mServerThread.start();
            this.mIsInitialized = true;
        }
        catch (Exception exception) {
            this.mException = exception;
        }
    }

    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public Exception getException() {
        return this.mException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(String string, int n) {
        this.mHost = string;
        this.mPort = n;
        this.mBDIDebugger = new BDIDebugger(this.mDebugger);
        BDIDebugConnector bDIDebugConnector = this;
        try {
            RMIClient rMIClient = this.mRmiService.createClient(string, n);
            rMIClient.setObjectAdapter(this.mObjectAdapter);
            LOGGER.info("Trying to connect to " + string + ":" + n);
            this.mListener = (DebugListener)rMIClient.importObject(DebugListener.class, "root", "debugListener");
            BPELDebugger bPELDebugger = (BPELDebugger)this.mObjectAdapter.exportObject("foo", (Object)this.mBDIDebugger);
            this.mLocalListener.setDebugger(bPELDebugger);
            this.mObjectAdapter.registerListerner(this.mLocalListener);
            this.mListener.setDebugger(bPELDebugger);
            this.mIsAttached = true;
            Hashtable<String, BDIDebugConnector> hashtable = allConnectors;
            synchronized (hashtable) {
                allConnectors.put(string + ":" + n, bDIDebugConnector);
            }
        }
        catch (Exception exception) {
            this.mIsAttached = false;
            this.mException = exception;
        }
    }

    public boolean isAttached() {
        return this.mIsAttached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach() {
        if (!this.mIsAttached) {
            return;
        }
        this.mIsAttached = false;
        try {
            this.mListener.setDebugger(null);
            if (this.mRmiServer != null) {
                this.mRmiServer.closeClients();
            }
            if (this.mServerThread != null) {
                this.mServerThread.interrupt();
            }
            if (this.mRmiServer != null) {
                this.mRmiServer.destroy();
            }
            if (this.mRmiService != null) {
                this.mRmiService.destroy();
            }
            if (this.mObjectAdapter != null) {
                this.mObjectAdapter.destroy();
            }
            Hashtable<String, BDIDebugConnector> hashtable = allConnectors;
            synchronized (hashtable) {
                allConnectors.remove(this.mHost + ":" + this.mPort);
            }
        }
        catch (Exception exception) {
            this.mDebugger.setException(new DebugException((Throwable)exception));
        }
        this.mServerThread = null;
        this.mRmiServer = null;
        this.mRmiService = null;
        this.mObjectAdapter = null;
        this.mBDIDebugger = null;
    }

    public BDIDebugger getBDIDebugger() {
        return this.mBDIDebugger;
    }

    private RMIService getRMIService() {
        try {
            RMIServiceFactory rMIServiceFactory = (RMIServiceFactory)this.getClass().getClassLoader().loadClass("org.netbeans.modules.bpel.debuggerbdi.rmi.wp.impl.DefaultRMIServiceFactory").newInstance();
            return rMIServiceFactory.createRMIService(this.getClass().getClassLoader());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LOGGER.warning("Exception in getRMIService:\n" + exception);
            return null;
        }
    }

    class ClientDebuggerListenerStub
    implements DebugListener {
        private BPELDebugger bpDebugger = null;

        ClientDebuggerListenerStub() {
        }

        public void setDebugger(BPELDebugger bPELDebugger) {
            this.bpDebugger = bPELDebugger;
        }

        public void socketClosed(Object object) {
            if (this.bpDebugger != null) {
                try {
                    this.bpDebugger.detach();
                }
                catch (Exception exception) {
                    LOGGER.warning("Exception in ClientDebuggerListernStub.socketClosed:\n" + exception);
                }
            }
        }
    }
}

