/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.bdiclient.impl;

import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.debugger.BpelDebuggerImpl;
import org.netbeans.modules.bpel.debugger.api.BpelProcess;
import org.netbeans.modules.bpel.debugger.api.WaitingCorrelatedMessage;
import org.netbeans.modules.bpel.debugger.api.psm.ProcessStaticModel;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.ProcessInstancesModelImpl;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.WaitingCorrelatedMessageImpl;
import org.netbeans.modules.bpel.debugger.psm.ProcessStaticModelImpl;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.BPELProcessRef;

public class BpelProcessImpl
implements BpelProcess {
    private final QName myQName;
    private final BPELProcessRef myProcessRef;
    private ProcessStaticModelImpl myPsm;

    protected BpelProcessImpl(BPELProcessRef bPELProcessRef, BpelDebuggerImpl bpelDebuggerImpl) {
        this.myProcessRef = bPELProcessRef;
        this.myQName = ProcessInstancesModelImpl.makeProcessQName(this.myProcessRef.uri());
    }

    public QName getQName() {
        return this.myQName;
    }

    public String getName() {
        return this.myQName.getLocalPart();
    }

    public String getTargetNamespace() {
        return this.myQName.getNamespaceURI();
    }

    public ProcessStaticModel getProcessStaticModel() {
        if (this.myPsm == null) {
            this.myPsm = ProcessStaticModelImpl.build(this);
        }
        return this.myPsm;
    }

    public BPELProcessRef getProcessRef() {
        return this.myProcessRef;
    }

    public WaitingCorrelatedMessage[] getWaitingCorrelatedEvents() {
        long[] lArray = this.myProcessRef.getWaitingCorrelatedEventIds();
        WaitingCorrelatedMessage[] waitingCorrelatedMessageArray = new WaitingCorrelatedMessage[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            waitingCorrelatedMessageArray[i] = new WaitingCorrelatedMessageImpl(this, this.myProcessRef.getWaitingCorrelatedEvent(lArray[i]));
        }
        return waitingCorrelatedMessageArray;
    }
}

