/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.bdiclient.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.debugger.BpelDebuggerImpl;
import org.netbeans.modules.bpel.debugger.api.BpelProcess;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;
import org.netbeans.modules.bpel.debugger.api.ProcessInstancesModel;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.BDIDebugFrame;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.BpelProcessImpl;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.ProcessInstanceImpl;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.BPELProcessInstanceRef;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.BPELProcessRef;

public class ProcessInstancesModelImpl
implements ProcessInstancesModel {
    private final Vector<ProcessInstancesModel.Listener> myListeners = new Vector();
    private final BpelDebuggerImpl myDebugger;
    private final Map<String, ProcessInstanceImpl> myProcessInstances = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<QName, BpelProcessImpl> myProcesses = new HashMap<QName, BpelProcessImpl>();

    public ProcessInstancesModelImpl(BpelDebuggerImpl bpelDebuggerImpl) {
        this.myDebugger = bpelDebuggerImpl;
    }

    public BpelDebuggerImpl getDebugger() {
        return this.myDebugger;
    }

    public void clear() {
        this.myProcessInstances.clear();
        this.myListeners.clear();
    }

    public ProcessInstanceImpl[] getProcessInstances() {
        return this.myProcessInstances.values().toArray(new ProcessInstanceImpl[this.myProcessInstances.size()]);
    }

    public ProcessInstanceImpl[] getProcessInstances(BpelProcess bpelProcess) {
        LinkedList<ProcessInstanceImpl> linkedList = new LinkedList<ProcessInstanceImpl>();
        for (ProcessInstanceImpl processInstanceImpl : this.myProcessInstances.values()) {
            if (!processInstanceImpl.getProcess().equals(bpelProcess)) continue;
            linkedList.add(processInstanceImpl);
        }
        return linkedList.toArray(new ProcessInstanceImpl[linkedList.size()]);
    }

    public BpelProcessImpl[] getProcesses() {
        return this.myProcesses.values().toArray(new BpelProcessImpl[this.myProcesses.size()]);
    }

    public BpelProcessImpl getProcess(BPELProcessRef bPELProcessRef) {
        QName qName = ProcessInstancesModelImpl.makeProcessQName(bPELProcessRef.uri());
        BpelProcessImpl bpelProcessImpl = this.myProcesses.get(qName);
        if (bpelProcessImpl == null) {
            bpelProcessImpl = new BpelProcessImpl(bPELProcessRef, this.myDebugger);
            this.myProcesses.put(qName, bpelProcessImpl);
        }
        return bpelProcessImpl;
    }

    public void addListener(ProcessInstancesModel.Listener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(ProcessInstancesModel.Listener listener) {
        this.myListeners.remove(listener);
    }

    protected void processUndeployed(String string) {
        QName qName = ProcessInstancesModelImpl.makeProcessQName(string);
        for (ProcessInstanceImpl processInstanceImpl : this.getProcessInstances()) {
            if (!processInstanceImpl.getProcessQName().equals(qName)) continue;
            processInstanceImpl.setUndeployed(true);
            if (processInstanceImpl.getState() == 2) {
                processInstanceImpl.resume();
            }
            this.myProcessInstances.remove(processInstanceImpl.getId());
            this.fireProcessInstanceRemoved(processInstanceImpl);
        }
        this.myProcesses.remove(qName);
    }

    protected BDIDebugFrame frameCreated(String string, String string2, String string3, String string4, String string5) {
        Object object;
        ProcessInstanceImpl processInstanceImpl = this.myProcessInstances.get(string2);
        if (processInstanceImpl == null) {
            object = this.myDebugger.getBDIDebugger().getVirtualBPELEngine();
            for (String string6 : object.allDeployedBPELs()) {
                BPELProcessRef bPELProcessRef = object.getBPELProcess(string6);
                this.getProcess(bPELProcessRef);
                List<String> list = Arrays.asList(bPELProcessRef.allProcessInstanceIDs());
                if (!list.contains(string2)) continue;
                BPELProcessInstanceRef bPELProcessInstanceRef = bPELProcessRef.getProcessInstance(string2);
                this.processInstanceStarted(bPELProcessInstanceRef);
                break;
            }
            if ((processInstanceImpl = this.myProcessInstances.get(string2)) == null) {
                return null;
            }
        }
        object = processInstanceImpl.addFrame(string, string3);
        return object;
    }

    protected void processInstanceStarted(BPELProcessInstanceRef bPELProcessInstanceRef) {
        ProcessInstanceImpl processInstanceImpl = new ProcessInstanceImpl(this, bPELProcessInstanceRef);
        this.myProcessInstances.put(processInstanceImpl.getId(), processInstanceImpl);
        processInstanceImpl.onProcessInstanceStarted();
        this.fireProcessInstanceAdded(processInstanceImpl);
    }

    protected void processInstanceDied(BPELProcessInstanceRef bPELProcessInstanceRef) {
        String string = bPELProcessInstanceRef.globalID();
        ProcessInstanceImpl processInstanceImpl = this.myProcessInstances.get(string);
        processInstanceImpl.onProcessInstanceDied();
    }

    protected void processInstanceCompleted(ProcessInstanceImpl processInstanceImpl) {
        this.myProcessInstances.remove(processInstanceImpl.getId());
        this.fireProcessInstanceRemoved(processInstanceImpl);
    }

    protected void processInstanceStateChanged(ProcessInstanceImpl processInstanceImpl, int n, int n2) {
        this.fireProcessInstanceStateChanged(processInstanceImpl, n, n2);
    }

    protected static QName makeProcessQName(String string) {
        int n = string.lastIndexOf(47);
        return new QName(string.substring(0, n), string.substring(n + 1));
    }

    private void fireProcessInstanceAdded(ProcessInstanceImpl processInstanceImpl) {
        Object[] objectArray = new ProcessInstancesModel.Listener[this.myListeners.size()];
        this.myListeners.copyInto(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i].processInstanceAdded((ProcessInstance)processInstanceImpl);
        }
    }

    private void fireProcessInstanceRemoved(ProcessInstanceImpl processInstanceImpl) {
        Object[] objectArray = new ProcessInstancesModel.Listener[this.myListeners.size()];
        this.myListeners.copyInto(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i].processInstanceRemoved((ProcessInstance)processInstanceImpl);
        }
    }

    private void fireProcessInstanceStateChanged(ProcessInstanceImpl processInstanceImpl, int n, int n2) {
        Object[] objectArray = new ProcessInstancesModel.Listener[this.myListeners.size()];
        this.myListeners.copyInto(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i].processInstanceStateChanged((ProcessInstance)processInstanceImpl, n, n2);
        }
    }
}

