/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.eventlog;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.bpel.debugger.eventlog.EventRecord;

public class EventLog {
    private List<EventRecord> myRecords = new LinkedList<EventRecord>();
    private Map<Listener, Object> myListenerMap = new WeakHashMap<Listener, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(EventRecord eventRecord) {
        EventLog eventLog = this;
        synchronized (eventLog) {
            eventRecord.setIndex(this.myRecords.size());
            this.myRecords.add(eventRecord);
        }
        this.fireRecordAdded(eventRecord);
    }

    public synchronized EventRecord[] getAllRecords() {
        return this.myRecords.toArray(new EventRecord[this.myRecords.size()]);
    }

    public synchronized EventRecord[] getRecords(int n, int n2) {
        return this.myRecords.subList(n, n2).toArray(new EventRecord[n2 - n]);
    }

    public synchronized int getSize() {
        return this.myRecords.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        Map<Listener, Object> map = this.myListenerMap;
        synchronized (map) {
            this.myListenerMap.put(listener, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        Map<Listener, Object> map = this.myListenerMap;
        synchronized (map) {
            this.myListenerMap.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRecordAdded(EventRecord eventRecord) {
        Listener[] listenerArray = this.myListenerMap;
        synchronized (this.myListenerMap) {
            Listener[] listenerArray2 = this.myListenerMap.keySet().toArray(new Listener[0]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (Listener listener : listenerArray2) {
                listener.recordAdded(eventRecord);
            }
            return;
        }
    }

    public static interface Listener {
        public void recordAdded(EventRecord var1);
    }
}

